/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.device;

import java.util.Map;
import java.util.Set;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.mgmt.ManagementClient;
import tuwien.auto.calimero.mgmt.PropertyClient;
import tuwien.auto.calimero.secure.SecurityControl;

public final class AccessPolicies {
    private static final int AuthorizeRequest = 977;
    private static final int DeviceDescriptorRead = 768;
    private static final int DomainAddressWrite = 992;
    private static final int DomainAddressRead = 993;
    private static final int DomainAddressSelectiveRead = 995;
    private static final int IndividualAddressRead = 256;
    private static final int IndividualAddressSerialNumberRead = 988;
    private static final int IndividualAddressSerialNumberWrite = 990;
    private static final int IndividualAddressWrite = 192;
    private static final int KeyWrite = 979;
    private static final int PropertyDescriptionRead = 984;
    private static final int PropertyExtDescriptionRead = 466;
    private static final Map<Integer, Integer> serviceLevelAccessPolicies = Map.ofEntries(Map.entry(977, AccessPolicies.accessPolicy("2AA/2AA")), Map.entry(768, AccessPolicies.accessPolicy("155/155")), Map.entry(993, AccessPolicies.accessPolicy("155/155")), Map.entry(992, AccessPolicies.accessPolicy("2AA/008")), Map.entry(995, AccessPolicies.accessPolicy("155/155")), Map.entry(256, AccessPolicies.accessPolicy("155/155")), Map.entry(988, AccessPolicies.accessPolicy("155/155")), Map.entry(990, AccessPolicies.accessPolicy("2AA/008")), Map.entry(192, AccessPolicies.accessPolicy("2AA/008")), Map.entry(979, AccessPolicies.accessPolicy("2AA/008")), Map.entry(984, AccessPolicies.accessPolicy("155/155")), Map.entry(466, AccessPolicies.accessPolicy("155/155")));
    private static final Set<Integer> writeServices = Set.of(Integer.valueOf(977), Integer.valueOf(992), Integer.valueOf(990), Integer.valueOf(192), Integer.valueOf(979));
    static Map<PropertyClient.PropertyKey, PropertyClient.Property> definitions;
    static final int Unlisted = 0;
    static final int RoleX = 1;
    static final int Tool = 2;
    static final int None = 0;
    static final int AuthOnly = 1;
    static final int AuthConf = 2;
    private static final int Read = 1;
    private static final int Write = 2;
    private static final int ReadWrite = 3;
    private static final int allAllowed;
    private static final int DoASerialNumberRead = 1004;
    private static final int DoASerialNumberWrite = 1006;
    private static final int UnlistedBits = 2;
    private static final int RoleXBits = 4;
    private static final int ToolBits = 4;
    private static final int unsecuredModeOffset = 10;
    private static final int[] roleOffset;
    private static final int[] securityOffset;

    private static int accessPolicy(String accessPolicy) {
        int slash = accessPolicy.indexOf(47);
        int off = Integer.parseInt(accessPolicy.substring(0, slash), 16);
        int on = Integer.parseInt(accessPolicy.substring(slash + 1), 16);
        if (off > 1023 || on > 1023) {
            throw new KNXIllegalArgumentException("invalid access policy " + accessPolicy);
        }
        return off << 10 | on;
    }

    static boolean checkServiceAccess(int service, boolean securityMode, SecurityControl securityCtrl) {
        boolean write = writeServices.contains(service);
        if (write) {
            return AccessPolicies.hasWriteAccess(service, securityMode, securityCtrl);
        }
        return AccessPolicies.hasReadAccess(service, securityMode, securityCtrl);
    }

    private static boolean hasWriteAccess(int service, boolean securityMode, SecurityControl securityCtrl) {
        return (AccessPolicies.accessLevel(service, securityMode, securityCtrl) & 2) == 2;
    }

    private static boolean hasReadAccess(int service, boolean securityMode, SecurityControl securityCtrl) {
        return (AccessPolicies.accessLevel(service, securityMode, securityCtrl) & 1) == 1;
    }

    private static int accessLevel(int service, boolean securityMode, SecurityControl securityCtrl) {
        int policy = serviceLevelAccessPolicies.getOrDefault(service, allAllowed);
        return AccessPolicies.readWrite(policy, securityMode, securityCtrl);
    }

    public static boolean checkPropertyAccess(int objType, int pid, boolean read, boolean securityMode, SecurityControl securityCtrl) {
        int policy;
        PropertyClient.PropertyKey key = pid <= 50 ? new PropertyClient.PropertyKey(pid) : new PropertyClient.PropertyKey(objType, pid);
        PropertyClient.Property property = definitions.get(key);
        if (property == null) {
            return objType != 17;
        }
        int n = policy = objType == 17 && pid == 5 ? AccessPolicies.accessPolicy("00C/00C") : property.accessPolicy();
        if (policy == 0 && objType == 17) {
            return false;
        }
        if (policy == 0) {
            return true;
        }
        int rw = read ? 1 : 2;
        return (AccessPolicies.readWrite(policy, securityMode, securityCtrl) & rw) == rw;
    }

    boolean readDomainAddressSerial(int service, int domainSize, boolean securityMode, SecurityControl securityCtrl) {
        return (AccessPolicies.doASerialAccessLevel(service, domainSize, securityMode, securityCtrl) & 1) == 1;
    }

    boolean writeDomainAddressSerial(int service, int domainSize, boolean securityMode, SecurityControl securityCtrl) {
        return (AccessPolicies.doASerialAccessLevel(service, domainSize, securityMode, securityCtrl) & 2) == 2;
    }

    private static int doASerialAccessLevel(int service, int domainSize, boolean securityMode, SecurityControl securityCtrl) {
        return AccessPolicies.readWrite(AccessPolicies.doASerialPolicy(service, domainSize), securityMode, securityCtrl);
    }

    private static int doASerialPolicy(int service, int doASize) {
        if (service != 1004 && service != 1006) {
            throw new KNXIllegalArgumentException("unknown DoA S/N service " + Integer.toHexString(service));
        }
        boolean read = service == 1004;
        switch (doASize) {
            case 2: {
                return read ? 0x155155 : 2793480;
            }
            case 4: {
                return read ? 4 : 2793480;
            }
            case 6: {
                return read ? 0x155155 : 2793480;
            }
            case 21: {
                return read ? 16388 : 32776;
            }
        }
        throw new KNXIllegalArgumentException("unsupported DoA size " + doASize);
    }

    static boolean checkRestartAccess(boolean masterReset, ManagementClient.EraseCode code, boolean securityMode, SecurityControl securityCtrl) {
        return (AccessPolicies.restartAccess(masterReset, code, securityMode, securityCtrl) & 2) == 2;
    }

    private static int restartAccess(boolean masterReset, ManagementClient.EraseCode code, boolean securityMode, SecurityControl securityCtrl) {
        if (!masterReset || masterReset && code == ManagementClient.EraseCode.ConfirmedRestart) {
            return AccessPolicies.accessPolicy("2AA/0AA");
        }
        if (securityMode && (code == ManagementClient.EraseCode.ResetIndividualAddress || code == ManagementClient.EraseCode.ResetApplicationProgram)) {
            throw new KNXIllegalArgumentException("unsupported restart service erase code " + String.valueOf(code));
        }
        return AccessPolicies.readWrite(AccessPolicies.accessPolicy("2AA/008"), securityMode, securityCtrl);
    }

    private static int readWrite(int policy, boolean securityMode, SecurityControl securityCtrl) {
        SecurityControl.DataSecurity sec = securityCtrl.security();
        int role = sec == SecurityControl.DataSecurity.None ? 0 : (securityCtrl.toolAccess() ? 2 : 1);
        int shift = (securityMode ? 0 : 10) + roleOffset[role] + securityOffset[sec.ordinal()];
        return policy >> shift & 3;
    }

    static {
        allAllowed = AccessPolicies.accessPolicy("3ff/3ff");
        roleOffset = new int[]{8, 4, 0};
        securityOffset = new int[]{0, 0, 2};
    }
}

