/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.device;

import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.FrameEvent;
import tuwien.auto.calimero.GroupAddress;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.cemi.CEMILData;
import tuwien.auto.calimero.link.KNXLinkClosedException;
import tuwien.auto.calimero.mgmt.Destination;
import tuwien.auto.calimero.mgmt.ManagementClient;

public final class LinkProcedure
implements Runnable {
    private static final EnumSet<Action> actuator = EnumSet.of(Action.EnterConfigMode, new Action[]{Action.ChannelFunctionActuator, Action.SetChannelParam, Action.BeginConnection, Action.LinkResponse, Action.QuitConfigMode});
    private static final EnumSet<Action> sensor = EnumSet.of(Action.StartLink, Action.ChannelFunctionSensor, Action.ChannelParamResponse, Action.SetDeleteLink, Action.StopLink);
    private static final int deviceObjectType = 0;
    private static final int pidConfigLink = 59;
    private static final long timeout = 3000L;
    private static final Logger logger = LoggerFactory.getLogger((String)"calimero.device.LinkProcedure");
    private final boolean isActuator;
    private final boolean reset;
    private Action state = Action.None;
    private final ManagementClient mgmt;
    private final IndividualAddress self;
    private final IndividualAddress remote;
    private final int mfId;
    private final boolean unidir;
    private int expectedGroupObjects;
    private static final boolean paramIndicator = false;
    private static final int subFunction = 0;
    private final int channelCode;
    private final int subFunc = 0;
    private final Map<Integer, GroupAddress> groupObjects;
    private int activeConnectionCode;
    public static final int LinkAdded = 0;
    public static final int UseExistingAddress = 1;
    public static final int LinkDeleted = 2;
    public static final int LinkNotAdded = 3;
    public static final int Error = 4;
    private boolean abort;
    private boolean noChannel;
    private boolean timerExpired;
    private boolean wrongService;
    private BiFunction<Integer, Map<Integer, GroupAddress>, Integer> linkFunction = (f, g) -> 0;
    private volatile int linkResponseStatus;
    private static final int NetworkParamWrite = 996;

    public static LinkProcedure forActuator(ManagementClient mgmt, IndividualAddress self, Destination d, int channelCode) {
        return new LinkProcedure(true, false, mgmt, self, d, false, 0, channelCode, new HashMap<Integer, GroupAddress>());
    }

    public static LinkProcedure forSensor(ManagementClient mgmt, IndividualAddress self, Destination d, boolean unidirectional, int manufacturerId, Map<Integer, GroupAddress> groupObjects) {
        return new LinkProcedure(false, false, mgmt, self, d, unidirectional, manufacturerId, 0, groupObjects);
    }

    public static LinkProcedure resetInstallation(ManagementClient mgmt) {
        return new LinkProcedure(false, true, mgmt, new IndividualAddress(0), null, false, 0, 0, Collections.emptyMap());
    }

    public static boolean isEnterConfigMode(byte[] asdu) {
        int iot = asdu[0] & 0xFF00 | asdu[1] & 0xFF;
        int pid = asdu[2] & 0xFF;
        return LinkProcedure.isEnterConfigMode(iot, pid, Arrays.copyOfRange(asdu, 3, asdu.length));
    }

    public static boolean isEnterConfigMode(int objectType, int pid, byte[] testInfo) {
        if (objectType == 0 && pid == 59) {
            int command = (testInfo[0] & 0xFF) >> 4;
            Action action = Action.values()[command];
            return action == Action.EnterConfigMode;
        }
        return false;
    }

    private LinkProcedure(boolean isActuator, boolean reset, ManagementClient mgmt, IndividualAddress self, Destination d, boolean unidir, int mfId, int channelCode, Map<Integer, GroupAddress> groupObjects) {
        this.isActuator = isActuator;
        this.reset = reset;
        this.mgmt = mgmt;
        this.self = self;
        this.remote = d != null ? d.getAddress() : null;
        this.unidir = unidir;
        this.mfId = mfId;
        this.channelCode = channelCode;
        this.groupObjects = Collections.synchronizedMap(groupObjects);
    }

    public void setLinkFunction(BiFunction<Integer, Map<Integer, GroupAddress>, Integer> linkFunction) {
        this.linkFunction = linkFunction;
    }

    /*
     * Exception decompiling
     */
    @Override
    public void run() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 8[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static void onCommand(Action action) {
        logger.debug("on {}", (Object)action);
    }

    private byte[] create(Action action) {
        int command = action.ordinal() << 4;
        byte[] value = new byte[]{(byte)command, 0, 0, 0};
        int flags = 0;
        switch (action) {
            case StartLink: {
                flags = (this.unidir ? 8 : 0) | 0 | 0;
                value[1] = (byte)(this.mfId >> 8);
                value[2] = (byte)this.mfId;
                value[3] = (byte)this.groupObjects.size();
                break;
            }
            case ChannelFunctionActuator: 
            case ChannelFunctionSensor: {
                value[1] = (byte)(this.channelCode >> 8);
                value[2] = (byte)this.channelCode;
                break;
            }
            case SetDeleteLink: 
            case LinkResponse: {
                flags = action == Action.SetDeleteLink ? 0 : this.linkResponseStatus;
                GroupAddress ga = this.groupObjects.get(this.activeConnectionCode);
                byte[] addr = ga.toByteArray();
                value[1] = (byte)this.activeConnectionCode;
                value[2] = addr[0];
                value[3] = addr[1];
                logger.info("create {}: connection code {} ==> {}", new Object[]{action, this.activeConnectionCode, ga});
                break;
            }
            case StopLink: {
                flags = (this.abort ? 4 : 0) | (this.noChannel ? 2 : 0) | (this.timerExpired ? 1 : 0);
                break;
            }
            case QuitConfigMode: {
                flags = this.timerExpired ? 1 : (this.noChannel ? 2 : (this.wrongService ? 3 : 0));
                break;
            }
        }
        value[0] = (byte)(value[0] | flags);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(Action action) throws KNXLinkClosedException, KNXTimeoutException {
        byte[] value = this.create(action);
        logger.info("send {}", (Object)action);
        LinkProcedure linkProcedure = this;
        synchronized (linkProcedure) {
            this.mgmt.writeNetworkParameter(this.remote, 0, 59, value);
            this.state = action;
        }
        LinkProcedure.onCommand(action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void receivedManagementService(FrameEvent e) {
        byte[] apdu = e.getFrame().getPayload();
        int svc = DataUnitBuilder.getAPDUService((byte[])apdu);
        if (svc == 996) {
            if (((CEMILData)e.getFrame()).getSource().equals((Object)this.self)) {
                logger.debug("received management service sent by us ({}) -- ignore", (Object)this.self);
                return;
            }
            byte[] asdu = DataUnitBuilder.extractASDU((byte[])apdu);
            int iot = asdu[0] & 0xFF00 | asdu[1] & 0xFF;
            int pid = asdu[2] & 0xFF;
            if (iot == 0 && pid == 59) {
                int command = (asdu[3] & 0xFF) >> 4;
                Action action = Action.values()[command];
                this.parseAction(action, asdu);
                LinkProcedure linkProcedure = this;
                synchronized (linkProcedure) {
                    this.state = action;
                    this.notifyAll();
                }
            }
        }
    }

    private void parseAction(Action action, byte[] asdu) {
        int flags = asdu[3] & 0xF;
        switch (action) {
            case StartLink: {
                int code = (asdu[4] & 0xFF) << 8 | asdu[5] & 0xFF;
                int objects = asdu[6] & 0xFF;
                boolean unidirectional = (flags & 8) == 8;
                boolean params = (flags & 4) == 4;
                int subfunc = flags & 3;
                logger.debug("received {}: unidir {}, params {}, subfunc {}, manufacturer code {}, group objects to link: {}", new Object[]{action, unidirectional, params, subfunc, code, objects});
                this.expectedGroupObjects = Math.max(1, objects);
                break;
            }
            case ChannelFunctionActuator: 
            case ChannelFunctionSensor: {
                int channel = (asdu[4] & 0xFF) << 8 | asdu[5] & 0xFF;
                logger.debug("received {}: E-mode channel code {}", (Object)action, (Object)channel);
                break;
            }
            case SetDeleteLink: 
            case LinkResponse: {
                int cc = asdu[4] & 0xFF;
                GroupAddress ga = new GroupAddress((asdu[5] & 0xFF) << 8 | asdu[6] & 0xFF);
                this.groupObjects.put(cc, ga);
                logger.info("received {}: flags {}, connection code {} ==> {}", new Object[]{action, flags, cc, ga});
                if (action == Action.SetDeleteLink) {
                    this.activeConnectionCode = cc;
                } else {
                    if (this.activeConnectionCode != cc) {
                        logger.error("link response connection code {} does not match {}", (Object)cc, (Object)this.activeConnectionCode);
                    }
                    if ((flags & 4) == 4) {
                        this.abort = true;
                    }
                }
                this.linkResponseStatus = this.linkFunction.apply(flags, this.groupObjects);
                break;
            }
            case StopLink: 
            case QuitConfigMode: {
                int status = asdu[3] & 7;
                logger.debug("received {}: status {}", (Object)action, (Object)status);
                break;
            }
        }
    }

    private void stopLink(Exception e) {
        logger.error("stop link procedure with {}", (Object)this.remote, (Object)e);
        try {
            if (this.state.ordinal() >= Action.EnterConfigMode.ordinal()) {
                this.write(Action.StopLink);
            }
        }
        catch (KNXTimeoutException | KNXLinkClosedException throwable) {
            // empty catch block
        }
    }

    private synchronized void waitFor(Action next) throws InterruptedException, KNXTimeoutException {
        logger.trace("wait for command {}", (Object)next);
        long start = System.currentTimeMillis();
        for (long remaining = 3000L; remaining > 0L; remaining -= System.currentTimeMillis() - start) {
            if (this.state == next) {
                LinkProcedure.onCommand(next);
                return;
            }
            this.wait(remaining);
        }
        this.timerExpired = true;
        throw new KNXTimeoutException("pairing timeout waiting for " + String.valueOf((Object)next));
    }

    static enum Action {
        None,
        EnterConfigMode,
        StartLink,
        ChannelFunctionActuator,
        ChannelFunctionSensor,
        SetChannelParam,
        ChannelParamResponse,
        BeginConnection,
        SetDeleteLink,
        LinkResponse,
        StopLink,
        QuitConfigMode,
        ResetInstallation,
        Features;

    }
}

