/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.device;

import java.util.EventObject;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.DetachEvent;
import tuwien.auto.calimero.FrameEvent;
import tuwien.auto.calimero.GroupAddress;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.cemi.CEMILData;
import tuwien.auto.calimero.cemi.CEMILDataEx;
import tuwien.auto.calimero.device.BaseKnxDevice;
import tuwien.auto.calimero.device.ProcessCommunicationResponder;
import tuwien.auto.calimero.device.ProcessCommunicationService;
import tuwien.auto.calimero.device.ServiceResult;
import tuwien.auto.calimero.link.KNXLinkClosedException;
import tuwien.auto.calimero.link.NetworkLinkListener;
import tuwien.auto.calimero.process.LteProcessEvent;
import tuwien.auto.calimero.process.ProcessCommunicator;
import tuwien.auto.calimero.process.ProcessCommunicatorImpl;
import tuwien.auto.calimero.process.ProcessEvent;
import tuwien.auto.calimero.process.ProcessListener;
import tuwien.auto.calimero.secure.SecureApplicationLayer;

final class ProcessServiceNotifier
implements ProcessListener,
AutoCloseable {
    static final int GROUP_READ = 0;
    static final int GROUP_RESPONSE = 64;
    static final int GROUP_WRITE = 128;
    private static final int GroupPropRead = 1000;
    private static final int GroupPropResponse = 1001;
    static final int GroupPropWrite = 1002;
    static final int GroupPropInfo = 1003;
    private final BaseKnxDevice device;
    private final ProcessCommunicationService svc;
    private final ProcessCommunicator recv;
    private final ProcessCommunicationResponder res;
    private final boolean lte = true;

    ProcessServiceNotifier(BaseKnxDevice device, ProcessCommunicationService service) throws KNXLinkClosedException {
        if (device.getDeviceLink() == null) {
            throw new NullPointerException("KNX device network link is required");
        }
        this.device = device;
        this.svc = service;
        this.recv = new ProcessCommunicatorImpl(device.getDeviceLink(), (SecureApplicationLayer)device.sal);
        this.res = new ProcessCommunicationResponder(device.getDeviceLink(), (SecureApplicationLayer)device.sal);
        this.recv.addProcessListener((ProcessListener)this);
        device.getDeviceLink().addLinkListener((NetworkLinkListener)new LteListener());
    }

    public void groupReadRequest(ProcessEvent e) {
        this.device.dispatch((EventObject)e, () -> this.svc.groupReadRequest(e), this::respond);
    }

    public void groupReadResponse(ProcessEvent e) {
        this.device.dispatch((EventObject)e, () -> {
            this.svc.groupResponse(e);
            return null;
        }, this::respond);
    }

    public void groupWrite(ProcessEvent e) {
        this.device.dispatch((EventObject)e, () -> {
            this.svc.groupWrite(e);
            return null;
        }, this::respond);
    }

    public void groupLteInfo(ProcessEvent e) {
        this.device.dispatch((EventObject)e, () -> {
            this.svc.groupWrite(e);
            return null;
        }, this::respond);
    }

    public void detached(DetachEvent e) {
    }

    void respond(EventObject event, ServiceResult<byte[]> sr) {
        if (sr.result() != null) {
            GroupAddress to = ((ProcessEvent)event).getDestination();
            try {
                this.res.setPriority(sr.getPriority());
                this.res.write(to, sr.result(), sr.compact);
            }
            catch (KNXTimeoutException | KNXLinkClosedException e) {
                this.device.logger().error("responding to {}: {}", new Object[]{to, DataUnitBuilder.toHex((byte[])sr.result(), (String)" "), e});
            }
        } else {
            sr.run();
        }
    }

    @Override
    public void close() {
        this.recv.close();
        this.res.close();
    }

    private final class LteListener
    implements NetworkLinkListener {
        private LteListener() {
        }

        public void indication(FrameEvent e) {
            CEMILData ldata = (CEMILData)e.getFrame();
            if (!(ldata instanceof CEMILDataEx)) {
                return;
            }
            byte[] apdu = ldata.getPayload();
            if (apdu.length < 2) {
                return;
            }
            try {
                byte[] data = ldata.toByteArray();
                int ctrl2 = data[3 + data[1]] & 0xFF;
                if ((ctrl2 & 4) == 0) {
                    return;
                }
                int svc = DataUnitBuilder.getAPDUService((byte[])apdu);
                if ((svc & 0x3FC) == 1000) {
                    byte[] tpdu = ldata.getPayload();
                    this.fireGroupReadWrite(ldata, ctrl2 & 0xF, tpdu, svc);
                }
            }
            catch (RuntimeException rte) {
                ProcessServiceNotifier.this.device.logger().error("on group property indication from {}", (Object)ldata.getSource(), (Object)rte);
            }
        }

        private void fireGroupReadWrite(CEMILData f, int eff, byte[] tpdu, int svc) {
            LteProcessEvent e = new LteProcessEvent(ProcessServiceNotifier.this.recv, f.getSource(), eff, (GroupAddress)f.getDestination(), tpdu);
            if (svc == 1000) {
                ProcessServiceNotifier.this.groupReadRequest((ProcessEvent)e);
            } else if (svc == 1003) {
                ProcessServiceNotifier.this.groupLteInfo((ProcessEvent)e);
            } else if (svc == 1002) {
                ProcessServiceNotifier.this.groupWrite((ProcessEvent)e);
            }
        }
    }
}

