/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.device;

import java.util.Arrays;
import java.util.concurrent.locks.ReentrantLock;
import tuwien.auto.calimero.device.KnxDevice;

final class ThreadSafeByteArray
implements KnxDevice.Memory {
    private final byte[] array;
    private final ReentrantLock lock = new ReentrantLock();

    ThreadSafeByteArray(int size) {
        this.array = new byte[size];
    }

    @Override
    public int size() {
        return this.array.length;
    }

    @Override
    public int get(int offset) {
        this.lock.lock();
        try {
            int n = this.array[offset] & 0xFF;
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] get(int offset, int bytes) {
        this.lock.lock();
        try {
            byte[] byArray = Arrays.copyOfRange(this.array, offset, offset + bytes);
            return byArray;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void set(int offset, int bite) {
        this.lock.lock();
        try {
            this.array[offset] = (byte)bite;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void set(int offset, byte ... bites) {
        this.lock.lock();
        try {
            System.arraycopy(bites, 0, this.array, offset, bites.length);
        }
        finally {
            this.lock.unlock();
        }
    }
}

