/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.device.ios;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.device.ios.InterfaceObjectServer;
import tuwien.auto.calimero.device.ios.KnxPropertyException;
import tuwien.auto.calimero.dptxlator.PropertyTypes;
import tuwien.auto.calimero.dptxlator.TranslatorTypes;
import tuwien.auto.calimero.mgmt.Description;
import tuwien.auto.calimero.mgmt.PropertyClient;

public class InterfaceObject {
    public static final int DEVICE_OBJECT = 0;
    public static final int ADDRESSTABLE_OBJECT = 1;
    public static final int ASSOCIATIONTABLE_OBJECT = 2;
    public static final int APPLICATIONPROGRAM_OBJECT = 3;
    @Deprecated(forRemoval=true)
    public static final int INTERFACEPROGRAM_OBJECT = 4;
    public static final int APPLICATION_PROGRAM2 = 4;
    public static final int ROUTER_OBJECT = 6;
    public static final int LTE_ADDRESS_FILTER_TABLE_OBJECT = 7;
    public static final int CEMI_SERVER_OBJECT = 8;
    public static final int GROUP_OBJECT_TABLE_OBJECT = 9;
    public static final int POLLING_MASTER = 10;
    public static final int KNXNETIP_PARAMETER_OBJECT = 11;
    public static final int APPLICATION_CONTROLLER = 12;
    public static final int FILE_SERVER_OBJECT = 13;
    public static final int SECURITY_OBJECT = 17;
    public static final int RF_MEDIUM_OBJECT = 19;
    private final List<Description> descriptions = new ArrayList<Description>();
    private final Map<Integer, Description> pidToDescription = new HashMap<Integer, Description>();
    final Map<PropertyClient.PropertyKey, byte[]> values = new HashMap<PropertyClient.PropertyKey, byte[]>();
    private final int type;
    private final Map<PropertyClient.PropertyKey, PropertyClient.Property> definitions;
    private volatile int idx;
    volatile InterfaceObjectServer ios;

    public InterfaceObject(int objectType) {
        this(objectType, Map.of());
    }

    InterfaceObject(int objectType, int index, Map<PropertyClient.PropertyKey, PropertyClient.Property> definitions) {
        this(objectType, definitions);
        this.setIndex(index);
    }

    private InterfaceObject(int objectType, Map<PropertyClient.PropertyKey, PropertyClient.Property> definitions) {
        this.type = objectType;
        this.definitions = definitions;
    }

    public int getType() {
        return this.type;
    }

    public String getTypeName() {
        return PropertyClient.getObjectTypeName((int)this.type);
    }

    public int getIndex() {
        return this.idx;
    }

    void load(InterfaceObjectServer.IosResourceHandler rh) throws KNXException {
        ArrayList<Description> loadDescriptions = new ArrayList<Description>();
        ArrayList<byte[]> loadValues = new ArrayList<byte[]>();
        rh.loadProperties(loadDescriptions, loadValues);
        Iterator k = loadValues.iterator();
        Iterator i = loadDescriptions.iterator();
        while (i.hasNext() && k.hasNext()) {
            Description d = (Description)i.next();
            byte[] v = (byte[])k.next();
            this.setDescription(d);
            this.values.put(new PropertyClient.PropertyKey(d.getObjectType(), d.getPID()), v);
        }
    }

    void save(InterfaceObjectServer.IosResourceHandler rh) throws KNXException {
        ArrayList<Description> saveDesc = new ArrayList<Description>(this.descriptions);
        saveDesc.removeAll(Arrays.asList(new Object[]{null}));
        ArrayList<byte[]> saveVal = new ArrayList<byte[]>();
        HashMap<PropertyClient.PropertyKey, byte[]> remaining = new HashMap<PropertyClient.PropertyKey, byte[]>(this.values);
        byte[] empty = new byte[]{};
        for (Description d : saveDesc) {
            PropertyClient.PropertyKey key = new PropertyClient.PropertyKey(d.getObjectType(), d.getPID());
            byte[] data = this.values.get(key);
            if (data == null) {
                saveVal.add(empty);
                continue;
            }
            remaining.remove(key);
            saveVal.add((byte[])data.clone());
        }
        for (PropertyClient.PropertyKey key : remaining.keySet()) {
            saveDesc.add(new Description(this.idx, this.type, key.getPID(), saveVal.size(), 0, true, 0, 0, 0, 0));
            saveVal.add((byte[])((byte[])remaining.get(key)).clone());
        }
        rh.saveProperties(saveDesc, saveVal);
    }

    public String toString() {
        return this.getTypeName() + " (index " + this.idx + ")";
    }

    byte[] getProperty(int pid, int start, int elements) throws KnxPropertyException {
        Description desc = this.findByPid(pid);
        if (desc == null) {
            throw new KnxPropertyException("no property ID " + pid + " in " + this.getTypeName() + " (index " + this.getIndex() + ")", 7);
        }
        byte[] bytes = this.values.get(new PropertyClient.PropertyKey(this.getType(), pid));
        if (start == 0) {
            if (elements > 1) {
                throw new KnxPropertyException("current number of elements consists of only 1 element", 0);
            }
            return new byte[]{bytes[0], bytes[1]};
        }
        int currElems = (bytes[0] & 0xFF) << 8 | bytes[1] & 0xFF;
        int actualElements = elements == Integer.MAX_VALUE ? currElems - start + 1 : elements;
        int size = start + actualElements - 1;
        if (currElems < size) {
            throw new KnxPropertyException(this.err(pid, "requested elements [" + start + ".." + size + "] exceed past last property value"), 9);
        }
        int typeSize = PropertyTypes.bitSize((int)desc.getPDT()).map(bits -> Math.max(bits, 8) / 8).orElseGet(() -> (bytes.length - 2) / currElems);
        byte[] data = new byte[actualElements * typeSize];
        int d = 0;
        for (int i = 2 + (start - 1) * typeSize; i < 2 + size * typeSize; ++i) {
            data[d++] = bytes[i];
        }
        return data;
    }

    private String err(int propertyId, String msg) {
        PropertyClient.Property p = this.getDefinition(propertyId);
        String s = p != null ? " (" + p.getName() + ")" : "";
        return String.format("%d|%d%s %s", this.getIndex(), propertyId, s, msg);
    }

    boolean setProperty(int pid, int start, int elements, byte[] data, boolean strictMode) throws KnxPropertyException {
        int i;
        boolean createDescription;
        Description d;
        Optional dptId;
        int pdt;
        byte[] bytes;
        PropertyClient.PropertyKey key;
        block13: {
            key = new PropertyClient.PropertyKey(this.getType(), pid);
            bytes = this.values.get(key);
            if (start == 0) {
                if (elements == 1 && data.length == 2 && data[0] == 0 && data[1] == 0) {
                    this.truncateValueArray(pid, 0);
                    return false;
                }
                throw new KnxPropertyException("set current number of elements", 5);
            }
            pdt = -1;
            dptId = Optional.empty();
            d = null;
            createDescription = false;
            try {
                d = new Description(this.getType(), this.getDescription(pid, 0));
                pdt = d.getPDT();
            }
            catch (KnxPropertyException e) {
                if (strictMode) {
                    throw new KnxPropertyException("strict mode: no description found for " + this.getTypeName() + " PID " + pid);
                }
                createDescription = true;
                PropertyClient.Property p = this.getDefinition(pid);
                if (p == null) break block13;
                pdt = p.getPDT();
                dptId = p.dpt();
            }
        }
        Optional id = dptId;
        int typeSize = PropertyTypes.bitSize((int)pdt).or(() -> id.flatMap(InterfaceObject::dptBitSize)).map(size -> Math.max(size / 8, 1)).orElseGet(() -> elements > 0 ? data.length / elements : 1);
        if (elements > 0 && typeSize != data.length / elements) {
            Object typeName = PropertyClient.getObjectTypeName((int)this.type);
            if (((String)typeName).isEmpty()) {
                typeName = "OT " + this.type;
            }
            throw new KnxPropertyException((String)typeName + " PID " + pid + " property type size is " + typeSize + ", not " + data.length / elements, 8);
        }
        int size2 = start + elements - 1;
        if (bytes == null || size2 > (bytes.length - 2) / typeSize) {
            int maxElements;
            int n = maxElements = d == null ? elements : d.getMaxElements();
            if (size2 > maxElements) {
                throw new KnxPropertyException("property values index range [" + start + "..." + size2 + "] exceeds " + maxElements + " maximum elements", 9);
            }
            byte[] resize = new byte[2 + size2 * typeSize];
            resize[0] = (byte)(size2 >> 8);
            resize[1] = (byte)size2;
            if (bytes != null) {
                for (i = 2; i < bytes.length; ++i) {
                    resize[i] = bytes[i];
                }
            }
            this.values.put(key, resize);
            bytes = resize;
        }
        int k = 0;
        boolean changed = false;
        for (i = 2 + (start - 1) * typeSize; i < 2 + size2 * typeSize; ++i) {
            changed |= bytes[i] != data[k];
            bytes[i] = data[k++];
        }
        if (createDescription) {
            this.createNewDescription(pid, true);
        }
        return changed;
    }

    byte[] getDescription(int pid, int propIndex) throws KnxPropertyException {
        Description d = null;
        if (pid != 0) {
            d = this.findByPid(pid);
        } else if (propIndex < this.descriptions.size()) {
            d = this.descriptions.get(propIndex);
        }
        if (d != null) {
            return new Description(this.getIndex(), d.getObjectType(), d.getPID(), d.getPropIndex(), d.getPDT(), d.isWriteEnabled(), 0, d.getMaxElements(), d.getReadLevel(), d.getWriteLevel()).toByteArray();
        }
        Object typeName = this.getTypeName();
        if (((String)typeName).isEmpty()) {
            typeName = "OT " + this.type;
        }
        throw new KnxPropertyException("no description found for " + (String)typeName + (pid != 0 ? " PID " + pid : " property index " + propIndex));
    }

    private Description findByPid(int pid) {
        return this.pidToDescription.get(pid);
    }

    int findFreeSlot() {
        int i = this.descriptions.indexOf(null);
        if (i == -1) {
            i = this.descriptions.size();
        }
        return i;
    }

    void setDescription(Description d, boolean allowCorrections) {
        int idx;
        boolean adjust = false;
        if (d.getObjectType() != this.type) {
            if (!allowCorrections) {
                throw new KNXIllegalArgumentException("interface object type differs");
            }
            adjust = true;
        }
        int existingIdx = 0;
        int pdt = 0;
        Description chk = this.findByPid(d.getPID());
        if (chk != null) {
            idx = existingIdx = chk.getPropIndex();
            pdt = chk.getPDT();
        } else {
            idx = this.findFreeSlot();
        }
        if (d.getPID() == 1) {
            if (d.getPropIndex() != 0) {
                if (!allowCorrections) {
                    throw new KNXIllegalArgumentException("property 'object type' (PID 1) only allowed at index 0");
                }
                adjust = true;
                idx = 0;
            }
        } else if (d.getPropIndex() == 0) {
            if (!allowCorrections) {
                throw new KNXIllegalArgumentException("only property 'object type' (PID 1) allowed at index 0");
            }
            adjust = true;
        } else {
            idx = d.getPropIndex();
        }
        if (d.getMaxElements() < d.getCurrentElements() && !allowCorrections) {
            throw new KNXIllegalArgumentException("maximum elements less than current elements");
        }
        if (d.getPDT() == 0 && allowCorrections) {
            PropertyClient.Property p;
            if (pdt == 0 && (p = this.getDefinition(d.getPID())) != null) {
                pdt = p.getPDT();
            }
            if (pdt != 0) {
                adjust = true;
            }
        } else {
            pdt = d.getPDT();
        }
        if (existingIdx != 0) {
            this.removeDescription(existingIdx);
        }
        Description set = adjust ? new Description(d.getObjectIndex(), this.type, d.getPID(), idx, pdt, d.isWriteEnabled(), d.getCurrentElements(), d.getMaxElements(), d.getReadLevel(), d.getWriteLevel()) : d;
        this.setDescription(set);
    }

    void setDescription(Description d) {
        int index = d.getPropIndex();
        while (index >= this.descriptions.size()) {
            this.descriptions.add(null);
        }
        this.descriptions.set(index, d);
        this.truncateValueArray(d.getPID(), d.getMaxElements());
        this.pidToDescription.put(d.getPID(), d);
    }

    void createNewDescription(int pid, boolean writeEnabled) {
        byte[] data = this.values.get(new PropertyClient.PropertyKey(this.getType(), pid));
        int elems = (data[0] & 0xFF) << 8 | data[1] & 0xFF;
        int maxElems = Math.max(elems, 1);
        int pdt = -1;
        PropertyClient.Property p = this.getDefinition(pid);
        if (p != null) {
            pdt = p.getPDT();
        }
        if (pdt == -1 && elems > 0) {
            int size = (data.length - 2) / elems;
            pdt = 17 + size - 1;
        }
        int pIndex = this.descriptions.size();
        boolean writable = p != null ? !p.readOnly() : writeEnabled;
        int readLevel = p != null ? p.readLevel() : 0;
        int writeLevel = p != null ? Math.max(0, p.writeLevel()) : 0;
        Description d = new Description(this.getIndex(), this.getType(), pid, pIndex, pdt, writable, elems, maxElems, readLevel, writeLevel);
        this.descriptions.add(d);
        this.pidToDescription.put(pid, d);
    }

    void removeDescription(int existingIdx) {
        this.descriptions.set(existingIdx, null);
    }

    void setIndex(int index) {
        this.idx = index;
    }

    void truncateValueArray(int pid, int maxElements) {
        PropertyClient.PropertyKey key = new PropertyClient.PropertyKey(this.getType(), pid);
        byte[] v = this.values.get(key);
        if (maxElements == 0 || v == null) {
            this.values.put(key, new byte[2]);
            return;
        }
        int elems = (v[0] & 0xFF) << 8 | v[1] & 0xFF;
        if (elems > maxElements) {
            int elemsFieldSize = 2;
            int typeSize = (v.length - 2) / elems;
            byte[] ba = new byte[2 + maxElements * typeSize];
            System.arraycopy(v, 2, ba, 2, ba.length - 2);
            ba[0] = (byte)(maxElements >> 8);
            ba[1] = (byte)maxElements;
            this.values.put(key, ba);
        }
    }

    void firePropertyChanged(int propertyId, int start, int elements, byte[] data) {
        InterfaceObjectServer server = this.ios;
        if (server != null) {
            server.firePropertyChanged(this, propertyId, start, elements, data);
        }
    }

    private PropertyClient.Property getDefinition(int pid) {
        PropertyClient.Property p = this.definitions.get(new PropertyClient.PropertyKey(this.type, pid));
        if (p == null && pid < 50) {
            p = this.definitions.get(new PropertyClient.PropertyKey(pid));
        }
        return p;
    }

    private static Optional<Integer> dptBitSize(String dptId) {
        try {
            return Optional.of(TranslatorTypes.createTranslator((int)0, (String)dptId).bitSize());
        }
        catch (KNXException kNXException) {
            return Optional.empty();
        }
    }
}

