/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.device.ios;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.device.ios.InterfaceObject;
import tuwien.auto.calimero.device.ios.InterfaceObjectServer;
import tuwien.auto.calimero.device.ios.KnxPropertyException;
import tuwien.auto.calimero.knxnetip.KNXnetIPRouting;
import tuwien.auto.calimero.knxnetip.util.ServiceFamiliesDIB;
import tuwien.auto.calimero.mgmt.PropertyClient;

public final class KnxipParameterObject
extends InterfaceObject {
    public static KnxipParameterObject lookup(InterfaceObjectServer ios, int objectInstance) {
        return (KnxipParameterObject)ios.lookup(11, objectInstance);
    }

    KnxipParameterObject(int objectType, int index, Map<PropertyClient.PropertyKey, PropertyClient.Property> definitions) {
        super(objectType, index, definitions);
    }

    public byte[] get(int pid) {
        return this.get(pid, 1, Integer.MAX_VALUE);
    }

    public byte[] getOrDefault(int pid, byte[] defaultData) {
        try {
            return this.get(pid);
        }
        catch (KnxPropertyException e) {
            return defaultData;
        }
    }

    public byte[] get(int pid, int start, int elements) {
        return this.getProperty(pid, start, elements);
    }

    public void set(int pid, byte ... data) {
        this.set(pid, 1, 1, data);
    }

    public void set(int pid, int start, int elements, byte ... data) {
        boolean strictMode = false;
        boolean changed = this.setProperty(pid, start, elements, data, false);
        if (changed) {
            this.firePropertyChanged(pid, start, elements, data);
        }
    }

    public void setInetAddress(int pid, InetAddress addr) {
        this.set(pid, addr.getAddress());
    }

    public InetAddress inetAddress(int pid) {
        try {
            return InetAddress.getByAddress(this.getProperty(pid, 1, 1));
        }
        catch (UnknownHostException e) {
            throw new KnxPropertyException(String.format("parsing IP address of PID %d: %s", pid, e.getMessage()));
        }
    }

    public String friendlyName() {
        String s;
        byte[] data = this.get(76, 1, 30);
        int end = (s = new String(data, StandardCharsets.ISO_8859_1)).indexOf(0);
        return s.substring(0, end == -1 ? data.length : end);
    }

    public void setFriendlyName(String name) {
        byte[] data = Arrays.copyOf(name.getBytes(StandardCharsets.ISO_8859_1), 30);
        this.set(76, 1, data.length, data);
    }

    public int deviceState() {
        return (int)KnxipParameterObject.unsigned(this.get(69, 1, 1));
    }

    public List<IndividualAddress> additionalAddresses() {
        ArrayList<IndividualAddress> list = new ArrayList<IndividualAddress>();
        try {
            byte[] data = this.get(53);
            ByteBuffer buf = ByteBuffer.wrap(data);
            while (buf.hasRemaining()) {
                list.add(new IndividualAddress(buf.getShort() & 0xFFFF));
            }
        }
        catch (KnxPropertyException knxPropertyException) {
            // empty catch block
        }
        return list;
    }

    public boolean securedService(ServiceFamiliesDIB.ServiceFamily serviceFamily) {
        try {
            long securedServices = KnxipParameterObject.unsigned(this.get(94));
            boolean secured = (securedServices >> serviceFamily.id() & 1L) == 1L;
            return secured;
        }
        catch (KnxPropertyException e) {
            return false;
        }
    }

    public void populateWithDefaults() {
        this.setInetAddress(65, KNXnetIPRouting.DefaultMulticast);
        this.set(69, 0);
        this.set(72, KnxipParameterObject.fromWord(0));
        this.set(74, new byte[4]);
        this.set(78, KnxipParameterObject.fromWord(100));
    }

    private static byte[] fromWord(int word) {
        return new byte[]{(byte)(word >> 8), (byte)word};
    }

    private static long unsigned(byte[] data) {
        long l = 0L;
        for (byte b : data) {
            l = (l << 8) + (long)(b & 0xFF);
        }
        return l;
    }

    public static final class Pid {
        public static final int TunnelingAddresses = 79;
        public static final int BackboneKey = 91;
        public static final int DeviceAuth = 92;
        public static final int UserPwdHashes = 93;
        public static final int SecuredServiceFamilies = 94;
        public static final int LatencyTolerance = 95;
        public static final int SyncLatencyFraction = 96;
        public static final int TunnelingUsers = 97;

        private Pid() {
        }
    }
}

