/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.device;

import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.IntUnaryOperator;
import org.slf4j.Logger;
import tuwien.auto.calimero.GroupAddress;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXAddress;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.ReturnCode;
import tuwien.auto.calimero.device.AccessPolicies;
import tuwien.auto.calimero.device.BaseKnxDevice;
import tuwien.auto.calimero.device.KnxDeviceServiceLogic;
import tuwien.auto.calimero.device.ServiceResult;
import tuwien.auto.calimero.device.ios.DeviceObject;
import tuwien.auto.calimero.device.ios.InterfaceObjectServer;
import tuwien.auto.calimero.device.ios.KnxPropertyException;
import tuwien.auto.calimero.device.ios.SecurityObject;
import tuwien.auto.calimero.log.LogService;
import tuwien.auto.calimero.mgmt.SecureManagement;
import tuwien.auto.calimero.mgmt.TransportLayer;
import tuwien.auto.calimero.mgmt.TransportLayerImpl;
import tuwien.auto.calimero.secure.KnxSecureException;
import tuwien.auto.calimero.secure.Security;
import tuwien.auto.calimero.secure.SecurityControl;

final class DeviceSecureApplicationLayer
extends SecureManagement {
    private static final int SeqSize = 6;
    private static final int KeySize = 16;
    private static final String secureSymbol = new String(Character.toChars(128274));
    private final InterfaceObjectServer ios;
    private final SecurityObject securityObject;
    private final Logger logger;
    private final Set<byte[]> lastFailures = Collections.newSetFromMap(new LinkedHashMap<byte[], Boolean>(){

        @Override
        protected boolean removeEldestEntry(Map.Entry<byte[], Boolean> eldest) {
            return this.size() > 10;
        }
    });

    DeviceSecureApplicationLayer(BaseKnxDevice device) {
        this(device.transportLayer(), device.getInterfaceObjectServer());
    }

    private DeviceSecureApplicationLayer(TransportLayer tl, InterfaceObjectServer ios) {
        this(tl, ios, (SecurityObject)ios.lookup(17, 1));
    }

    private DeviceSecureApplicationLayer(TransportLayer tl, InterfaceObjectServer ios, SecurityObject securityObject) {
        super((TransportLayerImpl)tl, DeviceObject.lookup(ios).serialNumber(), DeviceSecureApplicationLayer.unsigned(securityObject.get(59)), Map.of());
        this.ios = ios;
        this.securityObject = securityObject;
        String name = DeviceObject.lookup(ios).description();
        this.logger = LogService.getLogger((String)("calimero.device." + secureSymbol + "-AL " + name));
        long toolSeqNo = 0L;
        try {
            toolSeqNo = DeviceSecureApplicationLayer.unsigned(securityObject.get(250));
        }
        catch (KnxPropertyException knxPropertyException) {
            // empty catch block
        }
        if (toolSeqNo <= 1L) {
            this.resetToolAccessSequence();
        } else {
            this.updateSequenceNumber(true, toolSeqNo);
        }
        ByteBuffer failureLog = ByteBuffer.wrap(securityObject.get(55));
        this.initFailureCounter(1, failureLog.getShort() & 0xFFFF);
        this.initFailureCounter(2, failureLog.getShort() & 0xFFFF);
        this.initFailureCounter(3, failureLog.getShort() & 0xFFFF);
        this.initFailureCounter(4, failureLog.getShort() & 0xFFFF);
        while (failureLog.hasRemaining()) {
            byte[] buf = new byte[12];
            failureLog.get(buf);
            this.lastFailures.add(buf);
        }
        Security.defaultInstallation().groupKeys().forEach(this::tryAddSecuredGroupAddress);
    }

    public void close() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        baos.writeBytes(this.failureCountersArray());
        this.lastFailures.forEach(baos::writeBytes);
        this.securityObject.set(55, baos.toByteArray());
    }

    protected byte[] toolKey(IndividualAddress addr) {
        return this.securityObject.get(56);
    }

    protected void updateSequenceNumber(boolean toolAccess, long seqNo) {
        super.updateSequenceNumber(toolAccess, seqNo);
        if (toolAccess) {
            this.securityObject.set(250, DeviceSecureApplicationLayer.sixBytes(seqNo).array());
        } else {
            this.securityObject.set(59, DeviceSecureApplicationLayer.sixBytes(seqNo).array());
        }
    }

    protected byte[] securityKey(KNXAddress addr) {
        if (addr instanceof IndividualAddress) {
            int indAddressIndex = this.indAddressIndex((IndividualAddress)addr);
            if (indAddressIndex > 0) {
                return this.p2pKey(indAddressIndex);
            }
            return null;
        }
        int addressIndex = this.groupAddressIndex((GroupAddress)addr).orElseThrow(() -> new KnxSecureException("no group key for " + addr));
        return this.groupKey(addressIndex);
    }

    protected void updateLastValidSequence(boolean toolAccess, IndividualAddress remote, long seqNo) {
        if (toolAccess) {
            super.updateLastValidSequence(toolAccess, remote, seqNo);
        } else {
            byte[] addresses = this.securityObject.get(54);
            int entrySize = 8;
            int idx = DeviceSecureApplicationLayer.binarySearch(addresses, 8, 0, 2, remote.getRawAddress());
            if (idx >= 0) {
                ByteBuffer data = ByteBuffer.allocate(8).put(remote.toByteArray()).put(DeviceSecureApplicationLayer.sixBytes(seqNo));
                this.securityObject.set(54, idx + 1, 1, data.array());
            }
        }
    }

    protected long lastValidSequenceNumber(boolean toolAccess, IndividualAddress remote) {
        if (toolAccess) {
            return super.lastValidSequenceNumber(toolAccess, remote);
        }
        byte[] addresses = this.securityObject.get(54);
        int entrySize = 8;
        int idx = DeviceSecureApplicationLayer.binarySearch(addresses, 8, 0, 2, remote.getRawAddress());
        if (idx < 0) {
            return 0L;
        }
        int offset = idx * 8 + 2;
        return DeviceSecureApplicationLayer.unsigned(Arrays.copyOfRange(addresses, offset, offset + 6));
    }

    protected boolean checkAccess(KNXAddress dst, int service, SecurityControl securityCtrl) {
        if (dst instanceof GroupAddress && service == 0 || service == 128) {
            boolean auth;
            int goSecurity = this.groupObjectSecurity((GroupAddress)dst);
            boolean conf = (goSecurity & 2) == 2;
            boolean bl = auth = (goSecurity & 1) == 1;
            SecurityControl required = SecurityControl.of((SecurityControl.DataSecurity)(conf ? SecurityControl.DataSecurity.AuthConf : (auth ? SecurityControl.DataSecurity.Auth : SecurityControl.DataSecurity.None)), (boolean)false);
            if (!securityCtrl.equals((Object)required)) {
                this.logger.warn("group object {} security mismatch: requested {} but requires {}, ignore", new Object[]{dst, securityCtrl, required});
                return false;
            }
            return true;
        }
        return AccessPolicies.checkServiceAccess(service, this.isSecurityModeEnabled(), securityCtrl);
    }

    protected int groupObjectSecurity(GroupAddress group) {
        try {
            return this.groupAddressIndex(group).flatMap(this::groupObjectIndex).map(this::groupObjectSecurity).orElse(0);
        }
        catch (KnxPropertyException e) {
            return 0;
        }
    }

    protected void securityFailure(int errorType, IntUnaryOperator updateFunction, IndividualAddress src, KNXAddress dst, int ctrlExtended, long seqNo) {
        super.securityFailure(errorType, updateFunction, src, dst, ctrlExtended, seqNo);
        if (src == null) {
            return;
        }
        ByteBuffer buffer = ByteBuffer.allocate(12).put(src.toByteArray()).put(dst.toByteArray()).put((byte)ctrlExtended).put(DeviceSecureApplicationLayer.sixBytes(seqNo)).put((byte)errorType);
        this.lastFailures.add(buffer.array());
    }

    boolean isSecurityModeEnabled() {
        return this.securityObject.get(51, 1, 1)[0] == 1;
    }

    void setSecurityMode(boolean secure) {
        this.securityObject.set(51, (byte)(secure ? 1 : 0));
        this.logger.info("security mode {}", (Object)(secure ? "enabled" : "disabled"));
    }

    ServiceResult<byte[]> securityMode(boolean command, byte[] functionInput) {
        int serviceId = functionInput[1] & 0xFF;
        if (serviceId != 0) {
            return ServiceResult.error(ReturnCode.InvalidCommand);
        }
        if (command && functionInput.length == 3) {
            int mode = functionInput[2] & 0xFF;
            if (mode > 1) {
                return ServiceResult.error(ReturnCode.DataVoid);
            }
            this.setSecurityMode(mode == 1);
            return new ServiceResult<byte[]>(new byte[]{(byte)serviceId});
        }
        if (!command && functionInput.length == 2) {
            return new ServiceResult<byte[]>(new byte[]{(byte)serviceId, (byte)(this.isSecurityModeEnabled() ? 1 : 0)});
        }
        return ServiceResult.error(ReturnCode.Error);
    }

    ServiceResult<byte[]> securityFailuresLog(boolean command, byte[] functionInput) {
        if (functionInput.length != 3) {
            return ServiceResult.error(ReturnCode.DataVoid);
        }
        int id = functionInput[1] & 0xFF;
        int info = functionInput[2] & 0xFF;
        if (command) {
            if (id == 0 && info == 0) {
                this.clearFailureLog();
                return new ServiceResult<byte[]>(new byte[]{(byte)id});
            }
        } else {
            if (id == 0 && info == 0) {
                ByteBuffer counters = ByteBuffer.allocate(10).put((byte)id).put((byte)info).put(this.failureCountersArray());
                return ServiceResult.of(counters.array());
            }
            if (id == 1) {
                int index = info;
                int i = 0;
                for (byte[] msgInfo : this.lastFailures) {
                    if (i++ != index) continue;
                    return ServiceResult.of(ByteBuffer.allocate(2 + msgInfo.length).put((byte)id).put((byte)index).put(msgInfo).array());
                }
                return ServiceResult.of(ReturnCode.DataVoid, (byte)id);
            }
        }
        return ServiceResult.error(ReturnCode.InvalidCommand);
    }

    void factoryReset() {
        this.resetToolAccessSequence();
        this.clearFailureLog();
    }

    private void initFailureCounter(int errorType, int value) {
        this.securityFailure(errorType, __ -> value, null, null, 0, 0L);
    }

    private byte[] failureCountersArray() {
        int scf = this.failureCounter(1);
        int seqno = this.failureCounter(2);
        int crypto = this.failureCounter(3);
        int role = this.failureCounter(4);
        return ByteBuffer.allocate(8).putShort((short)scf).putShort((short)seqno).putShort((short)crypto).putShort((short)role).array();
    }

    private void clearFailureLog() {
        this.initFailureCounter(1, 0);
        this.initFailureCounter(2, 0);
        this.initFailureCounter(3, 0);
        this.initFailureCounter(4, 0);
        this.lastFailures.clear();
    }

    private void resetToolAccessSequence() {
        long counter = 0L;
        try {
            counter = DeviceObject.lookup(this.ios).downloadCounter();
        }
        catch (KnxPropertyException knxPropertyException) {
            // empty catch block
        }
        long initial = counter * 20L + (long)ThreadLocalRandom.current().nextInt(20) + 2L;
        this.updateSequenceNumber(true, initial);
    }

    private void addSecureLink(IndividualAddress address, long lastValidSeqNo) {
        byte[] addresses = this.securityObject.get(54);
        int raw = address.getRawAddress();
        int entrySize = 8;
        int idx = DeviceSecureApplicationLayer.binarySearch(addresses, 8, 0, 2, raw);
        int insert = idx < 0 ? -idx : idx + 1;
        byte[] element = ByteBuffer.allocate(8).putShort((short)raw).put(DeviceSecureApplicationLayer.sixBytes(lastValidSeqNo)).array();
        this.securityObject.set(54, insert, 1, element);
    }

    private void tryAddSecuredGroupAddress(GroupAddress address, byte[] groupKey) {
        try {
            this.addSecuredGroupAddress(address, groupKey);
        }
        catch (KnxSecureException knxSecureException) {
            // empty catch block
        }
    }

    private void addSecuredGroupAddress(GroupAddress address, byte[] groupKey) {
        if (groupKey.length != 0 && groupKey.length != 16) {
            throw new KNXIllegalArgumentException("group key with invalid length " + groupKey.length);
        }
        int gaIndex = this.groupAddressIndex(address).orElseThrow(() -> new KnxSecureException(address + " not in address table"));
        byte[] addresses = this.securityObject.get(53);
        int entrySize = 18;
        int idx = DeviceSecureApplicationLayer.binarySearch(addresses, 18, 0, 2, gaIndex);
        int insert = idx < 0 ? -idx : idx + 1;
        byte[] element = ByteBuffer.allocate(18).putShort((short)gaIndex).put(groupKey).array();
        this.securityObject.set(53, insert, 1, element);
    }

    private int indAddressIndex(IndividualAddress address) {
        byte[] addresses = this.securityObject.get(54);
        int entrySize = 8;
        return 1 + DeviceSecureApplicationLayer.binarySearch(addresses, 8, 0, 2, address.getRawAddress());
    }

    private Optional<Integer> groupAddressIndex(GroupAddress address) {
        return KnxDeviceServiceLogic.groupAddressIndex(this.ios, address);
    }

    private Optional<Integer> groupObjectIndex(int groupAddressIndex) {
        return KnxDeviceServiceLogic.groupObjectIndex(this.ios, groupAddressIndex);
    }

    private byte[] p2pKey(int addressIndex) {
        return this.lookupKey(52, addressIndex, 20);
    }

    private byte[] groupKey(int addressIndex) {
        return this.lookupKey(53, addressIndex, 18);
    }

    private byte[] lookupKey(int pidTable, int addressIndex, int entrySize) {
        if (!this.securityObject.isLoaded()) {
            return null;
        }
        byte[] keyArray = this.securityObject.get(pidTable);
        int idx = DeviceSecureApplicationLayer.binarySearch(keyArray, entrySize, 0, 2, addressIndex);
        if (idx < 0) {
            return null;
        }
        int offset = idx * entrySize + 2;
        return Arrays.copyOfRange(keyArray, offset, offset + 16);
    }

    private int groupObjectSecurity(int groupObjectIndex) {
        return this.securityObject.get(61, groupObjectIndex, 1)[0] & 0xFF;
    }

    static int binarySearch(byte[] a, int entrySize, int valueOffset, int typeSize, long key) {
        assert (entrySize >= valueOffset + typeSize);
        assert (a.length % entrySize == 0);
        int low = 0;
        int high = a.length / entrySize - 1;
        while (low <= high) {
            int mid = low + high >>> 1;
            int from = mid * entrySize + valueOffset;
            byte[] midVal = Arrays.copyOfRange(a, from, from + typeSize);
            long u = DeviceSecureApplicationLayer.unsigned(midVal);
            long cmp = u - key;
            if (cmp < 0L) {
                low = mid + 1;
                continue;
            }
            if (cmp > 0L) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    private static long unsigned(byte[] data) {
        long l = 0L;
        for (byte b : data) {
            l = (l << 8) + (long)(b & 0xFF);
        }
        return l;
    }

    private static ByteBuffer sixBytes(long num) {
        return ByteBuffer.allocate(6).putShort((short)(num >> 32)).putInt((int)num).flip();
    }
}

