/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.device;

import java.time.Duration;
import tuwien.auto.calimero.DeviceDescriptor;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXAddress;
import tuwien.auto.calimero.SerialNumber;
import tuwien.auto.calimero.device.ServiceResult;
import tuwien.auto.calimero.mgmt.Description;
import tuwien.auto.calimero.mgmt.Destination;
import tuwien.auto.calimero.mgmt.ManagementClient;
import tuwien.auto.calimero.mgmt.TransportLayer;

public interface ManagementService {
    public ServiceResult<byte[]> readProperty(Destination var1, int var2, int var3, int var4, int var5);

    public ServiceResult<Void> writeProperty(Destination var1, int var2, int var3, int var4, int var5, byte[] var6);

    public ServiceResult<Description> readPropertyDescription(int var1, int var2, int var3);

    default public ServiceResult<byte[]> functionPropertyCommand(Destination remote, int objectIndex, int propertyId, byte[] command) {
        return ServiceResult.empty();
    }

    default public ServiceResult<byte[]> readFunctionPropertyState(Destination remote, int objectIndex, int propertyId, byte[] functionInput) {
        return ServiceResult.empty();
    }

    public ServiceResult<byte[]> readMemory(int var1, int var2);

    public ServiceResult<Void> writeMemory(int var1, byte[] var2);

    public ServiceResult<Boolean> readAddress();

    public void writeAddress(IndividualAddress var1);

    public ServiceResult<Boolean> readAddressSerial(SerialNumber var1);

    default public ServiceResult<Boolean> readAddressSerial(byte[] serialNo) {
        return this.readAddressSerial(SerialNumber.from((byte[])serialNo));
    }

    public void writeAddressSerial(SerialNumber var1, IndividualAddress var2);

    default public void writeAddressSerial(byte[] serialNo, IndividualAddress newAddress) {
        this.writeAddressSerial(SerialNumber.from((byte[])serialNo), newAddress);
    }

    public ServiceResult<Boolean> readDomainAddress();

    public ServiceResult<Boolean> readDomainAddress(byte[] var1, IndividualAddress var2, int var3);

    public ServiceResult<Boolean> readDomainAddress(byte[] var1, byte[] var2);

    public void writeDomainAddress(byte[] var1);

    default public ServiceResult<byte[]> readParameter(int objectType, int pid, byte[] testInfo) {
        return ServiceResult.empty();
    }

    default public void writeParameter(int objectType, int pid, byte[] value) {
    }

    public ServiceResult<DeviceDescriptor> readDescriptor(int var1);

    public ServiceResult<Integer> readADC(int var1, int var2);

    public ServiceResult<Integer> writeAuthKey(Destination var1, int var2, byte[] var3);

    public ServiceResult<Integer> authorize(Destination var1, byte[] var2);

    public ServiceResult<Duration> restart(boolean var1, ManagementClient.EraseCode var2, int var3);

    public ServiceResult<byte[]> management(int var1, byte[] var2, KNXAddress var3, Destination var4, TransportLayer var5);

    public boolean isVerifyModeEnabled();
}

