/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.device;

import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Arrays;
import java.util.EventObject;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import tuwien.auto.calimero.CloseEvent;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.DetachEvent;
import tuwien.auto.calimero.DeviceDescriptor;
import tuwien.auto.calimero.FrameEvent;
import tuwien.auto.calimero.GroupAddress;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXAddress;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.KnxRuntimeException;
import tuwien.auto.calimero.Priority;
import tuwien.auto.calimero.ReturnCode;
import tuwien.auto.calimero.SerialNumber;
import tuwien.auto.calimero.cemi.CEMI;
import tuwien.auto.calimero.cemi.CEMILData;
import tuwien.auto.calimero.cemi.CemiTData;
import tuwien.auto.calimero.device.AccessPolicies;
import tuwien.auto.calimero.device.BaseKnxDevice;
import tuwien.auto.calimero.device.DeviceSecureApplicationLayer;
import tuwien.auto.calimero.device.KnxDeviceServiceLogic;
import tuwien.auto.calimero.device.ManagementService;
import tuwien.auto.calimero.device.ServiceResult;
import tuwien.auto.calimero.device.ios.DeviceObject;
import tuwien.auto.calimero.device.ios.InterfaceObject;
import tuwien.auto.calimero.device.ios.InterfaceObjectServer;
import tuwien.auto.calimero.device.ios.KnxPropertyException;
import tuwien.auto.calimero.device.ios.SecurityObject;
import tuwien.auto.calimero.link.KNXLinkClosedException;
import tuwien.auto.calimero.link.medium.KNXMediumSettings;
import tuwien.auto.calimero.link.medium.PLSettings;
import tuwien.auto.calimero.link.medium.RFSettings;
import tuwien.auto.calimero.mgmt.Description;
import tuwien.auto.calimero.mgmt.Destination;
import tuwien.auto.calimero.mgmt.KNXDisconnectException;
import tuwien.auto.calimero.mgmt.ManagementClient;
import tuwien.auto.calimero.mgmt.PropertyClient;
import tuwien.auto.calimero.mgmt.TransportLayer;
import tuwien.auto.calimero.mgmt.TransportLayerImpl;
import tuwien.auto.calimero.mgmt.TransportListener;
import tuwien.auto.calimero.secure.SecurityControl;

class ManagementServiceNotifier
implements TransportListener,
AutoCloseable {
    private static final int ADC_READ = 384;
    private static final int ADC_RESPONSE = 448;
    private static final int AUTHORIZE_READ = 977;
    private static final int AUTHORIZE_RESPONSE = 978;
    private static final int DOA_WRITE = 992;
    private static final int DOA_READ = 993;
    private static final int DOA_RESPONSE = 994;
    private static final int DOA_SELECTIVE_READ = 995;
    private static final int DoASerialNumberRead = 1004;
    private static final int DoASerialNumberResponse = 1005;
    private static final int DoASerialNumberWrite = 1006;
    private static final int IND_ADDR_READ = 256;
    private static final int IND_ADDR_RESPONSE = 320;
    private static final int IND_ADDR_WRITE = 192;
    private static final int IND_ADDR_SN_READ = 988;
    private static final int IND_ADDR_SN_RESPONSE = 989;
    private static final int IND_ADDR_SN_WRITE = 990;
    private static final int DEVICE_DESC_READ = 768;
    private static final int DEVICE_DESC_RESPONSE = 832;
    private static final int KEY_WRITE = 979;
    private static final int KEY_RESPONSE = 980;
    private static final int MEMORY_READ = 512;
    private static final int MEMORY_RESPONSE = 576;
    private static final int MEMORY_WRITE = 640;
    private static final int PROPERTY_DESC_READ = 984;
    private static final int PROPERTY_DESC_RESPONSE = 985;
    private static final int PROPERTY_READ = 981;
    private static final int PROPERTY_RESPONSE = 982;
    private static final int PROPERTY_WRITE = 983;
    private static final int RESTART = 896;
    static final int FunctionPropertyCommand = 711;
    private static final int FunctionPropertyStateRead = 712;
    private static final int FunctionPropertyStateResponse = 713;
    static final int MemoryExtendedWrite = 507;
    private static final int MemoryExtendedWriteResponse = 508;
    static final int MemoryExtendedRead = 509;
    private static final int MemoryExtendedReadResponse = 510;
    private static final int SystemNetworkParamRead = 456;
    private static final int SystemNetworkParamResponse = 457;
    private static final int SystemNetworkParamWrite = 458;
    private static final int NetworkParamRead = 986;
    private static final int NetworkParamResponse = 987;
    private static final int NetworkParamWrite = 996;
    private static final int PropertyExtRead = 460;
    private static final int PropertyExtResponse = 461;
    private static final int PropertyExtWriteCon = 462;
    private static final int PropertyExtWriteConResponse = 463;
    private static final int PropertyExtWriteUnCon = 464;
    private static final int PropertyExtDescriptionRead = 466;
    private static final int PropertyExtDescriptionResponse = 467;
    private static final int FunctionPropertyExtCommand = 468;
    private static final int FunctionPropertyExtStateRead = 469;
    private static final int FunctionPropertyExtStateResponse = 470;
    private static final int defaultMaxApduLength = 254;
    private boolean missingApduLength;
    private final BaseKnxDevice device;
    private final TransportLayer tl;
    private final DeviceSecureApplicationLayer sal;
    private final ManagementService mgmtSvc;
    private final Logger logger;
    private final int lengthDoA;
    private SecurityControl securityCtrl;
    private volatile Priority svcPriority;
    private static final int testInfoLength = 3;

    ManagementServiceNotifier(BaseKnxDevice device, ManagementService mgmt) throws KNXLinkClosedException {
        this.device = device;
        this.tl = device.transportLayer();
        this.sal = (DeviceSecureApplicationLayer)device.secureApplicationLayer();
        this.mgmtSvc = mgmt;
        this.logger = device.logger();
        int medium = device.getDeviceLink().getKNXMedium().getMedium();
        this.lengthDoA = medium == 4 ? 2 : (medium == 16 ? 6 : 0);
        this.sal.addListener(this);
        AccessPolicies.definitions = device.getInterfaceObjectServer().propertyDefinitions();
    }

    public void broadcast(FrameEvent e) {
        this.dispatchAndRespond(e);
    }

    public void dataConnected(FrameEvent e) {
        this.dispatchAndRespond(e);
    }

    public void dataIndividual(FrameEvent e) {
        this.dispatchAndRespond(e);
    }

    public void disconnected(Destination d) {
        d.destroy();
        ((KnxDeviceServiceLogic)this.mgmtSvc).destinationDisconnected(d);
    }

    public void group(FrameEvent e) {
    }

    public void detached(DetachEvent e) {
    }

    public void linkClosed(CloseEvent e) {
        this.logger.info("attached link was closed");
    }

    public void respond(EventObject e, ServiceResult<?> sr) {
        Destination d;
        IndividualAddress dst;
        IndividualAddress sender;
        FrameEvent fe = (FrameEvent)e;
        CEMI cemi = fe.getFrame();
        byte[] tpdu = cemi.getPayload();
        TransportLayerImpl impl = (TransportLayerImpl)this.tl;
        if (cemi instanceof CemiTData) {
            sender = new IndividualAddress(0);
            dst = new IndividualAddress(0);
            d = impl.createDestination(sender, false);
            d.close();
        } else {
            CEMILData ldata = (CEMILData)cemi;
            sender = ldata.getSource();
            d = impl.getDestination(sender);
            if (d == null) {
                d = impl.createDestination(sender, false);
            }
            dst = ldata.getDestination();
            this.svcPriority = ldata.getPriority();
        }
        int svc = DataUnitBuilder.getAPDUService((byte[])tpdu);
        byte[] asdu = DataUnitBuilder.extractASDU((byte[])tpdu);
        if (tpdu.length - 1 > this.getMaxApduLength()) {
            this.logger.warn("discard {}->{} {}: exceeds max. allowed APDU length of {}", new Object[]{sender, dst, DataUnitBuilder.decode((byte[])tpdu, (KNXAddress)dst), this.getMaxApduLength()});
            return;
        }
        try {
            this.dispatchToService(svc, asdu, (KNXAddress)dst, d, fe.security().orElse(SecurityControl.Plain));
        }
        catch (RuntimeException rte) {
            this.logger.warn("failed to execute service {}->{} {}: {}", new Object[]{sender, dst, DataUnitBuilder.decode((byte[])tpdu, (KNXAddress)dst), DataUnitBuilder.toHex((byte[])asdu, (String)" "), rte});
        }
    }

    @Override
    public void close() {
        this.tl.detach();
    }

    private void dispatchAndRespond(FrameEvent e) {
        CEMILData ldata;
        KNXAddress dst;
        CEMI cemi = e.getFrame();
        if (cemi instanceof CEMILData && (dst = (ldata = (CEMILData)cemi).getDestination()) instanceof IndividualAddress && !dst.equals(this.device.getAddress())) {
            return;
        }
        this.device.dispatch((EventObject)e, () -> ServiceResult.empty(), this::respond);
    }

    private void dispatchToService(int svc, byte[] data, KNXAddress dst, Destination respondTo, SecurityControl secCtrl) {
        boolean granted = AccessPolicies.checkServiceAccess(svc, this.sal.isSecurityModeEnabled(), secCtrl);
        if (!granted) {
            return;
        }
        this.securityCtrl = secCtrl;
        String name = DataUnitBuilder.decodeAPCI((int)svc);
        if (svc == 512) {
            this.onMemoryRead(name, respondTo, data);
        } else if (svc == 640) {
            this.onMemoryWrite(name, respondTo, data);
        } else if (svc == 984) {
            this.onPropDescRead(name, dst, respondTo, data);
        } else if (svc == 981) {
            this.onPropertyRead(name, dst, respondTo, data);
        } else if (svc == 983) {
            this.onPropertyWrite(name, dst, respondTo, data);
        } else if (svc == 768) {
            this.onDeviceDescRead(name, respondTo, data);
        } else if (svc == 384) {
            this.onAdcRead(name, respondTo, data);
        } else if (svc == 977) {
            this.onAuthorize(name, respondTo, data);
        } else if (svc == 256) {
            this.onIndAddrRead(name, respondTo, data);
        } else if (svc == 192) {
            this.onIndAddrWrite(name, respondTo, data);
        } else if (svc == 988) {
            this.onIndAddrSnRead(name, respondTo, data);
        } else if (svc == 990) {
            this.onIndAddrSnWrite(name, respondTo, data);
        } else if (svc == 993) {
            this.onDoARead(name, respondTo, data);
        } else if (svc == 995) {
            this.onDoASelectiveRead(name, respondTo, data);
        } else if (svc == 992) {
            this.onDoAWrite(name, respondTo, data);
        } else if (svc == 1004) {
            this.onDoASerialNumberRead(name, respondTo, data);
        } else if (svc == 1006) {
            this.onDoASerialNumberWrite(name, respondTo, data);
        } else if (svc == 979) {
            this.onKeyWrite(name, respondTo, data);
        } else if (svc == 896) {
            this.onRestart(name, respondTo, data);
        } else if (svc == 711) {
            this.onFunctionPropertyCommandOrState(name, dst, respondTo, true, data);
        } else if (svc == 712) {
            this.onFunctionPropertyCommandOrState(name, dst, respondTo, false, data);
        } else if (svc == 507) {
            this.onMemoryExtendedWrite(name, respondTo, data);
        } else if (svc == 509) {
            this.onMemoryExtendedRead(name, respondTo, data);
        } else if (svc == 986) {
            this.onNetworkParamRead(name, respondTo, data, false, dst.getRawAddress() == 0);
        } else if (svc == 996) {
            this.onNetworkParamWrite(name, respondTo, data, false);
        } else if (svc == 456) {
            this.onNetworkParamRead(name, respondTo, data, true, dst.getRawAddress() == 0);
        } else if (svc == 458) {
            this.onNetworkParamWrite(name, respondTo, data, true);
        } else if (svc == 460) {
            this.onPropertyExtRead(name, dst, respondTo, data);
        } else if (svc == 462 || svc == 464) {
            this.onPropertyExtWrite(name, dst, respondTo, data, svc == 462);
        } else if (svc == 466) {
            this.onPropertyExtDescriptionRead(name, dst, respondTo, data);
        } else if (svc == 468) {
            this.onFunctionPropertyExtCommandOrState(name, dst, respondTo, true, data, true);
        } else if (svc == 469) {
            this.onFunctionPropertyExtCommandOrState(name, dst, respondTo, false, data, true);
        } else {
            this.onManagement(svc, data, dst, respondTo);
        }
    }

    private void onNetworkParamRead(String name, Destination respondTo, byte[] data, boolean systemRead, boolean broadcast) {
        int service;
        int paramTypeSize;
        int n = paramTypeSize = systemRead ? 4 : 3;
        if (!this.verifyLength(data.length, paramTypeSize + 1, paramTypeSize + 3, name)) {
            return;
        }
        ByteBuffer buffer = ByteBuffer.wrap(data);
        int objectType = buffer.getShort() & 0xFF;
        int pid = systemRead ? (buffer.getShort() & 0xFFFF) >> 4 : buffer.get() & 0xFF;
        byte[] info = new byte[buffer.remaining()];
        buffer.get(info);
        String propertyName = this.propertyNameByObjectType(objectType, pid);
        this.logger.trace("{}->{} {} {}(1)|{}{} info {}", new Object[]{respondTo.getAddress(), GroupAddress.Broadcast, name, objectType, pid, propertyName, DataUnitBuilder.toHex((byte[])info, (String)" ")});
        ServiceResult<byte[]> sr = this.mgmtSvc.readParameter(objectType, pid, info);
        if (this.ignoreOrSchedule(sr)) {
            return;
        }
        byte[] res = sr.result();
        if (res.length == 0) {
            if (broadcast) {
                return;
            }
            objectType = 65535;
            pid = 255;
            info = new byte[]{};
        }
        ByteBuffer asdu = ByteBuffer.allocate(paramTypeSize + info.length + res.length);
        asdu.putShort((short)objectType);
        if (systemRead) {
            asdu.putShort((short)(pid << 4));
        } else {
            asdu.put((byte)pid);
        }
        asdu.put(info).put(res);
        int n2 = service = systemRead ? 457 : 987;
        if (broadcast) {
            byte[] apdu = DataUnitBuilder.createAPDU((int)service, (byte[])asdu.array());
            this.sendBroadcast(systemRead, apdu, Priority.SYSTEM, DataUnitBuilder.decodeAPCI((int)service));
        } else {
            this.send(respondTo, service, asdu.array(), Priority.SYSTEM);
        }
    }

    private void onNetworkParamWrite(String name, Destination respondTo, byte[] data, boolean systemWrite) {
        int minExpected;
        int n = minExpected = systemWrite ? 5 : 4;
        if (!this.verifyLength(data.length, minExpected, 12, name)) {
            return;
        }
        ByteBuffer buffer = ByteBuffer.wrap(data);
        int objectType = buffer.getShort() & 0xFF;
        int pid = systemWrite ? (buffer.getShort() & 0xFFFF) >> 4 : buffer.get() & 0xFF;
        byte[] info = new byte[buffer.remaining()];
        buffer.get(info);
        this.logger.trace("{}->{} {} {}(1)|{}{} info {}", new Object[]{respondTo.getAddress(), "[]", name, objectType, pid, this.propertyNameByObjectType(objectType, pid), DataUnitBuilder.toHex((byte[])info, (String)" ")});
        this.mgmtSvc.writeParameter(objectType, pid, info);
    }

    private void onRestart(String name, Destination respondTo, byte[] data) {
        if (!this.verifyLength(data.length, 1, 3, name)) {
            return;
        }
        int reserved = data[0] & 0x1E;
        if (reserved != 0) {
            this.logger.warn("{} uses reserved bits -- ignore", (Object)name);
            return;
        }
        boolean masterReset = (data[0] & 1) == 1;
        int eraseCode = masterReset ? data[1] & 0xFF : 0;
        int channel = masterReset ? data[2] & 0xFF : 0;
        int unsupportedEraseCode = 2;
        byte errorCode = 2;
        ServiceResult<Duration> sr = ServiceResult.of(Duration.ZERO);
        ManagementClient.EraseCode code = null;
        try {
            if (eraseCode > 0) {
                code = ManagementClient.EraseCode.of((int)eraseCode);
            }
            if (!AccessPolicies.checkRestartAccess(masterReset, code, this.sal.isSecurityModeEnabled(), this.securityCtrl)) {
                return;
            }
            this.logger.trace("{}->{} {}: {}, channel {}", new Object[]{respondTo.getAddress(), this.device.getAddress(), name, code == null ? "Basic Restart" : code, channel});
            sr = this.mgmtSvc.restart(masterReset, code, channel);
            if (!masterReset || this.ignoreOrSchedule(sr)) {
                return;
            }
            errorCode = 0;
        }
        catch (KNXIllegalArgumentException e) {
            this.logger.warn("{}->{} {}: {}", new Object[]{respondTo.getAddress(), this.device.getAddress(), name, e.getMessage()});
        }
        byte[] asdu = new byte[]{33, errorCode, 0, (byte)sr.result().toSeconds()};
        byte[] apdu = DataUnitBuilder.createLengthOptimizedAPDU((int)896, (byte[])asdu);
        this.send(respondTo, apdu, sr.getPriority(), name);
        List<Destination> destinations = this.transportLayerProxies().values().stream().map(p -> p.getDestination()).collect(Collectors.toList());
        destinations.forEach(Destination::destroy);
        if (code == ManagementClient.EraseCode.FactoryReset || code == ManagementClient.EraseCode.FactoryResetWithoutIndividualAddress) {
            SecurityObject.lookup(this.device.getInterfaceObjectServer()).populateWithDefaults();
        }
    }

    private void onKeyWrite(String name, Destination respondTo, byte[] data) {
        if (!this.verifyLength(data.length, 5, 5, name)) {
            return;
        }
        if (!respondTo.isConnectionOriented()) {
            return;
        }
        int level = data[0] & 0xFF;
        byte[] key = Arrays.copyOfRange(data, 1, 5);
        this.logger.trace("{}->{} {} level {} key 0x{}", new Object[]{respondTo.getAddress(), this.device.getAddress(), name, level, DataUnitBuilder.toHex((byte[])key, (String)"")});
        ServiceResult<Integer> sr = this.mgmtSvc.writeAuthKey(respondTo, level, key);
        if (this.ignoreOrSchedule(sr)) {
            return;
        }
        this.send(respondTo, 980, new byte[]{(byte)sr.result().intValue()}, sr.getPriority());
    }

    private void onIndAddrSnWrite(String name, Destination respondTo, byte[] data) {
        if (!this.verifyLength(data.length, 12, 12, name)) {
            return;
        }
        SerialNumber sn = SerialNumber.from((byte[])Arrays.copyOfRange(data, 0, 6));
        byte[] addr = Arrays.copyOfRange(data, 6, 8);
        byte[] reserved = Arrays.copyOfRange(data, 8, 12);
        IndividualAddress ia = new IndividualAddress(addr);
        this.logger.trace("{}->{} {} {} {}", new Object[]{respondTo.getAddress(), this.device.getAddress(), name, sn, ia});
        for (int i = 0; i < reserved.length; ++i) {
            byte b = reserved[i];
            if (b == 0) continue;
            this.logger.warn("byte " + (16 + i) + " not 0 (reserved area)");
        }
        this.mgmtSvc.writeAddressSerial(sn, ia);
    }

    private void onIndAddrSnRead(String name, Destination respondTo, byte[] data) {
        if (!this.verifyLength(data.length, 6, 6, name)) {
            return;
        }
        SerialNumber sn = SerialNumber.from((byte[])data);
        this.logger.trace("{}->{} {} {}", new Object[]{respondTo.getAddress(), this.device.getAddress(), name, sn});
        ServiceResult<Boolean> sr = this.mgmtSvc.readAddressSerial(sn);
        if (!sr.result().booleanValue()) {
            return;
        }
        if (this.ignoreOrSchedule(sr)) {
            return;
        }
        byte[] asdu = new byte[10];
        for (int i = 0; i < data.length; ++i) {
            byte b;
            asdu[i] = b = data[i];
        }
        byte[] apdu = DataUnitBuilder.createAPDU((int)989, (byte[])asdu);
        this.sendBroadcast(false, apdu, Priority.SYSTEM, DataUnitBuilder.decodeAPCI((int)989));
    }

    private void onIndAddrWrite(String name, Destination respondTo, byte[] data) {
        if (!this.verifyLength(data.length, 2, 2, name)) {
            return;
        }
        byte[] addr = Arrays.copyOfRange(data, 0, 2);
        IndividualAddress ia = new IndividualAddress(addr);
        this.logger.trace("{}->{} {} {}", new Object[]{respondTo.getAddress(), this.device.getAddress(), name, ia});
        this.mgmtSvc.writeAddress(ia);
    }

    private void onIndAddrRead(String name, Destination respondTo, byte[] data) {
        if (!this.verifyLength(data.length, 1, 1, name)) {
            return;
        }
        this.logger.trace("{}->{} {}", new Object[]{respondTo.getAddress(), this.device.getAddress(), name});
        ServiceResult<Boolean> sr = this.mgmtSvc.readAddress();
        if (!sr.result().booleanValue()) {
            return;
        }
        if (this.ignoreOrSchedule(sr)) {
            return;
        }
        byte[] asdu = new byte[]{};
        byte[] apdu = DataUnitBuilder.createAPDU((int)320, (byte[])asdu);
        this.sendBroadcast(false, apdu, Priority.SYSTEM, DataUnitBuilder.decodeAPCI((int)320));
    }

    private void onDoARead(String name, Destination respondTo, byte[] data) {
        if (!this.verifyLength(data.length, 0, 0, name)) {
            return;
        }
        this.logger.trace("{}->{} {}", new Object[]{respondTo.getAddress(), this.device.getAddress(), name});
        ServiceResult<Boolean> sr = this.mgmtSvc.readDomainAddress();
        this.sendDoAresponse(respondTo, sr);
    }

    private void onDoASelectiveRead(String name, Destination respondTo, byte[] data) {
        if (!this.verifyLength(data.length, 5, 14, name)) {
            return;
        }
        if (data[0] == 0 && data.length == 5) {
            byte[] domain = Arrays.copyOfRange(data, 0, 2);
            IndividualAddress ia = new IndividualAddress(Arrays.copyOfRange(data, 2, 4));
            int range = data[4] & 0xFF;
            this.logger.trace("{}->{} {} {} - {}", new Object[]{respondTo.getAddress(), this.device.getAddress(), name, ia, new IndividualAddress(ia.getRawAddress() + range)});
            ServiceResult<Boolean> sr = this.mgmtSvc.readDomainAddress(domain, ia, range);
            this.sendDoAresponse(respondTo, sr);
        } else if (data[0] == 1 && data.length == 14) {
            byte[] start = Arrays.copyOfRange(data, 1, 7);
            byte[] end = Arrays.copyOfRange(data, 7, 13);
            this.logger.trace("{}->{} {} {} - {}", new Object[]{respondTo.getAddress(), this.device.getAddress(), name, DataUnitBuilder.toHex((byte[])start, (String)""), DataUnitBuilder.toHex((byte[])end, (String)"")});
            ServiceResult<Boolean> sr = this.mgmtSvc.readDomainAddress(start, end);
            this.sendDoAresponse(respondTo, sr);
        }
    }

    private void sendDoAresponse(Destination respondTo, ServiceResult<Boolean> sr) {
        byte[] asdu;
        if (!sr.result().booleanValue()) {
            return;
        }
        if (this.ignoreOrSchedule(sr)) {
            return;
        }
        byte[] domain = this.domainAddress();
        if (domain.length != this.lengthDoA) {
            this.logger.error("length of domain address is {} bytes, should be {} - ignore", (Object)domain.length, (Object)this.lengthDoA);
            return;
        }
        if (this.lengthDoA == 2) {
            asdu = domain;
        } else if (this.lengthDoA == 6) {
            asdu = new byte[]{1, domain[0], domain[1], domain[2], domain[3], domain[4], domain[5]};
        } else {
            return;
        }
        this.send(respondTo, 994, asdu, sr.getPriority());
    }

    private byte[] domainAddress() {
        KNXMediumSettings settings = this.device.getDeviceLink().getKNXMedium();
        byte[] domain = settings instanceof PLSettings ? ((PLSettings)settings).getDomainAddress() : (settings instanceof RFSettings ? ((RFSettings)settings).getDomainAddress() : new byte[]{});
        return domain;
    }

    private void onDoAWrite(String name, Destination respondTo, byte[] data) {
        if (!this.verifyLength(data.length, this.lengthDoA, this.lengthDoA, name)) {
            return;
        }
        byte[] domain = Arrays.copyOfRange(data, 0, this.lengthDoA);
        this.logger.trace("{}->{} {} 0x{}", new Object[]{respondTo.getAddress(), this.device.getAddress(), name, DataUnitBuilder.toHex((byte[])domain, (String)"")});
        this.mgmtSvc.writeDomainAddress(domain);
    }

    private void onDoASerialNumberWrite(String name, Destination respondTo, byte[] data) {
        if (!this.verifyLength(data.length, 6 + this.lengthDoA, 6 + this.lengthDoA, name)) {
            return;
        }
        SerialNumber sno = SerialNumber.from((byte[])Arrays.copyOfRange(data, 0, 6));
        if (!this.matchesOurSerialNumber(sno)) {
            return;
        }
        byte[] domain = Arrays.copyOfRange(data, 6, 6 + this.lengthDoA);
        this.logger.trace("{}->{} {} SN {} DoA 0x{}", new Object[]{respondTo.getAddress(), this.device.getAddress(), name, sno, DataUnitBuilder.toHex((byte[])domain, (String)"")});
        this.mgmtSvc.writeDomainAddress(domain);
    }

    private void onDoASerialNumberRead(String name, Destination respondTo, byte[] data) {
        if (!this.verifyLength(data.length, 6, 6, name)) {
            return;
        }
        SerialNumber sno = SerialNumber.from((byte[])data);
        if (!this.matchesOurSerialNumber(sno)) {
            return;
        }
        this.logger.trace("{}->{} {} SN {}", new Object[]{respondTo.getAddress(), this.device.getAddress(), name, sno});
        byte[] endDoA = new byte[]{-1, -1, -1, -1, -1, -1};
        ServiceResult<Boolean> sr = this.mgmtSvc.readDomainAddress(new byte[this.lengthDoA], Arrays.copyOfRange(endDoA, 0, this.lengthDoA));
        if (!sr.result().booleanValue()) {
            return;
        }
        if (this.ignoreOrSchedule(sr)) {
            return;
        }
        byte[] domain = this.domainAddress();
        if (domain.length != this.lengthDoA) {
            this.logger.warn("length of domain address is {} bytes, should be {} - ignore", (Object)domain.length, (Object)this.lengthDoA);
            return;
        }
        byte[] asdu = ByteBuffer.allocate(6 + this.lengthDoA).put(sno.array()).put(domain).array();
        byte[] apdu = DataUnitBuilder.createAPDU((int)1005, (byte[])asdu);
        this.sendBroadcast(true, apdu, Priority.SYSTEM, DataUnitBuilder.decodeAPCI((int)1005));
    }

    private boolean matchesOurSerialNumber(SerialNumber sno) {
        RFSettings rfSettings;
        KNXMediumSettings medium = this.device.getDeviceLink().getKNXMedium();
        SerialNumber serialNumber = SerialNumber.Zero;
        if (medium instanceof RFSettings && (serialNumber = (rfSettings = (RFSettings)medium).serialNumber()).equals((Object)SerialNumber.Zero)) {
            try {
                serialNumber = DeviceObject.lookup(this.device.getInterfaceObjectServer()).serialNumber();
            }
            catch (KnxPropertyException e) {
                this.logger.warn("RF device with no serial number", (Throwable)((Object)e));
            }
        }
        return sno.equals((Object)serialNumber);
    }

    private void onAuthorize(String name, Destination respondTo, byte[] data) {
        if (!this.verifyLength(data.length, 5, 5, name)) {
            return;
        }
        if (respondTo.getState() != Destination.State.OpenIdle) {
            return;
        }
        int reserved = data[0] & 0xFF;
        if (reserved != 0) {
            this.logger.warn("first byte in authorize request not zero, ignore");
            return;
        }
        byte[] key = Arrays.copyOfRange(data, 1, 5);
        this.logger.trace("{}->{} {} key 0x{}", new Object[]{respondTo.getAddress(), this.device.getAddress(), name, DataUnitBuilder.toHex((byte[])key, (String)"")});
        ServiceResult<Integer> sr = this.mgmtSvc.authorize(respondTo, key);
        if (this.ignoreOrSchedule(sr)) {
            return;
        }
        this.send(respondTo, 978, new byte[]{(byte)sr.result().intValue()}, sr.getPriority());
    }

    private void onAdcRead(String name, Destination respondTo, byte[] data) {
        if (!this.verifyLength(data.length, 2, 2, name)) {
            return;
        }
        int channel = data[0] & 0x3F;
        int reads = data[1] & 0xFF;
        this.logger.trace("{}->{} {} channel {}, read count {}", new Object[]{respondTo.getAddress(), this.device.getAddress(), name, channel, reads});
        ServiceResult<Integer> sr = ServiceResult.of(0);
        try {
            sr = this.mgmtSvc.readADC(channel, reads);
            if (this.ignoreOrSchedule(sr)) {
                return;
            }
        }
        catch (KnxRuntimeException e) {
            reads = 0;
        }
        byte[] asdu = ByteBuffer.allocate(4).put((byte)channel).put((byte)reads).putShort((short)sr.result().intValue()).array();
        byte[] apdu = DataUnitBuilder.createLengthOptimizedAPDU((int)448, (byte[])asdu);
        this.send(respondTo, apdu, sr.getPriority(), DataUnitBuilder.decodeAPCI((int)448));
    }

    private void onDeviceDescRead(String name, Destination d, byte[] data) {
        if (!this.verifyLength(data.length, 1, 1, name)) {
            return;
        }
        int type = data[0] & 0xFF;
        this.logger.trace("{}->{} {} type {}", new Object[]{d.getAddress(), this.device.getAddress(), name, type});
        if (type != 0 && type != 2) {
            this.logger.warn("{}: unsupported type {}", (Object)name, (Object)type);
            return;
        }
        ServiceResult<DeviceDescriptor> sr = this.mgmtSvc.readDescriptor(type);
        if (this.ignoreOrSchedule(sr)) {
            return;
        }
        byte[] asdu = sr.result().toByteArray();
        byte[] apdu = DataUnitBuilder.createAPDU((int)832, (byte[])asdu);
        apdu[1] = (byte)(apdu[1] | type);
        this.send(d, apdu, this.svcPriority, DataUnitBuilder.decodeAPCI((int)832));
    }

    private void onPropertyRead(String name, KNXAddress dst, Destination d, byte[] data) {
        if (!this.verifyLength(data.length, 4, 4, name)) {
            return;
        }
        int objIndex = data[0] & 0xFF;
        int pid = data[1] & 0xFF;
        int elements = (data[2] & 0xFF) >> 4;
        int start = (data[2] & 0xF) << 8 | data[3] & 0xFF;
        this.logger.trace("{}->{} {} {}|{}{} {}..{}", new Object[]{d.getAddress(), dst, name, objIndex, pid, this.propertyName(objIndex, pid), start, start + elements - 1});
        ServiceResult<Object> sr = ServiceResult.empty();
        if (this.checkPropertyAccess(objIndex, pid, true)) {
            try {
                sr = this.mgmtSvc.readProperty(d, objIndex, pid, start, elements);
                if (this.ignoreOrSchedule(sr)) {
                    return;
                }
            }
            catch (KNXIllegalArgumentException | KnxPropertyException e) {
                this.logger.warn("{}", (Object)e.getMessage());
            }
        }
        byte[] res = (byte[])sr.result();
        byte[] asdu = new byte[4 + res.length];
        if (res.length == 0) {
            elements = 0;
        }
        asdu[0] = (byte)objIndex;
        asdu[1] = (byte)pid;
        asdu[2] = (byte)(elements << 4 | start >>> 8 & 0xF);
        asdu[3] = (byte)start;
        for (int i = 0; i < res.length; ++i) {
            asdu[i + 4] = res[i];
        }
        this.send(d, 982, asdu, sr.getPriority());
    }

    private void onPropertyWrite(String name, KNXAddress dst, Destination d, byte[] data) {
        if (!this.verifyLength(data.length, 5, this.getMaxApduLength() - 1, name)) {
            return;
        }
        int objIndex = data[0] & 0xFF;
        int pid = data[1] & 0xFF;
        int elements = (data[2] & 0xFF) >> 4;
        int start = (data[2] & 0xF) << 8 | data[3] & 0xFF;
        byte[] propertyData = Arrays.copyOfRange(data, 4, data.length);
        this.logger.trace("{}->{} {} {}|{}{} {}..{}: {}", new Object[]{d.getAddress(), dst, name, objIndex, pid, this.propertyName(objIndex, pid), start, start + elements - 1, DataUnitBuilder.toHex((byte[])propertyData, (String)"")});
        ServiceResult<Object> sr = ServiceResult.empty();
        if (this.checkPropertyAccess(objIndex, pid, true)) {
            try {
                sr = this.mgmtSvc.writeProperty(d, objIndex, pid, start, elements, propertyData);
                if (this.ignoreOrSchedule(sr)) {
                    return;
                }
            }
            catch (KNXIllegalArgumentException | KnxPropertyException e) {
                this.logger.warn("{}->{} {} {}|{}{} {}", new Object[]{d.getAddress(), dst, name, objIndex, pid, this.propertyName(objIndex, pid), e.getMessage()});
            }
        }
        byte[] res = pid == 5 || pid == 6 ? (byte[])sr.result() : propertyData;
        int written = res.length;
        if (sr.returnCode() != ReturnCode.Success) {
            elements = 0;
            written = 0;
        }
        byte[] asdu = new byte[4 + written];
        asdu[0] = (byte)objIndex;
        asdu[1] = (byte)pid;
        asdu[2] = (byte)(elements << 4 | start >>> 8 & 0xF);
        asdu[3] = (byte)start;
        for (int i = 0; i < written; ++i) {
            asdu[4 + i] = res[i];
        }
        this.send(d, 982, asdu, sr.getPriority());
    }

    private void onPropDescRead(String name, KNXAddress dst, Destination d, byte[] data) {
        if (!this.verifyLength(data.length, 3, 3, name)) {
            return;
        }
        int objIndex = data[0] & 0xFF;
        int pid = data[1] & 0xFF;
        int propIndex = data[2] & 0xFF;
        this.logger.trace("{}->{} {} {}|{} pidx {}{}", new Object[]{d.getAddress(), dst, name, objIndex, pid, propIndex, this.propertyName(objIndex, pid)});
        ServiceResult<Description> sr = null;
        try {
            sr = this.mgmtSvc.readPropertyDescription(objIndex, pid, propIndex);
        }
        catch (KNXIllegalArgumentException | KnxPropertyException e) {
            this.logger.warn("{}: {}", (Object)name, (Object)e.getMessage());
            byte[] asdu = new byte[7];
            asdu[0] = (byte)objIndex;
            asdu[1] = (byte)pid;
            asdu[2] = (byte)propIndex;
            this.send(d, 985, asdu, Priority.LOW);
            return;
        }
        if (this.ignoreOrSchedule(sr)) {
            return;
        }
        Description desc = sr.result();
        pid = desc.getPID();
        int index = desc.getPropIndex();
        int type = desc.isWriteEnabled() ? 128 : 0;
        int max = desc.getMaxElements();
        int access = desc.getReadLevel() << 4 | desc.getWriteLevel();
        byte[] asdu = new byte[]{(byte)objIndex, (byte)pid, (byte)index, (byte)(type |= desc.getPDT()), (byte)(max >>> 8), (byte)max, (byte)access};
        this.send(d, 985, asdu, sr.getPriority());
    }

    private void onFunctionPropertyCommandOrState(String name, KNXAddress dst, Destination respondTo, boolean isCommand, byte[] data) {
        if (!this.verifyLength(data.length, 3, 15, name)) {
            return;
        }
        int objIndex = data[0] & 0xFF;
        int pid = data[1] & 0xFF;
        byte[] functionInput = Arrays.copyOfRange(data, 2, data.length);
        this.logger.trace("{}->{} {} {}|{}{} {}", new Object[]{respondTo.getAddress(), dst, name, objIndex, pid, this.propertyName(objIndex, pid), DataUnitBuilder.toHex((byte[])functionInput, (String)" ")});
        ServiceResult<Object> sr = ServiceResult.error(ReturnCode.AccessDenied);
        if (this.checkPropertyAccess(objIndex, pid, !isCommand)) {
            try {
                Description description = this.device.getInterfaceObjectServer().getDescription(objIndex, pid);
                if (description.getPDT() == 62) {
                    sr = isCommand ? this.mgmtSvc.functionPropertyCommand(respondTo, objIndex, pid, functionInput) : this.mgmtSvc.readFunctionPropertyState(respondTo, objIndex, pid, functionInput);
                } else {
                    this.logger.warn("property {}|{} is not a function property", (Object)objIndex, (Object)pid);
                }
                if (this.ignoreOrSchedule(sr)) {
                    return;
                }
            }
            catch (KNXIllegalArgumentException | KnxPropertyException e) {
                this.logger.warn("{}", (Object)e.getMessage());
                sr = ServiceResult.error(ReturnCode.AddressVoid);
            }
        }
        byte[] res = (byte[])sr.result();
        byte[] asdu = new byte[3 + res.length];
        asdu[0] = (byte)objIndex;
        asdu[1] = (byte)pid;
        asdu[2] = (byte)sr.returnCode().code();
        for (int i = 0; i < res.length; ++i) {
            asdu[i + 3] = res[i];
        }
        this.send(respondTo, 713, asdu, sr.getPriority());
    }

    private void onMemoryWrite(String name, Destination d, byte[] data) {
        if (!this.verifyLength(data.length, 4, 66, name)) {
            return;
        }
        int bytes = data[0] & 0xFF;
        int address = (data[1] & 0xFF) << 8 | data[2] & 0xFF;
        if (bytes > this.getMaxApduLength() - 3) {
            this.logger.warn("{} of length {} > max. {} bytes - ignore", new Object[]{name, bytes, this.getMaxApduLength() - 3});
            return;
        }
        byte[] memory = Arrays.copyOfRange(data, 3, data.length);
        if (memory.length != bytes) {
            this.logger.warn("ill-formed {}: number field = {} but memory length = {}", new Object[]{name, bytes, memory});
        } else {
            boolean verifyByServer;
            this.logger.trace("{}->{} {}: start address 0x{}, {} bytes: {}", new Object[]{d.getAddress(), this.device.getAddress(), name, Integer.toHexString(address), bytes, DataUnitBuilder.toHex((byte[])memory, (String)" ")});
            ServiceResult<Void> sr = this.mgmtSvc.writeMemory(address, memory);
            if (this.ignoreOrSchedule(sr)) {
                return;
            }
            if (sr.returnCode() != ReturnCode.Success) {
                bytes = 0;
            }
            if (verifyByServer = this.mgmtSvc.isVerifyModeEnabled()) {
                byte[] written = memory;
                byte[] asdu = new byte[3 + bytes];
                asdu[0] = (byte)bytes;
                asdu[1] = (byte)(address >>> 8);
                asdu[2] = (byte)address;
                for (int i = 0; i < bytes; ++i) {
                    asdu[3 + i] = written[i];
                }
                byte[] apdu = DataUnitBuilder.createLengthOptimizedAPDU((int)576, (byte[])asdu);
                this.send(d, apdu, sr.getPriority(), DataUnitBuilder.decodeAPCI((int)576));
            }
        }
    }

    private void onMemoryExtendedWrite(String name, Destination d, byte[] data) {
        ReturnCode rc;
        if (!this.verifyLength(data.length, 5, 254, name)) {
            return;
        }
        int bytes = data[0] & 0xFF;
        int address = (data[1] & 0xFF) << 16 | (data[2] & 0xFF) << 8 | data[3] & 0xFF;
        Priority priority = Priority.LOW;
        if (bytes > this.getMaxApduLength() - 4) {
            this.logger.warn("memory-write of length {} > max. {} bytes - ignore", (Object)bytes, (Object)(this.getMaxApduLength() - 4));
            rc = ReturnCode.ExceedsMaxApduLength;
        } else {
            byte[] memory = Arrays.copyOfRange(data, 4, data.length);
            if (memory.length != bytes) {
                this.logger.warn("ill-formed memory write: number field = {} but memory length = {}", (Object)bytes, (Object)memory);
                rc = ReturnCode.Error;
            } else {
                this.logger.trace("{}->{} {}: start address 0x{}, {} bytes: {}", new Object[]{d.getAddress(), this.device.getAddress(), name, Integer.toHexString(address), bytes, DataUnitBuilder.toHex((byte[])memory, (String)" ")});
                ServiceResult<Void> sr = this.mgmtSvc.writeMemory(address, memory);
                if (this.ignoreOrSchedule(sr)) {
                    return;
                }
                rc = sr.returnCode();
                priority = sr.getPriority();
            }
        }
        boolean withCrc = rc == ReturnCode.SuccessWithCrc;
        byte[] asdu = new byte[4 + (withCrc ? 2 : 0)];
        asdu[0] = (byte)rc.code();
        asdu[1] = (byte)(address >>> 16);
        asdu[2] = (byte)(address >>> 8);
        asdu[3] = (byte)address;
        if (withCrc) {
            int crc = ManagementServiceNotifier.crc16Ccitt(data);
            asdu[4] = (byte)(crc >> 8);
            asdu[5] = (byte)crc;
        }
        this.send(d, 508, asdu, priority);
    }

    private static int crc16Ccitt(byte[] input) {
        int polynom = 4129;
        byte[] padded = Arrays.copyOf(input, input.length + 2);
        int result = 65535;
        for (int i = 0; i < 8 * padded.length; ++i) {
            result <<= 1;
            int nextBit = padded[i / 8] >> 7 - i % 8 & 1;
            if (((result |= nextBit) & 0x10000) == 0) continue;
            result ^= 0x1021;
        }
        return result & 0xFFFF;
    }

    private void onMemoryRead(String name, Destination d, byte[] data) {
        int bytesRead;
        if (!this.verifyLength(data.length, 3, 3, name)) {
            return;
        }
        int length = data[0] & 0xFF;
        int address = (data[1] & 0xFF) << 8 | data[2] & 0xFF;
        if (length > this.getMaxApduLength() - 3) {
            this.logger.warn("{} of length {} > max. {} bytes - ignored", new Object[]{name, length, this.getMaxApduLength() - 3});
            return;
        }
        this.logger.trace("{}->{} {}: start address 0x{}, {} bytes", new Object[]{d.getAddress(), this.device.getAddress(), name, Integer.toHexString(address), length});
        ServiceResult<byte[]> sr = this.mgmtSvc.readMemory(address, length);
        if (this.ignoreOrSchedule(sr)) {
            return;
        }
        byte[] res = sr.result();
        if (res.length != (bytesRead = length)) {
            bytesRead = 0;
        }
        byte[] asdu = new byte[3 + bytesRead];
        asdu[0] = (byte)bytesRead;
        asdu[1] = (byte)(address >> 8);
        asdu[2] = (byte)address;
        for (int i = 0; i < bytesRead; ++i) {
            asdu[3 + i] = res[i];
        }
        byte[] apdu = DataUnitBuilder.createLengthOptimizedAPDU((int)576, (byte[])asdu);
        this.send(d, apdu, sr.getPriority(), DataUnitBuilder.decodeAPCI((int)576));
    }

    private void onMemoryExtendedRead(String name, Destination d, byte[] data) {
        ReturnCode rc;
        if (!this.verifyLength(data.length, 4, 4, name)) {
            return;
        }
        int length = data[0] & 0xFF;
        int address = (data[1] & 0xFF) << 16 | (data[2] & 0xFF) << 8 | data[3] & 0xFF;
        byte[] read = new byte[]{};
        Priority priority = Priority.LOW;
        if (length > this.getMaxApduLength() - 4) {
            this.logger.warn("memory-read request of length {} > max. {} bytes - ignored", (Object)length, (Object)(this.getMaxApduLength() - 4));
            rc = ReturnCode.ExceedsMaxApduLength;
        } else {
            this.logger.trace("{}->{} {}: start address 0x{}, {} bytes", new Object[]{d.getAddress(), this.device.getAddress(), name, Integer.toHexString(address), length});
            ServiceResult<byte[]> sr = this.mgmtSvc.readMemory(address, length);
            rc = sr.returnCode();
            byte[] result = sr.result();
            if (rc == ReturnCode.Success) {
                if (result.length == length) {
                    read = result;
                } else {
                    rc = ReturnCode.MemoryError;
                }
            }
            priority = sr.getPriority();
        }
        byte[] asdu = new byte[4 + read.length];
        asdu[0] = (byte)rc.code();
        asdu[1] = (byte)(address >> 16);
        asdu[2] = (byte)(address >> 8);
        asdu[3] = (byte)address;
        for (int i = 0; i < read.length; ++i) {
            asdu[4 + i] = read[i];
        }
        this.send(d, 510, asdu, priority);
    }

    private void onPropertyExtDescriptionRead(String name, KNXAddress dst, Destination respondTo, byte[] data) {
        if (!this.verifyLength(data.length, 7, 7, name)) {
            return;
        }
        int iot = (data[0] & 0xFF) << 8 | data[1] & 0xFF;
        int instance = (data[2] & 0xFF) << 4 | (data[3] & 0xFF) >> 4;
        int pid = (data[3] & 0xF) << 8 | data[4] & 0xFF;
        int pdt = (data[5] & 0xFF) >> 4;
        if (pdt != 0) {
            this.logger.warn("{} PDT is reserved, but set to {}, ignore service", (Object)name, (Object)pdt);
            return;
        }
        int propIndex = (data[5] & 0xF) << 8 | data[6] & 0xFF;
        this.logger.trace("{}->{} {} {}({})|{} pidx {}{}", new Object[]{respondTo.getAddress(), dst, name, iot, instance, pid, propIndex, this.propertyNameByObjectType(iot, pid)});
        ServiceResult<Object> sr = ServiceResult.empty();
        try {
            int objIndex = this.objectIndex(iot, instance);
            sr = this.mgmtSvc.readPropertyDescription(objIndex, pid, propIndex);
            if (this.ignoreOrSchedule(sr)) {
                return;
            }
        }
        catch (KNXIllegalArgumentException | KnxPropertyException e) {
            this.logger.warn("read property description: {}", (Object)e.getMessage());
            byte[] asdu = new byte[7];
            asdu[0] = (byte)instance;
            asdu[1] = (byte)pid;
            asdu[2] = (byte)propIndex;
            this.send(respondTo, 467, asdu, Priority.LOW);
            return;
        }
        Description desc = (Description)sr.result();
        int pidResponse = desc.getPID();
        int index = desc.getPropIndex();
        int type = desc.isWriteEnabled() ? 128 : 0;
        int max = desc.getMaxElements();
        int access = desc.getReadLevel() << 4 | desc.getWriteLevel();
        byte[] asdu = new byte[]{(byte)instance, (byte)pidResponse, (byte)index, (byte)(type |= desc.getPDT()), (byte)(max >>> 8), (byte)max, (byte)access};
        this.send(respondTo, 467, asdu, sr.getPriority());
    }

    private void onPropertyExtRead(String name, KNXAddress dst, Destination respondTo, byte[] data) {
        if (!this.verifyLength(data.length, 8, 8, name)) {
            return;
        }
        int iot = (data[0] & 0xFF) << 8 | data[1] & 0xFF;
        int instance = (data[2] & 0xFF) << 4 | (data[3] & 0xFF) >> 4;
        int pid = (data[3] & 0xF) << 8 | data[4] & 0xFF;
        int elements = data[5] & 0xFF;
        int start = (data[6] & 0xFF) << 8 | data[7] & 0xFF;
        this.logger.trace("{}->{} {} {}({})|{}{} {}..{}", new Object[]{respondTo.getAddress(), dst, name, iot, instance, pid, this.propertyNameByObjectType(iot, pid), start, start + elements - 1});
        ServiceResult<Object> sr = ServiceResult.error(ReturnCode.AccessDenied);
        try {
            int objIndex = this.objectIndex(iot, instance);
            if (this.checkPropertyAccess(objIndex, pid, true)) {
                sr = this.mgmtSvc.readProperty(respondTo, objIndex, pid, start, elements);
            }
        }
        catch (KNXIllegalArgumentException | KnxPropertyException e) {
            this.logger.warn("reading property data: {}", (Object)e.getMessage());
            sr = ServiceResult.error(ReturnCode.AddressVoid);
        }
        int length = Math.max(1, ((byte[])sr.result()).length);
        byte[] asdu = Arrays.copyOfRange(data, 0, 8 + length);
        ReturnCode returnCode = sr.returnCode();
        asdu[8] = (byte)sr.returnCode().code();
        if (returnCode != ReturnCode.Success) {
            asdu[5] = 0;
        } else {
            System.arraycopy(sr.result(), 0, asdu, 8, length);
        }
        this.send(respondTo, 461, asdu, sr.getPriority());
    }

    private void onPropertyExtWrite(String name, KNXAddress dst, Destination respondTo, byte[] data, boolean confirm) {
        if (!this.verifyLength(data.length, 9, this.getMaxApduLength() - 2, name)) {
            return;
        }
        int iot = (data[0] & 0xFF) << 8 | data[1] & 0xFF;
        int instance = (data[2] & 0xFF) << 4 | (data[3] & 0xFF) >> 4;
        int pid = (data[3] & 0xF) << 8 | data[4] & 0xFF;
        int elements = data[5] & 0xFF;
        int start = (data[6] & 0xFF) << 8 | data[7] & 0xFF;
        byte[] propertyData = Arrays.copyOfRange(data, 8, data.length);
        this.logger.trace("{}->{} {} {}({})|{}{} {}..{}: {}", new Object[]{respondTo.getAddress(), dst, name, iot, instance, pid, this.propertyNameByObjectType(iot, pid), start, start + elements - 1, DataUnitBuilder.toHex((byte[])propertyData, (String)" ")});
        ServiceResult<Object> sr = ServiceResult.error(ReturnCode.AccessDenied);
        try {
            int objIndex = this.objectIndex(iot, instance);
            if (this.checkPropertyAccess(objIndex, pid, false)) {
                sr = this.mgmtSvc.writeProperty(respondTo, objIndex, pid, start, elements, propertyData);
            }
        }
        catch (KNXIllegalArgumentException | KnxPropertyException e) {
            this.logger.warn("writing property data: {}", (Object)e.getMessage());
            sr = ServiceResult.error(ReturnCode.AddressVoid);
        }
        if (!confirm) {
            return;
        }
        byte[] asdu = Arrays.copyOfRange(data, 0, 9);
        ReturnCode returnCode = sr.returnCode();
        if (returnCode != ReturnCode.Success) {
            asdu[5] = 0;
        }
        asdu[8] = (byte)returnCode.code();
        this.send(respondTo, 463, asdu, sr.getPriority());
    }

    private void onFunctionPropertyExtCommandOrState(String name, KNXAddress dst, Destination respondTo, boolean isCommand, byte[] data, boolean system) {
        ReturnCode rc;
        if (!this.verifyLength(data.length, 7, this.getMaxApduLength() - 2, name)) {
            return;
        }
        int iot = (data[0] & 0xFF) << 8 | data[1] & 0xFF;
        int oi = (data[2] & 0xFF) << 4 | (data[3] & 0xFF) >> 4;
        int pid = (data[3] & 0xF) << 8 | data[4] & 0xFF;
        byte[] functionInput = Arrays.copyOfRange(data, 5, data.length);
        this.logger.trace("{}->{} {} IOT {} OI {} PID {} {}", new Object[]{respondTo.getAddress(), dst, name, iot, oi, pid, DataUnitBuilder.toHex((byte[])functionInput, (String)" ")});
        ServiceResult<Object> sr = ServiceResult.error(ReturnCode.Error);
        try {
            int objIndex = this.objectIndex(iot, oi);
            Description description = this.device.getInterfaceObjectServer().getDescription(objIndex, pid);
            int reserved = functionInput[0] & 0xFF;
            sr = !this.checkPropertyAccess(objIndex, pid, !isCommand) ? ServiceResult.error(ReturnCode.AccessDenied) : (description.getPDT() == 62 && reserved != 0 ? ServiceResult.error(ReturnCode.DataVoid) : (iot == 17 && oi == 1 && pid == 51 ? this.sal.securityMode(isCommand, functionInput) : (description.getPDT() == 62 || description.getPDT() == 0 ? (iot == 17 && oi == 1 && pid == 55 ? this.sal.securityFailuresLog(isCommand, functionInput) : (isCommand ? this.mgmtSvc.functionPropertyCommand(respondTo, objIndex, pid, functionInput) : this.mgmtSvc.readFunctionPropertyState(respondTo, objIndex, pid, functionInput))) : ServiceResult.error(ReturnCode.DataTypeConflict))));
        }
        catch (KnxPropertyException e) {
            this.logger.warn("{}->{} {} {}({})|{}", new Object[]{respondTo.getAddress(), dst, name, iot, oi, pid, e});
            sr = ServiceResult.error(ReturnCode.AddressVoid);
        }
        byte[] result = (byte[])sr.result();
        byte[] state = new byte[]{};
        if (result.length > this.getMaxApduLength() - 2 - 5) {
            rc = ReturnCode.ExceedsMaxApduLength;
        } else {
            rc = sr.returnCode();
            state = result;
        }
        byte[] asdu = new byte[6 + state.length];
        asdu[0] = (byte)(iot >> 8);
        asdu[1] = (byte)iot;
        asdu[2] = (byte)(oi >> 4);
        asdu[3] = (byte)((oi & 0xF) << 4 | pid >> 8);
        asdu[4] = (byte)pid;
        asdu[5] = (byte)rc.code();
        for (int i = 0; i < state.length; ++i) {
            asdu[6 + i] = state[i];
        }
        Priority priority = system ? Priority.SYSTEM : Priority.LOW;
        this.send(respondTo, 470, asdu, priority);
    }

    private void onManagement(int svcType, byte[] data, KNXAddress dst, Destination respondTo) {
        ServiceResult<byte[]> sr = this.mgmtSvc.management(svcType, data, dst, respondTo, this.tl);
        if (sr != null) {
            sr.run();
        }
    }

    private boolean verifyLength(int length, int minExpected, int maxExpected, String svcType) {
        if (length < minExpected) {
            this.logger.warn(svcType + " SDU of length " + length + " too short, expected " + minExpected);
        } else if (length > maxExpected) {
            this.logger.warn(svcType + " SDU of length " + length + " too long, maximum " + maxExpected);
        }
        return length >= minExpected && length <= maxExpected;
    }

    private boolean ignoreOrSchedule(ServiceResult<?> svc) {
        if (svc == null) {
            this.logger.warn("return value of type ServiceResult required", (Throwable)new KnxRuntimeException("ServiceResult == null"));
            return true;
        }
        if (svc.result() != null) {
            return false;
        }
        svc.run();
        return true;
    }

    private void sendBroadcast(boolean system, byte[] apdu, Priority p, String service) {
        String type = system ? "system" : "domain";
        this.logger.trace("{}->[{} broadcast] {} {}", new Object[]{this.device.getAddress(), type, service, DataUnitBuilder.toHex((byte[])apdu, (String)" ")});
        try {
            byte[] tsdu = this.sal.secureData(this.device.getAddress(), (KNXAddress)GroupAddress.Broadcast, apdu, this.securityCtrl).orElse(apdu);
            this.tl.broadcast(system, p, tsdu);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (KNXTimeoutException | KNXLinkClosedException e) {
            this.logger.warn("{}->[{} broadcast] {} {}: {}", new Object[]{this.device.getAddress(), type, service, DataUnitBuilder.toHex((byte[])apdu, (String)" "), e.getMessage()});
        }
    }

    private void send(Destination respondTo, int service, byte[] asdu, Priority p) {
        byte[] apdu = DataUnitBuilder.createAPDU((int)service, (byte[])asdu);
        this.send(respondTo, apdu, p, DataUnitBuilder.decodeAPCI((int)service));
    }

    void send(Destination respondTo, byte[] apdu, Priority p, String service) {
        if (respondTo.getState() == Destination.State.Destroyed) {
            this.logger.warn("cannot respond with {}, {}", (Object)service, (Object)respondTo);
            return;
        }
        IndividualAddress dst = respondTo.getAddress();
        this.logger.trace("{}->{} {} {}", new Object[]{this.device.getAddress(), dst, service, DataUnitBuilder.toHex((byte[])apdu, (String)" ")});
        try {
            byte[] tsdu = this.sal.secureData(this.device.getAddress(), (KNXAddress)respondTo.getAddress(), apdu, this.securityCtrl).orElse(apdu);
            if (respondTo.isConnectionOriented()) {
                this.tl.sendData(respondTo, p, tsdu);
            } else {
                this.tl.sendData((KNXAddress)dst, p, tsdu);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (KNXTimeoutException | KNXLinkClosedException | KNXDisconnectException e) {
            this.logger.warn("{}->{} {} {}: {}, {}", new Object[]{this.device.getAddress(), dst, service, DataUnitBuilder.toHex((byte[])apdu, (String)" "), e.getMessage(), respondTo});
        }
    }

    private boolean checkPropertyAccess(int objectIndex, int pid, boolean read) {
        int objectType = this.objectType(objectIndex);
        boolean allowed = AccessPolicies.checkPropertyAccess(objectType, pid, read, this.sal.isSecurityModeEnabled(), this.securityCtrl);
        if (!allowed) {
            this.logger.info("property {} access to {}|{} denied - {}{}", new Object[]{read ? "read" : "write", objectIndex, pid, PropertyClient.getObjectTypeName((int)objectType), this.propertyName(objectIndex, pid)});
        }
        return allowed;
    }

    private int objectIndex(int iot, int oi) {
        byte[] data = this.device.getInterfaceObjectServer().getProperty(iot, oi, 29, 1, 1);
        return ManagementServiceNotifier.toUnsigned(data);
    }

    private int objectType(int objectIndex) {
        return ManagementServiceNotifier.toUnsigned(this.device.getInterfaceObjectServer().getProperty(objectIndex, 1, 1, 1));
    }

    private String propertyNameByObjectType(int iot, int pid) {
        InterfaceObjectServer ios = this.device.getInterfaceObjectServer();
        PropertyClient.PropertyKey key = pid <= 50 ? new PropertyClient.PropertyKey(pid) : new PropertyClient.PropertyKey(iot, pid);
        PropertyClient.Property property = ios.propertyDefinitions().get(key);
        if (property != null) {
            return " (" + property.getName() + ")";
        }
        return "";
    }

    private String propertyName(int objectIndex, int pid) {
        if (pid <= 50) {
            return this.propertyNameByObjectType(0, pid);
        }
        InterfaceObject[] objects = this.device.getInterfaceObjectServer().getInterfaceObjects();
        int objectType = objectIndex < objects.length ? objects[objectIndex].getType() : 0;
        return this.propertyNameByObjectType(objectType, pid);
    }

    private int getMaxApduLength() {
        try {
            return DeviceObject.lookup(this.device.getInterfaceObjectServer()).maxApduLength();
        }
        catch (KnxPropertyException e) {
            if (!this.missingApduLength) {
                this.missingApduLength = true;
                this.logger.warn("device has no maximum APDU length set (PID.MAX_APDULENGTH), using 254");
            }
            return 254;
        }
    }

    private Map<IndividualAddress, Destination.AggregatorProxy> transportLayerProxies() {
        try {
            Field field = this.tl.getClass().getDeclaredField("proxies");
            field.setAccessible(true);
            Map map = (Map)field.get(this.tl);
            return map;
        }
        catch (IllegalAccessException | NoSuchFieldException e) {
            e.printStackTrace();
            return null;
        }
    }

    private static int toUnsigned(byte[] data) {
        if (data.length == 1) {
            return data[0] & 0xFF;
        }
        if (data.length == 2) {
            return (data[0] & 0xFF) << 8 | data[1] & 0xFF;
        }
        return (data[0] & 0xFF) << 24 | (data[1] & 0xFF) << 16 | (data[2] & 0xFF) << 8 | data[3] & 0xFF;
    }
}

