/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.device;

import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.Priority;
import tuwien.auto.calimero.ReturnCode;

public class ServiceResult<T>
implements Runnable {
    private static final ServiceResult<Void> Empty = new ServiceResult(new byte[0]);
    private final ReturnCode ret;
    private final T data;
    final boolean compact;

    static <U> ServiceResult<U> empty() {
        return Empty;
    }

    static <U> ServiceResult<U> error(ReturnCode error) {
        return new ServiceResult(error);
    }

    public static <U> ServiceResult<U> of(U t) {
        return new ServiceResult<U>(t);
    }

    public static ServiceResult<byte[]> of(byte ... data) {
        return new ServiceResult<byte[]>(data);
    }

    static ServiceResult<byte[]> of(ReturnCode returnCode, byte ... result) {
        return new ServiceResult<byte[]>(returnCode, result);
    }

    public ServiceResult() {
        this.ret = ReturnCode.Success;
        this.data = null;
        this.compact = false;
    }

    public ServiceResult(byte ... result) {
        this(result);
    }

    private ServiceResult(ReturnCode returnCode) {
        this(returnCode, new byte[0]);
    }

    private ServiceResult(T t) {
        this.ret = ReturnCode.Success;
        this.data = t;
        this.compact = false;
    }

    private ServiceResult(ReturnCode returnCode, T result) {
        this.ret = returnCode;
        this.data = result;
        this.compact = false;
    }

    public ServiceResult(byte[] result, boolean compact) {
        if (result == null) {
            throw new KNXIllegalArgumentException("no service result");
        }
        this.ret = ReturnCode.Success;
        this.data = (T)result;
        this.compact = compact;
    }

    public byte[] getResult() {
        if (this.data instanceof byte[]) {
            return (byte[])this.data;
        }
        return null;
    }

    public T result() {
        return this.data;
    }

    @Override
    public void run() {
    }

    public Priority getPriority() {
        return Priority.LOW;
    }

    ReturnCode returnCode() {
        return this.ret;
    }
}

