/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.serial;

import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.RXTXVersion;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.serial.LibraryAdapter;

public class RxtxAdapter
extends LibraryAdapter {
    private static final int OPEN_TIMEOUT = 200;
    private SerialPort port;
    private InputStream is;
    private OutputStream os;

    public static List<String> getPortIdentifiers() {
        Enumeration enumeration = CommPortIdentifier.getPortIdentifiers();
        return Collections.list(enumeration).stream().map(CommPortIdentifier::getName).collect(Collectors.toList());
    }

    public RxtxAdapter(Logger logger, String string, int n) throws KNXException {
        super(logger);
        this.open(string, n);
    }

    public void setBaudRate(int n) {
        try {
            this.port.setSerialPortParams(n, 8, 1, 2);
        }
        catch (UnsupportedCommOperationException unsupportedCommOperationException) {
            this.logger.error("failed to configure port settings");
        }
    }

    public int getBaudRate() {
        return this.port.getBaudRate();
    }

    public InputStream getInputStream() {
        return this.is;
    }

    public OutputStream getOutputStream() {
        return this.os;
    }

    public void close() {
        try {
            this.port.close();
        }
        catch (RuntimeException runtimeException) {
            runtimeException.printStackTrace();
        }
    }

    private void open(String string, int n) throws KNXException {
        CommPortIdentifier.getPortIdentifiers();
        String string2 = string.startsWith("\\\\.\\") ? string.substring(4) : string;
        this.logger.info("open rxtx ({}) serial port connection for {}", (Object)RXTXVersion.getVersion(), (Object)string2);
        try {
            CommPortIdentifier commPortIdentifier = CommPortIdentifier.getPortIdentifier((String)string2);
            if (commPortIdentifier.getPortType() != 1) {
                throw new KNXException(string2 + " is not a serial port ID");
            }
            this.port = commPortIdentifier.open("Calimero", 200);
            this.port.setFlowControlMode(0);
            this.port.enableReceiveThreshold(1024);
            try {
                this.port.enableReceiveTimeout(250);
            }
            catch (UnsupportedCommOperationException unsupportedCommOperationException) {
                this.logger.warn("no timeout support: serial port might hang during close");
            }
            this.setBaudRate(n);
            this.logger.debug("setup serial port: baudrate {}, even parity, {} databits, {} stopbits, flow control {}", new Object[]{this.port.getBaudRate(), this.port.getDataBits(), this.port.getStopBits(), this.port.getFlowControlMode()});
            this.is = this.port.getInputStream();
            this.os = this.port.getOutputStream();
        }
        catch (NoSuchPortException | PortInUseException | UnsupportedCommOperationException | IOException throwable) {
            if (this.port != null) {
                this.port.close();
            }
            try {
                if (this.is != null) {
                    this.is.close();
                }
                if (this.os != null) {
                    this.os.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new KNXException("failed to open serial port " + string2, throwable);
        }
    }
}

