/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.serial;

import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.RXTXVersion;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.serial.spi.SerialCom;

public class RxtxAdapter
implements SerialCom {
    private static final int OPEN_TIMEOUT = 200;
    private Logger logger;
    private SerialPort port;
    private InputStream is;
    private OutputStream os;

    public static List<String> getPortIdentifiers() {
        Enumeration ports = CommPortIdentifier.getPortIdentifiers();
        return Collections.list(ports).stream().map(CommPortIdentifier::getName).collect(Collectors.toList());
    }

    public RxtxAdapter() {
    }

    public RxtxAdapter(Logger logger, String portId, int baudrate) throws KNXException {
        this.open(portId);
        this.logger = logger;
        try {
            this.port.setSerialPortParams(baudrate, 8, 1, 2);
        }
        catch (UnsupportedCommOperationException e) {
            this.close();
            throw new KNXException("failed to configure port settings", (Throwable)e);
        }
    }

    public List<String> portIdentifiers() {
        return RxtxAdapter.getPortIdentifiers();
    }

    public void open(String portId) throws KNXException {
        this.logger = LoggerFactory.getLogger((String)("calimero.serial:" + portId));
        CommPortIdentifier.getPortIdentifiers();
        String res = portId.startsWith("\\\\.\\") ? portId.substring(4) : portId;
        this.logger.info("open rxtx ({}) serial port connection for {}", (Object)RXTXVersion.getVersion(), (Object)res);
        try {
            CommPortIdentifier id = CommPortIdentifier.getPortIdentifier((String)res);
            if (id.getPortType() != 1) {
                throw new KNXException(res + " is not a serial port ID");
            }
            this.port = id.open("Calimero", 200);
            this.port.enableReceiveThreshold(1024);
            try {
                this.port.enableReceiveTimeout(5);
            }
            catch (UnsupportedCommOperationException e) {
                this.logger.warn("no timeout support: serial port might hang during close");
            }
            this.is = this.port.getInputStream();
            this.os = this.port.getOutputStream();
        }
        catch (NoSuchPortException | PortInUseException | UnsupportedCommOperationException | IOException e) {
            if (this.port != null) {
                this.port.close();
            }
            try {
                if (this.is != null) {
                    this.is.close();
                }
                if (this.os != null) {
                    this.os.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new KNXException("failed to open serial port " + res, e);
        }
    }

    public int baudRate() {
        return this.port.getBaudRate();
    }

    public void setSerialPortParams(int baudrate, int databits, SerialCom.StopBits stopbits, SerialCom.Parity parity) throws IOException {
        try {
            this.port.setSerialPortParams(baudrate, databits, stopbits.value(), parity.value());
        }
        catch (UnsupportedCommOperationException e) {
            throw new IOException("setting serial port parameters for " + this.port.getName(), e);
        }
    }

    public void setFlowControlMode(SerialCom.FlowControl mode) throws IOException {
        try {
            this.port.setFlowControlMode(mode.value());
        }
        catch (UnsupportedCommOperationException e) {
            throw new IOException("setting flow control mode " + String.valueOf(mode), e);
        }
    }

    public InputStream inputStream() {
        return this.is;
    }

    public OutputStream outputStream() {
        return this.os;
    }

    public void close() {
        boolean interrupted = false;
        try {
            interrupted = Thread.interrupted();
            this.port.close();
        }
        catch (RuntimeException e) {
            this.logger.debug("rxtx exception while closing serial port", (Throwable)e);
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public String toString() {
        return String.format("%s baudrate %d, parity %d, %d databits, %d stopbits, flow control %d", this.port.getName(), this.port.getBaudRate(), this.port.getParity(), this.port.getDataBits(), this.port.getStopBits(), this.port.getFlowControlMode());
    }
}

