/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.serial;

import gnu.io.CommPortIdentifier;
import gnu.io.NoSuchPortException;
import gnu.io.PortInUseException;
import gnu.io.RXTXVersion;
import gnu.io.SerialPort;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.serial.LibraryAdapter;

public class RxtxAdapter
extends LibraryAdapter {
    private static final int OPEN_TIMEOUT = 200;
    private SerialPort port;
    private InputStream is;
    private OutputStream os;

    public static List<String> getPortIdentifiers() {
        Enumeration ports = CommPortIdentifier.getPortIdentifiers();
        return Collections.list(ports).stream().map(CommPortIdentifier::getName).collect(Collectors.toList());
    }

    public RxtxAdapter(Logger logger, String portId, int baudrate) throws KNXException {
        super(logger);
        this.open(portId, baudrate);
    }

    public void setBaudRate(int baudrate) {
        try {
            this.port.setSerialPortParams(baudrate, 8, 1, 2);
        }
        catch (UnsupportedCommOperationException e) {
            this.logger.error("failed to configure port settings");
        }
    }

    public int getBaudRate() {
        return this.port.getBaudRate();
    }

    public InputStream getInputStream() {
        return this.is;
    }

    public OutputStream getOutputStream() {
        return this.os;
    }

    public void close() {
        boolean interrupted = false;
        try {
            interrupted = Thread.interrupted();
            this.port.close();
        }
        catch (RuntimeException e) {
            this.logger.debug("rxtx exception while closing serial port", (Throwable)e);
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void open(String portId, int baudrate) throws KNXException {
        CommPortIdentifier.getPortIdentifiers();
        String res = portId.startsWith("\\\\.\\") ? portId.substring(4) : portId;
        this.logger.info("open rxtx ({}) serial port connection for {}", (Object)RXTXVersion.getVersion(), (Object)res);
        try {
            CommPortIdentifier id = CommPortIdentifier.getPortIdentifier((String)res);
            if (id.getPortType() != 1) {
                throw new KNXException(res + " is not a serial port ID");
            }
            this.port = id.open("Calimero", 200);
            this.port.setFlowControlMode(0);
            this.port.enableReceiveThreshold(1024);
            try {
                this.port.enableReceiveTimeout(5);
            }
            catch (UnsupportedCommOperationException e) {
                this.logger.warn("no timeout support: serial port might hang during close");
            }
            this.setBaudRate(baudrate);
            this.logger.debug("setup serial port: baudrate {}, even parity, {} databits, {} stopbits, flow control {}", new Object[]{this.port.getBaudRate(), this.port.getDataBits(), this.port.getStopBits(), this.port.getFlowControlMode()});
            this.is = this.port.getInputStream();
            this.os = this.port.getOutputStream();
        }
        catch (NoSuchPortException | PortInUseException | UnsupportedCommOperationException | IOException e) {
            if (this.port != null) {
                this.port.close();
            }
            try {
                if (this.is != null) {
                    this.is.close();
                }
                if (this.os != null) {
                    this.os.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new KNXException("failed to open serial port " + res, e);
        }
    }
}

