/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.tools;

import java.io.ByteArrayOutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.HexFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Predicate;
import org.slf4j.Logger;
import tuwien.auto.calimero.DeviceDescriptor;
import tuwien.auto.calimero.GroupAddress;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.KNXRemoteException;
import tuwien.auto.calimero.dptxlator.DPT;
import tuwien.auto.calimero.dptxlator.DPTXlatorBoolean;
import tuwien.auto.calimero.dptxlator.DptXlator16BitSet;
import tuwien.auto.calimero.dptxlator.TranslatorTypes;
import tuwien.auto.calimero.link.KNXLinkClosedException;
import tuwien.auto.calimero.link.KNXNetworkLink;
import tuwien.auto.calimero.link.medium.TPSettings;
import tuwien.auto.calimero.log.LogService;
import tuwien.auto.calimero.mgmt.Destination;
import tuwien.auto.calimero.mgmt.LocalDeviceManagementIp;
import tuwien.auto.calimero.mgmt.LocalDeviceManagementUsb;
import tuwien.auto.calimero.mgmt.ManagementClient;
import tuwien.auto.calimero.mgmt.PropertyAdapter;
import tuwien.auto.calimero.mgmt.PropertyClient;
import tuwien.auto.calimero.mgmt.RemotePropertyServiceAdapter;
import tuwien.auto.calimero.serial.usb.UsbConnection;
import tuwien.auto.calimero.serial.usb.UsbConnectionFactory;
import tuwien.auto.calimero.tools.Json;
import tuwien.auto.calimero.tools.Main;

public class DeviceInfo
implements Runnable {
    private static final String tool = "DeviceInfo";
    private static final int addresstableObject = 1;
    private static final int assoctableObject = 2;
    private static final int appProgramObject = 3;
    private static final int interfaceProgramObject = 4;
    private static final int cemiServerObject = 8;
    private static final int knxnetipObject = 11;
    private static final int securityObject = 17;
    private static final int rfMediumObject = 19;
    private static final int pidHardwareType = 78;
    private final Map<Integer, List<Integer>> ifObjects = new HashMap<Integer, List<Integer>>();
    private static Logger out = LogService.getLogger((String)"calimero.tools");
    private ManagementClient mc;
    private Destination d;
    private PropertyClient pc;
    private final Map<String, Object> options = new HashMap<String, Object>();
    private DeviceDescriptor dd;
    private boolean isSystemB;
    private boolean groupAddressesDone;
    private final Set<String> categories = new HashSet<String>();
    private String category = "General";
    private final JsonResult jsonResult;
    private static final int legacyPidFilteringModeSelect = 62;
    private static final int legacyPidFilteringModeSupport = 63;
    private static final int addrManufact = 260;
    private static final int addrDevType = 261;
    private static final int addrVersion = 263;
    private static final int addrPeiType = 265;
    private static final int addrRunError = 269;
    private static final int addrRoutingCnt = 270;
    private static final int addrGroupObjTablePtr = 274;
    private static final int addrGroupAddrTable = 278;
    private static final int addrGroupAddrTableMask5705 = 16384;

    public DeviceInfo(String[] args) {
        try {
            this.parseOptions(args);
            if (this.options.containsKey("json")) {
                Object dev = this.options.containsKey("device") ? this.options.get("device") : this.options.get("host");
                this.jsonResult = new JsonResult(dev.toString(), new ArrayList<JsonItem>());
            } else {
                this.jsonResult = null;
            }
        }
        catch (KNXIllegalArgumentException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new KNXIllegalArgumentException(e.getMessage(), (Throwable)e);
        }
    }

    public static void main(String ... args) {
        try {
            DeviceInfo d = new DeviceInfo(args);
            Main.ShutdownHandler sh = new Main.ShutdownHandler().register();
            d.run();
            sh.unregister();
        }
        catch (Throwable t) {
            out.error("parsing options", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block41: {
            Throwable thrown = null;
            boolean canceled = false;
            IndividualAddress device = (IndividualAddress)this.options.get("device");
            try {
                if (this.options.isEmpty()) {
                    DeviceInfo.out("DeviceInfo - Read KNX device information");
                    Main.showVersion();
                    DeviceInfo.out("Type --help for help message");
                    return;
                }
                if (this.options.containsKey("about")) {
                    ((Runnable)this.options.get("about")).run();
                    return;
                }
                if (device != null) {
                    try (KNXNetworkLink link = this.createLink();
                         RemotePropertyServiceAdapter adapter = new RemotePropertyServiceAdapter(link, device, e -> {}, true);){
                        this.mc = adapter.managementClient();
                        this.d = adapter.destination();
                        this.pc = new PropertyClient((PropertyAdapter)adapter);
                        out.info("Reading data from device {}, might take some seconds ...", (Object)device);
                        this.readDeviceInfo();
                        break block41;
                    }
                }
                if (this.options.containsKey("usb")) {
                    try (UsbConnection conn = UsbConnectionFactory.open((String)((String)this.options.get("host")));
                         LocalDeviceManagementUsb adapter = new LocalDeviceManagementUsb(conn, e -> {}, false);){
                        this.dd = conn.deviceDescriptor();
                        this.pc = new PropertyClient((PropertyAdapter)adapter);
                        out.info("Reading info of KNX USB adapter {}, might take some seconds ...", (Object)this.dd);
                        this.readDeviceInfo();
                        break block41;
                    }
                }
                try (LocalDeviceManagementIp adapter = Main.newLocalDeviceMgmtIP(this.options, closed -> {});){
                    this.pc = new PropertyClient((PropertyAdapter)adapter);
                    out.info("Reading info of KNXnet/IP {}, might take some seconds ...", (Object)adapter.getName());
                    this.readDeviceInfo();
                }
            }
            catch (RuntimeException | KNXException e2) {
                thrown = e2;
            }
            catch (InterruptedException e3) {
                canceled = true;
                Thread.currentThread().interrupt();
            }
            finally {
                this.onCompletion((Exception)thrown, canceled);
            }
        }
    }

    protected void onDeviceInformation(Parameter parameter, String value, byte[] raw) {
    }

    protected void onDeviceInformation(Item item) {
        if (this.options.containsKey("json")) {
            this.jsonResult.info().add(new JsonItem(item.category, item.parameter, item.value, item.raw));
        } else {
            this.out(item);
        }
        this.onDeviceInformation(item.parameter(), item.value(), item.raw());
    }

    protected void onCompletion(Exception thrown, boolean canceled) {
        if (this.options.containsKey("json")) {
            System.out.println(this.jsonResult.toJson());
        }
        if (canceled) {
            out.info("reading device info canceled");
        }
        if (thrown != null) {
            out.error("completed with error", (Throwable)thrown);
        }
    }

    private void out(Item item) {
        boolean printUnformatted = false;
        boolean printCategory = this.categories.add(item.category());
        if (printCategory && !"General".equals(item.category())) {
            DeviceInfo.out(System.lineSeparator() + item.category());
        }
        String s = item.parameter().friendlyName() + " = " + item.value();
        String hex = item.raw().length > 0 ? "0x" + HexFormat.of().formatHex(item.raw()) : "n/a";
        int n = Math.max(1, 60 - s.length());
        String detail = "";
        DeviceInfo.out(s + detail);
    }

    private String interfaceObjectName(int objectIndex) {
        for (Map.Entry<Integer, List<Integer>> entry : this.ifObjects.entrySet()) {
            if (!entry.getValue().contains(objectIndex)) continue;
            return PropertyClient.getObjectTypeName((int)entry.getKey());
        }
        return "";
    }

    private void findInterfaceObjects() throws InterruptedException {
        if (this.readElements(0, 1) <= 0) {
            return;
        }
        boolean deviceObjectIdx = false;
        int objects = this.readElements(0, 71);
        if (objects > 0) {
            byte[] data = this.read(0, 71, 1, objects);
            if (data == null) {
                return;
            }
            for (int i = 0; i < data.length / 2; ++i) {
                int type = (data[2 * i] & 0xFF) << 8 | data[2 * i + 1] & 0xFF;
                this.ifObjects.compute(type, (__, v) -> v == null ? new ArrayList() : v).add(i);
            }
        } else {
            int type;
            this.ifObjects.put(0, List.of(Integer.valueOf(0)));
            for (int i = 1; i < 100 && (type = (int)DeviceInfo.toUnsigned(this.read(i, 1))) >= 0; ++i) {
                this.ifObjects.compute(type, (__, v) -> v == null ? new ArrayList() : v).add(i);
            }
            if (this.ifObjects.size() == 1) {
                this.ifObjects.put(8, List.of(Integer.valueOf(1)));
                out.info("Device implements only Device Object and cEMI Object");
            }
        }
    }

    private void readDeviceInfo() throws KNXException, InterruptedException {
        if (this.dd != null) {
            this.dd = this.deviceDescriptor(this.dd.toByteArray());
        } else if (this.mc != null) {
            this.dd = this.deviceDescriptor(this.mc.readDeviceDesc(this.d, 0));
        }
        if (this.dd != null) {
            if (this.dd == DeviceDescriptor.DD0.TYPE_1013) {
                this.readPL110Bcu1();
            } else if (this.dd == DeviceDescriptor.DD0.TYPE_0010 || this.dd == DeviceDescriptor.DD0.TYPE_0011 || this.dd == DeviceDescriptor.DD0.TYPE_0012) {
                this.readTP1Bcu1();
            } else if (this.dd == DeviceDescriptor.DD0.TYPE_0020 || this.dd == DeviceDescriptor.DD0.TYPE_0021 || this.dd == DeviceDescriptor.DD0.TYPE_0025) {
                this.readTP1Bcu2();
            } else if (this.dd == DeviceDescriptor.DD0.TYPE_0700 || this.dd == DeviceDescriptor.DD0.TYPE_0701) {
                this.readTP1Bcu1();
            } else {
                this.findInterfaceObjects();
            }
        } else {
            this.findInterfaceObjects();
        }
        boolean bl = this.isSystemB = this.dd == DeviceDescriptor.DD0.TYPE_07B0 || this.dd == DeviceDescriptor.DD0.TYPE_17B0 || this.dd == DeviceDescriptor.DD0.TYPE_27B0 || this.dd == DeviceDescriptor.DD0.TYPE_57B0;
        if (this.ifObjects.containsKey(0)) {
            this.readDeviceObject(0);
        }
        this.readActualPeiType();
        this.programmingMode();
        this.iterate(3, idx -> {
            this.readUnsigned((int)idx, 16, false, CommonParameter.RequiredPeiType);
            this.readProgram((int)idx);
        });
        this.iterate(4, this::readProgram);
        this.iterate(1, this::readLoadState);
        this.iterate(2, this::readLoadState);
        if (this.mc != null && !this.groupAddressesDone) {
            this.readGroupAddresses();
        }
        this.iterate(8, this::readCemiServerObject);
        this.iterate(19, this::readRFMediumObject);
        try {
            this.iterate(11, this::readKnxipInfo);
        }
        catch (InterruptedException | KNXException e) {
            throw e;
        }
        catch (Exception e) {
            out.warn("error reading KNXnet/IP object", (Throwable)e);
        }
        this.iterate(17, this::readSecurityObject);
    }

    private <E extends Exception> void iterate(int objectType, ThrowingConsumer<Integer, E> consumer) throws E {
        int i = 0;
        for (Integer idx : this.objectIndices(objectType)) {
            this.category = this.interfaceObjectName(idx) + (String)(++i > 1 ? " " + i : "");
            consumer.accept(idx);
        }
    }

    private List<Integer> objectIndices(int objectType) {
        return this.ifObjects.getOrDefault(objectType, List.of());
    }

    private void programmingMode() throws KNXFormatException, InterruptedException {
        DPTXlatorBoolean x = new DPTXlatorBoolean(DPTXlatorBoolean.DPT_SWITCH);
        try {
            if (this.ifObjects.containsKey(0)) {
                x.setData(this.pc.getProperty(0, 54, 1, 1));
                this.putResult((Parameter)CommonParameter.ProgrammingMode, x.getValue(), x.getData());
                return;
            }
        }
        catch (KNXException kNXException) {
            // empty catch block
        }
        try {
            if (this.mc != null) {
                x.setData(this.mc.readMemory(this.d, 96, 1));
                this.putResult((Parameter)CommonParameter.ProgrammingMode, x.getValue(), x.getData());
            }
        }
        catch (KNXException e) {
            out.error("reading memory location 0x60", (Throwable)e);
        }
    }

    private DeviceDescriptor.DD0 deviceDescriptor(byte[] data) {
        DeviceDescriptor.DD0 dd = DeviceDescriptor.DD0.from((byte[])data);
        this.putResult((Parameter)CommonParameter.DeviceDescriptor, dd.toString(), dd.maskVersion());
        this.putResult((Parameter)CommonParameter.KnxMedium, DeviceInfo.toMediumTypeString(dd.mediumType()), dd.mediumType());
        this.putResult((Parameter)CommonParameter.FirmwareType, DeviceInfo.toFirmwareTypeString(dd.firmwareType()), dd.firmwareType());
        this.putResult((Parameter)CommonParameter.FirmwareVersion, "" + dd.firmwareVersion(), dd.firmwareVersion());
        return dd;
    }

    private void readDeviceObject(int objectIdx) throws InterruptedException {
        this.read(CommonParameter.Manufacturer, objectIdx, 12, data -> Main.manufacturer((int)DeviceInfo.toUnsigned(data)));
        this.readUnsigned(objectIdx, 15, true, CommonParameter.OrderInfo);
        this.read(CommonParameter.SerialNumber, objectIdx, 11, DeviceInfo::knxSerialNumber);
        this.readUnsigned(objectIdx, 16, false, CommonParameter.ActualPeiType);
        this.readUnsigned(objectIdx, 78, true, CommonParameter.HardwareType);
        this.readUnsigned(objectIdx, 9, false, CommonParameter.FirmwareRevision);
        byte[] data2 = this.read(CommonParameter.DeviceDescriptor, objectIdx, 83);
        if (data2 != null) {
            DeviceDescriptor.DD0 profile = DeviceDescriptor.DD0.from((byte[])data2);
            if (this.dd == null) {
                this.dd = this.deviceDescriptor(data2);
            } else if (!profile.equals((Object)this.dd)) {
                this.putResult((Parameter)InternalParameter.AdditionalProfile, profile.toString(), data2);
            }
        }
        try {
            byte[] profileSna = this.read(CommonParameter.DeviceAddress, objectIdx, 57);
            byte[] profileDev = this.read(objectIdx, 58);
            byte[] profileAddr = new byte[]{profileSna[0], profileDev[0]};
            IndividualAddress ia = new IndividualAddress(profileAddr);
            this.putResult((Parameter)CommonParameter.DeviceAddress, "Additional profile address " + ia, ia.toByteArray());
        }
        catch (Exception profileSna) {
            // empty catch block
        }
        try {
            byte[] svcCtrl = this.read(InternalParameter.IndividualAddressWriteEnabled, objectIdx, 8);
            boolean indAddrWriteEnabled = (svcCtrl[1] & 4) == 4;
            this.putResult((Parameter)InternalParameter.IndividualAddressWriteEnabled, indAddrWriteEnabled ? "yes" : "no", svcCtrl[1] & 4);
            int services = svcCtrl[0] & 0xFF;
            String formatted = String.format("%8s", Integer.toBinaryString(services)).replace(' ', '0');
            this.putResult((Parameter)InternalParameter.ServiceControl, "Disabled services on EMI [Mgmt App TL-conn Switch TL-group Network Link User]: " + formatted, services);
        }
        catch (Exception svcCtrl) {
            // empty catch block
        }
        try {
            this.read(CommonParameter.DomainAddress, objectIdx, 82, bytes -> HexFormat.of().formatHex((byte[])bytes));
        }
        catch (Exception svcCtrl) {
            // empty catch block
        }
        this.read(CommonParameter.SoftwareVersion, objectIdx, 25, DeviceInfo::version);
        this.readUnsigned(objectIdx, 56, false, CommonParameter.MaxApduLength);
        int pidErrorFlags = 53;
        this.read(InternalParameter.ErrorFlags, objectIdx, 53, DeviceInfo::errorFlags);
    }

    private void readCemiServerObject(int objectIndex) throws InterruptedException {
        this.read(CemiParameter.MediumType, objectIndex, 51, DeviceInfo::mediumTypes);
        this.read(CemiParameter.SupportedCommModes, objectIndex, 64, DeviceInfo::supportedCommModes);
        this.read(CemiParameter.SelectedCommMode, objectIndex, 52, DeviceInfo::commMode);
        try {
            byte[] dev = this.read(CemiParameter.ClientAddress, objectIndex, 58);
            byte[] sna = this.read(objectIndex, 57);
            byte[] addr = new byte[]{sna[0], dev[0]};
            IndividualAddress ia = new IndividualAddress(addr);
            this.putResult((Parameter)CemiParameter.ClientAddress, "USB cEMI client address " + ia, ia.toByteArray());
        }
        catch (Exception dev) {
            // empty catch block
        }
        this.readSupportedFilteringModes(objectIndex, 65);
        this.readSelectedFilteringMode(objectIndex, 66);
        this.readSupportedFilteringModes(objectIndex, 63);
        this.readSelectedFilteringMode(objectIndex, 62);
        try {
            this.cEmiExtensionRfBiBat(objectIndex);
        }
        catch (Exception dev) {
            // empty catch block
        }
        try {
            byte[] data = this.read(objectIndex, 60);
            int selected = data[0] & 0xFF;
            boolean slave = (data[0] & 4) == 4;
            boolean master = (data[0] & 2) == 2;
            boolean async = (data[0] & 1) == 1;
            String formatted = "BiBat slave " + slave + ", BiBat master " + master + ", async " + async;
            this.putResult((Parameter)CemiParameter.SelectedRfMode, formatted, selected);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void readSupportedFilteringModes(int objectIndex, int pid) {
        try {
            this.read(CemiParameter.SupportedFilteringModes, objectIndex, pid, filters -> {
                int filter = filters[1] & 0xFF;
                boolean grp = (filter & 8) == 8;
                boolean doa = (filter & 4) == 4;
                boolean rep = (filter & 2) == 2;
                boolean ownIa = (filter & 1) == 1;
                return "ext. group addresses " + grp + ", domain address " + doa + ", repeated frames " + rep + ", own individual address " + ownIa;
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void readSelectedFilteringMode(int objectIndex, int pid) {
        try {
            this.read(CemiParameter.SelectedFilteringModes, objectIndex, pid, filters -> {
                boolean ownIa;
                int selected = filters[1] & 0xFF;
                boolean grp = (selected & 8) == 8;
                boolean doa = (selected & 4) == 4;
                boolean rep = (selected & 2) == 2;
                boolean bl = ownIa = (selected & 1) == 1;
                if (selected == 0) {
                    return "all supported filters active";
                }
                return "disabled frame filters: ext. group addresses " + grp + ", domain address " + doa + ", repeated frames " + rep + ", own individual address " + ownIa;
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void cEmiExtensionRfBiBat(int objectIndex) throws InterruptedException {
        this.read(CemiParameter.SupportedRfModes, objectIndex, 61, support -> {
            boolean slave = (support[0] & 4) == 4;
            boolean master = (support[0] & 2) == 2;
            boolean async = (support[0] & 1) == 1;
            return "BiBat slave " + slave + ", BiBat master " + master + ", Async " + async;
        });
    }

    private static String supportedCommModes(byte[] commModes) {
        int modes = commModes[1] & 0xFF;
        boolean tll = (modes & 8) == 8;
        boolean raw = (modes & 4) == 4;
        boolean bm = (modes & 2) == 2;
        boolean dll = (modes & 1) == 1;
        return "Transport layer local " + tll + ", Data link layer modes: normal " + dll + ", busmonitor " + bm + ", raw mode " + raw;
    }

    private static String commMode(byte[] data) {
        int commMode = data[0] & 0xFF;
        return switch (commMode) {
            case 0 -> "Data link layer";
            case 1 -> "Data link layer busmonitor";
            case 2 -> "Data link layer raw frames";
            case 6 -> "cEMI transport layer";
            case 255 -> "no layer";
            default -> "unknown/unspecified (" + commMode + ")";
        };
    }

    private void readRFMediumObject(int objectIndex) {
        try {
            int pidRfDomainAddress = 56;
            this.read(RfParameter.DomainAddress, objectIndex, 56, doa -> "0x" + HexFormat.of().formatHex((byte[])doa));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void readSystemState() throws InterruptedException {
        int state = this.readMem(96, 1);
        state &= 0x7F;
        String[] mode = new String[]{"Programming mode", "Normal operation", "Transport layer", "Application layer", "Serial PEI interface (msg protocol)", "User program", "Programming mode (ind. address)"};
        StringBuilder sb = new StringBuilder();
        for (int bit = 0; bit < 7; ++bit) {
            if ((state & 1 << bit) == 0) continue;
            sb.append(mode[bit]).append(", ");
        }
        this.putResult((Parameter)CommonParameter.SystemState, sb.toString(), state);
    }

    private void readActualPeiType() throws InterruptedException {
        if (this.mc == null) {
            return;
        }
        int channel = 4;
        boolean repeat = true;
        try {
            int v = this.mc.readADC(this.d, 4, 1);
            int peitype = (10 * v + 60) / 128;
            this.putResult((Parameter)CommonParameter.ActualPeiType, DeviceInfo.toPeiTypeString(peitype), peitype);
        }
        catch (KNXException e) {
            out.error("reading actual PEI type (A/D converter channel {}, repeat {})", new Object[]{4, 1, e});
        }
    }

    private void readSecurityObject(int objectIndex) throws InterruptedException {
        byte[] failure;
        Optional<byte[]> result;
        int pidSecurityMode = 51;
        byte[] empty = new byte[]{};
        this.readFunctionPropertyState((Parameter)SecurityParameter.SecurityMode, 17, 51, 0, empty, DeviceInfo::toOnOff);
        int pidSecurityReport = 57;
        this.read(SecurityParameter.SecurityFailure, objectIndex, 57, DeviceInfo::toYesNo);
        int pidSecurityFailuresLog = 55;
        byte[] readFailureCounters = new byte[]{0};
        this.readFunctionPropertyState((Parameter)SecurityParameter.SecurityFailureCounters, 17, 55, 0, readFailureCounters, DeviceInfo::securityFailureCounters);
        for (int i = 0; i < 5 && !(result = this.readFunctionPropertyState((Parameter)SecurityParameter.LastSecurityFailure, 17, 55, 1, failure = new byte[]{(byte)i}, DeviceInfo::latestSecurityFailure)).isEmpty(); ++i) {
        }
    }

    private static String toOnOff(byte[] data) {
        return (data[2] & 1) != 0 ? "on" : "off";
    }

    private static String toYesNo(byte[] data) {
        return (data[0] & 1) != 0 ? "yes" : "no";
    }

    private static String securityFailureCounters(byte[] data) {
        ByteBuffer counters = ByteBuffer.wrap(data, 3, data.length - 3);
        int scfErrors = counters.getShort() & 0xFFFF;
        int seqNoErrors = counters.getShort() & 0xFFFF;
        int cryptoErrors = counters.getShort() & 0xFFFF;
        int accessRoleErrors = counters.getShort() & 0xFFFF;
        return "control field " + scfErrors + ", sequence " + seqNoErrors + ", cryptographic " + cryptoErrors + ", access " + accessRoleErrors;
    }

    private static String latestSecurityFailure(byte[] data) {
        ByteBuffer msgInfo = ByteBuffer.wrap(data, 3, data.length - 3);
        IndividualAddress src = new IndividualAddress(msgInfo.getShort() & 0xFFFF);
        int dstRaw = msgInfo.getShort() & 0xFFFF;
        int ctrl2 = msgInfo.get() & 0xFF;
        boolean group = (ctrl2 & 0x80) != 0;
        GroupAddress dst = group ? new GroupAddress(dstRaw) : new IndividualAddress(dstRaw);
        byte[] seqData = new byte[6];
        msgInfo.get(seqData);
        long seqNo = DeviceInfo.toUnsigned(seqData);
        String[] errorTypes = new String[]{"reserved", "invalid SCF", "sequence error", "cryptographic error", "error against access & roles"};
        String error = errorTypes[msgInfo.get() & 0xFF];
        return String.format("%s->%s seq %d: %s", src, dst, seqNo, error);
    }

    private static String errorFlags(byte[] data) {
        if ((data[0] & 0xFF) == 255) {
            return "everything OK";
        }
        String[] description = new String[]{"System 1 internal system error", "Illegal system state", "Checksum / CRC error in internal non-volatile memory", "Stack overflow error", "Inconsistent system tables", "Physical transceiver error", "System 2 internal system error", "System 3 internal system error"};
        ArrayList<String> errors = new ArrayList<String>();
        for (int i = 0; i < 8; ++i) {
            if ((data[0] & 1 << i) != 0) continue;
            errors.add(description[i]);
        }
        return String.join((CharSequence)", ", errors);
    }

    private void putResult(Parameter p, String formatted, long raw) {
        this.putResult(p, formatted, ByteBuffer.allocate(8).putLong(raw).array());
    }

    private void putResult(Parameter p, String formatted, int raw) {
        this.putResult(p, formatted, ByteBuffer.allocate(4).putInt(raw).array());
    }

    private void putResult(Parameter p, String formatted, byte[] raw) {
        Item item = new Item(this.category, p, formatted, raw);
        this.onDeviceInformation(item);
    }

    private void readPL110Bcu1() throws InterruptedException {
        int addrDoA = 258;
        this.readMem(258, 2, true, (Parameter)CommonParameter.DomainAddress);
        this.readBcuInfo(true);
    }

    private void readTP1Bcu1() throws InterruptedException {
        int addrManufactData = 257;
        this.readMem(257, 3, true, (Parameter)CommonParameter.ManufacturerData);
        this.readBcuInfo(true);
    }

    private void readTP1Bcu2() throws InterruptedException {
        int addrManufacturer = 257;
        int addrAppId = 259;
        this.readMem(257, 2, Main::manufacturer, (Parameter)CommonParameter.Manufacturer);
        long appId = this.readMemLong(259, 5);
        String appMf = Main.manufacturer((int)appId >> 24);
        long swDev = appId >> 8 & 0xFFL;
        long swVersion = appId & 0xFFL;
        out.info("appId 0x{} - app manufacturer: {}, SW dev type {}, SW version {}", new Object[]{Long.toHexString(appId), appMf, swDev, swVersion});
        this.readBcuInfo(false);
        this.findInterfaceObjects();
    }

    private void readBcuInfo(boolean bcu1) throws InterruptedException {
        if (bcu1) {
            this.readMem(260, 1, Main::manufacturer, (Parameter)CommonParameter.Manufacturer);
            this.readMem(261, 2, true, (Parameter)CommonParameter.DeviceTypeNumber);
        }
        this.readMem(263, 1, i -> DeviceInfo.version(new byte[]{(byte)i.intValue()}), (Parameter)CommonParameter.SoftwareVersion);
        this.readMem(265, 1, DeviceInfo::toPeiTypeString, (Parameter)CommonParameter.RequiredPeiType);
        this.readMem(269, 1, DeviceInfo::decodeRunError, (Parameter)CommonParameter.RunError);
        this.readSystemState();
        this.readMem(270, 1, v -> Integer.toString(v >> 4 & 7), (Parameter)CommonParameter.RoutingCount);
        this.readMem(274, 1, true, (Parameter)CommonParameter.GroupObjTableLocation);
        this.readGroupAddresses();
    }

    private void readGroupAddresses() throws InterruptedException {
        int i;
        int memLocation;
        if (this.dd.equals(DeviceDescriptor.DD0.TYPE_5705)) {
            memLocation = 16384;
        } else if (this.ifObjects.containsKey(1)) {
            int addresstableObjectIdx = this.ifObjects.get(1).get(0);
            int tableSize = this.readElements(addresstableObjectIdx, 23);
            if (tableSize > 0) {
                StringJoiner joiner = new StringJoiner(", ");
                for (int i2 = 0; i2 < tableSize; ++i2) {
                    GroupAddress group = new GroupAddress(this.read(addresstableObjectIdx, 23, i2 + 1, 1));
                    joiner.add(group.toString());
                }
                this.groupAddressesDone = true;
                this.putResult((Parameter)CommonParameter.GroupAddresses, joiner.toString(), new byte[0]);
                return;
            }
            memLocation = (int)DeviceInfo.toUnsigned(this.read(addresstableObjectIdx, 7));
            if (memLocation <= 0) {
                return;
            }
        } else {
            memLocation = 278;
        }
        int lengthSize = this.isSystemB ? 2 : 1;
        int entries = this.readMem(memLocation, lengthSize, false, (Parameter)CommonParameter.GroupAddressTableEntries);
        int startAddr = memLocation + lengthSize;
        if (!this.isSystemB && entries > 0) {
            this.readMem(startAddr, 2, v -> new IndividualAddress(v & Short.MAX_VALUE).toString(), (Parameter)CommonParameter.DeviceAddress);
            startAddr += 2;
        }
        StringBuilder sb = new StringBuilder();
        int n = i = this.isSystemB ? 0 : 1;
        while (i < entries) {
            int raw = this.readMem(startAddr, 2);
            GroupAddress group = new GroupAddress(raw & Short.MAX_VALUE);
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append(group);
            if ((raw & 0x8000) == 32768) {
                sb.append("(R)");
            }
            startAddr += 2;
            ++i;
        }
        this.groupAddressesDone = true;
        this.putResult((Parameter)CommonParameter.GroupAddresses, sb.toString(), new byte[0]);
    }

    private void readKnxipInfo(int objectIndex) throws KNXException, InterruptedException {
        boolean manual;
        this.read(KnxipParameter.DeviceName, () -> this.readFriendlyName(objectIndex));
        byte[] data = this.read(KnxipParameter.Capabilities, objectIndex, 68, DeviceInfo::toCapabilitiesString).orElse(new byte[2]);
        boolean supportsTunneling = (data[1] & 1) == 1;
        this.read(KnxipParameter.MacAddress, objectIndex, 64, HexFormat.ofDelimiter(":")::formatHex);
        data = this.read(KnxipParameter.CurrentIPAssignment, objectIndex, 54, DeviceInfo::toIPAssignmentString).orElse(new byte[1]);
        int currentIPAssignment = data[0] & 0xF;
        boolean dhcpOrBoot = (data[0] & 6) != 0;
        byte[] currentIP = this.readIp(KnxipParameter.CurrentIPAddress, objectIndex, 57);
        byte[] currentMask = this.readIp(KnxipParameter.CurrentSubnetMask, objectIndex, 58);
        byte[] currentGw = this.readIp(KnxipParameter.CurrentDefaultGateway, objectIndex, 59);
        if (dhcpOrBoot) {
            this.readIp(KnxipParameter.DhcpServer, objectIndex, 63);
        }
        boolean bl = manual = ((data = this.read(KnxipParameter.ConfiguredIPAssignment, objectIndex, 55, config -> {
            int ipAssignment = config[0] & 0xF;
            return ipAssignment != currentIPAssignment ? DeviceInfo.toIPAssignmentString(config) : "";
        }).orElse(new byte[1]))[0] & 1) == 1;
        if (manual) {
            this.read(KnxipParameter.IPAddress, objectIndex, 60, ip -> Arrays.equals(currentIP, ip) ? "" : DeviceInfo.toIP(ip));
            this.read(KnxipParameter.SubnetMask, objectIndex, 61, mask -> Arrays.equals(currentMask, mask) ? "" : DeviceInfo.toIP(mask));
            this.read(KnxipParameter.DefaultGateway, objectIndex, 62, gw -> Arrays.equals(currentGw, gw) ? "" : DeviceInfo.toIP(gw));
        }
        this.readIp(KnxipParameter.RoutingMulticast, objectIndex, 66);
        this.readUnsigned(objectIndex, 67, false, KnxipParameter.TimeToLive);
        this.readUnsigned(objectIndex, 74, false, KnxipParameter.TransmitToIP);
        if (supportsTunneling) {
            int pid = 53;
            int elements = this.readElements(objectIndex, 53);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < elements; ++i) {
                data = this.read(objectIndex, 53, i + 1, 1, false);
                sb.append(new IndividualAddress(data)).append(" ");
            }
            this.putResult((Parameter)KnxipParameter.AdditionalIndividualAddresses, sb.toString(), new byte[0]);
        }
    }

    private void readProgram(int objectIdx) throws InterruptedException {
        this.read(CommonParameter.ProgramVersion, objectIdx, 13, DeviceInfo::programVersion);
        this.readLoadState(objectIdx);
        this.read(CommonParameter.RunStateControl, objectIdx, 6, DeviceInfo::getRunState);
    }

    private static String programVersion(byte[] data) {
        if (data.length != 5) {
            return HexFormat.of().formatHex(data);
        }
        int mfr = (data[0] & 0xFF) << 8 | data[1] & 0xFF;
        return String.format("%s %02x%02x v%d.%d", Main.manufacturer(mfr), data[2], data[3], (data[4] & 0xFF) >> 4, data[4] & 0xF);
    }

    private void readLoadState(int objectIdx) throws InterruptedException {
        Optional<byte[]> data = this.read(CommonParameter.LoadStateControl, objectIdx, 5, DeviceInfo::getLoadState);
        boolean hasErrorCode = this.isSystemB;
        if (hasErrorCode && data.isPresent() && data.get()[0] == 3) {
            this.read(CommonParameter.LoadStateError, objectIdx, 28, error -> {
                try {
                    return TranslatorTypes.createTranslator((String)"20.011", (byte[])error).getValue();
                }
                catch (KNXException e) {
                    return "";
                }
            });
        }
    }

    private Optional<byte[]> readFunctionPropertyState(Parameter p, int objectType, int propertyId, int service, byte[] info, Function<byte[], String> representation) throws InterruptedException {
        Optional<byte[]> data = Optional.ofNullable(this.readFunctionPropertyState(p, objectType, propertyId, service, info));
        data.map(representation).filter(Predicate.not(String::isEmpty)).ifPresent(formatted -> this.putResult(p, (String)formatted, (byte[])data.get()));
        return data;
    }

    private byte[] readFunctionPropertyState(Parameter p, int objectType, int propertyId, int service, byte ... info) throws InterruptedException {
        if (this.mc == null) {
            return null;
        }
        boolean oinstance = true;
        out.debug("read {} function property state {}({})|{} service {}", new Object[]{p.friendlyName(), objectType, 1, propertyId, service});
        try {
            return this.mc.readFunctionPropertyState(this.d, objectType, 1, propertyId, service, info);
        }
        catch (KNXException e) {
            out.debug(e.getMessage());
            return null;
        }
    }

    private Optional<byte[]> read(Parameter p, int objectIndex, int pid, Function<byte[], String> representation) throws InterruptedException {
        Optional<byte[]> data = Optional.ofNullable(this.read(p, objectIndex, pid));
        data.map(representation).filter(Predicate.not(String::isEmpty)).ifPresent(formatted -> this.putResult(p, (String)formatted, (byte[])data.get()));
        return data;
    }

    private void read(Parameter p, Callable<String> c) throws KNXLinkClosedException, InterruptedException {
        try {
            out.debug("read {} ...", (Object)p.friendlyName());
            String s = c.call();
            this.putResult(p, s, s.getBytes(StandardCharsets.ISO_8859_1));
        }
        catch (InterruptedException | KNXLinkClosedException e) {
            throw e;
        }
        catch (KNXRemoteException e) {
            out.warn("reading {}: {}", (Object)p, (Object)e.getMessage());
        }
        catch (Exception e) {
            out.error("error reading {}", (Object)p, (Object)e);
        }
    }

    private byte[] readIp(Parameter p, int objectIndex, int pid) throws InterruptedException {
        return this.read(p, objectIndex, pid, DeviceInfo::toIP).orElse(new byte[4]);
    }

    private String readFriendlyName(int objectIndex) throws KNXException, InterruptedException {
        byte[] data;
        char[] name = new char[30];
        int start = 0;
        do {
            data = this.pc.getProperty(objectIndex, 76, start + 1, 10);
            int i = 0;
            while (i < 10 && data[i] != 0) {
                name[start] = (char)(data[i] & 0xFF);
                ++i;
                ++start;
            }
        } while (start < 30 && data[9] != 0);
        return new String(name, 0, start);
    }

    private int readElements(int objectIndex, int pid) throws InterruptedException {
        byte[] elems = this.read(objectIndex, pid, 0, 1);
        return elems == null ? -1 : (int)DeviceInfo.toUnsigned(elems);
    }

    private byte[] read(int objectIndex, int pid) throws InterruptedException {
        return this.read(objectIndex, pid, 1, 1, true);
    }

    private byte[] read(Parameter p, int objectIndex, int pid) throws InterruptedException {
        out.debug("read {}|{} {}", new Object[]{objectIndex, pid, p.friendlyName()});
        return this.read(objectIndex, pid, 1, 1, false);
    }

    private byte[] read(int objectIndex, int pid, int start, int elements) throws InterruptedException {
        return this.read(objectIndex, pid, start, elements, true);
    }

    private byte[] read(int objectIndex, int pid, int start, int elements, boolean log) throws InterruptedException {
        if (log) {
            out.debug("read {}|{}", (Object)objectIndex, (Object)pid);
        }
        try {
            ByteArrayOutputStream res = new ByteArrayOutputStream();
            for (int i = start; i < start + elements; ++i) {
                byte[] data = this.pc.getProperty(objectIndex, pid, i, 1);
                res.write(data, 0, data.length);
            }
            return res.toByteArray();
        }
        catch (KNXException e) {
            out.debug("reading KNX property " + objectIndex + "|" + pid + ": " + e.getMessage());
            return null;
        }
    }

    private void readUnsigned(int objectIndex, int pid, boolean hex, Parameter p) throws InterruptedException {
        byte[] data = this.read(p, objectIndex, pid);
        if (data != null) {
            String formatted = hex ? HexFormat.of().formatHex(data) : Long.toString(DeviceInfo.toUnsigned(data));
            this.putResult(p, formatted, data);
        }
    }

    private int readMem(int startAddr, int bytes, boolean hex, Parameter p) throws InterruptedException {
        out.debug("read 0x{}..0x{} {}", new Object[]{Long.toHexString(startAddr), Long.toHexString(startAddr + bytes), p.friendlyName()});
        long v = this.readMemLong(startAddr, bytes);
        if (v != -1L) {
            this.putResult(p, hex ? Long.toHexString(v) : Long.toString(v), v);
        }
        return (int)v;
    }

    private void readMem(int startAddr, int bytes, Function<Integer, String> representation, Parameter p) throws InterruptedException {
        int v = this.readMem(startAddr, bytes);
        this.putResult(p, representation.apply(v), v);
    }

    private int readMem(int startAddr, int bytes) throws InterruptedException {
        return (int)this.readMemLong(startAddr, bytes);
    }

    private long readMemLong(int startAddr, int bytes) throws InterruptedException {
        try {
            return DeviceInfo.toUnsigned(this.mc.readMemory(this.d, startAddr, bytes));
        }
        catch (KNXException e) {
            out.debug("error reading 0x{}..0x{}: {}", new Object[]{Long.toHexString(startAddr), Long.toHexString(startAddr + bytes), e.toString()});
            return -1L;
        }
    }

    private KNXNetworkLink createLink() throws KNXException, InterruptedException {
        return Main.newLink(this.options);
    }

    private void parseOptions(String[] args) {
        if (args.length == 0) {
            return;
        }
        this.options.put("port", 3671);
        Iterator<String> i = List.of(args).iterator();
        while (i.hasNext()) {
            String arg = i.next();
            if (Main.isOption(arg, "help", "h")) {
                this.options.put("about", DeviceInfo::showUsage);
                return;
            }
            if (Main.parseCommonOption(arg, i, this.options) || Main.parseSecureOption(arg, i, this.options)) continue;
            if (Main.isOption(arg, "knx-address", "k")) {
                this.options.put("knx-address", Main.getAddress(i.next()));
                continue;
            }
            if (!this.options.containsKey("host")) {
                this.options.put("host", arg);
                continue;
            }
            if (!this.options.containsKey("device")) {
                try {
                    this.options.put("device", new IndividualAddress(arg));
                    continue;
                }
                catch (KNXFormatException e) {
                    throw new KNXIllegalArgumentException("KNX device " + e, (Throwable)e);
                }
            }
            throw new KNXIllegalArgumentException("unknown option " + arg);
        }
        if (this.options.containsKey("usb") && !this.options.containsKey("host")) {
            this.options.put("host", "");
        }
        if (!this.options.containsKey("host") || this.options.containsKey("ft12") && this.options.containsKey("usb")) {
            throw new KNXIllegalArgumentException("specify either IP host, serial port, or device");
        }
        if (!this.options.containsKey("device")) {
            String adapter;
            String string = this.options.containsKey("ft12") ? "FT1.2" : (adapter = this.options.containsKey("tpuart") ? "TP-UART" : "");
            if (!adapter.isEmpty()) {
                throw new KNXIllegalArgumentException("reading device info of local " + adapter + " interface is not supported, specify remote KNX device address");
            }
            if (this.options.containsKey("medium") || this.options.containsKey("domain")) {
                throw new KNXIllegalArgumentException("missing remote KNX device address");
            }
        }
        if (!this.options.containsKey("medium")) {
            this.options.put("medium", new TPSettings());
        }
        Main.setDomainAddress(this.options);
    }

    private static void showUsage() {
        StringJoiner joiner = new StringJoiner(System.lineSeparator());
        joiner.add("Usage: DeviceInfo [options] <host|port> [KNX device address]");
        joiner.add(Main.printCommonOptions());
        joiner.add(Main.printSecureOptions());
        DeviceInfo.out(joiner.toString());
    }

    private static void out(String s) {
        System.out.println(s);
    }

    private static long toUnsigned(byte[] data) {
        if (data == null || data.length > 8) {
            return -1L;
        }
        long value = 0L;
        for (byte b : data) {
            value = value << 8 | (long)(b & 0xFF);
        }
        return value;
    }

    private static String toIP(byte[] data) {
        try {
            if (data != null) {
                return InetAddress.getByAddress(data).getHostAddress();
            }
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return "n/a";
    }

    private static String toMediumTypeString(int type) {
        return switch (type) {
            case 0 -> "Twisted Pair 1";
            case 1 -> "Power-line 110";
            case 2 -> "Radio Frequency";
            case 5 -> "KNX IP";
            default -> "Type " + type;
        };
    }

    private static String mediumTypes(byte[] data) {
        try {
            return TranslatorTypes.createTranslator((DPT)DptXlator16BitSet.DptMedia, (byte[])data).getValue();
        }
        catch (Exception e) {
            return "";
        }
    }

    private static String toFirmwareTypeString(int type) {
        return switch (type) {
            case 0 -> "BCU 1, BCU 2, BIM M113";
            case 1 -> "Unidirectional devices";
            case 3 -> "Property based device management";
            case 7 -> "BIM M112";
            case 8 -> "IR Decoder, TP1 legacy";
            case 9 -> "Repeater, Coupler";
            default -> "Type " + type;
        };
    }

    private static String toPeiTypeString(int peitype) {
        if (peitype == -1 || peitype == 255) {
            return "n/a";
        }
        return switch (peitype) {
            case 0 -> "No adapter";
            case 1 -> "Illegal adapter";
            case 2 -> "4 inputs, 1 output (LED)";
            case 4 -> "2 inputs / 2 outputs, 1 output (LED)";
            case 6 -> "3 inputs / 1 output, 1 output (LED)";
            case 8 -> "5 inputs";
            case 10 -> "FT1.2 protocol";
            case 12 -> "Serial sync message protocol";
            case 14 -> "Serial sync data block protocol";
            case 16 -> "Serial async message protocol";
            case 17 -> "Programmable I/O";
            case 19 -> "4 outputs, 1 output (LED)";
            case 20 -> "Download";
            default -> "Reserved";
        };
    }

    private static String decodeRunError(int runError) {
        String[] flags = new String[]{"SYS0_ERR: buffer error", "SYS1_ERR: system state parity error", "EEPROM corrupted", "Stack overflow", "OBJ_ERR: group object/assoc. table error", "SYS2_ERR: transceiver error", "SYS3_ERR: confirm error"};
        int bits = ~runError & 0xFF;
        if (bits == 0) {
            return "OK";
        }
        StringJoiner sb = new StringJoiner(", ");
        for (int i = 0; i < flags.length; ++i) {
            if ((bits & 1 << i) == 0) continue;
            sb.add(flags[i]);
        }
        return sb.toString();
    }

    private static String getLoadState(byte[] data) {
        if (data == null || data.length < 1) {
            return "n/a";
        }
        int state = data[0] & 0xFF;
        return switch (state) {
            case 0 -> "Unloaded";
            case 1 -> "Loaded";
            case 2 -> "Loading";
            case 3 -> "Error (during load process)";
            case 4 -> "Unloading";
            case 5 -> "Load Completing (Intermediate)";
            default -> "Invalid load status " + state;
        };
    }

    private static String getRunState(byte[] data) {
        if (data == null || data.length < 1) {
            return "n/a";
        }
        int state = data[0] & 0xFF;
        return switch (state) {
            case 0 -> "Halted";
            case 1 -> "Running";
            case 2 -> "Ready";
            case 3 -> "Terminated";
            case 4 -> "Starting";
            case 5 -> "Shutting down";
            default -> "Invalid run state " + state;
        };
    }

    private static String toIPAssignmentString(byte[] data) {
        int bitset = data[0] & 0xFF;
        StringJoiner joiner = new StringJoiner(", ");
        if ((bitset & 1) != 0) {
            joiner.add("manual");
        }
        if ((bitset & 2) != 0) {
            joiner.add("Bootstrap Protocol");
        }
        if ((bitset & 4) != 0) {
            joiner.add("DHCP");
        }
        if ((bitset & 8) != 0) {
            joiner.add("Auto IP");
        }
        return joiner.toString();
    }

    private static String toCapabilitiesString(byte[] data) {
        StringJoiner joiner = new StringJoiner(", ");
        if ((data[1] & 1) == 1) {
            joiner.add("Device Management");
        }
        if ((data[1] & 2) == 2) {
            joiner.add("Tunneling");
        }
        if ((data[1] & 4) == 4) {
            joiner.add("Routing");
        }
        if ((data[1] & 8) == 8) {
            joiner.add("Remote Logging");
        }
        if ((data[1] & 0x10) == 16) {
            joiner.add("Remote Configuration and Diagnosis");
        }
        if ((data[1] & 0x20) == 32) {
            joiner.add("Object Server");
        }
        return joiner.toString();
    }

    private static String knxSerialNumber(byte[] data) {
        String hex = HexFormat.of().formatHex(data);
        return hex.substring(0, 4) + ":" + hex.substring(4);
    }

    private static String version(byte[] data) {
        if (data.length == 1) {
            return ((data[0] & 0xFF) >> 4) + "." + (data[0] & 0xF);
        }
        int magic = (data[0] & 0xFF) >> 3;
        int version = (data[0] & 7) << 2 | (data[1] & 0xC0) >> 6;
        int rev = data[1] & 0x3F;
        return "[" + magic + "] " + version + "." + rev;
    }

    private record JsonResult(String device, Collection<JsonItem> info) implements Json
    {
    }

    private record JsonItem(String category, Parameter parameter, String value, byte[] data) implements Json
    {
    }

    public static final class Item {
        private final String category;
        private final Parameter parameter;
        private final String value;
        private final byte[] raw;

        Item(String category, Parameter parameter, String value, byte[] raw) {
            this.category = category;
            this.parameter = parameter;
            this.value = value;
            this.raw = raw;
        }

        public String category() {
            return this.category;
        }

        public Parameter parameter() {
            return this.parameter;
        }

        public String value() {
            return this.value;
        }

        public byte[] raw() {
            return this.raw;
        }
    }

    public static interface Parameter {
        public String name();

        default public String friendlyName() {
            return this.name().replaceAll("([A-Z])", " $1").replace("I P", "IP").trim();
        }
    }

    @FunctionalInterface
    private static interface ThrowingConsumer<T, E extends Exception> {
        public void accept(T var1) throws E;
    }

    public static enum CommonParameter implements Parameter
    {
        DeviceDescriptor,
        KnxMedium,
        FirmwareType,
        FirmwareVersion,
        HardwareType,
        SerialNumber,
        DomainAddress,
        MaxApduLength,
        Manufacturer,
        ManufacturerData,
        DeviceTypeNumber,
        SoftwareVersion,
        ActualPeiType,
        RequiredPeiType,
        FirmwareRevision,
        RunError,
        ProgrammingMode,
        SystemState,
        RoutingCount,
        GroupObjTableLocation,
        GroupAddressTableEntries,
        DeviceAddress,
        GroupAddresses,
        ProgramVersion,
        LoadStateControl,
        LoadStateError,
        RunStateControl,
        OrderInfo;

    }

    public static enum InternalParameter implements Parameter
    {
        IndividualAddressWriteEnabled,
        ServiceControl,
        AdditionalProfile,
        ErrorFlags;

    }

    public static enum CemiParameter implements Parameter
    {
        MediumType,
        SupportedCommModes,
        SelectedCommMode,
        ClientAddress,
        SupportedRfModes,
        SelectedRfMode,
        SupportedFilteringModes,
        SelectedFilteringModes;

    }

    public static enum RfParameter implements Parameter
    {
        DomainAddress;

    }

    public static enum SecurityParameter implements Parameter
    {
        SecurityMode,
        SecurityFailure,
        SecurityFailureCounters,
        LastSecurityFailure;

    }

    public static enum KnxipParameter implements Parameter
    {
        DeviceName,
        Capabilities,
        MacAddress,
        IPAddress,
        SubnetMask,
        DefaultGateway,
        CurrentIPAddress,
        CurrentSubnetMask,
        CurrentDefaultGateway,
        IPAssignment,
        ConfiguredIPAssignment,
        DhcpServer,
        CurrentIPAssignment,
        RoutingMulticast,
        TimeToLive,
        TransmitToIP,
        AdditionalIndividualAddresses;

    }
}

