/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.tools;

import java.io.IOException;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.UnknownHostException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.KnxRuntimeException;
import tuwien.auto.calimero.SerialNumber;
import tuwien.auto.calimero.knxnetip.Discoverer;
import tuwien.auto.calimero.knxnetip.DiscovererTcp;
import tuwien.auto.calimero.knxnetip.TcpConnection;
import tuwien.auto.calimero.knxnetip.servicetype.DescriptionResponse;
import tuwien.auto.calimero.knxnetip.servicetype.SearchResponse;
import tuwien.auto.calimero.knxnetip.util.DIB;
import tuwien.auto.calimero.knxnetip.util.DeviceDIB;
import tuwien.auto.calimero.knxnetip.util.HPAI;
import tuwien.auto.calimero.knxnetip.util.ServiceFamiliesDIB;
import tuwien.auto.calimero.knxnetip.util.Srp;
import tuwien.auto.calimero.log.LogService;
import tuwien.auto.calimero.tools.Json;
import tuwien.auto.calimero.tools.Main;

public class Discover
implements Runnable {
    private static final String tool = "Discover";
    private static final String sep = System.lineSeparator();
    private static final Logger out = LogService.getLogger((String)"calimero.knxnetip.Discoverer");
    private final Discoverer d;
    private final DiscovererTcp tcp;
    private final Map<String, Object> options = new HashMap<String, Object>();
    private final List<Srp> searchParameters = new ArrayList<Srp>();
    private final boolean reuseForDescription;

    public Discover(String[] args) {
        boolean tcpSearch;
        try {
            this.parseOptions(args);
        }
        catch (KNXIllegalArgumentException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new KNXIllegalArgumentException(e.getMessage(), (Throwable)e);
        }
        Integer lp = (Integer)this.options.get("localport");
        NetworkInterface nif = (NetworkInterface)this.options.get("if");
        InetAddress local = nif != null ? this.inetAddress(nif) : null;
        boolean mcast = (Boolean)this.options.get("mcastResponse");
        boolean bl = tcpSearch = this.options.containsKey("search") && this.options.containsKey("host") && !this.options.containsKey("udp");
        if (tcpSearch || this.options.containsKey("tcp")) {
            InetAddress server = (InetAddress)this.options.get("host");
            InetSocketAddress ctrlEndpoint = new InetSocketAddress(server, (int)((Integer)this.options.get("serverport")));
            InetSocketAddress localEp = new InetSocketAddress(local, lp != null ? lp : 0);
            TcpConnection connection = Main.tcpConnection(localEp, ctrlEndpoint);
            Main.lookupKeyring(this.options);
            Optional<byte[]> optUserKey = Main.userKey(this.options);
            if (optUserKey.isPresent()) {
                byte[] userKey = optUserKey.get();
                byte[] devAuth = Main.deviceAuthentication(this.options);
                int user = (Integer)this.options.getOrDefault("user", 0);
                TcpConnection.SecureSession session = connection.newSecureSession(user, userKey, devAuth);
                this.tcp = Discoverer.secure((TcpConnection.SecureSession)session);
            } else {
                this.tcp = Discoverer.tcp((TcpConnection)connection);
            }
            this.reuseForDescription = true;
            this.tcp.timeout((Duration)this.options.get("timeout"));
            this.d = null;
        } else {
            this.d = new Discoverer(local, lp != null ? lp : 0, this.options.containsKey("nat"), mcast);
            this.reuseForDescription = false;
            this.d.timeout((Duration)this.options.get("timeout"));
            this.tcp = null;
        }
    }

    public static void main(String ... args) {
        try {
            Discover d = new Discover(args);
            Main.ShutdownHandler sh = new Main.ShutdownHandler().register();
            d.run();
            sh.unregister();
        }
        catch (Throwable t) {
            out.error("parsing options", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Throwable thrown = null;
        boolean canceled = false;
        try {
            if (this.options.containsKey("help")) {
                Discover.showUsage();
            } else if (this.options.containsKey("version")) {
                Main.showVersion();
            } else if (this.options.containsKey("search")) {
                if (this.options.containsKey("withDescription")) {
                    this.searchWithDescription();
                } else {
                    this.search();
                }
            } else if (this.options.containsKey("host")) {
                this.description();
            } else {
                Discover.out("Discover - KNXnet/IP server discovery & self description");
                Main.showVersion();
                Discover.out("Type --help for help message");
            }
        }
        catch (RuntimeException | KNXException e) {
            thrown = e;
        }
        catch (InterruptedException e) {
            canceled = true;
            Thread.currentThread().interrupt();
        }
        finally {
            this.onCompletion((Exception)thrown, canceled);
        }
    }

    protected void onEndpointReceived(Discoverer.Result<SearchResponse> result) {
        if (this.options.containsKey("json")) {
            System.out.println(Discover.endpointToJson(result));
        } else {
            SearchResponse sr = (SearchResponse)result.response();
            System.out.println(Discover.formatResponse(result, sr.getControlEndpoint(), sr.getDevice(), sr.getServiceFamilies(), sr.description()));
        }
    }

    protected void onDescriptionReceived(Discoverer.Result<DescriptionResponse> result) {
        if (this.options.containsKey("json")) {
            Discover.descriptionToJson(result);
        } else {
            Discover.onDescriptionReceived(result, null);
        }
    }

    private static String endpointToJson(Discoverer.Result<SearchResponse> result) {
        SearchResponse sr = (SearchResponse)result.response();
        JsonDescriptionResponse jsonDesc = new JsonDescriptionResponse(Discover.toJson(sr.getDevice()), sr.getServiceFamilies().families(), sr.description());
        record JsonSearchResponse(boolean v2, InetSocketAddress ctrlEndpoint, JsonDescriptionResponse description) implements Json
        {
        }
        JsonSearchResponse jsonResponse = new JsonSearchResponse(sr.v2(), sr.getControlEndpoint().endpoint(), jsonDesc);
        return Discover.toJson(result, jsonResponse);
    }

    private static void descriptionToJson(Discoverer.Result<DescriptionResponse> result) {
        DescriptionResponse dr = (DescriptionResponse)result.response();
        JsonDescriptionResponse jsonDesc = new JsonDescriptionResponse(Discover.toJson(dr.getDevice()), dr.getServiceFamilies().families(), dr.getDescription());
        System.out.println(Discover.toJson(result, jsonDesc));
    }

    private static String toJson(Discoverer.Result<?> result, Json response) {
        JsonResult jsonResult = new JsonResult(result.networkInterface().getName(), result.localEndpoint(), result.remoteEndpoint(), response);
        return jsonResult.toJson();
    }

    private static JsonDeviceInfo toJson(DeviceDIB device) {
        String mcast = "";
        try {
            mcast = InetAddress.getByAddress(device.getMulticastAddress()).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        boolean progMode = (device.getDeviceStatus() & 1) != 0;
        return new JsonDeviceInfo(device.getName(), device.getAddress(), device.getMACAddressString(), mcast, device.serialNumber(), device.getKNXMediumString(), progMode, device.getInstallation(), device.getProject());
    }

    private static void onDescriptionReceived(Discoverer.Result<DescriptionResponse> result, HPAI hpai) {
        DescriptionResponse dr = (DescriptionResponse)result.response();
        System.out.println(Discover.formatResponse(result, hpai, dr.getDevice(), dr.getServiceFamilies(), dr.getDescription()));
    }

    private static String formatResponse(Discoverer.Result<?> r, HPAI controlEp, DeviceDIB device, ServiceFamiliesDIB serviceFamilies, Collection<DIB> description) {
        StringBuilder sb = new StringBuilder();
        InetAddress addr = r.localEndpoint().getAddress();
        String localEndpoint = addr instanceof Inet6Address ? addr.toString() : addr.getHostAddress() + " (" + Discover.nameOf(r.networkInterface()) + ")";
        sb.append("Using ").append(localEndpoint).append(sep);
        sb.append("-".repeat(sb.length() - 1)).append(sep);
        if (device != null) {
            sb.append("\"").append(device.getName()).append("\" ");
        }
        if (controlEp != null) {
            String endpoint = controlEp.toString();
            if (serviceFamilies != null) {
                boolean tcp;
                boolean bl = tcp = serviceFamilies.families().getOrDefault(ServiceFamiliesDIB.ServiceFamily.Core, 0) > 1;
                if (tcp) {
                    endpoint = endpoint.replace("UDP", "UDP & TCP");
                }
            }
            sb.append("endpoint ").append(endpoint);
        }
        if (device != null) {
            String info = device.toString();
            String withoutName = info.substring(info.indexOf(","));
            boolean search = r.response() instanceof SearchResponse;
            String formatted = search ? withoutName.substring(0, withoutName.lastIndexOf(",")) : withoutName;
            sb.append(formatted).append(sep);
        }
        Object basic = sb.toString().replaceAll(", ", sep);
        if (serviceFamilies != null) {
            basic = (String)basic + "Supported services: " + serviceFamilies;
        }
        StringJoiner joiner = new StringJoiner(sep);
        joiner.add((CharSequence)basic);
        ArrayList<DIB> desc = new ArrayList<DIB>(description);
        desc.remove(device);
        desc.remove(serviceFamilies);
        Discover.extractDib(6, desc).map(dib -> " ".repeat(20) + dib).ifPresent(joiner::add);
        Discover.extractDib(8, desc).map(dib -> dib.toString().replace(", ", sep)).ifPresent(joiner::add);
        Discover.extractDib(7, desc).map(dib -> dib.toString().replaceFirst(", ", sep)).ifPresent(joiner::add);
        desc.forEach(dib -> joiner.add(dib.toString()));
        return joiner.add("").toString();
    }

    private static Optional<DIB> extractDib(int typeCode, Collection<DIB> description) {
        for (DIB dib : description) {
            if (dib.getDescTypeCode() != typeCode) continue;
            description.remove(dib);
            return Optional.of(dib);
        }
        return Optional.empty();
    }

    protected void onCompletion(Exception thrown, boolean canceled) {
        if (canceled) {
            String msg = this.options.containsKey("search") ? "stopped discovery" : "self description canceled";
            out.info(msg);
        }
        if (thrown != null) {
            out.error("completed with error", (Throwable)thrown);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void search() throws KNXException, InterruptedException {
        Srp[] srps = this.searchParameters.toArray(new Srp[0]);
        if (this.tcp != null) {
            CompletionStage result = ((CompletableFuture)this.tcp.search(srps).thenApply(list -> (Discoverer.Result)list.get(0))).thenAccept(this::onEndpointReceived);
            this.joinOnResult((CompletableFuture<Void>)result);
            return;
        }
        if (this.options.containsKey("host")) {
            InetAddress server = (InetAddress)this.options.get("host");
            InetSocketAddress ctrlEndpoint = new InetSocketAddress(server, (int)((Integer)this.options.get("serverport")));
            CompletionStage result = this.d.search(ctrlEndpoint, srps).thenAccept(this::onEndpointReceived);
            this.joinOnResult((CompletableFuture<Void>)result);
            return;
        }
        Duration timeout = (Duration)this.options.get("timeout");
        if (this.options.containsKey("if")) {
            this.d.startSearch(0, (NetworkInterface)this.options.get("if"), (int)timeout.toSeconds(), false);
        } else {
            if (srps.length > 0) {
                try {
                    List results = (List)this.d.search(srps).get();
                    results.forEach(this::onEndpointReceived);
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof KNXException) {
                        throw (KNXException)e.getCause();
                    }
                    throw new KnxRuntimeException("extended search", e.getCause());
                }
                return;
            }
            this.d.startSearch((int)timeout.toSeconds(), false);
        }
        class TimestampedResponse {
            final Instant received = Instant.now();
            final Discoverer.Result<SearchResponse> result;
            boolean shown;

            TimestampedResponse(Discoverer.Result<SearchResponse> response) {
                this.result = response;
            }
        }
        HashMap<InetSocketAddress, TimestampedResponse> responses = new HashMap<InetSocketAddress, TimestampedResponse>();
        int processed = 0;
        try {
            while (this.d.isSearching()) {
                List res = this.d.getSearchResponses();
                while (processed < res.size()) {
                    Discoverer.Result result = (Discoverer.Result)res.get(processed);
                    TimestampedResponse timestampedResponse = new TimestampedResponse((Discoverer.Result<SearchResponse>)result);
                    if (((SearchResponse)result.response()).v2()) {
                        responses.put(result.remoteEndpoint(), timestampedResponse);
                        this.onEndpointReceived(timestampedResponse.result);
                        timestampedResponse.shown = true;
                    } else {
                        responses.putIfAbsent(result.remoteEndpoint(), timestampedResponse);
                    }
                    ++processed;
                }
                Duration waitForV2Response = Duration.ofMillis(200L);
                Instant notificationThreshold = Instant.now().minus(waitForV2Response);
                for (TimestampedResponse timestampedResponse : responses.values()) {
                    Discoverer.Result<SearchResponse> result = timestampedResponse.result;
                    if (timestampedResponse.shown || ((SearchResponse)result.response()).v2() || Duration.between(timestampedResponse.received, notificationThreshold).isNegative()) continue;
                    this.onEndpointReceived(result);
                    timestampedResponse.shown = true;
                }
                Thread.sleep(50L);
            }
        }
        finally {
            if (processed == 0) {
                out.info("search stopped after {} seconds with 0 responses", (Object)timeout.toSeconds());
            }
        }
    }

    private void joinOnResult(CompletableFuture<Void> result) throws KNXException {
        block3: {
            try {
                result.join();
            }
            catch (CompletionException e) {
                InetAddress server = (InetAddress)this.options.get("host");
                InetSocketAddress ctrlEndpoint = new InetSocketAddress(server, (int)((Integer)this.options.get("serverport")));
                if (TimeoutException.class.isAssignableFrom(e.getCause().getClass())) {
                    throw new KNXTimeoutException("timeout waiting for response from " + ctrlEndpoint);
                }
                if (!(e.getCause() instanceof KNXException)) break block3;
                throw (KNXException)e.getCause();
            }
        }
    }

    private void description() throws KNXException, InterruptedException {
        if (this.tcp != null) {
            Discoverer.Result res = this.tcp.description();
            this.onDescriptionReceived((Discoverer.Result<DescriptionResponse>)res);
            return;
        }
        InetSocketAddress host = new InetSocketAddress((InetAddress)this.options.get("host"), (int)((Integer)this.options.get("serverport")));
        Duration timeout = (Duration)this.options.get("timeout");
        Discoverer.Result res = this.d.getDescription(host, (int)timeout.toSeconds());
        this.onDescriptionReceived((Discoverer.Result<DescriptionResponse>)res);
    }

    private void searchWithDescription() throws KNXException, InterruptedException {
        List res;
        Duration timeout = (Duration)this.options.get("timeout");
        if (this.options.containsKey("if")) {
            if (this.tcp != null) {
                try {
                    res = (List)this.tcp.search((Srp[])this.searchParameters.toArray(Srp[]::new)).get();
                }
                catch (ExecutionException e) {
                    if (e.getCause() instanceof KNXException) {
                        throw (KNXException)e.getCause();
                    }
                    throw new KnxRuntimeException("waiting for search response", (Throwable)e);
                }
            } else {
                this.d.startSearch(0, (NetworkInterface)this.options.get("if"), (int)timeout.toSeconds(), true);
                res = this.d.getSearchResponses();
            }
        } else {
            try {
                res = (List)this.d.search((Srp[])this.searchParameters.toArray(Srp[]::new)).get();
            }
            catch (ExecutionException e) {
                if (e.getCause() instanceof KNXException) {
                    throw (KNXException)e.getCause();
                }
                throw new KnxRuntimeException("waiting for search response", (Throwable)e);
            }
        }
        new HashSet(res).parallelStream().forEach(this::description);
    }

    private void description(Discoverer.Result<SearchResponse> r) {
        SearchResponse sr = (SearchResponse)r.response();
        HPAI hpai = sr.getControlEndpoint();
        InetSocketAddress server = hpai.nat() ? r.remoteEndpoint() : hpai.endpoint();
        try {
            if (this.tcp != null) {
                try {
                    Discoverer.Result description = this.tcp.description();
                    Discover.onDescriptionReceived((Discoverer.Result<DescriptionResponse>)description, new HPAI(hpai.hostProtocol(), server));
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
                return;
            }
            Discoverer discoverer = this.reuseForDescription ? this.d : new Discoverer(r.localEndpoint().getAddress(), 0, this.options.containsKey("nat"), false);
            int timeout = 2;
            Discoverer.Result dr = discoverer.getDescription(server, 2);
            Discover.onDescriptionReceived((Discoverer.Result<DescriptionResponse>)dr, new HPAI(hpai.hostProtocol(), server));
        }
        catch (KNXException e) {
            System.out.println("description failed for server " + server + " using " + r.localEndpoint().getAddress() + " at " + r.networkInterface().getName() + ": " + e.getMessage());
        }
    }

    private void parseOptions(String[] args) {
        this.options.put("localport", 0);
        this.options.put("serverport", 3671);
        this.options.put("timeout", Duration.ofSeconds(3L));
        this.options.put("mcastResponse", true);
        if (args.length == 0) {
            return;
        }
        Iterator<String> i = List.of(args).iterator();
        while (i.hasNext()) {
            String arg = i.next();
            if (Main.isOption(arg, "help", "h")) {
                this.options.put("help", null);
                return;
            }
            if (Main.isOption(arg, "version", null)) {
                this.options.put("version", null);
                return;
            }
            if (Main.parseSecureOption(arg, i, this.options)) {
                if (!this.options.containsKey("group-key")) continue;
                throw new KNXIllegalArgumentException("secure multicast is not specified for search & description");
            }
            if (Main.isOption(arg, "localport", null)) {
                this.options.put("localport", Integer.decode(i.next()));
                continue;
            }
            if (Main.isOption(arg, "nat", "n")) {
                this.options.put("nat", null);
                continue;
            }
            if (Main.isOption(arg, "netif", "i")) {
                this.options.put("if", Discover.getNetworkIF(i.next()));
                continue;
            }
            if (Main.isOption(arg, "timeout", "t")) {
                Duration timeout = Duration.ofSeconds(Long.parseLong(i.next()));
                if (timeout.toMillis() <= 0L) continue;
                this.options.put("timeout", timeout);
                continue;
            }
            if (Main.isOption(arg, "tcp", null)) {
                this.options.put("tcp", null);
                continue;
            }
            if (Main.isOption(arg, "udp", null)) {
                this.options.put("udp", null);
                continue;
            }
            if ("search".equals(arg)) {
                this.options.put("search", null);
                continue;
            }
            if (Main.isOption(arg, "unicast", "u")) {
                this.options.put("mcastResponse", Boolean.FALSE);
                continue;
            }
            if (Main.isOption(arg, "withDescription", null)) {
                this.options.put("withDescription", Boolean.FALSE);
                continue;
            }
            if (arg.equals("sd")) {
                this.options.put("search", null);
                this.options.put("withDescription", null);
                continue;
            }
            if (Main.isOption(arg, "progmode", null)) {
                this.searchParameters.add(Srp.withProgrammingMode());
                continue;
            }
            if (Main.isOption(arg, "mac", null)) {
                this.searchParameters.add(Srp.withMacAddress((byte[])DataUnitBuilder.fromHex((String)i.next().replaceAll(":", ""))));
                continue;
            }
            if ("describe".equals(arg)) {
                if (!i.hasNext()) {
                    throw new KNXIllegalArgumentException("specify remote host");
                }
                this.options.put("describe", null);
                continue;
            }
            if (Main.isOption(arg, "serverport", "p")) {
                this.options.put("serverport", Integer.decode(i.next()));
                continue;
            }
            if (Main.isOption(arg, "json", null)) {
                this.options.put("json", null);
                continue;
            }
            if (this.options.containsKey("search") || this.options.containsKey("describe")) {
                this.options.put("host", Main.parseHost(arg));
                continue;
            }
            throw new KNXIllegalArgumentException("unknown option " + arg);
        }
        if (this.options.containsKey("describe") && !this.options.containsKey("host")) {
            throw new KNXIllegalArgumentException("specify remote host");
        }
    }

    private static String nameOf(NetworkInterface nif) {
        if (nif == null) {
            return "default";
        }
        String name = nif.getName();
        String friendly = nif.getDisplayName();
        if (friendly != null && !name.equals(friendly)) {
            return name + " (" + friendly + ")";
        }
        return name;
    }

    private InetAddress inetAddress(NetworkInterface nif) {
        if (this.options.containsKey("nat")) {
            return nif.getInetAddresses().nextElement();
        }
        return nif.inetAddresses().filter(Inet4Address.class::isInstance).findAny().orElseThrow(() -> new KNXIllegalArgumentException("no IPv4 address bound to interface " + nif.getName()));
    }

    private static NetworkInterface getNetworkIF(String id) {
        try {
            NetworkInterface nif = NetworkInterface.getByName(id);
            if (nif != null) {
                return nif;
            }
            nif = NetworkInterface.getByInetAddress(InetAddress.getByName(id));
            if (nif != null) {
                return nif;
            }
            throw new KNXIllegalArgumentException("no network interface associated with " + id);
        }
        catch (IOException e) {
            throw new KNXIllegalArgumentException("error getting network interface, " + e.getMessage(), (Throwable)e);
        }
    }

    private static void showUsage() {
        String usage = "Usage: %s {search | describe} [options]\nSupported commands:\n  search [<host>]            start a discovery search\n    --withDescription        query self description for each search result\n    --unicast -u             request unicast response (where multicast would be used)\n    --netif -i <interface/host name | IP address>    local multicast network interface\n    --mac <address>          extended search requesting the specified MAC address\n    --progmode               extended search requesting devices in programming mode\n  describe <host>            query self description from host\n    --netif -i <interface/host name | IP address>    local outgoing network interface\n    --serverport -p <number> server UDP/TCP port (default %d)\n  sd                         shortcut for 'search --withDescription'\nOther options:\n  --localport <number>       local UDP/TCP port (default system assigned)\n  --nat -n                   enable Network Address Translation\n  --timeout -t               discovery/description response timeout in seconds\n  --tcp                      request TCP communication\n  --udp                      request UDP communication\n  --version                  show tool/library version and exit\n  --help -h                  show this help message".formatted(tool, 3671);
        Discover.out(usage + "\n" + Main.printSecureOptions(false));
    }

    private static void out(String s) {
        System.out.println(s);
    }

    private record JsonDescriptionResponse(JsonDeviceInfo device, Map<ServiceFamiliesDIB.ServiceFamily, Integer> svcFamilies, Collection<DIB> dibs) implements Json
    {
        JsonDescriptionResponse {
            dibs = dibs.stream().filter(dib -> dib.getDescTypeCode() != 1 && dib.getDescTypeCode() != 2).toList();
        }
    }

    private record JsonDeviceInfo(String name, IndividualAddress address, String macAddress, String multicast, SerialNumber sn, String knxMedium, boolean programmingMode, int installationId, int projectId) implements Json
    {
    }

    private record JsonResult(String netif, InetSocketAddress localEndpoint, InetSocketAddress remoteEndpoint, Json response) implements Json
    {
    }
}

