/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.tools;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.KNXRemoteException;
import tuwien.auto.calimero.link.KNXNetworkLink;
import tuwien.auto.calimero.link.medium.TPSettings;
import tuwien.auto.calimero.log.LogService;
import tuwien.auto.calimero.mgmt.PropertyAdapter;
import tuwien.auto.calimero.mgmt.PropertyClient;
import tuwien.auto.calimero.mgmt.RemotePropertyServiceAdapter;
import tuwien.auto.calimero.tools.Json;
import tuwien.auto.calimero.tools.Main;

public class IPConfig
implements Runnable {
    private static final String tool = "IPConfig";
    private static final String sep = System.lineSeparator();
    private static final int IPObjType = 11;
    private static Logger out = LogService.getLogger((String)"calimero.tools");
    private KNXNetworkLink lnk;
    private PropertyClient pc;
    private int objIndex = -1;
    private final Map<String, Object> options = new HashMap<String, Object>();

    protected IPConfig(String[] args) {
        try {
            this.parseOptions(args);
        }
        catch (KNXIllegalArgumentException e) {
            throw e;
        }
        catch (NoSuchElementException e) {
            throw new KNXIllegalArgumentException("no more options in argument list", (Throwable)e);
        }
        catch (RuntimeException e) {
            throw new KNXIllegalArgumentException(e.getMessage(), (Throwable)e);
        }
    }

    public static void main(String ... args) {
        try {
            new IPConfig(args).run();
        }
        catch (Throwable t) {
            out.error("IP config", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        KNXException thrown = null;
        boolean canceled = false;
        try {
            if (this.options.isEmpty()) {
                IPConfig.out("IPConfig - KNXnet/IP address configuration");
                Main.showVersion();
                IPConfig.out("Type --help for help message");
                return;
            }
            if (this.options.containsKey("about")) {
                ((Runnable)this.options.get("about")).run();
                return;
            }
            PropertyAdapter adapter = this.createAdapter();
            this.pc = new PropertyClient(adapter);
            this.pc.scanProperties(false, d -> {
                if (d.objectType() == 11) {
                    this.objIndex = d.objectIndex();
                }
            });
            if (this.objIndex == -1) {
                out.error(PropertyClient.getObjectTypeName((int)11) + " not found");
                return;
            }
            this.setIPAssignment();
            this.setIP(60, "ip");
            this.setIP(61, "subnet");
            this.setIP(62, "gateway");
            this.setIP(66, "multicast");
            ArrayList<String[]> config = new ArrayList<String[]>();
            try {
                this.readConfig(config);
            }
            finally {
                this.onConfigurationReceived(config);
            }
        }
        catch (KNXException e) {
            thrown = e;
        }
        catch (InterruptedException e) {
            canceled = true;
            Thread.currentThread().interrupt();
        }
        finally {
            if (this.pc != null) {
                this.pc.close();
            }
            if (this.lnk != null) {
                this.lnk.close();
            }
            this.onCompletion((Exception)((Object)thrown), canceled);
        }
    }

    protected void onConfigurationReceived(List<String[]> config) {
        if (this.options.containsKey("json")) {
            System.out.println(this.toJson(config));
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append("KNX IP device ").append(config.get(0)[2]).append(" ").append(config.get(1)[2]).append(sep);
        String padding = "                                   ";
        for (int i = 2; i < config.size(); ++i) {
            String[] s = config.get(i);
            String value = s[2].isEmpty() ? "n/a" : s[2];
            sb.append(s[1]).append("                                   ".substring(s[1].length())).append(value).append(sep);
        }
        System.out.println(sb);
    }

    protected void onCompletion(Exception thrown, boolean canceled) {
        if (canceled) {
            out.info("configuration canceled");
        }
        if (thrown != null) {
            out.error("completed with error", (Throwable)thrown);
        }
    }

    private String toJson(List<String[]> config) {
        Object device = this.options.containsKey("remote") ? this.options.get("remote") : this.options.get("host");
        Map<String, String> map = config.stream().collect(Collectors.toMap(sa -> sa[1], sa -> sa[2]));
        record JsonIpConfig(String device, Map<String, String> ipConfig) implements Json
        {
        }
        JsonIpConfig jsonIpConfig = new JsonIpConfig(device.toString(), map);
        return jsonIpConfig.toJson();
    }

    private void setIPAssignment() throws KNXException, InterruptedException {
        int assignment = 0;
        if (this.options.containsKey("manual")) {
            assignment |= 1;
        }
        if (this.options.containsKey("bootp")) {
            assignment |= 2;
        }
        if (this.options.containsKey("dhcp")) {
            assignment |= 4;
        }
        if (this.options.containsKey("auto")) {
            assignment |= 8;
        }
        if (assignment != 0) {
            this.pc.setProperty(this.objIndex, 55, 1, 1, new byte[]{(byte)assignment});
        }
    }

    private void setIP(int pid, String key) throws InterruptedException {
        if (this.options.containsKey(key)) {
            try {
                this.pc.setProperty(this.objIndex, pid, 1, 1, ((InetAddress)this.options.get(key)).getAddress());
            }
            catch (KNXException e) {
                out.error("setting " + key + " failed, " + e.getMessage());
            }
        }
    }

    private void readConfig(List<String[]> config) throws KNXException, InterruptedException {
        int pid = 52;
        byte[] data = this.query(pid);
        if (data != null) {
            IPConfig.add(config, pid, "KNXnet/IP server", new IndividualAddress(data).toString());
        }
        IPConfig.add(config, 76, "Name", this.queryFriendlyName());
        pid = 56;
        data = this.query(pid);
        if (data != null) {
            IPConfig.add(config, pid, "Supported IP assignment methods", IPConfig.getIPAssignment(new byte[]{(byte)(data[0] << 1 | 1)}));
        }
        if ((data = this.query(pid = 55)) != null) {
            IPConfig.add(config, pid, "Enabled IP assignment methods", IPConfig.getIPAssignment(data));
        }
        if ((data = this.query(pid = 54)) != null) {
            IPConfig.add(config, pid, "Current IP assignment method", IPConfig.getIPAssignment(data));
        }
        if ((data = this.query(pid = 70)) != null) {
            IPConfig.add(config, pid, "Routing capabilities", IPConfig.getRoutingCaps(data));
        }
        this.addIP(config, 60, "Configured IP address");
        this.addIP(config, 61, "Configured subnet mask");
        this.addIP(config, 57, "Current IP address");
        this.addIP(config, 58, "Current subnet mask");
        this.addIP(config, 62, "Configured default gateway");
        this.addIP(config, 59, "Current default gateway");
        this.addIP(config, 63, "DHCP/BootP server");
        this.addIP(config, 66, "Routing multicast");
    }

    private void addIP(List<String[]> config, int pid, String name) throws InterruptedException {
        IPConfig.add(config, pid, name, this.queryIP(pid));
    }

    private static void add(List<String[]> config, int pid, String name, String value) {
        config.add(new String[]{Integer.toString(pid), name, value});
    }

    private String queryFriendlyName() throws KNXException, InterruptedException {
        byte[] data;
        char[] name = new char[30];
        int start = 0;
        do {
            data = this.pc.getProperty(this.objIndex, 76, start + 1, 10);
            int i = 0;
            while (i < 10 && data[i] != 0) {
                name[start] = (char)(data[i] & 0xFF);
                ++i;
                ++start;
            }
        } while (start < 30 && data[9] != 0);
        return new String(name, 0, start);
    }

    private byte[] query(int pid) throws KNXException, InterruptedException {
        try {
            return this.pc.getProperty(this.objIndex, pid, 1, 1);
        }
        catch (KNXRemoteException e) {
            out.error("getting property with ID " + pid + " failed: {}", (Object)e.getMessage());
            return null;
        }
    }

    private String queryIP(int pid) throws InterruptedException {
        try {
            byte[] data = this.query(pid);
            return data == null ? "" : InetAddress.getByAddress(data).getHostAddress();
        }
        catch (UnknownHostException | KNXException throwable) {
            return "-";
        }
    }

    private static String getIPAssignment(byte[] value) {
        int bitset = value[0] & 0xFF;
        Object s = "";
        String div = ", ";
        if ((bitset & 1) != 0) {
            s = "manual";
        }
        if ((bitset & 2) != 0) {
            s = (String)s + (((String)s).isEmpty() ? "" : ", ") + "Bootstrap Protocol";
        }
        if ((bitset & 4) != 0) {
            s = (String)s + (((String)s).isEmpty() ? "" : ", ") + "DHCP";
        }
        if ((bitset & 8) != 0) {
            s = (String)s + (((String)s).isEmpty() ? "" : ", ") + "Auto IP";
        }
        return s;
    }

    private static String getRoutingCaps(byte[] value) {
        int bitset = value[0] & 0xFF;
        StringJoiner caps = new StringJoiner(", ");
        if ((bitset & 1) != 0) {
            caps.add("queue overflow statistics");
        }
        if ((bitset & 2) != 0) {
            caps.add("transmitted telegrams statistics");
        }
        if ((bitset & 4) != 0) {
            caps.add("priority/FIFO");
        }
        if ((bitset & 8) != 0) {
            caps.add("multiple KNX installations");
        }
        if ((bitset & 0x10) != 0) {
            caps.add("group address mapping");
        }
        return caps.toString();
    }

    private PropertyAdapter createAdapter() throws KNXException, InterruptedException {
        if (this.options.containsKey("localDM")) {
            return this.createLocalDMAdapter();
        }
        return this.createRemoteAdapter();
    }

    private PropertyAdapter createLocalDMAdapter() throws KNXException, InterruptedException {
        return Main.newLocalDeviceMgmtIP(this.options, closed -> {});
    }

    private PropertyAdapter createRemoteAdapter() throws KNXException, InterruptedException {
        this.lnk = Main.newLink(this.options);
        IndividualAddress remote = (IndividualAddress)this.options.get("remote");
        byte[] authKey = (byte[])this.options.get("authorize");
        if (authKey != null) {
            return new RemotePropertyServiceAdapter(this.lnk, remote, close -> {}, authKey);
        }
        return new RemotePropertyServiceAdapter(this.lnk, remote, close -> {}, this.options.containsKey("connect"));
    }

    private void parseOptions(String[] args) {
        ArrayList<String> l = new ArrayList<String>(Arrays.asList(args));
        l.removeAll(List.of(""));
        if (l.isEmpty()) {
            return;
        }
        this.options.put("port", 3671);
        this.options.put("medium", new TPSettings());
        Iterator<String> i = l.iterator();
        while (i.hasNext()) {
            String arg = (String)i.next();
            if (Main.isOption(arg, "help", "h")) {
                this.options.put("about", IPConfig::showUsage);
                return;
            }
            if (Main.parseCommonOption(arg, i, this.options) || Main.parseSecureOption(arg, i, this.options)) continue;
            if (Main.isOption(arg, "local", "l")) {
                this.options.put("localDM", null);
                continue;
            }
            if (Main.isOption(arg, "remote", "r")) {
                this.options.put("remote", Main.getAddress(i.next()));
                continue;
            }
            if (Main.isOption(arg, "knx-address", "k")) {
                this.options.put("knx-address", Main.getAddress(i.next()));
                continue;
            }
            if (Main.isOption(arg, "connect", "c")) {
                this.options.put("connect", null);
                continue;
            }
            if (Main.isOption(arg, "authorize", "a")) {
                this.options.put("authorize", IPConfig.getAuthorizeKey(i.next()));
                continue;
            }
            if (arg.equalsIgnoreCase("manual")) {
                this.options.put("manual", null);
                continue;
            }
            if (arg.equalsIgnoreCase("bootp")) {
                this.options.put("bootp", null);
                continue;
            }
            if (arg.equalsIgnoreCase("dhcp")) {
                this.options.put("dhcp", null);
                continue;
            }
            if (arg.equalsIgnoreCase("auto")) {
                this.options.put("auto", null);
                continue;
            }
            if (arg.equalsIgnoreCase("ip")) {
                IPConfig.parseIP(i.next(), "ip", this.options);
                continue;
            }
            if (arg.equalsIgnoreCase("subnet")) {
                IPConfig.parseIP(i.next(), "subnet", this.options);
                continue;
            }
            if (arg.equalsIgnoreCase("gateway")) {
                IPConfig.parseIP(i.next(), "gateway", this.options);
                continue;
            }
            if (arg.equalsIgnoreCase("multicast")) {
                IPConfig.parseIP(i.next(), "multicast", this.options);
                continue;
            }
            if (!this.options.containsKey("host")) {
                this.options.put("host", arg);
                continue;
            }
            throw new KNXIllegalArgumentException("unknown option \"" + arg + "\"");
        }
        if (!this.options.containsKey("remote")) {
            this.options.put("localDM", null);
        }
        if (this.options.containsKey("usb") && !this.options.containsKey("host")) {
            this.options.put("host", "");
        }
        if (!this.options.containsKey("localDM") && !this.options.containsKey("remote")) {
            throw new KNXIllegalArgumentException("no connection category specified");
        }
        if (!this.options.containsKey("host") && !this.options.containsKey("ft12")) {
            throw new KNXIllegalArgumentException("no host or serial port specified");
        }
        if (this.options.containsKey("ft12") && !this.options.containsKey("remote")) {
            throw new KNXIllegalArgumentException("--remote option is mandatory with --ft12");
        }
        Main.setDomainAddress(this.options);
    }

    private static void showUsage() {
        StringJoiner joiner = new StringJoiner(sep);
        joiner.add("Usage: IPConfig [options] <host|port>");
        joiner.add(Main.printCommonOptions());
        joiner.add("  --local -l                 local device management (default)");
        joiner.add("  --remote -r <KNX addr>     remote property service");
        joiner.add("Options for remote property services only:");
        joiner.add("  --connect -c               connection oriented mode");
        joiner.add("  --authorize -a <key>       authorize key to access KNX device");
        joiner.add(Main.printSecureOptions());
        joiner.add("Commands to change the IP configuration:");
        joiner.add("  ip <address>               set the configured fixed IP address");
        joiner.add("  subnet <address>           set the configured IP subnet mask");
        joiner.add("  gateway <address>          set the configured IP address of the default gateway");
        joiner.add("  multicast <address>        set the routing multicast address");
        joiner.add("  manual                     enable manual IP assignment for current IP address");
        joiner.add("  bootp                      enable Bootstrap Protocol IP assignment for current IP address");
        joiner.add("  dhcp                       enable DHCP IP assignment for current IP address");
        joiner.add("  auto                       enable automatic IP (AutoIP) assignment for current IP address").add("                                             (address range 169.254.1.0 to 169.254.254.255)");
        IPConfig.out(joiner.toString());
    }

    private static void out(String s) {
        System.out.println(s);
    }

    private static byte[] getAuthorizeKey(String key) {
        long value = Long.decode(key);
        if (value < 0L || value > 0xFFFFFFFFL) {
            throw new KNXIllegalArgumentException("invalid authorize key");
        }
        return new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
    }

    private static void parseIP(String address, String key, Map<String, Object> options) {
        try {
            options.put(key, InetAddress.getByName(address));
        }
        catch (UnknownHostException e) {
            throw new KNXIllegalArgumentException("failed to read IP " + address, (Throwable)e);
        }
    }
}

