/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.tools;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.RecordComponent;
import java.util.Arrays;
import java.util.Collection;
import java.util.HexFormat;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import tuwien.auto.calimero.KnxRuntimeException;

interface Json {
    public static final int Indent = 2;
    public static final String Eol = "\n";

    default public String toJson() {
        return this.toJson(new StringBuilder(), 0).toString();
    }

    private StringBuilder toJson(StringBuilder sb, int indent) {
        return Json.iterate(Arrays.asList(this.getClass().getRecordComponents()), "{", "}", "", "", RecordComponent::getName, this::recordValue, sb, indent);
    }

    private Object recordValue(RecordComponent rc) {
        try {
            return rc.getAccessor().invoke((Object)this, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            return new KnxRuntimeException("enumerating values of " + this.getClass().getSimpleName(), (Throwable)e);
        }
    }

    private static <T> void toJsonArray(Iterable<? extends T> elems, String elemOpener, String elemCloser, Function<T, String> key, Function<T, Object> value, StringBuilder sb, int indent) {
        Json.iterate(elems, "[", "]", elemOpener, elemCloser, key, value, sb, indent);
    }

    private static <T> StringBuilder iterate(Iterable<? extends T> elems, String opener, String closer, String elemOpener, String elemCloser, Function<T, String> key, Function<T, Object> value, StringBuilder sb, int indent) {
        sb.append(opener);
        String delim = "";
        for (T e : elems) {
            sb.append(delim).append(Eol).append(" ".repeat(indent + 2)).append(elemOpener);
            Json.addKeyValue(key.apply(e), value.apply(e), sb, indent + 2);
            sb.append(elemCloser);
            delim = ",";
        }
        return sb.append(Eol).append(" ".repeat(indent)).append(closer);
    }

    private static void addKeyValue(String key, Object value, StringBuilder sb, int indent) {
        if (!key.isEmpty()) {
            sb.append("\"").append(key).append("\": ");
        }
        if (value == null) {
            sb.append("null");
        } else if (value instanceof Json) {
            Json json = (Json)value;
            json.toJson(sb, indent);
        } else if (value instanceof Number || value instanceof Boolean) {
            sb.append(value);
        } else if (value instanceof Collection) {
            Collection c = (Collection)value;
            Json.toJsonArray(c, "", "", o -> "", Function.identity(), sb, indent);
        } else if (value instanceof Object[]) {
            Object[] oa = (Object[])value;
            Json.toJsonArray(List.of(oa), "", "", o -> "", Function.identity(), sb, indent);
        } else if (value instanceof Map) {
            Map m = (Map)value;
            Json.toJsonArray(m.entrySet(), "{ ", " }", e -> e.getKey().toString(), Map.Entry::getValue, sb, indent);
        } else if (value instanceof byte[]) {
            byte[] ba = (byte[])value;
            sb.append("\"").append(HexFormat.of().formatHex(ba)).append("\"");
        } else {
            sb.append("\"").append(Json.escape(value.toString())).append("\"");
        }
    }

    private static String escape(String value) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < value.length(); ++i) {
            char c = value.charAt(i);
            sb.append(switch (c) {
                case '\"' -> "\\\"";
                case '\\' -> "\\\\";
                case '/' -> "\\/";
                case '\b' -> "\\b";
                case '\f' -> "\\f";
                case '\n' -> "\\n";
                case '\r' -> "\\r";
                case '\t' -> "\\t";
                default -> c <= '\u001f' ? String.format("\\u%04x", c) : Character.valueOf(c);
            });
        }
        return sb.toString();
    }
}

