/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UncheckedIOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.time.Duration;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HexFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.LoggerFactory;
import tuwien.auto.calimero.CloseEvent;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.KnxRuntimeException;
import tuwien.auto.calimero.Settings;
import tuwien.auto.calimero.knxnetip.SecureConnection;
import tuwien.auto.calimero.knxnetip.TcpConnection;
import tuwien.auto.calimero.link.Connector;
import tuwien.auto.calimero.link.KNXNetworkLink;
import tuwien.auto.calimero.link.KNXNetworkLinkFT12;
import tuwien.auto.calimero.link.KNXNetworkLinkIP;
import tuwien.auto.calimero.link.KNXNetworkLinkTpuart;
import tuwien.auto.calimero.link.KNXNetworkLinkUsb;
import tuwien.auto.calimero.link.LinkEvent;
import tuwien.auto.calimero.link.NetworkLinkListener;
import tuwien.auto.calimero.link.medium.KNXMediumSettings;
import tuwien.auto.calimero.link.medium.PLSettings;
import tuwien.auto.calimero.link.medium.RFSettings;
import tuwien.auto.calimero.mgmt.LocalDeviceManagementIp;
import tuwien.auto.calimero.secure.Keyring;
import tuwien.auto.calimero.secure.Security;
import tuwien.auto.calimero.serial.ConnectionStatus;
import tuwien.auto.calimero.tools.BaosClient;
import tuwien.auto.calimero.tools.DatapointImporter;
import tuwien.auto.calimero.tools.DeviceInfo;
import tuwien.auto.calimero.tools.Discover;
import tuwien.auto.calimero.tools.IPConfig;
import tuwien.auto.calimero.tools.Memory;
import tuwien.auto.calimero.tools.NetworkMonitor;
import tuwien.auto.calimero.tools.ProcComm;
import tuwien.auto.calimero.tools.ProgMode;
import tuwien.auto.calimero.tools.PropClient;
import tuwien.auto.calimero.tools.Property;
import tuwien.auto.calimero.tools.Restart;
import tuwien.auto.calimero.tools.ScanDevices;
import tuwien.auto.calimero.tools.TrafficMonitor;

final class Main {
    private static final String[][] cmds = new String[][]{{"discover", "Discover KNXnet/IP devices", "search"}, {"describe", "KNXnet/IP device self-description", "describe"}, {"scan", "Determine the existing KNX devices on a KNX subnetwork"}, {"ipconfig", "KNXnet/IP device address configuration"}, {"monitor", "Open network monitor (passive) for KNX network traffic"}, {"read", "Read a value using KNX process communication", "read"}, {"write", "Write a value using KNX process communication", "write"}, {"groupmon", "Open group monitor for KNX process communication", "monitor"}, {"trafficmon", "KNX link-layer traffic & link status monitor"}, {"get", "Read a KNX property", "get"}, {"set", "Write a KNX property", "set"}, {"properties", "Open KNX property client"}, {"info", "Send an LTE info command", "info"}, {"baos", "Communicate with a KNX BAOS device"}, {"devinfo", "Read KNX device information"}, {"mem", "Access KNX device memory"}, {"progmode", "Check/set device(s) in programming mode"}, {"restart", "Restart a KNX interface/device"}, {"import", "Import datapoints from a KNX project (.knxproj) or group addresses file (.xml|.csv)"}};
    private static final List<Class<? extends Runnable>> tools = Arrays.asList(Discover.class, Discover.class, ScanDevices.class, IPConfig.class, NetworkMonitor.class, ProcComm.class, ProcComm.class, ProcComm.class, TrafficMonitor.class, Property.class, Property.class, PropClient.class, ProcComm.class, BaosClient.class, DeviceInfo.class, Memory.class, ProgMode.class, Restart.class, DatapointImporter.class);
    private static final Map<InetSocketAddress, TcpConnection> tcpConnectionPool = new HashMap<InetSocketAddress, TcpConnection>();
    private static boolean registeredTcpShutdownHook;
    private static final Map<Integer, String> manufacturer;
    private static Keyring toolKeyring;

    static synchronized TcpConnection tcpConnection(InetSocketAddress local, InetSocketAddress server) {
        TcpConnection connection;
        if (!registeredTcpShutdownHook) {
            Runtime.getRuntime().addShutdownHook(new Thread(Main::closeTcpConnections));
            registeredTcpShutdownHook = true;
        }
        if ((connection = tcpConnectionPool.get(server)) == null || !connection.isConnected()) {
            connection = local.getAddress().isAnyLocalAddress() && local.getPort() == 0 ? TcpConnection.newTcpConnection((InetSocketAddress)server) : TcpConnection.newTcpConnection((InetSocketAddress)local, (InetSocketAddress)server);
            tcpConnectionPool.put(server, connection);
        }
        return connection;
    }

    private static void closeTcpConnections() {
        TcpConnection[] connections;
        for (TcpConnection c : connections = (TcpConnection[])tcpConnectionPool.values().toArray(TcpConnection[]::new)) {
            c.close();
        }
    }

    private Main() {
    }

    public static void main(String ... args) {
        boolean help;
        if (args.length == 1 && (args[0].equals("-v") || args[0].equals("--version"))) {
            System.out.println(Settings.getLibraryHeader((boolean)false));
            return;
        }
        boolean bl = help = args.length >= 1 && (args[0].equals("--help") || args[0].equals("-h"));
        if (args.length == 0 || help) {
            Main.usage();
            return;
        }
        int cmdIdx = 0;
        if (args[0].startsWith("-v")) {
            String vs = args[0];
            String level = vs.startsWith("-vvv") ? "trace" : (vs.startsWith("-vv") ? "debug" : "info");
            System.setProperty("org.slf4j.simpleLogger.defaultLogLevel", level);
            ++cmdIdx;
        }
        String cmd = args[cmdIdx];
        for (int i = 0; i < cmds.length; ++i) {
            if (!cmds[i][0].equals(cmd)) continue;
            try {
                String[] toolargs;
                Method m = tools.get(i).getMethod("main", String[].class);
                if (args.length > 1 && (args[1].equals("--help") || args[1].equals("-h"))) {
                    toolargs = new String[]{"-h"};
                } else {
                    int defaultArgsStart = 2;
                    int defaultArgs = cmds[i].length - 2;
                    int startArgs = cmdIdx + 1;
                    int userArgs = args.length - startArgs;
                    toolargs = Arrays.copyOfRange(cmds[i], 2, 2 + defaultArgs + userArgs);
                    System.arraycopy(args, startArgs, toolargs, defaultArgs, userArgs);
                }
                m.invoke(null, new Object[]{toolargs});
            }
            catch (Exception e) {
                System.err.print("internal error initializing tool \"" + cmd + "\": ");
                if (e instanceof InvocationTargetException) {
                    e.getCause().printStackTrace();
                }
                e.printStackTrace();
            }
            return;
        }
        System.out.println("unknown command \"" + cmd + "\"");
    }

    private static void usage() {
        StringBuilder sb = new StringBuilder();
        String sep = System.lineSeparator();
        sb.append("Supported commands (always safe without further options, use -h for help):").append(sep);
        for (String[] cmd : cmds) {
            sb.append(cmd[0]).append(" - ").append(cmd[1]).append(sep);
        }
        System.out.println(sb);
    }

    static void showVersion() {
        System.out.println(Settings.getLibraryHeader((boolean)false));
    }

    static String manufacturer(int id) {
        return manufacturer.getOrDefault(id, "Unknown");
    }

    static InetSocketAddress createLocalSocket(Map<String, Object> options) {
        return Main.createLocalSocket((InetAddress)options.get("localhost"), (Integer)options.get("localport"));
    }

    static InetSocketAddress createLocalSocket(InetAddress host, Integer port) {
        int p = port != null ? port : 0;
        return host != null ? new InetSocketAddress(host, p) : new InetSocketAddress(p);
    }

    static InetAddress parseHost(String host) {
        try {
            return InetAddress.getByName(host);
        }
        catch (UnknownHostException e) {
            throw new KNXIllegalArgumentException("failed to read IP host " + host, (Throwable)e);
        }
    }

    static KNXMediumSettings getMedium(String id) {
        int medium = KNXMediumSettings.getMedium((String)id);
        return KNXMediumSettings.create((int)medium, (IndividualAddress)KNXMediumSettings.BackboneRouter);
    }

    static IndividualAddress getAddress(String address) {
        try {
            return new IndividualAddress(address);
        }
        catch (KNXFormatException e) {
            throw new KNXIllegalArgumentException("KNX device address", (Throwable)e);
        }
    }

    static boolean isOption(String arg, String longOpt, String shortOpt) {
        boolean so;
        boolean lo = arg.startsWith("--") && arg.regionMatches(2, longOpt, 0, arg.length() - 2);
        boolean bl = so = shortOpt != null && arg.startsWith("-") && arg.regionMatches(1, shortOpt, 0, arg.length() - 1);
        if (arg.equals("-" + longOpt)) {
            throw new KNXIllegalArgumentException("use --" + longOpt);
        }
        return lo || so;
    }

    static void setDomainAddress(Map<String, Object> options) {
        Long value = (Long)options.get("domain");
        if (value == null) {
            return;
        }
        ByteBuffer buffer = ByteBuffer.allocate(8);
        buffer.putLong(value);
        KNXMediumSettings medium = (KNXMediumSettings)options.get("medium");
        byte[] domain = new byte[medium.getMedium() == 4 ? 2 : 6];
        buffer.position(8 - domain.length);
        buffer.get(domain);
        if (medium.getMedium() == 16) {
            ((RFSettings)medium).setDomainAddress(domain);
        } else if (medium.getMedium() == 4) {
            ((PLSettings)medium).setDomainAddress(domain);
        } else {
            throw new KNXIllegalArgumentException(medium.getMediumString() + " networks don't use domain addresses, use --medium to specify KNX network medium");
        }
    }

    static boolean parseCommonOption(String arg, Iterator<String> i, Map<String, Object> options) {
        if (Main.isOption(arg, "version", null)) {
            options.put("about", Main::showVersion);
        } else if (Main.isOption(arg, "localhost", null)) {
            options.put("localhost", Main.parseHost(i.next()));
        } else if (Main.isOption(arg, "localport", null)) {
            options.put("localport", Integer.decode(i.next()));
        } else if (Main.isOption(arg, "port", "p")) {
            options.put("port", Integer.decode(i.next()));
        } else if (Main.isOption(arg, "nat", "n")) {
            options.put("nat", null);
        } else if (Main.isOption(arg, "ft12", "f")) {
            options.put("ft12", null);
        } else if (Main.isOption(arg, "usb", "u")) {
            options.put("usb", null);
        } else if (Main.isOption(arg, "tpuart", null)) {
            options.put("tpuart", null);
        } else if (Main.isOption(arg, "medium", "m")) {
            options.put("medium", Main.getMedium(i.next()));
        } else if (Main.isOption(arg, "domain", null)) {
            options.put("domain", Long.decode(i.next()));
        } else if (Main.isOption(arg, "tcp", null)) {
            options.put("tcp", null);
        } else if (Main.isOption(arg, "udp", null)) {
            options.put("udp", null);
        } else if (Main.isOption(arg, "ft12-cemi", null)) {
            options.put("ft12-cemi", null);
        } else if (Main.isOption(arg, "json", null)) {
            options.put("json", null);
        } else if (Main.isOption(arg, "reconnect-delay", null)) {
            options.put("reconnectDelay", Duration.ofSeconds(Long.parseLong(i.next())));
        } else if (Main.isOption(arg, "max-reconnect-attempts", null)) {
            options.put("maxConnectAttempts", Long.parseLong(i.next()));
        } else {
            return false;
        }
        return true;
    }

    static boolean parseSecureOption(String arg, Iterator<String> i, Map<String, Object> options) {
        if (Main.isOption(arg, "group-key", null)) {
            options.put("group-key", Main.fromHex(i.next()));
        } else if (Main.isOption(arg, "device-key", null)) {
            options.put("device-key", Main.fromHex(i.next()));
        } else if (Main.isOption(arg, "device-pwd", null)) {
            options.put("device-key", SecureConnection.hashDeviceAuthenticationPassword((char[])i.next().toCharArray()));
        } else if (Main.isOption(arg, "user", null)) {
            options.put("user", Integer.decode(i.next()));
        } else if (Main.isOption(arg, "user-key", null)) {
            options.put("user-key", Main.fromHex(i.next()));
        } else if (Main.isOption(arg, "user-pwd", null)) {
            options.put("user-key", SecureConnection.hashUserPassword((char[])i.next().toCharArray()));
        } else if (Main.isOption(arg, "keyring", null)) {
            options.put("keyring", Keyring.load((String)i.next()));
        } else if (Main.isOption(arg, "keyring-pwd", null)) {
            options.put("keyring-pwd", i.next().toCharArray());
        } else if (Main.isOption(arg, "interface", null)) {
            options.put("interface", Main.getAddress(i.next()));
        } else {
            return false;
        }
        return true;
    }

    static String printCommonOptions() {
        return "Options:\n  --help -h                  show this help message\n  --version                  show tool/library version and exit\n  --localhost <id>           local IP/host name\n  --localport <number>       local UDP port (default system assigned)\n  --port -p <number>         UDP/TCP port on <host> (default %d)\n  --udp                      use UDP (default for unsecure communication)\n  --tcp                      use TCP (default for KNX IP secure)\n  --nat -n                   enable Network Address Translation\n  --ft12 -f                  use FT1.2 serial communication\n  --usb -u                   use KNX USB communication\n  --tpuart                   use TP-UART communication\n  --medium -m <id>           KNX medium [tp1|p110|knxip|rf] (default tp1)\n  --domain <address>         domain address on KNX PL/RF medium (defaults to broadcast domain)\n  --knx-address -k <addr>    KNX device address of local endpoint\n  --json                     show JSON-formatted output".formatted(3671);
    }

    static String printSecureOptions(boolean printGroupKey) {
        String optGroupKey = "\n  --group-key <key>          multicast group key (backbone key, 32 hexadecimal digits)";
        return "KNX Secure:\n  --keyring <path>           *.knxkeys file for secure communication (defaults to keyring in current working directory)\n  --keyring-pwd <password>   keyring password\nKNX IP Secure specific:%s\n  --user <id>                tunneling user identifier (1..127)\n  --user-pwd <password>      tunneling user password\n  --user-key <key>           tunneling user password hash (32 hexadecimal digits)\n  --device-pwd <password>    device authentication password\n  --device-key <key>         device authentication code (32 hexadecimal digits)".formatted(printGroupKey ? "\n  --group-key <key>          multicast group key (backbone key, 32 hexadecimal digits)" : "");
    }

    static String printSecureOptions() {
        return Main.printSecureOptions(true);
    }

    static KNXNetworkLink newLink(Map<String, Object> options) throws KNXException, InterruptedException {
        KNXNetworkLink link = new Connector().reconnectOn(false, true, true).reconnectDelay((Duration)options.getOrDefault("reconnectDelay", Duration.ofSeconds(4L))).maxConnectAttempts(((Long)options.getOrDefault("maxConnectAttempts", 3L)).longValue()).newLink(() -> Main.createNewLink(options));
        link.addLinkListener(new NetworkLinkListener(){

            @LinkEvent
            void connectionStatus(ConnectionStatus status) {
                System.out.println(LocalTime.now().truncatedTo(ChronoUnit.MILLIS) + " connection status KNX " + status);
            }
        });
        return link;
    }

    private static KNXNetworkLink createNewLink(Map<String, Object> options) throws KNXException, InterruptedException {
        Main.lookupKeyring(options);
        String host = (String)options.get("host");
        KNXMediumSettings medium = (KNXMediumSettings)options.get("medium");
        if (options.containsKey("ft12")) {
            return new KNXNetworkLinkFT12(host, medium);
        }
        if (options.containsKey("ft12-cemi")) {
            return KNXNetworkLinkFT12.newCemiLink((String)host, (KNXMediumSettings)medium);
        }
        if (options.containsKey("usb")) {
            return new KNXNetworkLinkUsb(host, medium);
        }
        IndividualAddress device = (IndividualAddress)options.get("knx-address");
        if (device != null) {
            medium.setDeviceAddress(device);
        }
        if (options.containsKey("tpuart")) {
            KNXNetworkLinkTpuart link = new KNXNetworkLinkTpuart(host, medium, Collections.emptyList());
            if (device == null) {
                LoggerFactory.getLogger((String)"calimero.tools").info("TP-UART sends without assigned KNX address (--knx-address)");
            }
            return link;
        }
        InetSocketAddress local = Main.createLocalSocket(options);
        InetAddress addr = Main.parseHost(host);
        if (addr.isMulticastAddress()) {
            Optional<byte[]> optGroupKey;
            if (medium.getDeviceAddress().equals((Object)KNXMediumSettings.BackboneRouter)) {
                medium.setDeviceAddress(new IndividualAddress(15, 15, 255));
            }
            if ((optGroupKey = Main.groupKey(addr, options)).isPresent()) {
                byte[] groupKey = optGroupKey.get();
                try {
                    NetworkInterface nif = NetworkInterface.getByInetAddress(local.getAddress());
                    if (nif == null && !local.getAddress().isAnyLocalAddress()) {
                        throw new KNXIllegalArgumentException(local.getAddress() + " is not assigned to a network interface");
                    }
                    return KNXNetworkLinkIP.newSecureRoutingLink((NetworkInterface)nif, (InetAddress)addr, (byte[])groupKey, (Duration)Duration.ofMillis(2000L), (KNXMediumSettings)medium);
                }
                catch (SocketException e) {
                    throw new KNXIllegalArgumentException("getting network interface of " + local.getAddress(), (Throwable)e);
                }
            }
            return KNXNetworkLinkIP.newRoutingLink((InetAddress)local.getAddress(), (InetAddress)addr, (KNXMediumSettings)medium);
        }
        InetSocketAddress remote = new InetSocketAddress(addr, (int)((Integer)options.get("port")));
        boolean nat = options.containsKey("nat");
        Optional<byte[]> optUserKey = Main.userKey(options);
        if (optUserKey.isPresent()) {
            byte[] userKey = optUserKey.get();
            byte[] devAuth = Main.deviceAuthentication(options);
            int user = (Integer)options.getOrDefault("user", 0);
            if (options.containsKey("udp")) {
                return KNXNetworkLinkIP.newSecureTunnelingLink((InetSocketAddress)local, (InetSocketAddress)remote, (boolean)nat, (byte[])devAuth, (int)user, (byte[])userKey, (KNXMediumSettings)medium);
            }
            TcpConnection.SecureSession session = Main.tcpConnection(local, remote).newSecureSession(user, userKey, devAuth);
            return KNXNetworkLinkIP.newSecureTunnelingLink((TcpConnection.SecureSession)session, (KNXMediumSettings)medium);
        }
        if (options.containsKey("tcp")) {
            TcpConnection c = Main.tcpConnection(local, remote);
            return KNXNetworkLinkIP.newTunnelingLink((TcpConnection)c, (KNXMediumSettings)medium);
        }
        return KNXNetworkLinkIP.newTunnelingLink((InetSocketAddress)local, (InetSocketAddress)remote, (boolean)nat, (KNXMediumSettings)medium);
    }

    static LocalDeviceManagementIp newLocalDeviceMgmtIP(Map<String, Object> options, Consumer<CloseEvent> adapterClosed) throws KNXException, InterruptedException {
        Main.lookupKeyring(options);
        InetSocketAddress local = Main.createLocalSocket(options);
        InetSocketAddress host = new InetSocketAddress((String)options.get("host"), (int)((Integer)options.get("port")));
        boolean nat = options.containsKey("nat");
        Optional<byte[]> optUserKey = Main.deviceMgmtKey(options);
        if (optUserKey.isPresent()) {
            byte[] userKey = optUserKey.get();
            byte[] devAuth = Main.deviceAuthentication(options);
            if (options.containsKey("udp")) {
                return LocalDeviceManagementIp.newSecureAdapter((InetSocketAddress)local, (InetSocketAddress)host, (boolean)nat, (byte[])devAuth, (byte[])userKey, adapterClosed);
            }
            TcpConnection.SecureSession session = Main.tcpConnection(local, host).newSecureSession(1, userKey, devAuth);
            return LocalDeviceManagementIp.newSecureAdapter((TcpConnection.SecureSession)session, adapterClosed);
        }
        if (options.containsKey("tcp")) {
            TcpConnection c = Main.tcpConnection(local, host);
            return LocalDeviceManagementIp.newAdapter((TcpConnection)c, adapterClosed);
        }
        boolean queryWriteEnable = options.containsKey("emulatewriteenable");
        return LocalDeviceManagementIp.newAdapter((InetSocketAddress)local, (InetSocketAddress)host, (boolean)nat, (boolean)queryWriteEnable, adapterClosed);
    }

    static void lookupKeyring(Map<String, Object> options) {
        boolean gotPwd = options.containsKey("keyring-pwd");
        Optional<Keyring> optKeyring = Optional.ofNullable((Keyring)options.get("keyring"));
        if (gotPwd) {
            optKeyring.or(Main::cwdKeyring).ifPresent(keyring -> {
                Security.defaultInstallation().useKeyring(keyring, (char[])options.get("keyring-pwd"));
                toolKeyring = keyring;
            });
        } else if (optKeyring.isPresent()) {
            System.out.println("both keyring and keyring password are required, secure communication won't be available!");
        }
    }

    private static Optional<Keyring> cwdKeyring() {
        Optional<Keyring> optional;
        block8: {
            String knxkeys = ".knxkeys";
            Stream<Path> list = Files.list(Path.of("", new String[0]));
            try {
                optional = list.map(Path::toString).filter(path -> path.endsWith(".knxkeys")).findAny().map(Keyring::load);
                if (list == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (list != null) {
                        try {
                            list.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ignore) {
                    return Optional.empty();
                }
            }
            list.close();
        }
        return optional;
    }

    static Optional<byte[]> userKey(Map<String, Object> options) {
        return Optional.ofNullable((byte[])options.get("user-key")).or(() -> Main.keyringUserKey(options));
    }

    private static Optional<byte[]> deviceMgmtKey(Map<String, Object> options) {
        return Optional.ofNullable((byte[])options.get("user-key")).or(() -> Main.keyringDeviceMgmtKey(options));
    }

    private static Optional<byte[]> groupKey(InetAddress multicastGroup, Map<String, Object> options) {
        return Optional.ofNullable((byte[])options.get("group-key")).or(() -> Main.keyringGroupKey(multicastGroup, options));
    }

    static byte[] deviceAuthentication(Map<String, Object> options) {
        return Optional.ofNullable((byte[])options.get("device-key")).or(() -> Main.keyringDeviceAuthentication(options)).orElse(new byte[0]);
    }

    private static Optional<byte[]> keyringUserKey(Map<String, Object> options) {
        int user;
        if (toolKeyring == null) {
            return Optional.empty();
        }
        IndividualAddress ifAddr = (IndividualAddress)options.get("interface");
        Optional<Keyring.Interface> connectConfig = Main.interfaceFor(ifAddr, user = ((Integer)options.getOrDefault("user", 0)).intValue());
        if (connectConfig.isPresent()) {
            options.put("user", connectConfig.get().user());
            return connectConfig.get().password().map(Main.decryptAndHashUserPwd(options));
        }
        return Optional.empty();
    }

    private static Optional<byte[]> keyringDeviceMgmtKey(Map<String, Object> options) {
        IndividualAddress ifAddr = (IndividualAddress)options.get("interface");
        return Main.keyringDeviceForInterface(ifAddr).flatMap(Keyring.Device::password).map(Main.decryptAndHashUserPwd(options));
    }

    private static Optional<byte[]> keyringGroupKey(InetAddress multicastGroup, Map<String, Object> options) {
        if (toolKeyring == null) {
            return Optional.empty();
        }
        return toolKeyring.backbone().filter(bb -> bb.multicastGroup().equals(multicastGroup)).flatMap(Keyring.Backbone::groupKey).map(key -> toolKeyring.decryptKey(key, (char[])options.get("keyring-pwd")));
    }

    private static Optional<byte[]> keyringDeviceAuthentication(Map<String, Object> options) {
        IndividualAddress ifAddr = (IndividualAddress)options.get("interface");
        return Main.keyringDeviceForInterface(ifAddr).flatMap(Keyring.Device::authentication).map(pwd -> SecureConnection.hashDeviceAuthenticationPassword((char[])toolKeyring.decryptPassword(pwd, (char[])options.get("keyring-pwd"))));
    }

    private static Optional<Keyring.Device> keyringDeviceForInterface(IndividualAddress ifAddr) {
        if (toolKeyring == null) {
            return Optional.empty();
        }
        Map devices = toolKeyring.devices();
        Map interfaces = toolKeyring.interfaces();
        if (ifAddr != null) {
            if (devices.containsKey(ifAddr)) {
                return Optional.of((Keyring.Device)devices.get(ifAddr));
            }
            for (Map.Entry entry : interfaces.entrySet()) {
                for (Keyring.Interface iface : (List)entry.getValue()) {
                    if (!iface.address().equals((Object)ifAddr)) continue;
                    IndividualAddress host = (IndividualAddress)entry.getKey();
                    return Optional.ofNullable((Keyring.Device)devices.get(host));
                }
            }
        }
        if (interfaces.size() != 1) {
            return Optional.empty();
        }
        IndividualAddress deviceAddr = (IndividualAddress)interfaces.keySet().iterator().next();
        return Optional.of((Keyring.Device)devices.get(deviceAddr));
    }

    private static Optional<Keyring.Interface> interfaceFor(IndividualAddress ifAddr, int user) {
        if (toolKeyring == null) {
            return Optional.empty();
        }
        Map interfaces = toolKeyring.interfaces();
        List list = null;
        if (ifAddr == null) {
            if (interfaces.size() != 1) {
                return Optional.empty();
            }
            list = (List)interfaces.values().iterator().next();
        }
        if (user != 0) {
            if (list == null && (list = (List)interfaces.get(ifAddr)) == null) {
                return Optional.empty();
            }
            for (Keyring.Interface ifConfig : list) {
                if (ifConfig.user() != user) continue;
                return Optional.of(ifConfig);
            }
        }
        if (list == null) {
            for (List configs : interfaces.values()) {
                for (Keyring.Interface ifConfig : configs) {
                    if (!ifConfig.address().equals((Object)ifAddr)) continue;
                    return Optional.of(ifConfig);
                }
            }
        }
        return Optional.empty();
    }

    private static Function<byte[], byte[]> decryptAndHashUserPwd(Map<String, Object> options) {
        return pwd -> SecureConnection.hashUserPassword((char[])toolKeyring.decryptPassword(pwd, (char[])options.get("keyring-pwd")));
    }

    private static byte[] fromHex(String hex) {
        int len = hex.length();
        if (len != 0 && len != 32) {
            throw new KNXIllegalArgumentException("wrong KNX key length, requires 16 bytes (32 hex chars)");
        }
        return HexFormat.of().parseHex(hex);
    }

    static String fromDptName(String id) {
        return switch (id) {
            case "switch" -> "1.001";
            case "bool" -> "1.002";
            case "dimmer" -> "3.007";
            case "blinds" -> "3.008";
            case "string" -> "16.001";
            case "temp" -> "9.001";
            case "float", "float2" -> "9.002";
            case "float4" -> "14.005";
            case "ucount" -> "5.010";
            case "int" -> "13.001";
            case "angle" -> "5.003";
            case "percent", "%" -> "5.001";
            default -> {
                if (!"-".equals(id) && !Character.isDigit(id.charAt(0))) {
                    throw new KnxRuntimeException("unrecognized DPT '" + id + "'");
                }
                yield id;
            }
        };
    }

    static {
        try (InputStream is = Main.class.getResourceAsStream("/knxManufacturers.properties");
             BufferedReader r = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8));){
            manufacturer = r.lines().map(s -> s.split("=")).collect(Collectors.toUnmodifiableMap(s -> Integer.parseUnsignedInt(s[0]), s -> s[1]));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static final class PeekingIterator<E>
    implements Iterator<E> {
        private final Iterator<E> i;
        private E next;

        PeekingIterator(Iterator<E> i) {
            this.i = i;
        }

        public E peek() {
            return this.next != null ? this.next : (this.next = this.next());
        }

        @Override
        public boolean hasNext() {
            return this.next != null || this.i.hasNext();
        }

        @Override
        public E next() {
            E e = this.next != null ? this.next : this.i.next();
            this.next = null;
            return e;
        }
    }

    static final class ShutdownHandler
    extends Thread {
        private final Thread t = Thread.currentThread();

        ShutdownHandler() {
        }

        ShutdownHandler register() {
            Runtime.getRuntime().addShutdownHook(this);
            return this;
        }

        void unregister() {
            Runtime.getRuntime().removeShutdownHook(this);
        }

        @Override
        public void run() {
            this.t.interrupt();
        }
    }
}

