/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.tools;

import java.math.BigInteger;
import java.util.HashMap;
import java.util.HexFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.slf4j.Logger;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.link.KNXNetworkLink;
import tuwien.auto.calimero.link.medium.TPSettings;
import tuwien.auto.calimero.log.LogService;
import tuwien.auto.calimero.mgmt.ManagementProcedures;
import tuwien.auto.calimero.mgmt.ManagementProceduresImpl;
import tuwien.auto.calimero.tools.Json;
import tuwien.auto.calimero.tools.Main;

public class Memory
implements Runnable {
    private static final String tool = "Memory";
    private static Logger out = LogService.getLogger((String)"calimero.tools");
    private ManagementProcedures mp;
    private final Map<String, Object> options = new HashMap<String, Object>();
    public static final Command Done = new Done();

    public Memory(String[] args) {
        try {
            this.parseOptions(args);
        }
        catch (KNXIllegalArgumentException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new KNXIllegalArgumentException(e.getMessage(), (Throwable)e);
        }
    }

    public static void main(String ... args) {
        try {
            Memory d = new Memory(args);
            Main.ShutdownHandler sh = new Main.ShutdownHandler().register();
            d.run();
            sh.unregister();
        }
        catch (Throwable t) {
            out.error("parsing options", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Throwable thrown = null;
        boolean canceled = false;
        try {
            if (this.options.isEmpty()) {
                Memory.out("Memory - Access KNX device memory");
                Main.showVersion();
                Memory.out("Type --help for help message");
                return;
            }
            if (this.options.containsKey("about")) {
                ((Runnable)this.options.get("about")).run();
                return;
            }
            try (KNXNetworkLink link = Main.newLink(this.options);){
                this.mp = new ManagementProceduresImpl(link);
                this.readWriteMemory();
            }
        }
        catch (RuntimeException | KNXException e) {
            thrown = e;
        }
        catch (InterruptedException e) {
            canceled = true;
            Thread.currentThread().interrupt();
        }
        finally {
            this.onCompletion((Exception)thrown, canceled);
        }
    }

    protected Command fetchCommand() {
        Object object = this.options.remove("read");
        if (object instanceof Integer) {
            Integer startAddr = (Integer)object;
            return new Read(startAddr, (Integer)this.options.get("bytes"));
        }
        object = this.options.remove("write");
        if (object instanceof Integer) {
            Integer startAddr = (Integer)object;
            String s = (String)this.options.get("data");
            byte[] data = this.options.containsKey("dec") ? new BigInteger(s).toByteArray() : DataUnitBuilder.fromHex((String)s);
            return new Write(startAddr, data);
        }
        return Done;
    }

    protected void onMemoryRead(int address, byte[] data) {
        if (this.options.containsKey("json")) {
            record JsonMemory(String startAddress, int length, byte[] data) implements Json
            {
            }
            Memory.out(new JsonMemory(Integer.toHexString(address), data.length, data).toJson());
            return;
        }
        this.out(data);
    }

    protected void onCompletion(Exception thrown, boolean canceled) {
        if (canceled) {
            out.info("memory access canceled");
        }
        if (thrown != null) {
            out.error("completed with error", (Throwable)thrown);
        }
    }

    private void out(byte[] data) {
        Object s = this.options.containsKey("dec") ? new BigInteger(1, data).toString() : "0x" + HexFormat.of().formatHex(data);
        Memory.out((String)s);
    }

    private void readWriteMemory() throws KNXException, InterruptedException {
        IndividualAddress device = (IndividualAddress)this.options.get("device");
        Command cmd = this.fetchCommand();
        while (cmd != Done) {
            if (cmd instanceof Read) {
                Read read = (Read)cmd;
                out.debug("read {} 0x{}..0x{}", new Object[]{device, Long.toHexString(read.startAddress()), Long.toHexString(read.startAddress() + read.length() - 1)});
                this.onMemoryRead(read.startAddress(), this.mp.readMemory(device, (long)read.startAddress(), read.length()));
            } else {
                Write write = (Write)cmd;
                int startAddr = write.startAddress();
                byte[] data = write.data();
                out.debug("write to {} 0x{}..0x{}: {}", new Object[]{device, Long.toHexString(startAddr), Long.toHexString(startAddr + data.length - 1), HexFormat.ofDelimiter(" ").formatHex(data)});
                this.mp.writeMemory(device, (long)startAddr, data, false, false);
            }
            cmd = this.fetchCommand();
        }
    }

    private void parseOptions(String[] args) {
        if (args.length == 0) {
            return;
        }
        this.options.put("port", 3671);
        this.options.put("bytes", 1);
        Iterator<String> i = List.of(args).iterator();
        while (i.hasNext()) {
            String arg = i.next();
            if (Main.isOption(arg, "help", "h")) {
                this.options.put("about", Memory::showUsage);
                return;
            }
            if (Main.parseCommonOption(arg, i, this.options) || Main.parseSecureOption(arg, i, this.options)) continue;
            if (Main.isOption(arg, "knx-address", "k")) {
                this.options.put("knx-address", Main.getAddress(i.next()));
                continue;
            }
            if (Main.isOption(arg, "dec", null)) {
                this.options.put("dec", null);
                continue;
            }
            if (arg.equals("read") || arg.equals("r")) {
                this.options.put("read", Integer.decode(i.next()));
                if (!i.hasNext()) continue;
                this.options.put("bytes", Integer.parseInt(i.next()));
                continue;
            }
            if (arg.equals("write") || arg.equals("w")) {
                this.options.put("write", Integer.decode(i.next()));
                this.options.put("data", i.next());
                continue;
            }
            if (!this.options.containsKey("host")) {
                this.options.put("host", arg);
                continue;
            }
            if (!this.options.containsKey("device")) {
                try {
                    this.options.put("device", new IndividualAddress(arg));
                    continue;
                }
                catch (KNXFormatException e) {
                    throw new KNXIllegalArgumentException("KNX device " + e, (Throwable)e);
                }
            }
            throw new KNXIllegalArgumentException("unknown option " + arg);
        }
        if (this.options.containsKey("usb") && !this.options.containsKey("host")) {
            this.options.put("host", "");
        }
        if (!this.options.containsKey("host") || this.options.containsKey("ft12") && this.options.containsKey("usb")) {
            throw new KNXIllegalArgumentException("specify either IP host, serial port, or device");
        }
        if (!this.options.containsKey("device")) {
            throw new KNXIllegalArgumentException("missing remote KNX device address");
        }
        if (!this.options.containsKey("medium")) {
            this.options.put("medium", new TPSettings());
        }
        Main.setDomainAddress(this.options);
    }

    private static void showUsage() {
        StringJoiner joiner = new StringJoiner(System.lineSeparator());
        joiner.add("Usage: Memory [options] <host|port> <KNX device address> read|write addr ...");
        joiner.add("Commands:");
        joiner.add("  read <address> [bytes]     read number of bytes (default 1) starting at memory address");
        joiner.add("  write <address> data       write data (hex default) to memory starting at address");
        joiner.add(Main.printCommonOptions());
        joiner.add("  --dec                      interpret memory data in decimal format");
        joiner.add(Main.printSecureOptions());
        Memory.out(joiner.toString());
    }

    private static void out(String s) {
        System.out.println(s);
    }

    public record Read(int startAddress, int length) implements Command
    {
    }

    public record Write(int startAddress, byte[] data) implements Command
    {
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface Command {
    }

    private record Done() implements Command
    {
    }
}

