/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.tools;

import java.net.InetSocketAddress;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.HexFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.slf4j.Logger;
import tuwien.auto.calimero.CloseEvent;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.FrameEvent;
import tuwien.auto.calimero.GroupAddress;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXAddress;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.LteHeeTag;
import tuwien.auto.calimero.Priority;
import tuwien.auto.calimero.cemi.CEMIBusMon;
import tuwien.auto.calimero.cemi.RFMediumInfo;
import tuwien.auto.calimero.knxnetip.TcpConnection;
import tuwien.auto.calimero.link.Connector;
import tuwien.auto.calimero.link.KNXNetworkMonitor;
import tuwien.auto.calimero.link.KNXNetworkMonitorFT12;
import tuwien.auto.calimero.link.KNXNetworkMonitorIP;
import tuwien.auto.calimero.link.KNXNetworkMonitorTpuart;
import tuwien.auto.calimero.link.KNXNetworkMonitorUsb;
import tuwien.auto.calimero.link.LinkEvent;
import tuwien.auto.calimero.link.LinkListener;
import tuwien.auto.calimero.link.MonitorFrameEvent;
import tuwien.auto.calimero.link.medium.KNXMediumSettings;
import tuwien.auto.calimero.link.medium.RFLData;
import tuwien.auto.calimero.link.medium.RawAckBase;
import tuwien.auto.calimero.link.medium.RawFrame;
import tuwien.auto.calimero.link.medium.RawFrameBase;
import tuwien.auto.calimero.link.medium.TPSettings;
import tuwien.auto.calimero.log.LogService;
import tuwien.auto.calimero.serial.ConnectionStatus;
import tuwien.auto.calimero.tools.Json;
import tuwien.auto.calimero.tools.Main;
import tuwien.auto.calimero.tools.TrafficMonitor;

public class NetworkMonitor
implements Runnable {
    private static final String tool = "NetworkMonitor";
    private static final String sep = System.lineSeparator();
    private static Logger out = LogService.getLogger((String)"calimero.tools");
    private final Map<String, Object> options = new HashMap<String, Object>();
    private KNXNetworkMonitor m;
    private final LinkListener l = new LinkListener(){

        public void indication(FrameEvent e) {
            try {
                NetworkMonitor.this.onIndication(e);
            }
            catch (RuntimeException rte) {
                out.warn("on indication", (Throwable)rte);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void linkClosed(CloseEvent e) {
            out.info("network monitor closed (" + e.getReason() + ")");
            NetworkMonitor networkMonitor = NetworkMonitor.this;
            synchronized (networkMonitor) {
                NetworkMonitor.this.notify();
            }
        }
    };

    public NetworkMonitor(String[] args) {
        try {
            this.parseOptions(args);
        }
        catch (KNXIllegalArgumentException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new KNXIllegalArgumentException(e.getMessage(), (Throwable)e);
        }
    }

    public static void main(String ... args) {
        try {
            NetworkMonitor m = new NetworkMonitor(args);
            ShutdownHandler sh = m.new ShutdownHandler().register();
            m.run();
            sh.unregister();
        }
        catch (KNXIllegalArgumentException e) {
            out.error("parsing options", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Throwable thrown = null;
        boolean canceled = false;
        try {
            this.start();
            NetworkMonitor networkMonitor = this;
            synchronized (networkMonitor) {
                while (this.m != null && this.m.isOpen()) {
                    this.wait(500L);
                }
            }
        }
        catch (InterruptedException e) {
            canceled = true;
            Thread.currentThread().interrupt();
        }
        catch (RuntimeException | KNXException e) {
            thrown = e;
        }
        finally {
            this.quit();
            this.onCompletion((Exception)thrown, canceled);
        }
    }

    public void start() throws KNXException, InterruptedException {
        if (this.options.isEmpty()) {
            NetworkMonitor.out("NetworkMonitor - Monitor a KNX network (passive busmonitor mode)");
            Main.showVersion();
            NetworkMonitor.out("Type --help for help message");
            return;
        }
        if (this.options.containsKey("about")) {
            ((Runnable)this.options.get("about")).run();
            return;
        }
        this.m = this.newMonitor();
        this.m.setDecodeRawFrames(true);
        this.m.addMonitorListener(this.l);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void quit() {
        if (this.m != null && this.m.isOpen()) {
            this.m.close();
            NetworkMonitor networkMonitor = this;
            synchronized (networkMonitor) {
                this.notifyAll();
            }
        }
    }

    protected void onIndication(FrameEvent e) {
        CEMIBusMon frame = (CEMIBusMon)e.getFrame();
        RawFrame raw = ((MonitorFrameEvent)e).getRawFrame();
        if (this.options.containsKey("json")) {
            System.out.println(NetworkMonitor.toJson(raw, frame));
            return;
        }
        StringBuilder sb = new StringBuilder();
        boolean compact = this.options.containsKey("compact");
        if (compact) {
            sb.append("Seq ").append(frame.getSequenceNumber());
        } else {
            sb.append(frame);
        }
        if (raw != null) {
            sb.append(compact ? " " : " = ");
            sb.append(raw);
            if (raw instanceof RawFrameBase) {
                RawFrameBase f = (RawFrameBase)raw;
                sb.append(": ").append(DataUnitBuilder.decode((byte[])f.getTPDU(), (KNXAddress)f.getDestination()));
                sb.append(" ");
                HexFormat.ofDelimiter(" ").formatHex(sb, DataUnitBuilder.extractASDU((byte[])f.getTPDU()));
            } else if (raw instanceof RFLData) {
                RFLData rf = (RFLData)raw;
                try {
                    sb.append(": ");
                    String bibat = NetworkMonitor.decodeBibat(rf);
                    if (!bibat.isEmpty()) {
                        sb.append(bibat);
                    } else {
                        sb.append(DataUnitBuilder.decode((byte[])rf.getTpdu(), (KNXAddress)rf.getDestination()));
                        sb.append(" ").append(NetworkMonitor.decodeLteFrame(rf));
                    }
                }
                catch (Exception ex) {
                    out.error("decoding RF frame", (Throwable)ex);
                }
            }
        }
        System.out.println(LocalTime.now() + " " + sb);
    }

    private static String toJson(RawFrame raw, CEMIBusMon frame) {
        Record jsonRaw = null;
        if (raw != null) {
            if (raw instanceof RawFrameBase) {
                RawFrameBase f = (RawFrameBase)raw;
                byte[] tpdu = f.getTPDU();
                String tpci = DataUnitBuilder.decodeTPCI((int)DataUnitBuilder.getTPDUService((byte[])tpdu), (KNXAddress)f.getDestination());
                String apci = DataUnitBuilder.decodeAPCI((int)DataUnitBuilder.getAPDUService((byte[])tpdu));
                byte[] asdu = DataUnitBuilder.extractASDU((byte[])tpdu);
                record JsonRawFrame(String svc, boolean extended, IndividualAddress src, KNXAddress dst, boolean repetition, int hopCount, Priority priority, String tpci, String apci, byte[] asdu, int checksum) implements Json
                {
                }
                jsonRaw = new JsonRawFrame(NetworkMonitor.frameFormat(f.getFrameType()), f.extended(), f.getSource(), f.getDestination(), f.isRepetition(), f.getHopcount(), f.getPriority(), tpci, apci, asdu, f.getChecksum());
            } else if (raw instanceof RawAckBase) {
                RawAckBase ack = (RawAckBase)raw;
                record JsonRawAck(String svc, String ackType) implements Json
                {
                }
                jsonRaw = new JsonRawAck(NetworkMonitor.frameFormat(ack.getFrameType()), NetworkMonitor.ackType(ack.getAckType()));
            } else if (raw instanceof RFLData) {
                RFLData rf = (RFLData)raw;
                byte[] tpdu = rf.getTpdu();
                String tpci = DataUnitBuilder.decodeTPCI((int)DataUnitBuilder.getTPDUService((byte[])tpdu), (KNXAddress)rf.getDestination());
                String apci = DataUnitBuilder.decodeAPCI((int)DataUnitBuilder.getAPDUService((byte[])tpdu));
                byte[] asdu = DataUnitBuilder.extractASDU((byte[])tpdu);
                byte[] doa = rf.isSystemBroadcast() ? null : rf.getDoAorSN();
                byte[] sn = rf.isSystemBroadcast() ? rf.getDoAorSN() : null;
                record JsonRfLData(String svc, IndividualAddress src, KNXAddress dst, int frameNumber, boolean systemBroadcast, RFMediumInfo.RSS rss, boolean batteryOk, boolean txOnlyDevice, byte[] doa, byte[] sn, String tpci, String apci, byte[] asdu, int checksum) implements Json
                {
                }
                jsonRaw = new JsonRfLData(NetworkMonitor.frameFormatRf(rf.getFrameType()), rf.getSource(), rf.getDestination(), rf.getFrameNumber(), rf.isSystemBroadcast(), rf.getRss(), rf.isBatteryOk(), rf.isTransmitOnlyDevice(), doa, sn, tpci, apci, asdu, 0);
            } else {
                out.info("unsupported frame type " + raw);
            }
        }
        record JsonMonitorIndication(Instant time, String svc, long relativeTimestamp, int seqNumber, boolean frameError, boolean bitError, boolean parityError, boolean lost, byte[] data, Json rawFrame) implements Json
        {
        }
        JsonMonitorIndication json = new JsonMonitorIndication(Instant.now(), TrafficMonitor.svcPrimitive(frame.getMessageCode()), frame.getTimestamp(), frame.getSequenceNumber(), frame.getFrameError(), frame.getBitError(), frame.getParityError(), frame.getLost(), frame.getPayload(), (Json)((Object)jsonRaw));
        return json.toJson();
    }

    private static String frameFormat(int format) {
        return switch (format) {
            case 0 -> "L-Data";
            case 1 -> "L-PollData";
            case 2 -> "Ack";
            default -> "" + format;
        };
    }

    private static String frameFormatRf(int format) {
        String lte = (format & 0xC) == 4 ? "LTE " : "";
        return lte + (String)(switch (format) {
            case 0 -> "L-Data (async)";
            case 1 -> "Fast Ack";
            case 4 -> "L-Data (sync)";
            case 5 -> "BiBat Sync";
            case 6 -> "BiBat Help Call";
            case 7 -> "BiBat Help Call Res";
            case 8 -> "RF Multi L-Data (async)";
            case 9 -> "RF Multi L-Data (async, Ack.req)";
            case 10 -> "RF Multi Repeater Ack";
            default -> "" + format;
        });
    }

    private static String ackType(int ackType) {
        return switch (ackType) {
            case 204 -> "ACK";
            case 12 -> "NAK";
            case 192 -> "BUSY";
            case 0 -> "NAK_BUSY";
            default -> "" + ackType;
        };
    }

    protected void onCompletion(Exception thrown, boolean canceled) {
        if (canceled) {
            out.info("NetworkMonitor stopped");
        }
        if (thrown != null) {
            out.error(thrown.getMessage() != null ? thrown.getMessage() : thrown.getClass().getName());
        }
    }

    private KNXNetworkMonitor newMonitor() throws KNXException, InterruptedException {
        KNXNetworkMonitor monitor = new Connector().reconnectOn(false, true, true).reconnectDelay((Duration)this.options.getOrDefault("reconnectDelay", Duration.ofSeconds(4L))).maxConnectAttempts(((Long)this.options.getOrDefault("maxConnectAttempts", 3L)).longValue()).newMonitor(() -> this.createMonitor());
        monitor.addMonitorListener(new LinkListener(){

            @LinkEvent
            void connectionStatus(ConnectionStatus status) {
                System.out.println(LocalTime.now().truncatedTo(ChronoUnit.MILLIS) + " connection status KNX " + status);
            }
        });
        return monitor;
    }

    private KNXNetworkMonitor createMonitor() throws KNXException, InterruptedException {
        String host = (String)this.options.get("host");
        KNXMediumSettings medium = (KNXMediumSettings)this.options.get("medium");
        if (this.options.containsKey("ft12")) {
            return new KNXNetworkMonitorFT12(host, medium);
        }
        if (this.options.containsKey("ft12-cemi")) {
            return KNXNetworkMonitorFT12.newCemiMonitor((String)host, (KNXMediumSettings)medium);
        }
        if (this.options.containsKey("usb")) {
            return new KNXNetworkMonitorUsb(host, medium);
        }
        if (this.options.containsKey("tpuart")) {
            return new KNXNetworkMonitorTpuart(host, true);
        }
        InetSocketAddress local = Main.createLocalSocket(this.options);
        InetSocketAddress remote = new InetSocketAddress(Main.parseHost(host), (int)((Integer)this.options.get("port")));
        boolean nat = this.options.containsKey("nat");
        if (this.options.containsKey("user")) {
            byte[] devAuth = (byte[])this.options.getOrDefault("device-key", new byte[0]);
            byte[] userKey = (byte[])this.options.getOrDefault("user-key", new byte[0]);
            int user = (Integer)this.options.getOrDefault("user", 0);
            if (this.options.containsKey("udp")) {
                return KNXNetworkMonitorIP.newSecureMonitorLink((InetSocketAddress)local, (InetSocketAddress)remote, (boolean)nat, (byte[])devAuth, (int)user, (byte[])userKey, (KNXMediumSettings)medium);
            }
            TcpConnection.SecureSession session = Main.tcpConnection(local, remote).newSecureSession(user, userKey, devAuth);
            return KNXNetworkMonitorIP.newSecureMonitorLink((TcpConnection.SecureSession)session, (KNXMediumSettings)medium);
        }
        if (this.options.containsKey("tcp")) {
            TcpConnection c = Main.tcpConnection(local, remote);
            return KNXNetworkMonitorIP.newMonitorLink((TcpConnection)c, (KNXMediumSettings)medium);
        }
        return new KNXNetworkMonitorIP(local, remote, nat, medium);
    }

    private void parseOptions(String[] args) {
        if (args.length == 0) {
            return;
        }
        this.options.put("port", 3671);
        this.options.put("medium", new TPSettings());
        Iterator<String> i = List.of(args).iterator();
        while (i.hasNext()) {
            String arg = i.next();
            if (Main.isOption(arg, "help", "h")) {
                this.options.put("about", NetworkMonitor::showUsage);
                return;
            }
            if (Main.parseCommonOption(arg, i, this.options) || Main.parseSecureOption(arg, i, this.options)) continue;
            if (Main.isOption(arg, "compact", "c")) {
                this.options.put("compact", null);
                continue;
            }
            if (!this.options.containsKey("host")) {
                this.options.put("host", arg);
                continue;
            }
            throw new KNXIllegalArgumentException("unknown option " + arg);
        }
        if (this.options.containsKey("usb") && !this.options.containsKey("host")) {
            this.options.put("host", "");
        }
        if (!this.options.containsKey("host") || this.options.containsKey("ft12") && this.options.containsKey("usb")) {
            throw new KNXIllegalArgumentException("specify either IP host, serial port, or device");
        }
        Main.setDomainAddress(this.options);
    }

    private static void showUsage() {
        StringJoiner joiner = new StringJoiner(sep);
        joiner.add("Usage: NetworkMonitor [options] <host|port>");
        joiner.add(Main.printCommonOptions());
        joiner.add("  --compact -c               show incoming busmonitor indications in compact format");
        joiner.add(Main.printSecureOptions(false));
        NetworkMonitor.out(joiner.toString());
    }

    private static void out(String s) {
        System.out.println(s);
    }

    protected static String decodeLteFrame(RFLData frame) throws KNXFormatException {
        boolean lteExt;
        int extFormat = frame.getFrameType() & 0xF;
        boolean bl = lteExt = (extFormat & 0xC) == 4;
        if (!lteExt) {
            return "no LTE";
        }
        byte[] tpdu = frame.getTpdu();
        int pci = tpdu[0] & 0xFF;
        int tpci = pci >>> 6;
        if (tpci != RFLData.Tpci.UnnumberedData.ordinal()) {
            throw new KNXFormatException("LTE extended frame requires TPCI " + RFLData.Tpci.UnnumberedData);
        }
        return NetworkMonitor.decodeLteFrame(extFormat, frame.getDestination(), DataUnitBuilder.extractASDU((byte[])tpdu));
    }

    protected static String decodeLteFrame(int extFormat, KNXAddress dst, byte[] asdu) throws KNXFormatException {
        StringBuilder sb = new StringBuilder();
        LteHeeTag tag = LteHeeTag.from((int)extFormat, (GroupAddress)((GroupAddress)dst));
        sb.append(tag).append(' ');
        int iot = (asdu[0] & 0xFF) << 8 | asdu[1] & 0xFF;
        int ioi = asdu[2] & 0xFF;
        int pid = asdu[3] & 0xFF;
        if (pid == 255) {
            int companyCode = (asdu[4] & 0xFF) << 8 | asdu[5] & 0xFF;
            int privatePid = asdu[6] & 0xFF;
            sb.append("IOT ").append(iot).append(" OI ").append(ioi).append(" Company ").append(companyCode).append(" PID ").append(privatePid).append(": ").append(HexFormat.of().formatHex(asdu, 7, asdu.length));
        } else {
            sb.append("IOT ").append(iot).append(" OI ").append(ioi).append(" PID ").append(pid).append(": ").append(HexFormat.of().formatHex(asdu, 4, asdu.length));
        }
        return sb.toString();
    }

    protected static String decodeBibat(RFLData frame) throws KNXFormatException {
        int frameType = frame.getFrameType() >>> 4;
        byte[] tpdu = frame.getTpdu();
        if (frameType == 1) {
            return "Fast ACK";
        }
        if (frameType == 5) {
            return "RndPausePtr " + (tpdu[0] & 0xFF);
        }
        if (frameType == 6) {
            return "Retransmitter " + (tpdu[0] & 0xFF);
        }
        if (frameType == 7) {
            int ticks = (tpdu[0] & 0xFF) << 16 | (tpdu[1] & 0xFF) << 8 | tpdu[2] & 0xFF;
            double next = (double)(ticks * 10 / 16384) / 10.0;
            return "NextBlock " + next + " ms NextBlock# " + (tpdu[3] & 0xFF) + " RndPausePtr " + (tpdu[4] & 0xFF);
        }
        return "";
    }

    private final class ShutdownHandler
    extends Thread {
        private ShutdownHandler() {
        }

        private ShutdownHandler register() {
            Runtime.getRuntime().addShutdownHook(this);
            return this;
        }

        private void unregister() {
            try {
                Runtime.getRuntime().removeShutdownHook(this);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            NetworkMonitor.this.quit();
        }
    }
}

