/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HexFormat;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.BiFunction;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.DetachEvent;
import tuwien.auto.calimero.FrameEvent;
import tuwien.auto.calimero.GroupAddress;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.KNXTimeoutException;
import tuwien.auto.calimero.LteHeeTag;
import tuwien.auto.calimero.Priority;
import tuwien.auto.calimero.SerialNumber;
import tuwien.auto.calimero.cemi.CEMI;
import tuwien.auto.calimero.cemi.CEMILData;
import tuwien.auto.calimero.cemi.CEMILDataEx;
import tuwien.auto.calimero.datapoint.Datapoint;
import tuwien.auto.calimero.datapoint.DatapointMap;
import tuwien.auto.calimero.datapoint.DatapointModel;
import tuwien.auto.calimero.datapoint.StateDP;
import tuwien.auto.calimero.dptxlator.DPT;
import tuwien.auto.calimero.dptxlator.DPTXlator;
import tuwien.auto.calimero.dptxlator.DPTXlator8BitEnum;
import tuwien.auto.calimero.dptxlator.DptXlator8BitSet;
import tuwien.auto.calimero.dptxlator.TranslatorTypes;
import tuwien.auto.calimero.link.KNXLinkClosedException;
import tuwien.auto.calimero.link.KNXNetworkLink;
import tuwien.auto.calimero.link.NetworkLinkListener;
import tuwien.auto.calimero.link.medium.KNXMediumSettings;
import tuwien.auto.calimero.link.medium.RFSettings;
import tuwien.auto.calimero.link.medium.TPSettings;
import tuwien.auto.calimero.log.LogService;
import tuwien.auto.calimero.process.LteProcessEvent;
import tuwien.auto.calimero.process.ProcessCommunicator;
import tuwien.auto.calimero.process.ProcessCommunicatorImpl;
import tuwien.auto.calimero.process.ProcessEvent;
import tuwien.auto.calimero.process.ProcessListener;
import tuwien.auto.calimero.tools.Json;
import tuwien.auto.calimero.tools.Main;
import tuwien.auto.calimero.xml.KNXMLException;
import tuwien.auto.calimero.xml.XmlInputFactory;
import tuwien.auto.calimero.xml.XmlOutputFactory;
import tuwien.auto.calimero.xml.XmlReader;
import tuwien.auto.calimero.xml.XmlWriter;

public class ProcComm
implements Runnable {
    private static final String tool = "ProcComm";
    private static final String sep = System.lineSeparator();
    private static final String toolDatapointsFile = "." + "ProcComm".toLowerCase() + "_dplist.xml";
    private static final Logger out = LogService.getLogger((String)"calimero.tools.ProcComm");
    private KNXNetworkLink link;
    protected ProcessCommunicator pc;
    private final Map<String, Object> options = new HashMap<String, Object>();
    private final DatapointModel<StateDP> datapoints = new DatapointMap();
    private volatile boolean closed;
    private static final int GroupPropWrite = 1002;
    private static final Map<String, StdMode> lteZToStdMode = Map.ofEntries(Map.entry("200.100", StdMode.xlator("1.100")), Map.entry("200.101", StdMode.xlator("1.006")), Map.entry("201.100", StdMode.xlator("20.102")), Map.entry("201.102", StdMode.xlator("20.103")), Map.entry("201.104", StdMode.xlator("20.105")), Map.entry("201.105", StdMode.xlator("20.60105")), Map.entry("201.107", StdMode.xlator("20.002")), Map.entry("201.108", StdMode.xlator("20.003")), Map.entry("201.109", StdMode.xlator("20.106")), Map.entry("202.001", StdMode.xlator("5.004")), Map.entry("202.002", StdMode.xlator("5.010")), Map.entry("203.002", StdMode.xlator("7.002")), Map.entry("203.003", StdMode.xlator("7.003")), Map.entry("203.004", StdMode.xlator("7.004")), Map.entry("203.005", StdMode.xlator("7.005")), Map.entry("203.006", StdMode.xlator("7.006")), Map.entry("203.007", StdMode.xlator("7.007")), Map.entry("203.011", StdMode.function(ProcComm::twoByteUnsigned10Millis, "l/h")), Map.entry("203.012", StdMode.xlatorDimensionless("7.001")), Map.entry("203.013", StdMode.function(ProcComm::twoByteUnsigned10Millis, "\u03bcA")), Map.entry("203.014", StdMode.function(ProcComm::twoByteUnsigned, "kW")), Map.entry("203.015", StdMode.function(ProcComm::twoByteUnsigned50Millis, "mbar")), Map.entry("203.017", StdMode.function(ProcComm::twoByteUnsigned10Millis, "%")), Map.entry("203.100", StdMode.function(ProcComm::twoByteUnsigned, "ppm")), Map.entry("203.101", StdMode.function(ProcComm::twoByteUnsigned10Millis, "m/s")), Map.entry("203.102", StdMode.function(ProcComm::twoByteUnsigned50Millis, "W/m\u00b2")), Map.entry("203.104", StdMode.function(ProcComm::twoByteUnsigned, "m\u00b3/h")), Map.entry("204.001", StdMode.xlator("6.001")), Map.entry("205.002", StdMode.xlator("8.002")), Map.entry("205.003", StdMode.xlator("8.003")), Map.entry("205.004", StdMode.xlator("8.004")), Map.entry("205.005", StdMode.xlator("8.005")), Map.entry("205.006", StdMode.xlator("8.006")), Map.entry("205.007", StdMode.xlator("8.007")), Map.entry("205.017", StdMode.xlator("8.010")), Map.entry("205.100", StdMode.function(ProcComm::twoByteSigned20Millis, "\u00b0C")), Map.entry("205.101", StdMode.function(ProcComm::twoByteSigned20Millis, "K")), Map.entry("205.102", StdMode.function(ProcComm::twoByteSigned, "m\u00b3/h")), Map.entry("218.001", StdMode.function(ProcComm::fourByteSigned, "l")), Map.entry("218.002", StdMode.function(ProcComm::fourByteSigned0001, "m\u00b3/h")));

    public ProcComm(String[] args) {
        try {
            this.parseOptions(args);
        }
        catch (KNXIllegalArgumentException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new KNXIllegalArgumentException(e.getMessage(), (Throwable)e);
        }
    }

    public static void main(String ... args) {
        try {
            ProcComm pc = new ProcComm(args);
            ShutdownHandler sh = pc.new ShutdownHandler().register();
            pc.run();
            sh.unregister();
        }
        catch (Throwable t) {
            out.error("tool options", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Throwable thrown = null;
        boolean canceled = false;
        try {
            this.start(null);
            if (this.options.containsKey("about")) {
                return;
            }
            this.loadDatapoints();
            if (this.options.containsKey("monitor")) {
                this.runMonitorLoop();
            } else {
                this.readWrite();
            }
        }
        catch (IOException | RuntimeException | KNXException e) {
            thrown = e;
        }
        catch (InterruptedException e) {
            canceled = true;
            Thread.currentThread().interrupt();
        }
        finally {
            this.quit();
            this.onCompletion((Exception)thrown, canceled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(ProcessListener l) throws KNXException, InterruptedException {
        if (this.closed) {
            return;
        }
        if (this.options.containsKey("about")) {
            ((Runnable)this.options.get("about")).run();
            this.closed = true;
            return;
        }
        ProcComm procComm = this;
        synchronized (procComm) {
            if (this.link != null) {
                return;
            }
            this.link = this.createLink();
        }
        this.pc = new ProcessCommunicatorImpl(this.link);
        if (l != null) {
            this.pc.addProcessListener(l);
        }
        if (this.options.containsKey("monitor")) {
            ProcessListener monitor = new ProcessListener(){

                public void groupWrite(ProcessEvent e) {
                    ProcComm.this.onGroupEvent(e);
                }

                public void groupReadResponse(ProcessEvent e) {
                    ProcComm.this.onGroupEvent(e);
                }

                public void groupReadRequest(ProcessEvent e) {
                    ProcComm.this.onGroupEvent(e);
                }

                public void detached(DetachEvent e) {
                    ProcComm.this.closed = true;
                }
            };
            this.pc.addProcessListener(monitor);
        }
        if (this.options.containsKey("lte")) {
            this.link.addLinkListener(new NetworkLinkListener(){

                public void indication(FrameEvent e) {
                    ProcComm.this.checkForLteFrame(e);
                }
            });
        }
        if (this.options.containsKey("timeout")) {
            this.pc.responseTimeout((Duration)this.options.get("timeout"));
        }
    }

    public void quit() {
        this.closed = true;
        if (this.pc != null) {
            KNXNetworkLink lnk = this.pc.detach();
            if (lnk != null) {
                lnk.close();
            }
            this.saveDatapoints();
        }
    }

    protected void issueCommand(String line) throws KNXException, InterruptedException {
        String[] s = line.trim().split(" +");
        if (s.length == 1 && "exit".equalsIgnoreCase(s[0])) {
            return;
        }
        if (s.length == 1 && ("?".equals(s[0]) || "help".equals(s[0]))) {
            ProcComm.out(ProcComm.listCommandsAndDptAliases(new StringJoiner(System.lineSeparator()), false));
        }
        if (s.length > 1) {
            boolean info;
            String cmd = s[0];
            String addr = s[1];
            boolean read = cmd.equals("read") || cmd.equals("r");
            boolean write = cmd.equals("write") || cmd.equals("w");
            boolean bl = info = cmd.equals("info") || cmd.equals("i");
            if (this.options.containsKey("lte") && (read || write || info)) {
                this.issueLteCommand(addr, s);
            } else if (read || write) {
                boolean withDpt = read && s.length == 3 || write && s.length >= 4;
                GroupAddress ga = new GroupAddress(addr);
                StateDP dp = new StateDP(ga, "tmp", 0, withDpt ? Main.fromDptName(s[2]) : null);
                if (withDpt && !s[2].equals("-")) {
                    this.datapoints.remove((Datapoint)dp);
                    this.datapoints.add((Datapoint)dp);
                }
                StateDP stateDP = dp = this.datapoints.contains(ga) ? (StateDP)this.datapoints.get(ga) : dp;
                this.readWrite((Datapoint)dp, write, write ? String.join((CharSequence)" ", Arrays.asList(s).subList(withDpt ? 3 : 2, s.length)) : null);
            } else {
                ProcComm.out("unknown command '" + cmd + "'");
            }
        }
    }

    protected void onGroupEvent(ProcessEvent e) {
        int svcCode = e.getServiceCode();
        byte[] asdu = e.getASDU();
        if (this.options.containsKey("json")) {
            record JsonGroupEvent(Instant time, IndividualAddress src, GroupAddress dst, int svcCode, String svc, boolean lengthOptimizedApdu, byte[] asdu, String decodedAsdu) implements Json
            {
            }
            JsonGroupEvent json = new JsonGroupEvent(Instant.now(), e.getSourceAddr(), e.getDestination(), svcCode, DataUnitBuilder.decodeAPCI((int)svcCode), e.isLengthOptimizedAPDU(), asdu, this.decodeAsdu(e, asdu, new StringBuilder()).toString());
            System.out.println(json.toJson());
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(e.getSourceAddr()).append("->");
        if (!this.options.containsKey("lte")) {
            sb.append(e.getDestination());
        }
        if (!this.options.containsKey("compact")) {
            sb.append(" ").append(DataUnitBuilder.decodeAPCI((int)svcCode)).append(" ");
            HexFormat.ofDelimiter(" ").formatHex(sb, asdu);
        }
        if (asdu.length > 0) {
            sb.append(this.options.containsKey("compact") ? " " : ": ");
            this.decodeAsdu(e, asdu, sb);
        }
        System.out.println(LocalTime.now().truncatedTo(ChronoUnit.MILLIS) + " " + sb);
    }

    private StringBuilder decodeAsdu(ProcessEvent e, byte[] asdu, StringBuilder sb) {
        if (asdu.length > 0) {
            try {
                if ((e.getServiceCode() & 0x3FC) == 1000) {
                    sb.append(this.decodeLteFrame((LteProcessEvent)e));
                } else {
                    Datapoint dp = this.datapoints.get(e.getDestination());
                    if (dp != null) {
                        sb.append(this.asString(asdu, 0, dp.getDPT()));
                    } else {
                        sb.append(ProcComm.decodeAsduByLength(asdu, e.isLengthOptimizedAPDU()));
                    }
                }
            }
            catch (RuntimeException | KNXException ex) {
                out.info("error parsing group event {}", (Object)sb, (Object)ex);
            }
        }
        return sb;
    }

    protected void onReadResponse(Datapoint dp, String value) {
        System.out.println("read " + dp.getMainAddress() + " value: " + value);
    }

    protected void onCompletion(Exception thrown, boolean canceled) {
        if (canceled) {
            out.info("process communication was stopped");
        }
        if (thrown != null) {
            out.error("completed with error", (Throwable)thrown);
        }
    }

    protected String asString(byte[] asdu, int dptMainNumber, String dptID) throws KNXException {
        DPTXlator t = TranslatorTypes.createTranslator((int)dptMainNumber, (String)dptID);
        t.setData(asdu);
        return t.getValue();
    }

    private KNXNetworkLink createLink() throws KNXException, InterruptedException {
        return Main.newLink(this.options);
    }

    private String getDPT(GroupAddress group) {
        String dpt = (String)this.options.get("dpt");
        StateDP datapoint = (StateDP)this.datapoints.get(group);
        if (dpt == null) {
            return datapoint != null ? datapoint.getDPT() : null;
        }
        String id = Main.fromDptName(dpt);
        if (datapoint != null) {
            datapoint.setDPT(0, id);
        } else {
            this.datapoints.add((Datapoint)new StateDP(group, "", 0, id));
        }
        return id;
    }

    private void readWrite() throws KNXException, InterruptedException {
        if (this.options.containsKey("lte")) {
            this.issueLteCommand((String)this.options.get("tag"), (String[])this.options.get("lte-cmd"));
            if (this.options.containsKey("read")) {
                Thread.sleep(this.pc.responseTimeout().toMillis());
            }
            return;
        }
        boolean write = this.options.containsKey("write");
        if (!write && !this.options.containsKey("read")) {
            return;
        }
        GroupAddress main = (GroupAddress)this.options.get("dst");
        this.readWrite((Datapoint)new StateDP(main, "", 0, this.getDPT(main)), write, (String)this.options.get("value"));
    }

    private void readWrite(Datapoint dp, boolean write, String value) throws KNXException, InterruptedException {
        if (!write) {
            this.onReadResponse(dp, this.pc.read(dp));
        } else {
            if (dp.getDPT() == null) {
                System.out.println("cannot write to " + dp.getMainAddress() + " because DPT is not known yet, retry and specify DPT once");
                return;
            }
            this.pc.write(dp, value);
            System.out.println("write to " + dp.getMainAddress() + " successful");
        }
    }

    private void issueLteCommand(String addr, String ... s) throws KNXTimeoutException, KNXLinkClosedException {
        int svc;
        boolean info;
        if (s.length < 5) {
            System.out.println("LTE-HEE command: r|w|i address IOT OI [\"company\" company] PID [hex values]");
            return;
        }
        int iot = Integer.parseInt(s[2]);
        int oi = Integer.parseInt(s[3]);
        int privatePidOffset = "company".equals(s[4]) ? 2 : 0;
        int company = privatePidOffset > 0 ? Integer.parseInt(s[5]) : 0;
        int pid = Integer.parseInt(s[4 + privatePidOffset]);
        String data = String.join((CharSequence)"", Arrays.copyOfRange(s, 5 + privatePidOffset, s.length)).replaceAll("0x", "");
        String cmd = s[0];
        boolean read = cmd.equals("read") || cmd.equals("r");
        boolean write = cmd.equals("write") || cmd.equals("w");
        boolean bl = info = cmd.equals("info") || cmd.equals("i");
        int n = write ? 0 : (read ? 1 : (svc = info ? 2 : -1));
        if (svc == -1) {
            System.out.println("unknown command '" + cmd + "'");
            return;
        }
        if ((info || write) == data.isEmpty()) {
            System.out.println("data value(s) required for writing (but never for reading)!");
        } else {
            this.readWrite(svc, addr, iot, oi, company, pid, data);
        }
    }

    private void readWrite(int cmd, String tag, int iot, int oi, int company, int pid, String data) throws KNXTimeoutException, KNXLinkClosedException {
        int dataLen = data.length() / 2;
        int asduLen = 4 + (company > 0 ? 3 : 0) + dataLen;
        byte[] asdu = new byte[asduLen];
        int i = 0;
        asdu[i++] = (byte)(iot >> 8);
        asdu[i++] = (byte)iot;
        int sendOi = cmd == 1 ? 0 : oi;
        asdu[i++] = (byte)sendOi;
        if (company > 0) {
            asdu[i++] = -1;
            asdu[i++] = (byte)(company >> 8);
            asdu[i++] = (byte)company;
        }
        asdu[i++] = (byte)pid;
        if (data.length() % 2 != 0) {
            System.out.println("error writing [" + data + "]: data length has to be even");
            return;
        }
        for (int k = 0; k < data.length(); k += 2) {
            asdu[i++] = (byte)Integer.parseInt(data.substring(k, k + 2), 16);
        }
        int groupPropRead = 1000;
        int groupPropWrite = 1002;
        int groupPropInfo = 1003;
        int dataTagGroup = 4;
        int service = cmd == 0 ? 1002 : (cmd == 1 ? 1000 : 1003);
        byte[] tpdu = DataUnitBuilder.createAPDU((int)service, (byte[])asdu);
        tpdu[0] = (byte)(tpdu[0] | 4);
        LteHeeTag tagAddr = LteHeeTag.from((String)tag);
        boolean knxip = this.link.getKNXMedium().getMedium() == 32;
        boolean tp1 = this.link.getKNXMedium().getMedium() == 2;
        Priority priority = service == 1003 || service == 1002 ? Priority.NORMAL : Priority.LOW;
        boolean repeat = !knxip;
        boolean domainBroadcast = tp1;
        CEMILDataEx ldata = CEMILDataEx.newLte((int)(knxip ? 41 : 17), (IndividualAddress)KNXMediumSettings.BackboneRouter, (LteHeeTag)tagAddr, (byte[])tpdu, (Priority)priority, (boolean)repeat, (boolean)domainBroadcast, (boolean)false, (int)6);
        String svc = cmd == 0 ? "write" : (cmd == 1 ? "read" : "info");
        Object scmp = company > 0 ? " company " + company : "";
        Object sdata = data.length() > 0 ? " data [" + data + "]" : "";
        System.out.println("send LTE-HEE " + svc + " " + tag + " IOT " + iot + " OI " + sendOi + (String)scmp + " PID " + pid + (String)sdata);
        this.link.send((CEMILData)ldata, true);
    }

    private void checkForLteFrame(FrameEvent e) {
        CEMI cemi = e.getFrame();
        if (!(cemi instanceof CEMILDataEx)) {
            return;
        }
        try {
            CEMILDataEx f = (CEMILDataEx)cemi;
            byte[] data = f.toByteArray();
            int ctrl2 = data[3 + data[1]] & 0xFF;
            if ((ctrl2 & 4) == 0) {
                return;
            }
            byte[] tpdu = f.getPayload();
            this.onGroupEvent((ProcessEvent)new LteProcessEvent(this.pc, f.getSource(), ctrl2 & 0xF, (GroupAddress)f.getDestination(), tpdu));
        }
        catch (Exception ex) {
            out.error("decoding LTE frame", (Throwable)ex);
        }
    }

    protected String decodeLteFrame(LteProcessEvent e) throws KNXFormatException {
        return this.decodeLteFrame(e.getServiceCode(), e.extFrameFormat(), e.getDestination(), e.getASDU());
    }

    private String decodeLteFrame(int svcCode, int extFormat, GroupAddress dst, byte[] asdu) {
        Object v;
        StateDP dp;
        StringBuilder sb = new StringBuilder();
        LteHeeTag tag = LteHeeTag.from((int)extFormat, (GroupAddress)dst);
        sb.append(tag).append(' ');
        int iot = (asdu[0] & 0xFF) << 8 | asdu[1] & 0xFF;
        int ioi = asdu[2] & 0xFF;
        int pid = asdu[3] & 0xFF;
        byte[] data = Arrays.copyOfRange(asdu, pid == 255 ? 7 : 4, asdu.length);
        String value = HexFormat.of().formatHex(data);
        if (data.length > 0 && (dp = (StateDP)this.datapoints.get(dst)) != null) {
            String dpt = dp.getDPT();
            value = ProcComm.decodeDpValue(dpt, data, true).or(() -> ProcComm.decodeLteZDpValue(svcCode, dpt, data)).orElse(HexFormat.of().formatHex(data));
        }
        Object object = v = value.isEmpty() ? "" : ": " + value;
        if (pid == 255) {
            int companyCode = (asdu[4] & 0xFF) << 8 | asdu[5] & 0xFF;
            int privatePid = asdu[6] & 0xFF;
            sb.append("IOT ").append(iot).append(" OI ").append(ioi).append(" Company ").append(companyCode).append(" PID ").append(privatePid).append((String)v);
        } else {
            sb.append("IOT ").append(iot).append(" OI ").append(ioi).append(" PID ").append(pid).append((String)v);
        }
        return sb.toString();
    }

    private static Optional<String> decodeDpValue(String dpt, byte[] data, boolean withUnit) {
        try {
            DPTXlator t = TranslatorTypes.createTranslator((String)dpt, (byte[])data);
            t.setAppendUnit(withUnit);
            return Optional.of(t.getValue());
        }
        catch (KNXException | KNXIllegalArgumentException e) {
            return Optional.empty();
        }
    }

    private static Optional<String> decodeLteZDpValue(int svcCode, String dpt, byte[] data) {
        StdMode std = lteZToStdMode.get(dpt);
        if (std == null) {
            return Optional.empty();
        }
        Optional<String> opt = Optional.empty();
        if (!std.dptId.isEmpty()) {
            opt = ProcComm.decodeDpValue(std.dptId, Arrays.copyOfRange(data, 0, data.length - 1), std.withUnit);
        }
        if (std.f != null) {
            opt = Optional.of(std.f.apply(data, std.unit));
        }
        boolean write = svcCode == 1002;
        return opt.map(v -> write ? ProcComm.appendHvacCommand(v, data) : ProcComm.appendLteStatus(v, data));
    }

    private static String appendLteStatus(String prefix, byte[] data) {
        try {
            DptXlator8BitSet status = new DptXlator8BitSet((DPT)DptXlator8BitSet.DptGeneralStatus);
            status.setData(data, data.length - 1);
            return prefix + (String)(status.getNumericValue() == 0.0 ? "" : " (" + status.getValue() + ")");
        }
        catch (KNXFormatException e) {
            return prefix;
        }
    }

    private static String appendHvacCommand(String prefix, byte[] data) {
        try {
            DPTXlator8BitEnum cmd = new DPTXlator8BitEnum("20.60104");
            cmd.setData(data, data.length - 1);
            return prefix + " (" + cmd.getValue() + ")";
        }
        catch (KNXFormatException e) {
            return prefix;
        }
    }

    private static String decodeAsduByLength(byte[] asdu, boolean optimized) {
        StringBuilder sb = new StringBuilder();
        List typesBySize = TranslatorTypes.getMainTypesBySize((int)(optimized ? 0 : asdu.length));
        Iterator i = typesBySize.iterator();
        while (i.hasNext()) {
            TranslatorTypes.MainType main = (TranslatorTypes.MainType)i.next();
            try {
                String dptid = (String)main.getSubTypes().keySet().iterator().next();
                DPTXlator t = TranslatorTypes.createTranslator((int)main.getMainNumber(), (String)dptid);
                t.setData(asdu);
                sb.append(t.getValue()).append(" [").append(dptid).append("]").append(i.hasNext() ? ", " : "");
            }
            catch (KNXException | KNXIllegalArgumentException throwable) {}
        }
        return sb.toString();
    }

    private void runMonitorLoop() throws IOException, InterruptedException {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in, Charset.defaultCharset()));
        while (true) {
            if (!in.ready() && !this.closed) {
                Thread.sleep(250L);
                continue;
            }
            if (this.closed) break;
            String line = in.readLine();
            if (line == null) continue;
            try {
                this.issueCommand(line);
            }
            catch (KNXTimeoutException e) {
                ProcComm.out(e.getMessage());
            }
            catch (RuntimeException | KNXException e) {
                out.error("[{}] {}", (Object)line, (Object)e.toString());
            }
        }
    }

    private void loadDatapoints() {
        if (this.options.containsKey("datapoints")) {
            this.loadDatapoints((String)this.options.get("datapoints"));
        } else if (Files.exists(Path.of(toolDatapointsFile, new String[0]), new LinkOption[0])) {
            this.loadDatapoints(toolDatapointsFile);
        }
    }

    private void loadDatapoints(String dpResource) {
        try (XmlReader r = XmlInputFactory.newInstance().createXMLReader(dpResource);){
            this.datapoints.load(r);
        }
        catch (KNXMLException e) {
            out.info("failed to load datapoint information from {}: {}", (Object)dpResource, (Object)e.getMessage());
        }
    }

    private void saveDatapoints() {
        boolean possiblyModified;
        if (this.options.containsKey("datapoints")) {
            return;
        }
        boolean bl = possiblyModified = this.options.containsKey("monitor") || this.options.containsKey("dpt");
        if (((DatapointMap)this.datapoints).getDatapoints().isEmpty() || !possiblyModified) {
            return;
        }
        try (XmlWriter w = XmlOutputFactory.newInstance().createXMLWriter(toolDatapointsFile);){
            this.datapoints.save(w);
        }
        catch (KNXMLException e) {
            out.warn("on saving datapoint information to " + toolDatapointsFile, (Throwable)e);
        }
    }

    private void parseOptions(String[] args) {
        if (args.length == 0) {
            this.options.put("about", ProcComm::showToolInfo);
            return;
        }
        this.options.put("port", 3671);
        this.options.put("medium", new TPSettings());
        boolean lte = false;
        Main.PeekingIterator<String> i = new Main.PeekingIterator<String>(List.of(args).iterator());
        while (i.hasNext()) {
            String arg = i.next();
            if (Main.isOption(arg, "help", "h")) {
                this.options.put("about", ProcComm::showUsage);
                return;
            }
            if (Main.parseCommonOption(arg, i, this.options) || Main.parseSecureOption(arg, i, this.options)) continue;
            if (Main.isOption(arg, "compact", "c")) {
                this.options.put("compact", null);
                continue;
            }
            if (lte || Main.isOption(arg, "lte", null)) {
                lte = false;
                this.options.put("lte", null);
                if (!this.options.containsKey("tag")) continue;
                ArrayList<String> list = new ArrayList<String>();
                list.add(this.options.containsKey("read") ? "read" : (this.options.containsKey("write") ? "write" : "info"));
                list.add((String)this.options.get("tag"));
                list.add(arg);
                list.add(i.next());
                if ("company".equals(i.peek())) {
                    list.add(i.next());
                    list.add(i.next());
                }
                list.add(i.next());
                if (this.options.containsKey("write") || this.options.containsKey("info")) {
                    list.add(i.next());
                }
                this.options.put("lte-cmd", list.toArray(new String[0]));
                continue;
            }
            if (arg.equals("read")) {
                if (!i.hasNext()) break;
                this.options.put("read", null);
                lte = this.checkLte(i);
                if (lte) continue;
                try {
                    this.options.put("dst", new GroupAddress(i.next()));
                }
                catch (KNXFormatException e) {
                    throw new KNXIllegalArgumentException("read datapoint: " + e.getMessage());
                }
                if (!i.hasNext()) continue;
                if ("-".equals(i.peek())) {
                    i.next();
                    continue;
                }
                if (!ProcComm.isDpt(i.peek())) continue;
                this.options.put("dpt", i.next());
                continue;
            }
            if (arg.equals("write")) {
                if (!i.hasNext()) break;
                this.options.put("write", null);
                lte = this.checkLte(i);
                if (lte) continue;
                try {
                    this.options.put("dst", new GroupAddress(i.next()));
                }
                catch (KNXFormatException e) {
                    throw new KNXIllegalArgumentException("write datapoint: " + e.getMessage());
                }
                if ("-".equals(i.peek())) {
                    i.next();
                } else if (ProcComm.isDpt(i.peek())) {
                    this.options.put("dpt", i.next());
                }
                String value = i.next();
                this.options.put("value", value);
                if (!ProcComm.isTwoPartValue(value)) continue;
                this.options.put("value", value + " " + i.next());
                continue;
            }
            if (arg.equals("info")) {
                if (!i.hasNext()) break;
                this.options.put("info", null);
                lte = this.checkLte(i);
                continue;
            }
            if (arg.equals("monitor")) {
                this.options.put("monitor", null);
                continue;
            }
            if (Main.isOption(arg, "sn", null)) {
                this.options.put("sn", SerialNumber.of((long)Long.decode(i.next())));
                continue;
            }
            if (Main.isOption(arg, "knx-address", "k")) {
                this.options.put("knx-address", Main.getAddress(i.next()));
                continue;
            }
            if (Main.isOption(arg, "timeout", "t")) {
                this.options.put("timeout", Duration.ofSeconds(Integer.decode(i.next()).intValue()));
                continue;
            }
            if (Main.isOption(arg, "datapoints", null)) {
                this.options.put("datapoints", i.next());
                continue;
            }
            if (!this.options.containsKey("host")) {
                this.options.put("host", arg);
                continue;
            }
            throw new KNXIllegalArgumentException("unknown option " + arg);
        }
        if (this.options.containsKey("usb") && !this.options.containsKey("host")) {
            this.options.put("host", "");
        }
        if (!this.options.containsKey("host") || this.options.containsKey("ft12") && this.options.containsKey("usb")) {
            throw new KNXIllegalArgumentException("specify either IP host, serial port, or device");
        }
        if (!(this.options.containsKey("monitor") || this.options.containsKey("read") || this.options.containsKey("write") || this.options.containsKey("info"))) {
            throw new KNXIllegalArgumentException("specify read, write, or group monitoring");
        }
        if (this.options.containsKey("read") && this.options.containsKey("write")) {
            throw new KNXIllegalArgumentException("either read or write - not both");
        }
        Main.setDomainAddress(this.options);
        this.setRfDeviceSettings();
    }

    private boolean checkLte(Main.PeekingIterator<String> i) {
        if ("--lte".equals(i.peek())) {
            i.next();
            this.options.put("tag", i.next());
            return true;
        }
        if (this.options.containsKey("lte")) {
            this.options.put("tag", i.next());
            return true;
        }
        return false;
    }

    private void setRfDeviceSettings() {
        SerialNumber sn = (SerialNumber)this.options.get("sn");
        if (sn == null) {
            return;
        }
        KNXMediumSettings medium = (KNXMediumSettings)this.options.get("medium");
        if (medium.getMedium() != 16) {
            throw new KNXIllegalArgumentException(medium.getMediumString() + " networks don't use serial number, use --medium to specify KNX RF");
        }
        RFSettings rf = (RFSettings)medium;
        IndividualAddress device = (IndividualAddress)this.options.getOrDefault("knx-address", rf.getDeviceAddress());
        this.options.put("medium", new RFSettings(device, rf.getDomainAddress(), sn, rf.isUnidirectional()));
    }

    private static boolean isDpt(String s) {
        if (s.startsWith("-")) {
            return false;
        }
        String id = Main.fromDptName(s);
        String regex = "[0-9][0-9]*\\.[0-9][0-9][0-9]";
        return Pattern.matches("[0-9][0-9]*\\.[0-9][0-9][0-9]", id);
    }

    private static boolean isTwoPartValue(String value) {
        return List.of("decrease", "increase", "up", "down").contains(value);
    }

    private static void showToolInfo() {
        ProcComm.out("ProcComm - KNX process communication & group monitor");
        Main.showVersion();
        ProcComm.out("Type --help for help message");
    }

    private static void showUsage() {
        StringJoiner joiner = new StringJoiner(sep);
        joiner.add("Usage: ProcComm [options] <host|port> <command>");
        joiner.add(Main.printCommonOptions());
        joiner.add("  --compact -c               show incoming indications in compact format");
        joiner.add("  --lte                      enable LTE commands, decode LTE messages");
        joiner.add(Main.printSecureOptions());
        ProcComm.listCommandsAndDptAliases(joiner, true);
        ProcComm.out(joiner);
    }

    private static StringJoiner listCommandsAndDptAliases(StringJoiner joiner, boolean showMonitor) {
        joiner.add("Available commands for process communication:");
        joiner.add("  (read/write: omitting the DPT might require a '-' placeholder to avoid ambiguity)");
        joiner.add("  read  <KNX group address> [DPT]          read from datapoint (expecting the specified datapoint type)");
        joiner.add("  write <KNX group address> [DPT] <value>  write to datapoint (value formatted for specified datapoint type)");
        if (showMonitor) {
            joiner.add("  monitor                                  enter group monitoring");
        }
        joiner.add("Name aliases for common datapoint types:");
        joiner.add("  1.001: switch {off, on}                         1.002: bool {false, true}").add("  3.007: dimmer {decrease 0..7, increase 0..7}    3.008: blinds {up 0..7, down 0..7}").add("  5.001: percent {1..100} or % {1..100}").add("  5.003: angle {0..360}                           5.010: ucount {0..255}").add("  9.001: temp {-273..+670760}                    13.001: int (2-byte integer)").add("  9.002: float/float2 (2-byte float)             14.005: float4 (4-byte float)").add(" 16.001: string (ISO-8859-1, max. length 14)");
        return joiner;
    }

    private static void out(Object s) {
        System.out.println(s);
    }

    private static String twoByteUnsigned(byte[] data, String unit) {
        int v = (data[0] & 0xFF) << 8 | data[1] & 0xFF;
        return v + " " + unit;
    }

    private static String twoByteUnsigned10Millis(byte[] data, String unit) {
        int v = (data[0] & 0xFF) << 8 | data[1] & 0xFF;
        double d = (double)v / 100.0;
        return d + " " + unit;
    }

    private static String twoByteUnsigned50Millis(byte[] data, String unit) {
        int v = (data[0] & 0xFF) << 8 | data[1] & 0xFF;
        double d = (double)v / 20.0;
        return d + " " + unit;
    }

    private static String twoByteSigned(byte[] data, String unit) {
        int v = (short)(data[0] & 0xFF) << 8 | data[1] & 0xFF;
        return v + " " + unit;
    }

    private static String twoByteSigned20Millis(byte[] data, String unit) {
        int v = (short)(data[0] & 0xFF) << 8 | data[1] & 0xFF;
        double d = (double)v / 50.0;
        return d + " " + unit;
    }

    private static String fourByteSigned(byte[] data, String unit) {
        int v = (data[0] & 0xFF) << 24 | (data[1] & 0xFF) << 16 | (data[2] & 0xFF) << 8 | data[3] & 0xFF;
        return v + " " + unit;
    }

    private static String fourByteSigned0001(byte[] data, String unit) {
        int v = (data[0] & 0xFF) << 24 | (data[1] & 0xFF) << 16 | (data[2] & 0xFF) << 8 | data[3] & 0xFF;
        double d = (double)v / 10000.0;
        return d + " " + unit;
    }

    private final class ShutdownHandler
    extends Thread {
        private ShutdownHandler() {
        }

        ShutdownHandler register() {
            Runtime.getRuntime().addShutdownHook(this);
            return this;
        }

        void unregister() {
            try {
                Runtime.getRuntime().removeShutdownHook(this);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            ProcComm.this.quit();
        }
    }

    private static final class StdMode {
        private final BiFunction<byte[], String, String> f;
        private final String unit;
        private final String dptId;
        private final boolean withUnit;

        private StdMode(BiFunction<byte[], String, String> f, String unit) {
            this.f = f;
            this.unit = unit;
            this.dptId = "";
            this.withUnit = true;
        }

        private StdMode(String dptId, boolean withUnit) {
            this.dptId = dptId;
            this.withUnit = withUnit;
            this.f = null;
            this.unit = null;
        }

        static StdMode function(BiFunction<byte[], String, String> f, String unit) {
            return new StdMode(f, unit);
        }

        static StdMode xlator(String dptId) {
            return new StdMode(dptId, true);
        }

        static StdMode xlatorDimensionless(String dptId) {
            return new StdMode(dptId, false);
        }
    }
}

