/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.tools;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.TreeSet;
import java.util.stream.Collectors;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.link.KNXNetworkLink;
import tuwien.auto.calimero.link.medium.TPSettings;
import tuwien.auto.calimero.mgmt.LocalDeviceManagementIp;
import tuwien.auto.calimero.mgmt.ManagementProceduresImpl;
import tuwien.auto.calimero.mgmt.PropertyAdapter;
import tuwien.auto.calimero.mgmt.PropertyClient;
import tuwien.auto.calimero.tools.Json;
import tuwien.auto.calimero.tools.Main;

public class ProgMode
implements Runnable {
    private static final String tool = "ProgMode";
    private static final String sep = System.lineSeparator();
    private final Map<String, Object> options = new HashMap<String, Object>();

    public ProgMode(String[] args) {
        try {
            this.parseOptions(args);
        }
        catch (KNXIllegalArgumentException e) {
            throw e;
        }
        catch (RuntimeException | KNXFormatException e) {
            throw new KNXIllegalArgumentException(e.getMessage(), e);
        }
    }

    public static void main(String ... args) {
        try {
            new ProgMode(args).run();
        }
        catch (Throwable t) {
            ProgMode.out((CharSequence)("error parsing arguments (use --help): " + t), new Throwable[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (this.options.containsKey("about")) {
            ((Runnable)this.options.get("about")).run();
            return;
        }
        Throwable thrown = null;
        boolean canceled = false;
        try {
            if (this.options.containsKey("localDevMgmt")) {
                this.knxipServerProgMode();
            } else {
                this.progMode();
            }
        }
        catch (RuntimeException | KNXException e) {
            thrown = e;
        }
        catch (InterruptedException e) {
            canceled = true;
            Thread.currentThread().interrupt();
        }
        finally {
            this.onCompletion((Exception)thrown, canceled);
        }
    }

    private void knxipServerProgMode() throws KNXException, InterruptedException {
        try (LocalDeviceManagementIp devmgmt = Main.newLocalDeviceMgmtIP(this.options, closed -> {});
             PropertyClient pc = new PropertyClient((PropertyAdapter)devmgmt);){
            String cmd = (String)this.options.get("command");
            if ("status".equals(cmd)) {
                byte[] subnetAddr = pc.getProperty(0, 57, 1, 1);
                byte[] deviceAddr = pc.getProperty(0, 58, 1, 1);
                IndividualAddress server = new IndividualAddress(new byte[]{subnetAddr[0], deviceAddr[0]});
                while (true) {
                    byte[] progmode;
                    if ((progmode = pc.getProperty(0, 54, 1, 1))[0] == 1) {
                        this.devicesInProgMode(server);
                    } else {
                        this.devicesInProgMode(new IndividualAddress[0]);
                    }
                    Thread.sleep(3000L);
                }
            }
            boolean progmode = "on".equals(cmd);
            pc.setProperty(0, 54, 1, 1, new byte[]{(byte)(progmode ? 1 : 0)});
            byte[] check = pc.getProperty(0, 54, 1, 1);
            ProgMode.out((CharSequence)("Programming mode " + (check[0] == 1 ? "active" : "inactive")), new Throwable[0]);
        }
    }

    private void progMode() throws KNXException, InterruptedException {
        try (KNXNetworkLink link = this.createLink();
             ManagementProceduresImpl mgmt = new ManagementProceduresImpl(link);){
            String cmd = (String)this.options.get("command");
            if ("status".equals(cmd)) {
                if (!this.options.containsKey("json")) {
                    ProgMode.out((CharSequence)"Device(s) in programming mode ...", false);
                }
                while (true) {
                    this.devicesInProgMode(mgmt.readAddress());
                }
            }
            IndividualAddress device = (IndividualAddress)this.options.get("device");
            mgmt.setProgrammingMode(device, "on".equals(cmd));
        }
    }

    protected void devicesInProgMode(IndividualAddress ... devices) {
        if (this.options.containsKey("json")) {
            record JsonDevices(IndividualAddress[] devices) implements Json
            {
            }
            ProgMode.out((CharSequence)new JsonDevices(devices).toJson(), new Throwable[0]);
            return;
        }
        String output = devices.length == 0 ? "none" : new TreeSet<IndividualAddress>(Arrays.asList(devices)).stream().map(Objects::toString).collect(Collectors.joining(", "));
        ProgMode.out((CharSequence)("\u001b[2K\rDevice(s) in programming mode: " + output + "\t\t"), false);
    }

    protected void onCompletion(Exception thrown, boolean canceled) {
        if (canceled) {
            ProgMode.out((CharSequence)"ProgMode got canceled", new Throwable[0]);
        }
        if (thrown != null) {
            ProgMode.out((CharSequence)"ProgMode error", thrown);
        }
    }

    private KNXNetworkLink createLink() throws KNXException, InterruptedException {
        return Main.newLink(this.options);
    }

    private void parseOptions(String[] args) throws KNXFormatException {
        if (args.length == 0) {
            this.options.put("about", ProgMode::showToolInfo);
            return;
        }
        this.options.put("port", 3671);
        this.options.put("medium", new TPSettings());
        boolean setmode = false;
        Iterator<String> i = List.of(args).iterator();
        while (i.hasNext()) {
            String arg = i.next();
            if (Main.isOption(arg, "help", "h")) {
                this.options.put("about", ProgMode::showUsage);
                return;
            }
            if (Main.parseCommonOption(arg, i, this.options) || Main.parseSecureOption(arg, i, this.options)) continue;
            if (Main.isOption(arg, "knx-address", "k")) {
                this.options.put("knx-address", Main.getAddress(i.next()));
                continue;
            }
            if (Main.isOption(arg, "local", null)) {
                this.options.put("localDevMgmt", null);
                continue;
            }
            if (arg.equals("on") || arg.equals("off")) {
                this.options.put("command", arg);
                setmode = true;
                continue;
            }
            if (setmode) {
                this.options.put("device", new IndividualAddress(arg));
                setmode = false;
                continue;
            }
            if (!this.options.containsKey("host")) {
                this.options.put("host", arg);
                continue;
            }
            this.options.put("device", new IndividualAddress(arg));
        }
        if (this.options.containsKey("usb") && !this.options.containsKey("host")) {
            this.options.put("host", "");
        }
        if (!this.options.containsKey("host")) {
            throw new KNXIllegalArgumentException("no communication device/host specified");
        }
        if (this.options.containsKey("ft12") && !this.options.containsKey("remote")) {
            throw new KNXIllegalArgumentException("--remote option is mandatory with --ft12");
        }
        if (this.options.containsKey("localDevMgmt")) {
            if (this.options.containsKey("device")) {
                throw new KNXIllegalArgumentException("local device management does not need a KNX device address");
            }
        } else if (this.options.containsKey("command") != this.options.containsKey("device")) {
            throw new KNXIllegalArgumentException("setting programming mode requires mode and KNX device address");
        }
        this.options.putIfAbsent("command", "status");
        Main.setDomainAddress(this.options);
    }

    private static void showToolInfo() {
        ProgMode.out((CharSequence)"ProgMode - Check/set device(s) in programming mode", new Throwable[0]);
        Main.showVersion();
        ProgMode.out((CharSequence)"Use --help for help message", new Throwable[0]);
    }

    private static void showUsage() {
        StringJoiner joiner = new StringJoiner(sep);
        joiner.add("Usage: ProgMode [options] <host|port> [on|off [<device address>]]");
        joiner.add(Main.printCommonOptions());
        joiner.add("  --local                    use local device management");
        joiner.add(Main.printSecureOptions());
        joiner.add("Commands (local device management does not need a device address):");
        joiner.add("  on  [<device address>]     switch programming mode on");
        joiner.add("  off [<device address>]     switch programming mode off");
        ProgMode.out((CharSequence)joiner.toString(), new Throwable[0]);
    }

    private static void out(CharSequence s, Throwable ... t) {
        if (t.length > 0 && t[0] != null) {
            System.out.print(s + ": ");
            t[0].printStackTrace();
        } else {
            System.out.println(s);
        }
    }

    private static void out(CharSequence s, boolean newline) {
        if (newline) {
            System.out.println(s);
        } else {
            System.out.print(s);
            System.out.flush();
        }
    }
}

