/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.nio.charset.Charset;
import tuwien.auto.calimero.log.LogService;
import tuwien.auto.calimero.tools.Property;

public class PropClient
implements Runnable {
    private final PropertyEx property;

    public PropClient(String[] args) {
        this.property = new PropertyEx(args);
    }

    public static void main(String ... args) {
        Property.out = LogService.getLogger((String)"calimero.tools");
        try {
            PropClient pc = new PropClient(args);
            pc.run();
        }
        catch (Throwable t) {
            Property.out.error("client error", t);
        }
    }

    @Override
    public void run() {
        this.property.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String[] readLine(BufferedReader r) throws IOException, InterruptedException {
        System.out.print("> ");
        PropClient propClient = this;
        synchronized (propClient) {
            while (this.property.pc.isOpen() && !r.ready()) {
                this.wait(100L);
            }
        }
        String line = r.readLine();
        return line != null ? line.trim().split("\\s") : null;
    }

    class PropertyEx
    extends Property {
        PropertyEx(String[] args) {
            super(args);
        }

        @Override
        protected void runCommand(String ... cmd) throws InterruptedException {
            this.options.remove("command");
            super.runCommand("?");
            PropertyEx.out("exit - close connection and exit");
            this.runReaderLoop(PropClient.this);
        }

        private void runReaderLoop(PropClient propClient) {
            BufferedReader r = new BufferedReader(new InputStreamReader(System.in, Charset.defaultCharset()));
            try {
                String[] args;
                while ((args = propClient.readLine(r)) != null) {
                    if (args.length <= 0 || args.length == 1 && args[0].isEmpty()) continue;
                    if (!"exit".equalsIgnoreCase(args[0])) {
                        super.runCommand(args);
                        continue;
                    }
                    break;
                }
            }
            catch (InterruptedIOException | InterruptedException e) {
                System.out.println("received interrupt, closing ...");
            }
            catch (IOException e) {
                System.out.println("I/O error, " + e.getMessage());
            }
        }
    }
}

