/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.tools;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tuwien.auto.calimero.DeviceDescriptor;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.link.KNXNetworkLink;
import tuwien.auto.calimero.link.medium.TPSettings;
import tuwien.auto.calimero.mgmt.ManagementProceduresImpl;
import tuwien.auto.calimero.tools.Json;
import tuwien.auto.calimero.tools.Main;

public class ScanDevices
implements Runnable {
    private static final String tool = "ScanDevices";
    private static final String sep = System.lineSeparator();
    private static Logger out = LoggerFactory.getLogger((String)"calimero.tools");
    private final Map<String, Object> options = new HashMap<String, Object>();

    public static void main(String ... args) {
        try {
            ScanDevices scan = new ScanDevices(args);
            Main.ShutdownHandler sh = new Main.ShutdownHandler().register();
            scan.run();
            sh.unregister();
        }
        catch (Throwable t) {
            out.error("parsing options", t);
        }
    }

    public ScanDevices(String[] args) {
        try {
            this.parseOptions(args);
        }
        catch (KNXIllegalArgumentException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new KNXIllegalArgumentException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Throwable thrown = null;
        boolean canceled = false;
        try {
            if (this.options.isEmpty()) {
                ScanDevices.out("ScanDevices - Determine existing KNX devices on a KNX subnetwork");
                Main.showVersion();
                ScanDevices.out("Type --help for help message");
                return;
            }
            if (this.options.containsKey("about")) {
                ((Runnable)this.options.get("about")).run();
                return;
            }
            try (KNXNetworkLink link = this.createLink();
                 ManagementProceduresImpl mp = new ManagementProceduresImpl(link);){
                int[] lines;
                String[] range = ((String)this.options.get("range")).split("\\.", 0);
                int area = Integer.decode(range[0]);
                if (range.length > 1) {
                    int[] nArray = new int[1];
                    v1 = nArray;
                    nArray[0] = Integer.decode(range[1]);
                } else {
                    v1 = lines = IntStream.range(0, 16).toArray();
                }
                if (range.length == 3) {
                    int device = Integer.decode(range[2]);
                    IndividualAddress addr = new IndividualAddress(area, lines[0], device);
                    if (mp.isAddressOccupied(addr)) {
                        this.onDeviceFound(addr);
                    }
                } else {
                    for (int line : lines) {
                        ScanDevices.out("start scan of " + area + "." + line + ".[0..255] ...");
                        mp.scanNetworkDevices(area, line, this::onDeviceFound, this::onDeviceFound);
                    }
                }
            }
        }
        catch (RuntimeException | KNXException e) {
            thrown = e;
        }
        catch (InterruptedException e) {
            canceled = true;
            Thread.currentThread().interrupt();
        }
        finally {
            this.onCompletion((Exception)thrown, canceled);
        }
    }

    private KNXNetworkLink createLink() throws KNXException, InterruptedException {
        return Main.newLink(this.options);
    }

    protected void onDeviceFound(IndividualAddress device) {
        if (this.options.containsKey("requireDD0")) {
            return;
        }
        if (this.options.containsKey("json")) {
            ScanDevices.out(new JsonDevice((String)this.options.get("range"), device, null).toJson());
        } else {
            ScanDevices.out(device);
        }
    }

    protected void onDeviceFound(IndividualAddress device, DeviceDescriptor.DD0 dd0) {
        if (!this.options.containsKey("requireDD0")) {
            return;
        }
        if (this.options.containsKey("json")) {
            ScanDevices.out(new JsonDevice((String)this.options.get("range"), device, dd0).toJson());
        } else {
            ScanDevices.out(device + " (DD0 " + dd0 + ")");
        }
    }

    protected void onCompletion(Exception thrown, boolean canceled) {
        if (canceled) {
            out.info("scanning for devices canceled");
        }
        if (thrown != null) {
            out.error("completed with error", (Throwable)thrown);
        }
    }

    private void parseOptions(String[] args) {
        if (args.length == 0) {
            return;
        }
        this.options.put("port", 3671);
        this.options.put("medium", new TPSettings());
        Iterator<String> i = List.of(args).iterator();
        while (i.hasNext()) {
            String arg = i.next();
            if (Main.isOption(arg, "help", "h")) {
                this.options.put("about", ScanDevices::showUsage);
                return;
            }
            if (Main.parseCommonOption(arg, i, this.options) || Main.parseSecureOption(arg, i, this.options)) continue;
            if (Main.isOption(arg, "knx-address", "k")) {
                this.options.put("knx-address", Main.getAddress(i.next()));
                continue;
            }
            if (Main.isOption(arg, "dd", null)) {
                this.options.put("requireDD0", arg);
                continue;
            }
            if (!this.options.containsKey("host")) {
                this.options.put("host", arg);
                continue;
            }
            if (!this.options.containsKey("range")) {
                this.options.put("range", arg);
                continue;
            }
            throw new KNXIllegalArgumentException("unknown option " + arg);
        }
        if (this.options.containsKey("usb") && !this.options.containsKey("host")) {
            this.options.put("host", "");
        }
        if (!this.options.containsKey("host")) {
            throw new KNXIllegalArgumentException("specify either IP host, serial port, or device");
        }
        if (!this.options.containsKey("range")) {
            throw new KNXIllegalArgumentException("Missing area.line range to scan for devices");
        }
        Main.setDomainAddress(this.options);
    }

    private static void showUsage() {
        StringJoiner joiner = new StringJoiner(sep);
        joiner.add("Usage: ScanDevices [options] <host|port> <area[.line[.device]]>");
        joiner.add("The area and line are given as numbers in the range [0..15], e.g., 3.1");
        joiner.add("The (optional) device address part is in the range [0..255], e.g., 1.1.209");
        joiner.add(Main.printCommonOptions());
        joiner.add("  --dd                       require response with device descriptor");
        joiner.add(Main.printSecureOptions());
        ScanDevices.out(joiner.toString());
    }

    private static void out(Object s) {
        System.out.println(s);
    }

    private record JsonDevice(String range, IndividualAddress device, DeviceDescriptor.DD0 dd0) implements Json
    {
    }
}

