/*
 * Decompiled with CFR 0.152.
 */
package tuwien.auto.calimero.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.HashMap;
import java.util.HexFormat;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import org.slf4j.Logger;
import tuwien.auto.calimero.DataUnitBuilder;
import tuwien.auto.calimero.FrameEvent;
import tuwien.auto.calimero.GroupAddress;
import tuwien.auto.calimero.IndividualAddress;
import tuwien.auto.calimero.KNXAddress;
import tuwien.auto.calimero.KNXException;
import tuwien.auto.calimero.KNXFormatException;
import tuwien.auto.calimero.KNXIllegalArgumentException;
import tuwien.auto.calimero.Priority;
import tuwien.auto.calimero.SerialNumber;
import tuwien.auto.calimero.cemi.CEMI;
import tuwien.auto.calimero.cemi.CEMILData;
import tuwien.auto.calimero.cemi.CEMILDataEx;
import tuwien.auto.calimero.datapoint.Datapoint;
import tuwien.auto.calimero.datapoint.DatapointMap;
import tuwien.auto.calimero.datapoint.DatapointModel;
import tuwien.auto.calimero.datapoint.StateDP;
import tuwien.auto.calimero.dptxlator.DPTXlator;
import tuwien.auto.calimero.dptxlator.TranslatorTypes;
import tuwien.auto.calimero.knxnetip.LostMessageEvent;
import tuwien.auto.calimero.knxnetip.RoutingBusyEvent;
import tuwien.auto.calimero.knxnetip.servicetype.TunnelingFeature;
import tuwien.auto.calimero.link.KNXNetworkLink;
import tuwien.auto.calimero.link.LinkEvent;
import tuwien.auto.calimero.link.NetworkLinkListener;
import tuwien.auto.calimero.link.medium.KNXMediumSettings;
import tuwien.auto.calimero.link.medium.RFSettings;
import tuwien.auto.calimero.link.medium.TPSettings;
import tuwien.auto.calimero.log.LogService;
import tuwien.auto.calimero.tools.Json;
import tuwien.auto.calimero.tools.Main;
import tuwien.auto.calimero.tools.NetworkMonitor;
import tuwien.auto.calimero.xml.KNXMLException;
import tuwien.auto.calimero.xml.XmlInputFactory;
import tuwien.auto.calimero.xml.XmlReader;

public class TrafficMonitor
implements Runnable {
    private static final String tool = MethodHandles.lookup().lookupClass().getSimpleName();
    private static final Logger out = LogService.getLogger((String)("calimero.tools." + tool));
    private final Map<String, Object> options = new HashMap<String, Object>();
    private final DatapointModel<StateDP> datapoints = new DatapointMap();
    private KNXNetworkLink link;

    public TrafficMonitor(String[] args) {
        try {
            this.parseOptions(args);
        }
        catch (KNXIllegalArgumentException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw new KNXIllegalArgumentException(e.getMessage(), (Throwable)e);
        }
    }

    public static void main(String ... args) {
        try {
            TrafficMonitor pc = new TrafficMonitor(args);
            Main.ShutdownHandler sh = new Main.ShutdownHandler().register();
            pc.run();
            sh.unregister();
        }
        catch (Throwable t) {
            out.error("tool options", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        Throwable thrown = null;
        boolean canceled = false;
        try {
            this.start();
            if (this.options.containsKey("about")) {
                return;
            }
            this.loadDatapoints();
            this.runMonitorLoop();
        }
        catch (IOException | RuntimeException | KNXException e) {
            thrown = e;
        }
        catch (InterruptedException e) {
            canceled = true;
            Thread.currentThread().interrupt();
        }
        finally {
            this.quit();
            this.onCompletion((Exception)thrown, canceled);
        }
    }

    private void start() throws KNXException, InterruptedException {
        if (this.options.containsKey("about")) {
            ((Runnable)this.options.get("about")).run();
            return;
        }
        this.link = Main.newLink(this.options);
        this.link.addLinkListener(new NetworkLinkListener(){

            public void indication(FrameEvent e) {
                TrafficMonitor.this.onFrameEvent(e);
            }

            public void confirmation(FrameEvent e) {
                TrafficMonitor.this.onFrameEvent(e);
            }

            @LinkEvent
            void routingBusy(RoutingBusyEvent e) {
                TrafficMonitor.outTimestamped(e.sender().getAddress().getHostAddress() + " sent " + e.get());
            }

            @LinkEvent
            void routingLostMessage(LostMessageEvent e) {
                TrafficMonitor.outTimestamped(e.getSender() + " lost " + e.getLostMessages() + " routing messages" + (e.isKNXFault() ? ", KNX network fault" : ""));
            }

            @LinkEvent
            void tunnelingFeature(TunnelingFeature feature) {
                TrafficMonitor.outTimestamped(feature.toString());
            }
        });
    }

    public void quit() {
        if (this.link != null) {
            this.link.close();
        }
    }

    protected void onCompletion(Exception thrown, boolean canceled) {
        if (canceled) {
            out.info("traffic monitor was stopped");
        }
        if (thrown != null) {
            out.error("completed with error", (Throwable)thrown);
        }
    }

    private String asString(byte[] asdu, int dptMainNumber, String dptID) throws KNXException {
        DPTXlator t = TranslatorTypes.createTranslator((int)dptMainNumber, (String)dptID);
        t.setData(asdu);
        return t.getValue();
    }

    private void onFrameEvent(FrameEvent e) {
        StringJoiner joiner;
        block12: {
            CEMI frame = e.getFrame();
            if (this.options.containsKey("json")) {
                System.out.println(TrafficMonitor.toJson(frame));
                return;
            }
            joiner = new StringJoiner(" ");
            if (frame instanceof CEMILData) {
                CEMILData ldata = (CEMILData)frame;
                KNXAddress dst = ldata.getDestination();
                byte[] payload = frame.getPayload();
                boolean compact = this.options.containsKey("compact");
                if (compact) {
                    joiner.add(ldata.getSource() + "->" + dst);
                } else {
                    joiner.add(frame.toString()).add("--");
                }
                joiner.add(DataUnitBuilder.decode((byte[])payload, (KNXAddress)dst));
                if (payload.length > 1) {
                    byte[] asdu = DataUnitBuilder.extractASDU((byte[])payload);
                    if (asdu.length > 0) {
                        joiner.add(HexFormat.ofDelimiter(" ").formatHex(asdu));
                    }
                    int apduSvc = DataUnitBuilder.getAPDUService((byte[])payload);
                    try {
                        if ((apduSvc & 0x3FC) == 1000) {
                            CEMILDataEx f = (CEMILDataEx)ldata;
                            byte[] data = f.toByteArray();
                            int ctrl2 = data[3 + data[1]] & 0xFF;
                            if ((ctrl2 & 4) != 0) {
                                int eff = ctrl2 & 0xF;
                                joiner.add(compact ? "" : ":");
                                joiner.add(TrafficMonitor.decodeLteFrame(eff, dst, asdu));
                            }
                            break block12;
                        }
                        if (asdu.length <= 0 || !(dst instanceof GroupAddress) || dst.getRawAddress() == 0) break block12;
                        Datapoint dp = this.datapoints.get((GroupAddress)dst);
                        joiner.add(compact ? "" : ":");
                        if (dp != null) {
                            joiner.add(this.asString(asdu, 0, dp.getDPT()));
                            break block12;
                        }
                        joiner.add(TrafficMonitor.decodeAsduByLength(asdu, payload.length == 2));
                    }
                    catch (RuntimeException | KNXException ex) {
                        out.info("error parsing group event {} {}", (Object)joiner, (Object)ex.toString());
                    }
                }
            } else {
                joiner.add(frame.toString());
            }
        }
        TrafficMonitor.outTimestamped(joiner.toString());
    }

    private static String toJson(CEMI frame) {
        if (frame instanceof CEMILData) {
            CEMILData ldata = (CEMILData)frame;
            byte[] payload = frame.getPayload();
            String tpci = "";
            String apci = "";
            byte[] asdu = null;
            if (payload.length > 1) {
                tpci = DataUnitBuilder.decodeTPCI((int)DataUnitBuilder.getTPDUService((byte[])payload), (KNXAddress)ldata.getDestination());
                apci = DataUnitBuilder.decodeAPCI((int)DataUnitBuilder.getAPDUService((byte[])payload));
                asdu = DataUnitBuilder.extractASDU((byte[])payload);
            }
            boolean extended = ldata instanceof CEMILDataEx;
            record JsonRawFrame(String svc, boolean extended, IndividualAddress src, KNXAddress dst, boolean repetition, int hopCount, Priority priority, boolean ack, boolean sysBcast, boolean con, String tpci, String apci, byte[] asdu) implements Json
            {
            }
            JsonRawFrame json = new JsonRawFrame(TrafficMonitor.svcPrimitive(ldata.getMessageCode()), extended, ldata.getSource(), ldata.getDestination(), ldata.isRepetition(), ldata.getHopCount(), ldata.getPriority(), ldata.isAckRequested(), ldata.isSystemBroadcast(), ldata.isPositiveConfirmation(), tpci, apci, asdu);
            record JsonTrafficEvent(Instant time, JsonRawFrame frame) implements Json
            {
                private final JsonRawFrame frame;

                JsonTrafficEvent(Instant time, JsonRawFrame frame) {
                    this.time = time;
                    this.frame = frame;
                }

                public JsonRawFrame frame() {
                    return this.frame;
                }
            }
            JsonTrafficEvent jsonTraffic = new JsonTrafficEvent(Instant.now(), json);
            return jsonTraffic.toJson();
        }
        out.debug("unsupported cEMI frame format " + frame);
        return null;
    }

    static String svcPrimitive(int msgCode) {
        return switch (msgCode) {
            case 43 -> "L_Busmon.ind";
            case 17 -> "L_Data.req";
            case 46 -> "L_Data.con";
            case 41 -> "L_Data.ind";
            case 16 -> "L_Raw.req";
            case 45 -> "L_Raw.ind";
            case 47 -> "L_Raw.con";
            case 19 -> "L_Poll_Data.req";
            case 37 -> "L_Poll_Data.con";
            case 65 -> "T_Data_Connected.req";
            case 137 -> "T_Data_Connected.ind";
            case 74 -> "T_Data_Individual.req";
            case 148 -> "T_Data_Individual.ind";
            default -> "0x" + Integer.toHexString(msgCode);
        };
    }

    private static String decodeLteFrame(int extFormat, KNXAddress dst, byte[] asdu) throws KNXFormatException {
        return NetworkMonitor.decodeLteFrame(extFormat, dst, asdu);
    }

    private static String decodeAsduByLength(byte[] asdu, boolean optimized) {
        StringJoiner joiner = new StringJoiner(", ");
        List typesBySize = TranslatorTypes.getMainTypesBySize((int)(optimized ? 0 : asdu.length));
        for (TranslatorTypes.MainType mainType : typesBySize) {
            try {
                String dptid = (String)mainType.getSubTypes().keySet().iterator().next();
                DPTXlator t = TranslatorTypes.createTranslator((int)mainType.getMainNumber(), (String)dptid);
                t.setData(asdu);
                joiner.add(t.getValue() + " [" + dptid + "]");
            }
            catch (KNXException | KNXIllegalArgumentException throwable) {}
        }
        return joiner.toString();
    }

    private void runMonitorLoop() throws IOException, InterruptedException {
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in, Charset.defaultCharset()));
        while (true) {
            if (!in.ready() && this.link.isOpen()) {
                Thread.sleep(250L);
                continue;
            }
            if (!this.link.isOpen()) break;
            String line = in.readLine();
            if (line == null) continue;
            String[] s = line.trim().split(" +");
            if (s.length == 1 && "exit".equalsIgnoreCase(s[0])) {
                return;
            }
            if (s.length == 1 && ("?".equals(s[0]) || "help".equals(s[0]))) {
                TrafficMonitor.out(TrafficMonitor.listCommands());
            }
            if (s.length <= 1) continue;
            String cmd = s[0];
            try {
                try {
                    GroupAddress ga = new GroupAddress(cmd);
                    String dpt = Main.fromDptName(s[1]);
                    StateDP dp = new StateDP(ga, "tmp", 0, dpt);
                    this.datapoints.remove((Datapoint)dp);
                    this.datapoints.add((Datapoint)dp);
                }
                catch (KNXFormatException e) {
                    TrafficMonitor.out("unknown command '" + cmd + "'");
                }
            }
            catch (RuntimeException e) {
                out.info("[{}] {}", (Object)line, (Object)e.toString());
            }
        }
    }

    private void loadDatapoints() {
        String datapointsFile = (String)this.options.get("datapoints");
        if (datapointsFile != null && Files.isRegularFile(Path.of(datapointsFile, new String[0]), new LinkOption[0])) {
            try (XmlReader r = XmlInputFactory.newInstance().createXMLReader(datapointsFile);){
                this.datapoints.load(r);
            }
            catch (KNXMLException e) {
                out.info("failed to load datapoint information from {}: {}", (Object)datapointsFile, (Object)e.getMessage());
            }
        }
    }

    private void parseOptions(String[] args) {
        if (args.length == 0) {
            this.options.put("about", TrafficMonitor::showToolInfo);
            return;
        }
        this.options.put("port", 3671);
        this.options.put("medium", new TPSettings());
        Main.PeekingIterator<String> i = new Main.PeekingIterator<String>(List.of(args).iterator());
        while (i.hasNext()) {
            String arg = i.next();
            if (Main.isOption(arg, "help", "h")) {
                this.options.put("about", TrafficMonitor::showUsage);
                return;
            }
            if (Main.parseCommonOption(arg, i, this.options) || Main.parseSecureOption(arg, i, this.options)) continue;
            if (Main.isOption(arg, "datapoints", null)) {
                this.options.put("datapoints", i.next());
                continue;
            }
            if (Main.isOption(arg, "compact", "c")) {
                this.options.put("compact", null);
                continue;
            }
            if (Main.isOption(arg, "timeout", "t")) {
                this.options.put("timeout", Duration.ofSeconds(Integer.decode(i.next()).intValue()));
                continue;
            }
            if (!this.options.containsKey("host")) {
                this.options.put("host", arg);
                continue;
            }
            throw new KNXIllegalArgumentException("unknown option " + arg);
        }
        if (this.options.containsKey("usb") && !this.options.containsKey("host")) {
            this.options.put("host", "");
        }
        if (!this.options.containsKey("host") || this.options.containsKey("ft12") && this.options.containsKey("usb")) {
            throw new KNXIllegalArgumentException("specify either IP host, serial port, or device");
        }
        Main.setDomainAddress(this.options);
        this.setRfDeviceSettings();
    }

    private void setRfDeviceSettings() {
        SerialNumber sn = (SerialNumber)this.options.get("sn");
        if (sn == null) {
            return;
        }
        KNXMediumSettings medium = (KNXMediumSettings)this.options.get("medium");
        if (medium.getMedium() != 16) {
            throw new KNXIllegalArgumentException(medium.getMediumString() + " networks don't use serial number, use --medium to specify KNX RF");
        }
        RFSettings rf = (RFSettings)medium;
        IndividualAddress device = (IndividualAddress)this.options.getOrDefault("knx-address", rf.getDeviceAddress());
        this.options.put("medium", new RFSettings(device, rf.getDomainAddress(), sn, rf.isUnidirectional()));
    }

    private static void showToolInfo() {
        TrafficMonitor.out(tool + " - KNX traffic monitor");
        Main.showVersion();
        TrafficMonitor.out("Type --help for help message");
    }

    private static void showUsage() {
        StringJoiner joiner = new StringJoiner(System.lineSeparator());
        joiner.add("Usage: " + tool + " [options] <host|port> <command>");
        joiner.add(Main.printCommonOptions());
        joiner.add("  --compact -c               show incoming indications in compact format");
        joiner.add(Main.printSecureOptions());
        joiner.add(TrafficMonitor.listCommands());
        TrafficMonitor.out(joiner);
    }

    private static String listCommands() {
        return "Available commands for filtering traffic: none";
    }

    private static void outTimestamped(String s) {
        TrafficMonitor.out(LocalTime.now().truncatedTo(ChronoUnit.MILLIS) + " " + String.join((CharSequence)"", s));
    }

    private static void out(Object s) {
        System.out.println(s);
    }
}

