/*
 * Decompiled with CFR 0.152.
 */
package com.github.cambierr.spring.session.couchbase;

import com.couchbase.client.java.document.json.JsonArray;
import com.couchbase.client.java.document.json.JsonObject;
import com.couchbase.client.java.repository.annotation.Field;
import com.couchbase.client.java.repository.annotation.Id;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Base64;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.springframework.data.couchbase.core.mapping.Document;
import org.springframework.session.ExpiringSession;

@Document
public class CouchbaseSession
implements ExpiringSession {
    public static final String COUCHBASE_PREFIX = "spring::session::";
    public static final int SESSION_DEFAULT_VALIDITY = 1800;
    protected static int SESSION_VALIDITY = 1800;
    @Id
    private String id;
    @Field
    private long created;
    @Field
    private long accessed;
    @Field
    private int interval;
    @Field
    private Map<String, Object> data;

    public static void setSessionValidity(int validity) {
        SESSION_VALIDITY = validity;
    }

    public CouchbaseSession() {
        this(1800);
    }

    protected CouchbaseSession(String id) {
        this.id = id;
    }

    public CouchbaseSession(int interval) {
        this(UUID.randomUUID().toString(), interval);
    }

    public CouchbaseSession(String _id, int interval) {
        this.id = _id;
        this.interval = interval;
        this.accessed = System.currentTimeMillis();
        this.data = new HashMap<String, Object>();
    }

    public long getCreationTime() {
        return this.created;
    }

    public void setLastAccessedTime(long lastAccessedTime) {
        this.accessed = lastAccessedTime;
    }

    public long getLastAccessedTime() {
        return this.accessed;
    }

    public void setMaxInactiveIntervalInSeconds(int interval) {
        this.interval = interval;
    }

    public int getMaxInactiveIntervalInSeconds() {
        return this.interval;
    }

    public boolean isExpired() {
        return System.currentTimeMillis() > this.accessed + (long)(1000 * this.interval);
    }

    public String getId() {
        return this.id;
    }

    protected long getCouchbaseExpiration() {
        return this.interval > 2592000 ? System.currentTimeMillis() / 1000L + (long)this.interval : (long)this.interval;
    }

    public <T> T getAttribute(String attributeName) {
        if (!this.data.containsKey(attributeName)) {
            return null;
        }
        Object o = this.data.get(attributeName);
        if (this.isSerialized(o)) {
            return (T)this.deserialize((SerializedItem)o);
        }
        return (T)o;
    }

    public Set<String> getAttributeNames() {
        return this.data.keySet();
    }

    private boolean isTypeValid(Object _object) {
        return _object == null || _object instanceof String || _object instanceof Integer || _object instanceof Long || _object instanceof Double || _object instanceof Boolean || _object instanceof JsonObject || _object instanceof JsonArray;
    }

    public void setAttribute(String attributeName, Object attributeValue) {
        if (this.isTypeValid(attributeValue)) {
            this.data.put(attributeName, attributeValue);
        } else {
            this.data.put(attributeName, this.serialize(attributeValue));
        }
    }

    public void removeAttribute(String attributeName) {
        this.data.remove(attributeName);
    }

    private SerializedItem serialize(Object _object) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            ObjectOutputStream oos = new ObjectOutputStream(baos);
            oos.writeObject(_object);
            oos.close();
            return new SerializedItem(Base64.getEncoder().encodeToString(baos.toByteArray()));
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private Object deserialize(SerializedItem _serialized) {
        if (_serialized == null) {
            return null;
        }
        try {
            return new ObjectInputStream(new ByteArrayInputStream(Base64.getDecoder().decode(_serialized.serialized))).readObject();
        }
        catch (Exception ex) {
            throw new RuntimeException(ex);
        }
    }

    private boolean isSerialized(Object _object) {
        return _object instanceof SerializedItem;
    }

    public static class SerializedItem {
        public String serialized;

        public SerializedItem() {
        }

        public SerializedItem(String _serialized) {
            this.serialized = _serialized;
        }
    }
}

