/*
 * Decompiled with CFR 0.152.
 */
package com.github.cambierr.spring.session.couchbase;

import com.github.cambierr.spring.session.couchbase.CouchbaseSession;
import org.springframework.data.couchbase.core.CouchbaseTemplate;
import org.springframework.session.SessionRepository;
import org.springframework.util.Assert;

public class CouchbaseSessionRepository
implements SessionRepository<CouchbaseSession> {
    private final CouchbaseTemplate couchbase;

    public CouchbaseSessionRepository(CouchbaseTemplate couchbase) {
        Assert.notNull((Object)couchbase);
        this.couchbase = couchbase;
    }

    public CouchbaseSession createSession() {
        return new CouchbaseSession();
    }

    public void save(CouchbaseSession session) {
        this.couchbase.save((Object)session);
    }

    public CouchbaseSession getSession(String id) {
        return (CouchbaseSession)this.couchbase.findById(id, CouchbaseSession.class);
    }

    public void delete(String id) {
        this.couchbase.remove((Object)new CouchbaseSession(id));
    }
}

