/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.catalog.runtimeprovider;

import org.apache.camel.catalog.DefaultRuntimeProvider;
import org.apache.camel.catalog.RuntimeProvider;
import org.apache.camel.catalog.quarkus.QuarkusRuntimeProvider;
import org.apache.camel.springboot.catalog.SpringBootRuntimeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public enum CamelRuntimeProvider {
    DEFAULT,
    SPRINGBOOT,
    QUARKUS;

    private static final Logger LOGGER;

    public static RuntimeProvider getProvider(String runtimeProvider) {
        try {
            switch (CamelRuntimeProvider.valueOf(runtimeProvider)) {
                case DEFAULT: {
                    return new DefaultRuntimeProvider();
                }
                case SPRINGBOOT: {
                    return new SpringBootRuntimeProvider();
                }
                case QUARKUS: {
                    return new QuarkusRuntimeProvider();
                }
            }
            LOGGER.warn("Unsupported Runtime Provider: {}", (Object)runtimeProvider);
            return null;
        }
        catch (IllegalArgumentException ex) {
            LOGGER.warn("Unknown Runtime Provider: {}", (Object)runtimeProvider);
            return null;
        }
    }

    static {
        LOGGER = LoggerFactory.getLogger(CamelRuntimeProvider.class);
    }
}

