/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.catalog.util;

import com.github.cameltooling.lsp.internal.catalog.model.ApiOptionMethodDescriptorModel;
import com.github.cameltooling.lsp.internal.catalog.model.ApiOptionMethodsModel;
import com.github.cameltooling.lsp.internal.catalog.model.ApiOptionModel;
import com.github.cameltooling.lsp.internal.catalog.model.ApiPropertyMethodOptionModel;
import com.github.cameltooling.lsp.internal.catalog.model.ApiPropertyOptionModel;
import com.github.cameltooling.lsp.internal.catalog.model.BaseOptionModel;
import com.github.cameltooling.lsp.internal.catalog.model.ComponentModel;
import com.github.cameltooling.lsp.internal.catalog.model.ComponentOptionModel;
import com.github.cameltooling.lsp.internal.catalog.model.EndpointOptionModel;
import java.util.Collections;
import java.util.Map;
import org.apache.camel.util.json.DeserializationException;
import org.apache.camel.util.json.JsonObject;
import org.apache.camel.util.json.Jsoner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ModelHelper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ModelHelper.class);

    private ModelHelper() {
    }

    public static ComponentModel generateComponentModel(String json, boolean includeOptions) {
        if (json != null) {
            try {
                JsonObject obj = (JsonObject)Jsoner.deserialize((String)json);
                return ModelHelper.generateComponentModel(includeOptions, obj);
            }
            catch (DeserializationException e) {
                LOGGER.error("Cannot deserialize provided json.", (Throwable)e);
                return new ComponentModel();
            }
        }
        return new ComponentModel();
    }

    private static ComponentModel generateComponentModel(boolean includeOptions, JsonObject obj) {
        ComponentModel component = new ComponentModel();
        Map modelComponent = obj.getMap("component");
        component.setScheme(modelComponent.getOrDefault("scheme", ""));
        component.setSyntax(modelComponent.getOrDefault("syntax", ""));
        component.setAlternativeSyntax(modelComponent.getOrDefault("alternativeSyntax", ""));
        component.setAlternativeSchemes(modelComponent.getOrDefault("alternativeSchemes", ""));
        component.setTitle(modelComponent.getOrDefault("title", ""));
        component.setDescription(modelComponent.getOrDefault("description", ""));
        component.setLabel(modelComponent.getOrDefault("label", ""));
        component.setDeprecated(ModelHelper.getSafeBoolean("deprecated", modelComponent));
        component.setConsumerOnly(ModelHelper.getSafeBoolean("consumerOnly", modelComponent));
        component.setProducerOnly(ModelHelper.getSafeBoolean("producerOnly", modelComponent));
        component.setJavaType(modelComponent.getOrDefault("javaType", ""));
        component.setGroupId(modelComponent.getOrDefault("groupId", ""));
        component.setArtifactId(modelComponent.getOrDefault("artifactId", ""));
        component.setVersion(modelComponent.getOrDefault("version", ""));
        if (includeOptions) {
            ModelHelper.populateComponentProperties(obj, component);
            ModelHelper.populateProperties(obj, component);
            ModelHelper.populateApis(obj, component);
            ModelHelper.populateApiProperties(obj, component);
        }
        return component;
    }

    private static void populateApiProperties(JsonObject obj, ComponentModel component) {
        Map apiProperties = obj.getMap("apiProperties");
        if (apiProperties != null) {
            for (Map.Entry<String, Map<String, Object>> entry : apiProperties.entrySet()) {
                ApiPropertyOptionModel option = ModelHelper.createApiPropertyOptionModel(entry);
                component.addApiPropertyOptionModel(option);
            }
        }
    }

    private static void populateApis(JsonObject obj, ComponentModel component) {
        Map apis = obj.getMap("apis");
        if (apis != null) {
            for (Map.Entry<String, Map<String, Object>> entry : apis.entrySet()) {
                ApiOptionModel option = ModelHelper.createApiOptionModel(entry);
                component.addApiOption(option);
            }
        }
    }

    private static void populateProperties(JsonObject obj, ComponentModel component) {
        Map modelProperties = obj.getMap("properties");
        if (modelProperties != null) {
            for (Map.Entry<String, Map<String, Object>> entry : modelProperties.entrySet()) {
                EndpointOptionModel option = ModelHelper.createEndpointOptionModel(entry);
                component.addEndpointOption(option);
            }
        }
    }

    private static void populateComponentProperties(JsonObject obj, ComponentModel component) {
        Map modelComponentProperties = obj.getMap("componentProperties");
        if (modelComponentProperties != null) {
            for (Map.Entry<String, Map<String, Object>> entry : modelComponentProperties.entrySet()) {
                ComponentOptionModel option = ModelHelper.createComponentOptionModel(entry);
                component.addComponentOption(option);
            }
        }
    }

    private static ApiPropertyOptionModel createApiPropertyOptionModel(Map.Entry<String, Map<String, Object>> apiProperty) {
        ApiPropertyOptionModel option = new ApiPropertyOptionModel();
        option.setName(apiProperty.getKey());
        Map methods = apiProperty.getValue().getOrDefault("methods", Collections.emptyMap());
        for (Map.Entry method : methods.entrySet()) {
            String methodName = (String)method.getKey();
            ApiPropertyMethodOptionModel methodDescriptor = new ApiPropertyMethodOptionModel();
            Map properties = ((Map)method.getValue()).getOrDefault("properties", Collections.emptyMap());
            for (Map.Entry<String, Map<String, Object>> entry : properties.entrySet()) {
                methodDescriptor.add(ModelHelper.createEndpointOptionModel(entry));
            }
            if ("creator".equals(methodName)) {
                option.setCreator(methodDescriptor);
                continue;
            }
            if ("deleter".equals(methodName)) {
                option.setDeleter(methodDescriptor);
                continue;
            }
            if ("fetcher".equals(methodName)) {
                option.setFetcher(methodDescriptor);
                continue;
            }
            if ("reader".equals(methodName)) {
                option.setReader(methodDescriptor);
                continue;
            }
            if ("updater".equals(methodName)) {
                option.setUpdater(methodDescriptor);
                continue;
            }
            option.setPropertyMethod(methodDescriptor);
        }
        return option;
    }

    private static ApiOptionModel createApiOptionModel(Map.Entry<String, Map<String, Object>> api) {
        ApiOptionModel option = new ApiOptionModel();
        option.setName(api.getKey());
        Map<String, Object> options = api.getValue();
        option.setConsumerOnly(ModelHelper.getSafeBoolean("consumerOnly", options));
        option.setProducerOnly(ModelHelper.getSafeBoolean("producerOnly", options));
        option.setAliases(options.getOrDefault("aliases", Collections.emptyList()));
        Map methods = options.getOrDefault("methods", Collections.emptyMap());
        ApiOptionMethodsModel apiOptionsMethodsModel = new ApiOptionMethodsModel();
        for (Map.Entry method : methods.entrySet()) {
            String methodName = (String)method.getKey();
            ApiOptionMethodDescriptorModel methodDescriptor = new ApiOptionMethodDescriptorModel();
            methodDescriptor.setDescription(((Map)method.getValue()).getOrDefault("description", ""));
            methodDescriptor.setSignatures(((Map)method.getValue()).getOrDefault("signatures", Collections.emptyList()));
            if ("creator".equals(methodName)) {
                apiOptionsMethodsModel.setCreator(methodDescriptor);
                continue;
            }
            if ("deleter".equals(methodName)) {
                apiOptionsMethodsModel.setDeleter(methodDescriptor);
                continue;
            }
            if ("fetcher".equals(methodName)) {
                apiOptionsMethodsModel.setFetcher(methodDescriptor);
                continue;
            }
            if ("reader".equals(methodName)) {
                apiOptionsMethodsModel.setReader(methodDescriptor);
                continue;
            }
            if (!"updater".equals(methodName)) continue;
            apiOptionsMethodsModel.setUpdater(methodDescriptor);
        }
        option.setApiOptionsMethodsModel(apiOptionsMethodsModel);
        return option;
    }

    private static EndpointOptionModel createEndpointOptionModel(Map.Entry<String, Map<String, Object>> modelProperty) {
        EndpointOptionModel option = new EndpointOptionModel();
        ModelHelper.fillBaseOptions(modelProperty, option);
        Map<String, Object> options = modelProperty.getValue();
        option.setPrefix((String)options.getOrDefault("prefix", ""));
        option.setMultiValue(ModelHelper.getSafeBoolean("multiValue", options));
        return option;
    }

    private static ComponentOptionModel createComponentOptionModel(Map.Entry<String, Map<String, Object>> modelComponentProperty) {
        ComponentOptionModel option = new ComponentOptionModel();
        ModelHelper.fillBaseOptions(modelComponentProperty, option);
        return option;
    }

    private static void fillBaseOptions(Map.Entry<String, Map<String, Object>> modelComponentProperty, BaseOptionModel option) {
        Map<String, Object> options = modelComponentProperty.getValue();
        option.setName(modelComponentProperty.getKey());
        option.setKind((String)options.getOrDefault("kind", ""));
        option.setGroup((String)options.getOrDefault("group", ""));
        option.setRequired(ModelHelper.getSafeBoolean("required", options));
        option.setType((String)options.getOrDefault("type", ""));
        option.setJavaType((String)options.getOrDefault("javaType", ""));
        option.setDeprecated(ModelHelper.getSafeBoolean("deprecated", options));
        option.setSecret(ModelHelper.getSafeBoolean("secret", options));
        option.setDescription((String)options.getOrDefault("description", ""));
        option.setEnums(options.getOrDefault("enum", Collections.emptyList()));
        option.setDefaultValue(options.getOrDefault("defaultValue", ""));
    }

    private static boolean getSafeBoolean(String key, Map<String, Object> options) {
        Object value = options.get(key);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return "true".equals(value);
    }
}

