/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.completion;

import com.github.cameltooling.lsp.internal.catalog.model.BaseOptionModel;
import com.github.cameltooling.lsp.internal.catalog.model.EndpointOptionModel;
import com.github.cameltooling.lsp.internal.instancemodel.OptionParamURIInstance;
import java.util.Set;
import java.util.function.Predicate;
import org.eclipse.lsp4j.CompletionItem;

public class FilterPredicateUtils {
    private FilterPredicateUtils() {
    }

    public static Predicate<CompletionItem> matchesCompletionFilter(String filterString) {
        return item -> {
            if (filterString != null && filterString.trim().length() > 0) {
                return item.getLabel().startsWith(filterString) || item.getInsertText() != null && item.getInsertText().startsWith(filterString);
            }
            return true;
        };
    }

    public static Predicate<EndpointOptionModel> matchesEndpointOptionFilter(String filterString) {
        return item -> {
            if (filterString != null && filterString.trim().length() > 0) {
                return item.getName().startsWith(filterString);
            }
            return true;
        };
    }

    public static Predicate<CompletionItem> removeDuplicatedOptions(Set<OptionParamURIInstance> alreadyDefinedOptions, int positionInCamelURI) {
        return uriOption -> {
            int occured = 0;
            for (OptionParamURIInstance definedOption : alreadyDefinedOptions) {
                if (!definedOption.getKey().getKeyName().equalsIgnoreCase(uriOption.getLabel()) || definedOption.isInRange(positionInCamelURI)) continue;
                ++occured;
            }
            return occured < 1;
        };
    }

    public static Predicate<BaseOptionModel> matchesProducerConsumerGroups(boolean isProducer) {
        return endpoint -> {
            String group = endpoint.getGroup();
            if (isProducer) {
                return !"consumer".equals(group);
            }
            return !"producer".equals(group);
        };
    }
}

