/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.completion;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.cameltooling.lsp.internal.completion.traits.CamelKTraitManager;
import com.github.cameltooling.lsp.internal.parser.ParserFileHelperUtil;
import io.fabric8.kubernetes.api.model.apiextensions.v1.JSONSchemaProps;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemKind;
import org.eclipse.lsp4j.InsertTextFormat;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class VSCodeTasksCompletionProcessor {
    private TextDocumentItem textDocumentItem;

    public VSCodeTasksCompletionProcessor(TextDocumentItem textDocumentItem) {
        this.textDocumentItem = textDocumentItem;
    }

    public CompletableFuture<List<CompletionItem>> getCompletions(Position position) {
        ArrayList<CompletionItem> completions;
        block2: {
            Map<String, JSONSchemaProps> traits;
            block3: {
                completions = new ArrayList<CompletionItem>();
                if (!this.textDocumentItem.getText().contains("traits")) break block2;
                String line = new ParserFileHelperUtil().getLine(this.textDocumentItem, position);
                traits = CamelKTraitManager.getTraits();
                if ('.' != line.charAt(position.getCharacter() - 1)) break block3;
                int startOfTrait = line.substring(0, position.getCharacter() - 1).lastIndexOf("\"");
                if (startOfTrait == -1) break block2;
                String traitName = line.substring(startOfTrait + 1, position.getCharacter() - 1);
                JSONSchemaProps trait = traits.get(traitName);
                Map properties = trait.getProperties();
                for (Map.Entry<String, JSONSchemaProps> entry : properties.entrySet()) {
                    CompletionItem completion = this.createCompletionItemForProperty(position, entry);
                    completions.add(completion);
                }
                break block2;
            }
            for (Map.Entry<String, JSONSchemaProps> traitEntry : traits.entrySet()) {
                CompletionItem completion = this.createCompletionitemForTrait(position, traitEntry);
                completions.add(completion);
            }
        }
        return CompletableFuture.completedFuture(completions);
    }

    private CompletionItem createCompletionitemForTrait(Position position, Map.Entry<String, JSONSchemaProps> traitEntry) {
        CompletionItem completion = new CompletionItem(traitEntry.getKey());
        completion.setKind(CompletionItemKind.Snippet);
        Set properties = traitEntry.getValue().getProperties().keySet();
        Object propertiesChoice = !properties.isEmpty() ? "${1|" + String.join((CharSequence)",", properties) + "|}" : "";
        String insertText = "\"" + traitEntry.getKey() + "." + (String)propertiesChoice + "=\"";
        completion.setInsertTextFormat(InsertTextFormat.Snippet);
        this.applyTextEdit(position, completion, insertText);
        completion.setDocumentation(traitEntry.getValue().getDescription());
        return completion;
    }

    private CompletionItem createCompletionItemForProperty(Position position, Map.Entry<String, JSONSchemaProps> property) {
        String label = property.getKey();
        CompletionItem completion = new CompletionItem(label);
        JsonNode defaultPropertyValue = property.getValue().getDefault();
        Object insertText = defaultPropertyValue != null ? label + "=" + String.valueOf(defaultPropertyValue) : label;
        this.applyTextEdit(position, completion, (String)insertText);
        completion.setSortText("${1" + label);
        completion.setDocumentation(property.getValue().getDescription());
        return completion;
    }

    private void applyTextEdit(Position position, CompletionItem completion, String insertText) {
        Position positionLSP = new Position(position.getLine(), position.getCharacter());
        completion.setTextEdit(Either.forLeft((Object)new TextEdit(new Range(positionLSP, positionLSP), insertText)));
    }
}

