/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.diagnostic;

import com.github.cameltooling.lsp.internal.catalog.diagnostic.CamelDiagnosticMessage;
import com.github.cameltooling.lsp.internal.parser.ParserFileHelperUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.parser.RouteBuilderParser;
import org.apache.camel.parser.XmlRouteParser;
import org.apache.camel.parser.model.CamelEndpointDetails;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentItem;
import org.jboss.forge.roaster.Roaster;
import org.jboss.forge.roaster.model.JavaType;
import org.jboss.forge.roaster.model.source.JavaClassSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DiagnosticService {
    public static final String APACHE_CAMEL_VALIDATION = "Apache Camel validation";
    protected static final Logger LOGGER = LoggerFactory.getLogger(DiagnosticService.class);
    public static final String ERROR_CODE_UNKNOWN_PROPERTIES = "camel.diagnostic.unknown.properties";
    public static final String ERROR_CODE_INVALID_ENUM = "camel.diagnostic.invalid.enum";
    protected CompletableFuture<CamelCatalog> camelCatalog;

    protected DiagnosticService(CompletableFuture<CamelCatalog> camelCatalog) {
        this.camelCatalog = camelCatalog;
    }

    protected void logExceptionValidatingDocument(String docUri, Exception e) {
        LOGGER.warn("Error while trying to validate the document {}", (Object)docUri, (Object)e);
    }

    protected void computeErrorMessage(StringBuilder sb, String syntaxError) {
        if (syntaxError != null) {
            sb.append(syntaxError).append("\n");
        }
    }

    protected void computeErrorMessage(StringBuilder sb, Map<String, String> mapEntryErrors, CamelDiagnosticMessage<Map.Entry<String, String>> errorMsgComputer) {
        if (mapEntryErrors != null) {
            for (Map.Entry<String, String> invalid : mapEntryErrors.entrySet()) {
                sb.append(errorMsgComputer.getErrorMessage(invalid)).append("\n");
            }
        }
    }

    protected void computeErrorMessage(StringBuilder sb, Set<String> setOfErrors, CamelDiagnosticMessage<Set<String>> errorMsgComputer) {
        if (setOfErrors != null && !setOfErrors.isEmpty()) {
            sb.append(errorMsgComputer.getErrorMessage(setOfErrors)).append("\n");
        }
    }

    protected List<CamelEndpointDetails> retrieveEndpoints(String fileUri, String camelText) {
        ArrayList<CamelEndpointDetails> endpoints = new ArrayList<CamelEndpointDetails>();
        if (fileUri.endsWith(".xml")) {
            try {
                XmlRouteParser.parseXmlRouteEndpoints((InputStream)new ByteArrayInputStream(camelText.getBytes(StandardCharsets.UTF_8)), (String)"", (String)("/" + fileUri), endpoints);
            }
            catch (Exception e) {
                this.logExceptionValidatingDocument(fileUri, e);
            }
        } else if (fileUri.endsWith(".java")) {
            try {
                JavaType parsedJavaFile = Roaster.parse((String)camelText);
                if (parsedJavaFile instanceof JavaClassSource) {
                    JavaClassSource clazz = (JavaClassSource)parsedJavaFile;
                    RouteBuilderParser.parseRouteBuilderEndpoints((JavaClassSource)clazz, (String)"", (String)("/" + fileUri), endpoints);
                }
            }
            catch (Exception e) {
                this.logExceptionValidatingDocument(fileUri, e);
            }
        }
        return endpoints;
    }

    protected Range computeRange(String fullCamelText, TextDocumentItem textDocumentItem, CamelEndpointDetails camelEndpointDetails) {
        int endLinePosition;
        int startLinePosition;
        int startOfUri;
        int endLine = camelEndpointDetails.getLineNumberEnd() != null ? Integer.valueOf(camelEndpointDetails.getLineNumberEnd()) - 1 : this.findLine(fullCamelText, camelEndpointDetails);
        String lineContainingTheCamelURI = new ParserFileHelperUtil().getLine(textDocumentItem, endLine);
        String endpointUri = camelEndpointDetails.getEndpointUri();
        if (textDocumentItem.getUri().endsWith(".xml")) {
            endpointUri = endpointUri.replace("&", "&amp;");
        }
        if ((startOfUri = lineContainingTheCamelURI.indexOf(endpointUri)) != -1) {
            startLinePosition = startOfUri;
            endLinePosition = startOfUri + endpointUri.length();
        } else {
            startLinePosition = 0;
            endLinePosition = lineContainingTheCamelURI.length();
        }
        int startLine = camelEndpointDetails.getLineNumber() != null ? Integer.valueOf(camelEndpointDetails.getLineNumber()) - 1 : this.findLine(fullCamelText, camelEndpointDetails);
        return new Range(new Position(startLine, startLinePosition), new Position(endLine, endLinePosition));
    }

    protected int findLine(String fullCamelText, CamelEndpointDetails camelEndpointDetails) {
        int currentSearchedLine = 0;
        BufferedReader reader = new BufferedReader(new StringReader(fullCamelText));
        try {
            String str;
            while ((str = reader.readLine()) != null) {
                if (str.contains(camelEndpointDetails.getEndpointUri())) {
                    return currentSearchedLine;
                }
                ++currentSearchedLine;
            }
        }
        catch (IOException e) {
            LOGGER.error("Error while computing range of error", (Throwable)e);
        }
        return 0;
    }
}

