/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.instancemodel.propertiesfile;

import com.github.cameltooling.lsp.internal.instancemodel.ILineRangeDefineable;
import com.github.cameltooling.lsp.internal.instancemodel.propertiesfile.CamelComponentNamePropertyInstance;
import com.github.cameltooling.lsp.internal.instancemodel.propertiesfile.CamelComponentParameterPropertyInstance;
import com.github.cameltooling.lsp.internal.instancemodel.propertiesfile.CamelPropertyKeyInstance;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.camel.catalog.CamelCatalog;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.Position;

public class CamelComponentPropertyKey
implements ILineRangeDefineable {
    private String fullCamelComponentPropertyKey;
    private CamelComponentNamePropertyInstance componentName;
    private CamelComponentParameterPropertyInstance componentProperty;
    private CamelPropertyKeyInstance camelPropertyKeyInstance;

    public CamelComponentPropertyKey(String camelComponentPropertyKey, CamelPropertyKeyInstance camelPropertyKeyInstance) {
        this.fullCamelComponentPropertyKey = camelComponentPropertyKey;
        this.camelPropertyKeyInstance = camelPropertyKeyInstance;
        int firstDotIndex = camelComponentPropertyKey.indexOf(46);
        if (firstDotIndex != -1) {
            this.componentName = new CamelComponentNamePropertyInstance(camelComponentPropertyKey.substring(0, firstDotIndex), this);
            this.componentProperty = new CamelComponentParameterPropertyInstance(camelComponentPropertyKey.substring(firstDotIndex + 1), this.componentName.getEndPositionInLine() + 1, this);
        } else {
            this.componentName = new CamelComponentNamePropertyInstance(camelComponentPropertyKey, this);
        }
    }

    public boolean isInRange(int positionChar) {
        return this.getStartPositionInLine() <= positionChar && positionChar <= this.fullCamelComponentPropertyKey.length() + this.getStartPositionInLine();
    }

    public CompletableFuture<List<CompletionItem>> getCompletions(Position position, CompletableFuture<CamelCatalog> camelCatalog) {
        int characterPosition = position.getCharacter();
        if (this.isInside(this.componentName, characterPosition)) {
            return this.componentName.getCompletions(position, camelCatalog);
        }
        if (this.isInside(this.componentProperty, characterPosition)) {
            return this.componentProperty.getCompletions(position, camelCatalog);
        }
        return CompletableFuture.completedFuture(Collections.emptyList());
    }

    private boolean isInside(ILineRangeDefineable lineRangeDefineable, int characterPosition) {
        return lineRangeDefineable != null && lineRangeDefineable.getStartPositionInLine() <= characterPosition && lineRangeDefineable.getEndPositionInLine() >= characterPosition;
    }

    @Override
    public int getStartPositionInLine() {
        return this.camelPropertyKeyInstance.getStartPositionInLine() + "camel.component.".length();
    }

    public String getComponentId() {
        return this.componentName.getName();
    }

    public String getComponentProperty() {
        return this.componentProperty != null ? this.componentProperty.getProperty() : null;
    }

    @Override
    public int getLine() {
        return this.getCamelPropertyKeyInstance().getLine();
    }

    @Override
    public int getEndPositionInLine() {
        return this.getStartPositionInLine() + this.fullCamelComponentPropertyKey.length();
    }

    public CamelPropertyKeyInstance getCamelPropertyKeyInstance() {
        return this.camelPropertyKeyInstance;
    }

    public CompletableFuture<Hover> getHover(Position position, CompletableFuture<CamelCatalog> camelCatalog) {
        int characterPosition = position.getCharacter();
        if (this.isInside(this.componentName, characterPosition)) {
            return this.componentName.getHover(camelCatalog);
        }
        if (this.isInside(this.componentProperty, characterPosition)) {
            return this.componentProperty.getHover(camelCatalog);
        }
        return CompletableFuture.completedFuture(null);
    }

    public boolean shouldUseDashedCase() {
        return this.camelPropertyKeyInstance.shouldUseDashedCase();
    }
}

