/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.instancemodel.propertiesfile;

import com.github.cameltooling.lsp.internal.catalog.util.StringUtils;
import com.github.cameltooling.lsp.internal.completion.CompletionResolverUtils;
import com.github.cameltooling.lsp.internal.instancemodel.ILineRangeDefineable;
import com.github.cameltooling.lsp.internal.instancemodel.propertiesfile.CamelPropertyKeyInstance;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.tooling.model.MainModel;
import org.apache.camel.util.StringHelper;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.Position;

public class CamelGroupPropertyKey
implements ILineRangeDefineable {
    private String groupConfiguration;
    private CamelPropertyKeyInstance camelPropertyKeyInstance;
    private String groupName;

    public CamelGroupPropertyKey(String groupProperty, CamelPropertyKeyInstance camelPropertyKeyInstance) {
        this.groupConfiguration = groupProperty;
        this.camelPropertyKeyInstance = camelPropertyKeyInstance;
        int secondDotIndex = groupProperty.indexOf(46);
        this.groupName = secondDotIndex != -1 ? groupProperty.substring(0, secondDotIndex) : groupProperty;
    }

    @Override
    public int getLine() {
        return this.camelPropertyKeyInstance.getLine();
    }

    @Override
    public int getStartPositionInLine() {
        return this.camelPropertyKeyInstance.getStartPositionInLine() + "camel.".length();
    }

    @Override
    public int getEndPositionInLine() {
        return this.getStartPositionInLine() + this.groupConfiguration.length();
    }

    public boolean isInRange(int positionChar) {
        return this.getStartPositionInLine() <= positionChar && positionChar <= this.groupConfiguration.length() + this.getStartPositionInLine();
    }

    public CompletableFuture<Hover> getHover(Position position, CompletableFuture<CamelCatalog> camelCatalog) {
        if (this.isInGroupAttribute(position)) {
            return camelCatalog.thenApply(catalog -> {
                if (catalog instanceof DefaultCamelCatalog) {
                    String fullName;
                    MainModel mainModel = ((DefaultCamelCatalog)catalog).mainModel();
                    Optional<MainModel.MainOptionModel> mainOptionModel = this.findFirstOption(mainModel, fullName = "camel." + this.groupConfiguration);
                    if (!mainOptionModel.isPresent() && fullName.contains("-")) {
                        mainOptionModel = this.findFirstOption(mainModel, StringUtils.dashToCamelCase(fullName));
                    }
                    if (mainOptionModel.isPresent()) {
                        return this.createHover(mainOptionModel.get().getDescription());
                    }
                }
                return null;
            });
        }
        return CompletableFuture.completedFuture(null);
    }

    private Optional<MainModel.MainOptionModel> findFirstOption(MainModel mainModel, String fullName) {
        return mainModel.getOptions().stream().filter(option -> option.getName().startsWith(fullName)).findFirst();
    }

    private boolean isInGroupAttribute(Position position) {
        return this.getStartPositionInLine() + this.groupName.length() <= position.getCharacter();
    }

    public CompletableFuture<List<CompletionItem>> getCompletions(Position position, CompletableFuture<CamelCatalog> camelCatalog) {
        if (this.isInGroupAttribute(position)) {
            boolean shouldUseDashed = this.shouldUseDashedCase();
            return camelCatalog.thenApply(catalog -> {
                if (catalog instanceof DefaultCamelCatalog) {
                    ArrayList<CompletionItem> completions = new ArrayList<CompletionItem>();
                    completions.addAll(this.retrieveCamelMainCompletions(shouldUseDashed, (CamelCatalog)catalog));
                    return completions;
                }
                return Collections.emptyList();
            });
        }
        return CompletableFuture.completedFuture(Collections.emptyList());
    }

    private List<CompletionItem> retrieveCamelMainCompletions(boolean shouldUseDashed, CamelCatalog catalog) {
        MainModel mainModel = ((DefaultCamelCatalog)catalog).mainModel();
        String groupPrefix = "camel." + this.groupName + ".";
        return mainModel.getOptions().stream().filter(option -> option.getName().startsWith(groupPrefix)).map(option -> {
            String realOptionName = option.getName().substring(groupPrefix.length());
            if (shouldUseDashed) {
                realOptionName = StringHelper.camelCaseToDash((String)realOptionName);
            }
            CompletionItem completionItem = new CompletionItem(realOptionName);
            completionItem.setDocumentation(option.getDescription());
            CompletionResolverUtils.applyDeprecation(completionItem, option.isDeprecated());
            completionItem.setInsertText(realOptionName + "=");
            return completionItem;
        }).collect(Collectors.toList());
    }

    private boolean shouldUseDashedCase() {
        return this.camelPropertyKeyInstance.shouldUseDashedCase();
    }
}

