/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.modelinemodel;

import com.github.cameltooling.lsp.internal.completion.modeline.CamelKModelineOptionNames;
import com.github.cameltooling.lsp.internal.instancemodel.ILineRangeDefineable;
import com.github.cameltooling.lsp.internal.modelinemodel.CamelKModelineOption;
import com.github.cameltooling.lsp.internal.parser.CamelKModelineParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.camel.catalog.CamelCatalog;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentItem;

public class CamelKModeline
implements ILineRangeDefineable {
    private String fullModeline;
    private List<CamelKModelineOption> options = new ArrayList<CamelKModelineOption>();
    private int endOfPrefixPositionInline;
    private int line;

    public CamelKModeline(String fullModeline, TextDocumentItem documentItem, int line) {
        this.fullModeline = fullModeline;
        this.line = line;
        String modelineCamelkStart = new CamelKModelineParser().retrieveModelineCamelKStart(fullModeline);
        if (modelineCamelkStart != null) {
            this.endOfPrefixPositionInline = modelineCamelkStart.length();
            this.parseOptions(fullModeline, modelineCamelkStart, documentItem);
        } else {
            this.endOfPrefixPositionInline = -1;
        }
    }

    private void parseOptions(String fullModeline, String modelineCamelkStart, TextDocumentItem documentItem) {
        int currentPosition = modelineCamelkStart.length();
        String remainingModeline = fullModeline.substring(currentPosition);
        while (!remainingModeline.isEmpty()) {
            int nextSpaceLikeCharacter = this.getNextSpaceLikeCharacter(remainingModeline);
            if (nextSpaceLikeCharacter != -1) {
                this.options.add(new CamelKModelineOption(remainingModeline.substring(1, nextSpaceLikeCharacter), currentPosition + 1, documentItem, this.line));
                remainingModeline = remainingModeline.substring(nextSpaceLikeCharacter);
                currentPosition += nextSpaceLikeCharacter;
                continue;
            }
            if (!remainingModeline.trim().isEmpty() && !this.isEnfOfXmlModeline(remainingModeline.trim())) {
                this.options.add(new CamelKModelineOption(remainingModeline.substring(1), currentPosition + 1, documentItem, this.line));
            }
            remainingModeline = "";
        }
    }

    private boolean isEnfOfXmlModeline(String remainingModeline) {
        return "-->".equals(remainingModeline);
    }

    private int getNextSpaceLikeCharacter(String remainingModeline) {
        int nextSpace = remainingModeline.indexOf(32, 1);
        int nextTab = remainingModeline.indexOf(9, 1);
        if (nextSpace == -1) {
            return nextTab;
        }
        if (nextTab == -1) {
            return nextSpace;
        }
        return Math.min(nextSpace, nextTab);
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getStartPositionInLine() {
        return 0;
    }

    @Override
    public int getEndPositionInLine() {
        return this.fullModeline.length();
    }

    public List<CamelKModelineOption> getOptions() {
        return this.options;
    }

    public CompletableFuture<List<CompletionItem>> getCompletions(int character, CompletableFuture<CamelCatalog> camelCatalog) {
        if (this.endOfPrefixPositionInline != -1 && character >= this.endOfPrefixPositionInline) {
            for (CamelKModelineOption camelKModelineOption : this.options) {
                if (!camelKModelineOption.isInRange(character)) continue;
                return camelKModelineOption.getCompletions(character, camelCatalog);
            }
            return CompletableFuture.completedFuture(CamelKModelineOptionNames.getCompletionItems());
        }
        return CompletableFuture.completedFuture(Collections.emptyList());
    }

    public CompletableFuture<Hover> getHover(Position position, CompletableFuture<CamelCatalog> camelCatalog) {
        for (CamelKModelineOption camelKModelineOption : this.options) {
            if (!camelKModelineOption.isInRange(position.getCharacter())) continue;
            return camelKModelineOption.getHover(position, camelCatalog);
        }
        return CompletableFuture.completedFuture(null);
    }
}

