/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.modelinemodel;

import com.github.cameltooling.lsp.internal.modelinemodel.CamelKModelineResourceFileOption;
import com.github.cameltooling.lsp.internal.modelinemodel.ICamelKModelineOptionValue;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.camel.catalog.CamelCatalog;
import org.eclipse.lsp4j.CompletionItem;

public class CamelKModelineResourceOption
implements ICamelKModelineOptionValue {
    private static final String PREFIX_FILE = "file:";
    private String value;
    private int startPosition;
    private int line;
    private CamelKModelineResourceFileOption resourceFileValue;

    public CamelKModelineResourceOption(String value, int startPosition, String uri, int line) {
        this.value = value;
        this.startPosition = startPosition;
        this.line = line;
        if (value.startsWith(PREFIX_FILE)) {
            int endPosition = value.indexOf(64);
            this.resourceFileValue = endPosition != -1 ? new CamelKModelineResourceFileOption(value.substring(PREFIX_FILE.length(), endPosition), startPosition + PREFIX_FILE.length(), uri, line) : new CamelKModelineResourceFileOption(value.substring(PREFIX_FILE.length()), startPosition + PREFIX_FILE.length(), uri, line);
        }
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getStartPositionInLine() {
        return this.startPosition;
    }

    @Override
    public int getEndPositionInLine() {
        return this.startPosition + this.value.length();
    }

    @Override
    public String getValueAsString() {
        return this.value;
    }

    @Override
    public CompletableFuture<List<CompletionItem>> getCompletions(int position, CompletableFuture<CamelCatalog> camelCatalog) {
        if (position == this.startPosition) {
            CompletionItem configmap = new CompletionItem("configmap:");
            configmap.setDocumentation("Add a runtime resource from a Configmap (syntax: configmap:name[/key][@path], where name represents the configmap name, key optionally represents the configmap key to be filtered and path represents the destination path)");
            CompletionItem secret = new CompletionItem("secret:");
            secret.setDocumentation("Add a runtime resource from a Secret (syntax: secret:name[/key][@path], where name represents the secret name, key optionally represents the secret key to be filtered and path represents the destination path)");
            CompletionItem file = new CompletionItem(PREFIX_FILE);
            file.setDocumentation("Add a runtime resource from a file (syntax: file:name[@path], where name represents the local file path and path represents the destination path)");
            return CompletableFuture.completedFuture(Arrays.asList(configmap, secret, file));
        }
        if (this.resourceFileValue != null && this.resourceFileValue.isInRange(position)) {
            return this.resourceFileValue.getCompletions(position, camelCatalog);
        }
        return ICamelKModelineOptionValue.super.getCompletions(position, camelCatalog);
    }
}

