/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.modelinemodel;

import com.github.cameltooling.lsp.internal.completion.traits.CamelKTraitManager;
import com.github.cameltooling.lsp.internal.modelinemodel.CamelKModelineTraitOption;
import com.github.cameltooling.lsp.internal.modelinemodel.ICamelKModelineOptionValue;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.camel.catalog.CamelCatalog;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.Hover;

public class CamelKModelineTraitDefinitionProperty
implements ICamelKModelineOptionValue {
    private String traitDefinitionProperty;
    private int startPosition;
    private CamelKModelineTraitOption traitOption;
    private int line;

    public CamelKModelineTraitDefinitionProperty(CamelKModelineTraitOption camelKModelineTraitOption, String traitDefinitionProperty, int startPosition, int line) {
        this.traitOption = camelKModelineTraitOption;
        this.traitDefinitionProperty = traitDefinitionProperty;
        this.startPosition = startPosition;
        this.line = line;
    }

    @Override
    public int getLine() {
        return this.line;
    }

    @Override
    public int getStartPositionInLine() {
        return this.startPosition;
    }

    @Override
    public int getEndPositionInLine() {
        return this.getStartPositionInLine() + this.traitDefinitionProperty.length();
    }

    @Override
    public String getValueAsString() {
        return this.traitDefinitionProperty;
    }

    @Override
    public CompletableFuture<List<CompletionItem>> getCompletions(int position, CompletableFuture<CamelCatalog> camelCatalog) {
        String filter = this.retrieveTraitPropertyPartBefore(position);
        return CompletableFuture.completedFuture(CamelKTraitManager.getTraitPropertyNameCompletionItems(filter, this));
    }

    private String retrieveTraitPropertyPartBefore(int position) {
        return this.traitDefinitionProperty.substring(0, position - this.getStartPositionInLine());
    }

    @Override
    public CompletableFuture<Hover> getHover(int characterPosition, CompletableFuture<CamelCatalog> camelCatalog) {
        String description = CamelKTraitManager.getPropertyDescription(this.getTraitOption().getTraitDefinition().getValueAsString(), this.traitDefinitionProperty);
        if (description != null) {
            return CompletableFuture.completedFuture(this.createHover(description));
        }
        return ICamelKModelineOptionValue.super.getHover(characterPosition, camelCatalog);
    }

    public CamelKModelineTraitOption getTraitOption() {
        return this.traitOption;
    }
}

