/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal;

import com.github.cameltooling.lsp.internal.AbstractLanguageServer;
import com.github.cameltooling.lsp.internal.CamelTextDocumentService;
import com.github.cameltooling.lsp.internal.CamelWorkspaceService;
import com.github.cameltooling.lsp.internal.settings.SettingsManager;
import com.github.cameltooling.lsp.internal.telemetry.TelemetryManager;
import java.util.Arrays;
import java.util.concurrent.CompletableFuture;
import org.eclipse.lsp4j.CodeActionOptions;
import org.eclipse.lsp4j.CompletionOptions;
import org.eclipse.lsp4j.DocumentSymbolOptions;
import org.eclipse.lsp4j.InitializeParams;
import org.eclipse.lsp4j.InitializeResult;
import org.eclipse.lsp4j.InitializedParams;
import org.eclipse.lsp4j.MessageParams;
import org.eclipse.lsp4j.MessageType;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.SetTraceParams;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.services.LanguageClient;
import org.eclipse.lsp4j.services.LanguageClientAware;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.lsp4j.services.NotebookDocumentService;
import org.eclipse.lsp4j.services.WorkspaceService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelLanguageServer
extends AbstractLanguageServer
implements LanguageServer,
LanguageClientAware {
    public static final String LANGUAGE_ID = "LANGUAGE_ID_APACHE_CAMEL";
    private static final Logger LOGGER = LoggerFactory.getLogger(CamelLanguageServer.class);
    private LanguageClient client;
    private SettingsManager settingsManager;
    private TelemetryManager telemetryManager;

    public CamelLanguageServer() {
        CamelTextDocumentService textDocumentService = new CamelTextDocumentService(this);
        this.setTextDocumentService(textDocumentService);
        this.settingsManager = new SettingsManager(textDocumentService);
        this.setWorkspaceService(new CamelWorkspaceService(this.getSettingsManager()));
    }

    public void connect(LanguageClient client) {
        this.client = client;
        this.telemetryManager = new TelemetryManager(client);
    }

    public void exit() {
        super.stopServer();
        System.exit(0);
    }

    public CompletableFuture<InitializeResult> initialize(InitializeParams params) {
        Integer processId = params.getProcessId();
        if (processId != null) {
            this.setParentProcessId(processId.longValue());
        } else {
            LOGGER.info("Missing Parent process ID!!");
            this.setParentProcessId(0L);
        }
        this.getSettingsManager().apply(params);
        ServerCapabilities capabilities = this.createServerCapabilities();
        InitializeResult result = new InitializeResult(capabilities);
        return CompletableFuture.completedFuture(result);
    }

    public void initialized(InitializedParams params) {
        super.initialized(params);
        if (this.telemetryManager != null) {
            this.telemetryManager.onInitialized();
        }
    }

    private ServerCapabilities createServerCapabilities() {
        ServerCapabilities capabilities = new ServerCapabilities();
        capabilities.setTextDocumentSync(TextDocumentSyncKind.Full);
        capabilities.setCompletionProvider(new CompletionOptions(Boolean.TRUE, Arrays.asList(".", "?", "&", "\"", "=")));
        capabilities.setHoverProvider(Boolean.TRUE);
        capabilities.setDocumentSymbolProvider(new DocumentSymbolOptions("Camel"));
        capabilities.setReferencesProvider(Boolean.TRUE);
        capabilities.setDefinitionProvider(Boolean.TRUE);
        capabilities.setCodeActionProvider(new CodeActionOptions(Arrays.asList("quickfix")));
        capabilities.setFoldingRangeProvider(Boolean.TRUE);
        return capabilities;
    }

    public CompletableFuture<Object> shutdown() {
        super.shutdownServer();
        return CompletableFuture.completedFuture(new Object());
    }

    @Override
    public WorkspaceService getWorkspaceService() {
        return super.getWorkspaceService();
    }

    public void sendShowMessageNotification(MessageType type, String msg) {
        this.getClient().showMessage(new MessageParams(type, msg));
    }

    public LanguageClient getClient() {
        return this.client;
    }

    public SettingsManager getSettingsManager() {
        return this.settingsManager;
    }

    public TelemetryManager getTelemetryManager() {
        return this.telemetryManager;
    }

    public NotebookDocumentService getNotebookDocumentService() {
        return null;
    }

    public void setTrace(SetTraceParams params) {
    }
}

