/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal;

import com.github.cameltooling.lsp.internal.CamelLanguageServer;
import com.github.cameltooling.lsp.internal.catalog.runtimeprovider.CamelRuntimeProvider;
import com.github.cameltooling.lsp.internal.catalog.util.KameletsCatalogManager;
import com.github.cameltooling.lsp.internal.codeactions.CodeActionProcessor;
import com.github.cameltooling.lsp.internal.completion.CamelEndpointCompletionProcessor;
import com.github.cameltooling.lsp.internal.completion.CamelPropertiesCompletionProcessor;
import com.github.cameltooling.lsp.internal.completion.PomCompletionProcessor;
import com.github.cameltooling.lsp.internal.completion.VSCodeTasksCompletionProcessor;
import com.github.cameltooling.lsp.internal.completion.modeline.CamelKModelineCompletionprocessor;
import com.github.cameltooling.lsp.internal.completion.modeline.CamelKModelineInsertionProcessor;
import com.github.cameltooling.lsp.internal.definition.DefinitionProcessor;
import com.github.cameltooling.lsp.internal.diagnostic.DiagnosticRunner;
import com.github.cameltooling.lsp.internal.documentsymbol.DocumentSymbolProcessor;
import com.github.cameltooling.lsp.internal.folding.FoldingRangeProcessor;
import com.github.cameltooling.lsp.internal.hover.CamelKModelineHoverProcessor;
import com.github.cameltooling.lsp.internal.hover.CamelPropertiesFileHoverProcessor;
import com.github.cameltooling.lsp.internal.hover.CamelURIHoverProcessor;
import com.github.cameltooling.lsp.internal.parser.CamelKModelineInsertionParser;
import com.github.cameltooling.lsp.internal.parser.CamelKModelineParser;
import com.github.cameltooling.lsp.internal.references.ReferencesProcessor;
import com.github.cameltooling.lsp.internal.settings.JSONUtility;
import com.github.cameltooling.lsp.internal.settings.SettingsManager;
import com.github.cameltooling.lsp.internal.telemetry.TelemetryLanguage;
import com.google.gson.Gson;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.catalog.DefaultCamelCatalog;
import org.apache.camel.catalog.RuntimeProvider;
import org.apache.camel.catalog.VersionManager;
import org.apache.camel.catalog.maven.MavenVersionManager;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.CodeLensParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionList;
import org.eclipse.lsp4j.CompletionParams;
import org.eclipse.lsp4j.DefinitionParams;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.DidCloseTextDocumentParams;
import org.eclipse.lsp4j.DidOpenTextDocumentParams;
import org.eclipse.lsp4j.DidSaveTextDocumentParams;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentHighlight;
import org.eclipse.lsp4j.DocumentHighlightParams;
import org.eclipse.lsp4j.DocumentOnTypeFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.DocumentSymbolParams;
import org.eclipse.lsp4j.FoldingRange;
import org.eclipse.lsp4j.FoldingRangeRequestParams;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.HoverParams;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.LocationLink;
import org.eclipse.lsp4j.ReferenceParams;
import org.eclipse.lsp4j.RenameParams;
import org.eclipse.lsp4j.SignatureHelp;
import org.eclipse.lsp4j.SignatureHelpParams;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.lsp4j.services.TextDocumentService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelTextDocumentService
implements TextDocumentService {
    private static final Logger LOGGER = LoggerFactory.getLogger(CamelTextDocumentService.class);
    protected Map<String, TextDocumentItem> openedDocuments = new HashMap<String, TextDocumentItem>();
    private CompletableFuture<CamelCatalog> camelCatalog;
    private CamelLanguageServer camelLanguageServer;
    private KameletsCatalogManager kameletsCatalogManager = new KameletsCatalogManager();

    public CamelTextDocumentService(CamelLanguageServer camelLanguageServer) {
        this.camelLanguageServer = camelLanguageServer;
        this.camelCatalog = CompletableFuture.supplyAsync(() -> new DefaultCamelCatalog(true));
    }

    public void updateCatalog(String camelVersion, String camelCatalogRuntimeProvider, List<Map<?, ?>> extraComponents) {
        this.camelCatalog = CompletableFuture.supplyAsync(() -> {
            DefaultCamelCatalog catalog = new DefaultCamelCatalog(true);
            this.updateCatalogVersion(camelVersion, catalog);
            this.updateCatalogRuntimeProvider(camelCatalogRuntimeProvider, catalog);
            this.updateCatalogExtraComponents(extraComponents, catalog);
            return catalog;
        });
    }

    private void updateCatalogExtraComponents(List<Map<?, ?>> extraComponents, DefaultCamelCatalog catalog) {
        if (extraComponents != null) {
            for (Map<?, ?> extraComponent : extraComponents) {
                JSONUtility jsonUtility = new JSONUtility();
                Map extraComponentTopLevel = jsonUtility.toModel(extraComponent, Map.class);
                Map componentAttributes = jsonUtility.toModel(extraComponentTopLevel.get("component"), Map.class);
                String name = (String)componentAttributes.get("scheme");
                String className = (String)componentAttributes.get("javaType");
                catalog.addComponent(name, className, new Gson().toJson(extraComponent));
            }
        }
    }

    private void updateCatalogRuntimeProvider(String camelCatalogRuntimeProvider, DefaultCamelCatalog catalog) {
        RuntimeProvider runtimeProvider;
        if (camelCatalogRuntimeProvider != null && !camelCatalogRuntimeProvider.isEmpty() && (runtimeProvider = CamelRuntimeProvider.getProvider(camelCatalogRuntimeProvider)) != null) {
            catalog.setRuntimeProvider(runtimeProvider);
        }
    }

    private void updateCatalogVersion(String camelVersion, DefaultCamelCatalog catalog) {
        if (camelVersion != null && !camelVersion.isEmpty()) {
            MavenVersionManager versionManager = new MavenVersionManager();
            if (camelVersion.contains("redhat")) {
                versionManager.addMavenRepository("central", "https://repo1.maven.org/maven2/");
                versionManager.addMavenRepository("maven.redhat.ga", "https://maven.repository.redhat.com/ga/");
            }
            catalog.setVersionManager((VersionManager)versionManager);
            if (!catalog.loadVersion(camelVersion)) {
                LOGGER.warn("Cannot load Camel catalog with version {}", (Object)camelVersion);
            }
        }
    }

    public CompletableFuture<Either<List<CompletionItem>, CompletionList>> completion(CompletionParams completionParams) {
        String uri = completionParams.getTextDocument().getUri();
        LOGGER.info("completion: {}", (Object)uri);
        TextDocumentItem textDocumentItem = this.openedDocuments.get(uri);
        if (textDocumentItem != null) {
            if (uri.endsWith(".properties")) {
                return new CamelPropertiesCompletionProcessor(textDocumentItem, this.getCamelCatalog()).getCompletions(completionParams.getPosition(), this.getSettingsManager(), this.getKameletsCatalogManager()).thenApply(Either::forLeft);
            }
            if (new CamelKModelineInsertionParser(textDocumentItem).canPutCamelKModeline(completionParams.getPosition())) {
                return new CamelKModelineInsertionProcessor(textDocumentItem).getCompletions().thenApply(Either::forLeft);
            }
            if (new CamelKModelineParser().isOnCamelKModeline(completionParams.getPosition().getLine(), textDocumentItem)) {
                return new CamelKModelineCompletionprocessor(textDocumentItem, this.getCamelCatalog()).getCompletions(completionParams.getPosition()).thenApply(Either::forLeft);
            }
            if (uri.endsWith("pom.xml")) {
                return new PomCompletionProcessor(textDocumentItem, this.getCamelCatalog()).getCompletions(completionParams.getPosition()).thenApply(Either::forLeft);
            }
            if (uri.endsWith("tasks.json")) {
                return new VSCodeTasksCompletionProcessor(textDocumentItem).getCompletions(completionParams.getPosition()).thenApply(Either::forLeft);
            }
            return new CamelEndpointCompletionProcessor(textDocumentItem, this.getCamelCatalog(), this.getKameletsCatalogManager()).getCompletions(completionParams.getPosition(), this.getSettingsManager()).thenApply(Either::forLeft);
        }
        LOGGER.warn("The document with uri {} has not been found in opened documents. Cannot provide completion.", (Object)uri);
        return CompletableFuture.completedFuture(Either.forLeft(Collections.emptyList()));
    }

    public CompletableFuture<CompletionItem> resolveCompletionItem(CompletionItem unresolved) {
        LOGGER.info("resolveCompletionItem: {}", (Object)unresolved.getLabel());
        return CompletableFuture.completedFuture(unresolved);
    }

    public CompletableFuture<Hover> hover(HoverParams hoverParams) {
        LOGGER.info("hover: {}", (Object)hoverParams.getTextDocument());
        String uri = hoverParams.getTextDocument().getUri();
        TextDocumentItem textDocumentItem = this.openedDocuments.get(uri);
        if (uri.endsWith(".properties")) {
            return new CamelPropertiesFileHoverProcessor(textDocumentItem).getHover(hoverParams.getPosition(), this.getCamelCatalog(), this.getKameletsCatalogManager());
        }
        if (new CamelKModelineParser().isOnCamelKModeline(hoverParams.getPosition().getLine(), textDocumentItem)) {
            return new CamelKModelineHoverProcessor(textDocumentItem).getHover(hoverParams.getPosition(), this.getCamelCatalog());
        }
        return new CamelURIHoverProcessor(textDocumentItem, this.getCamelCatalog(), this.getKameletsCatalogManager()).getHover(hoverParams.getPosition());
    }

    public CompletableFuture<SignatureHelp> signatureHelp(SignatureHelpParams signatureHelpParams) {
        LOGGER.info("signatureHelp: {}", (Object)signatureHelpParams.getTextDocument());
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<Either<List<? extends Location>, List<? extends LocationLink>>> definition(DefinitionParams params) {
        TextDocumentIdentifier textDocument = params.getTextDocument();
        LOGGER.info("definition: {}", (Object)textDocument);
        TextDocumentItem textDocumentItem = this.openedDocuments.get(textDocument.getUri());
        return new DefinitionProcessor(textDocumentItem).getDefinitions(params.getPosition());
    }

    public CompletableFuture<List<? extends Location>> references(ReferenceParams params) {
        LOGGER.info("references: {}", (Object)params.getTextDocument());
        return new ReferencesProcessor(this, this.openedDocuments.get(params.getTextDocument().getUri())).getReferences(params.getPosition());
    }

    public CompletableFuture<List<? extends DocumentHighlight>> documentHighlight(DocumentHighlightParams position) {
        LOGGER.info("documentHighlight: {}", (Object)position.getTextDocument());
        return CompletableFuture.completedFuture(Collections.emptyList());
    }

    public CompletableFuture<List<Either<SymbolInformation, DocumentSymbol>>> documentSymbol(DocumentSymbolParams params) {
        LOGGER.info("documentSymbol: {}", (Object)params.getTextDocument());
        return new DocumentSymbolProcessor(this.openedDocuments.get(params.getTextDocument().getUri())).getDocumentSymbols();
    }

    public CompletableFuture<List<Either<Command, CodeAction>>> codeAction(CodeActionParams params) {
        LOGGER.info("codeAction: {}", (Object)params.getTextDocument());
        return new CodeActionProcessor(this).getCodeActions(params);
    }

    public CompletableFuture<List<? extends CodeLens>> codeLens(CodeLensParams params) {
        LOGGER.info("codeLens: {}", (Object)params.getTextDocument());
        return CompletableFuture.completedFuture(Collections.emptyList());
    }

    public CompletableFuture<CodeLens> resolveCodeLens(CodeLens unresolved) {
        LOGGER.info("resolveCodeLens: {}", (Object)unresolved.getCommand().getCommand());
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<List<? extends TextEdit>> formatting(DocumentFormattingParams params) {
        LOGGER.info("formatting: {}", (Object)params.getTextDocument());
        return CompletableFuture.completedFuture(Collections.emptyList());
    }

    public CompletableFuture<List<? extends TextEdit>> rangeFormatting(DocumentRangeFormattingParams params) {
        LOGGER.info("rangeFormatting: {}", (Object)params.getTextDocument());
        return CompletableFuture.completedFuture(Collections.emptyList());
    }

    public CompletableFuture<List<? extends TextEdit>> onTypeFormatting(DocumentOnTypeFormattingParams params) {
        LOGGER.info("onTypeFormatting: {}", (Object)params.getTextDocument());
        return CompletableFuture.completedFuture(Collections.emptyList());
    }

    public CompletableFuture<WorkspaceEdit> rename(RenameParams params) {
        LOGGER.info("rename: {}", (Object)params.getTextDocument());
        return CompletableFuture.completedFuture(null);
    }

    public CompletableFuture<List<FoldingRange>> foldingRange(FoldingRangeRequestParams params) {
        TextDocumentIdentifier textDocument = params.getTextDocument();
        LOGGER.info("foldingRange: {}", (Object)textDocument);
        String uri = textDocument.getUri();
        TextDocumentItem textDocumentItem = this.openedDocuments.get(uri);
        if (textDocumentItem != null) {
            return new FoldingRangeProcessor().computeFoldingRanges(textDocumentItem);
        }
        return CompletableFuture.completedFuture(Collections.emptyList());
    }

    public void didOpen(DidOpenTextDocumentParams params) {
        TextDocumentItem textDocument = params.getTextDocument();
        LOGGER.info("didOpen: {}", (Object)textDocument);
        this.openedDocuments.put(textDocument.getUri(), textDocument);
        new DiagnosticRunner(this.getCamelCatalog(), this.camelLanguageServer).compute(params);
        new TelemetryLanguage(this.camelLanguageServer.getTelemetryManager()).compute(textDocument);
    }

    public void didChange(DidChangeTextDocumentParams params) {
        LOGGER.info("didChange: {}", (Object)params.getTextDocument());
        List contentChanges = params.getContentChanges();
        TextDocumentItem textDocumentItem = this.openedDocuments.get(params.getTextDocument().getUri());
        if (!contentChanges.isEmpty()) {
            textDocumentItem.setText(((TextDocumentContentChangeEvent)contentChanges.get(0)).getText());
            new DiagnosticRunner(this.getCamelCatalog(), this.camelLanguageServer).compute(params);
        }
    }

    public void didClose(DidCloseTextDocumentParams params) {
        LOGGER.info("didClose: {}", (Object)params.getTextDocument());
        String uri = params.getTextDocument().getUri();
        this.openedDocuments.remove(uri);
        new DiagnosticRunner(this.getCamelCatalog(), this.camelLanguageServer).clear(uri);
    }

    public void didSave(DidSaveTextDocumentParams params) {
        LOGGER.info("didSave: {}", (Object)params.getTextDocument());
        new DiagnosticRunner(this.getCamelCatalog(), this.camelLanguageServer).compute(params);
    }

    public TextDocumentItem getOpenedDocument(String uri) {
        return this.openedDocuments.get(uri);
    }

    public Collection<TextDocumentItem> getAllOpenedDocuments() {
        return this.openedDocuments.values();
    }

    public CompletableFuture<CamelCatalog> getCamelCatalog() {
        return this.camelCatalog;
    }

    public SettingsManager getSettingsManager() {
        return this.camelLanguageServer.getSettingsManager();
    }

    public KameletsCatalogManager getKameletsCatalogManager() {
        return this.kameletsCatalogManager;
    }
}

