/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.codeactions;

import com.github.cameltooling.lsp.internal.CamelTextDocumentService;
import com.github.cameltooling.lsp.internal.catalog.util.KameletsCatalogManager;
import com.github.cameltooling.lsp.internal.parser.ParserFileHelperUtil;
import com.github.cameltooling.lsp.internal.settings.SettingsManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.commons.text.similarity.LevenshteinDistance;
import org.eclipse.lsp4j.CodeAction;
import org.eclipse.lsp4j.CodeActionParams;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public abstract class AbstractQuickfix {
    protected CamelTextDocumentService camelTextDocumentService;

    protected AbstractQuickfix(CamelTextDocumentService camelTextDocumentService) {
        this.camelTextDocumentService = camelTextDocumentService;
    }

    public List<Either<Command, CodeAction>> apply(CodeActionParams params) {
        TextDocumentItem openedDocument = this.camelTextDocumentService.getOpenedDocument(params.getTextDocument().getUri());
        List diagnostics = params.getContext().getDiagnostics();
        ArrayList<Either<Command, CodeAction>> res = new ArrayList<Either<Command, CodeAction>>();
        for (Diagnostic diagnostic : diagnostics) {
            String currentValueInError;
            if (diagnostic.getCode() == null || !this.getDiagnosticId().equals(diagnostic.getCode().getLeft()) || (currentValueInError = this.retrieveCurrentErrorValue(openedDocument, diagnostic)) == null) continue;
            List<String> possibleProperties = this.retrievePossibleValues(openedDocument, this.camelTextDocumentService.getCamelCatalog(), diagnostic.getRange().getStart(), this.camelTextDocumentService.getSettingsManager(), this.camelTextDocumentService.getKameletsCatalogManager());
            int distanceThreshold = Math.round((float)currentValueInError.length() * 0.4f);
            LevenshteinDistance levenshteinDistance = new LevenshteinDistance(Integer.valueOf(distanceThreshold));
            List mostProbableProperties = possibleProperties.stream().filter(possibleProperty -> levenshteinDistance.apply((CharSequence)possibleProperty, currentValueInError) != -1).collect(Collectors.toList());
            for (String mostProbableProperty : mostProbableProperties) {
                res.add((Either<Command, CodeAction>)Either.forRight((Object)this.createCodeAction(params, diagnostic, mostProbableProperty)));
            }
        }
        return res;
    }

    protected String retrieveCurrentErrorValue(TextDocumentItem openedDocument, Diagnostic diagnostic) {
        Range diagnosticRange = diagnostic.getRange();
        String line = new ParserFileHelperUtil().getLine(openedDocument, diagnosticRange.getStart().getLine());
        int endCharacter = diagnosticRange.getEnd().getCharacter();
        if (line.length() > endCharacter) {
            return line.substring(diagnosticRange.getStart().getCharacter(), endCharacter);
        }
        return null;
    }

    protected CodeAction createCodeAction(CodeActionParams params, Diagnostic diagnostic, String possibleProperty) {
        CodeAction codeAction = new CodeAction("Did you mean " + possibleProperty + "?");
        codeAction.setDiagnostics(Collections.singletonList(diagnostic));
        codeAction.setKind("quickfix");
        HashMap<String, List<TextEdit>> changes = new HashMap<String, List<TextEdit>>();
        TextEdit textEdit = new TextEdit(diagnostic.getRange(), possibleProperty);
        changes.put(params.getTextDocument().getUri(), Arrays.asList(textEdit));
        codeAction.setEdit(new WorkspaceEdit(changes));
        return codeAction;
    }

    protected abstract List<String> retrievePossibleValues(TextDocumentItem var1, CompletableFuture<CamelCatalog> var2, Position var3, SettingsManager var4, KameletsCatalogManager var5);

    protected abstract String getDiagnosticId();
}

