/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.completion;

import com.github.cameltooling.lsp.internal.catalog.model.ComponentOptionModel;
import com.github.cameltooling.lsp.internal.catalog.util.ModelHelper;
import com.github.cameltooling.lsp.internal.completion.CompletionResolverUtils;
import com.github.cameltooling.lsp.internal.completion.FilterPredicateUtils;
import com.github.cameltooling.lsp.internal.instancemodel.propertiesfile.CamelComponentParameterPropertyInstance;
import com.github.cameltooling.lsp.internal.instancemodel.propertiesfile.CamelPropertyValueInstance;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.camel.util.StringHelper;
import org.eclipse.lsp4j.CompletionItem;

public class CamelComponentOptionNamesCompletionFuture
implements Function<CamelCatalog, List<CompletionItem>> {
    private String componentId;
    private CamelPropertyValueInstance camelPropertyValueInstance;
    private String startFilter;
    private CamelComponentParameterPropertyInstance camelComponentParameterPropertyInstance;

    public CamelComponentOptionNamesCompletionFuture(String componentId, CamelComponentParameterPropertyInstance camelComponentParameterPropertyFileInstance, CamelPropertyValueInstance camelPropertyFileValueInstance, String startFilter) {
        this.componentId = componentId;
        this.camelComponentParameterPropertyInstance = camelComponentParameterPropertyFileInstance;
        this.camelPropertyValueInstance = camelPropertyFileValueInstance;
        this.startFilter = startFilter;
    }

    @Override
    public List<CompletionItem> apply(CamelCatalog catalog) {
        Stream endpointOptions = ModelHelper.generateComponentModel(catalog.componentJSonSchema(this.componentId), true).getComponentOptions().stream();
        return endpointOptions.map(parameter -> {
            String parameterDisplayName = this.computeDisplayName((ComponentOptionModel)parameter, this.camelComponentParameterPropertyInstance.shouldUseDashedCase());
            CompletionItem completionItem = new CompletionItem(parameterDisplayName);
            completionItem.setDocumentation(parameter.getDescription());
            completionItem.setDetail(parameter.getJavaType());
            CompletionResolverUtils.applyDeprecation(completionItem, parameter.isDeprecated());
            Object insertText = parameterDisplayName;
            if (this.hasValueProvided() && parameter.getDefaultValue() != null) {
                insertText = (String)insertText + String.format("=%s", parameter.getDefaultValue());
            }
            completionItem.setInsertText((String)insertText);
            CompletionResolverUtils.applyTextEditToCompletionItem(this.camelComponentParameterPropertyInstance, completionItem);
            return completionItem;
        }).filter(FilterPredicateUtils.matchesCompletionFilter(this.startFilter)).collect(Collectors.toList());
    }

    private String computeDisplayName(ComponentOptionModel parameter, boolean useDashedCase) {
        String camelCaseName = parameter.getName();
        if (useDashedCase) {
            return StringHelper.camelCaseToDash((String)camelCaseName);
        }
        return camelCaseName;
    }

    private boolean hasValueProvided() {
        return this.camelPropertyValueInstance == null || this.camelPropertyValueInstance.getCamelPropertyFileValue() == null;
    }
}

