/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.completion;

import com.github.cameltooling.lsp.internal.catalog.util.ModelHelper;
import com.github.cameltooling.lsp.internal.completion.CompletionResolverUtils;
import com.github.cameltooling.lsp.internal.completion.FilterPredicateUtils;
import com.github.cameltooling.lsp.internal.instancemodel.CamelUriElementInstance;
import com.github.cameltooling.lsp.internal.instancemodel.ReferenceUtils;
import com.github.cameltooling.lsp.internal.parser.ParserXMLFileHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.camel.catalog.CamelCatalog;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.TextDocumentItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CamelComponentSchemesCompletionsFuture
implements Function<CamelCatalog, List<CompletionItem>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CamelComponentSchemesCompletionsFuture.class);
    private CamelUriElementInstance uriElement;
    private String filterString;
    private TextDocumentItem docItem;

    public CamelComponentSchemesCompletionsFuture(CamelUriElementInstance uriElement, String filterText, TextDocumentItem docItem) {
        this.uriElement = uriElement;
        this.filterString = filterText;
        this.docItem = docItem;
    }

    @Override
    public List<CompletionItem> apply(CamelCatalog catalog) {
        List<CompletionItem> result = this.getCompletionForComponents(catalog);
        if (ReferenceUtils.isReferenceComponentKind(this.uriElement)) {
            result.addAll(this.addExistingEndpointsOfSameSchemeCompletionItems());
        }
        return result;
    }

    private List<CompletionItem> getCompletionForComponents(CamelCatalog catalog) {
        return catalog.findComponentNames().stream().map(componentName -> ModelHelper.generateComponentModel(catalog.componentJSonSchema(componentName), true)).filter(componentModel -> componentModel.getSyntax() != null).map(componentModel -> {
            CompletionItem completionItem = new CompletionItem(componentModel.getSyntax());
            completionItem.setDocumentation(componentModel.getDescription());
            CompletionResolverUtils.applyDeprecation(completionItem, componentModel.getDeprecated());
            CompletionResolverUtils.applyTextEditToCompletionItem(this.uriElement, completionItem);
            return completionItem;
        }).filter(FilterPredicateUtils.matchesCompletionFilter(this.filterString)).collect(Collectors.toList());
    }

    private List<CompletionItem> addExistingEndpointsOfSameSchemeCompletionItems() {
        ArrayList<CompletionItem> result = new ArrayList<CompletionItem>();
        try {
            List<String> allEndpointIDsWithScheme = CompletionResolverUtils.retrieveEndpointIDsOfScheme(this.uriElement.getComponentName(), new ParserXMLFileHelper(), this.docItem);
            for (String s : allEndpointIDsWithScheme) {
                CompletionItem completionItem = new CompletionItem(s);
                CompletionResolverUtils.applyTextEditToCompletionItem(this.uriElement, completionItem);
                result.add(completionItem);
            }
        }
        catch (Exception ex) {
            LOGGER.error("Error retrieving existing {} endpoints!", (Object)this.uriElement.getComponentName(), (Object)ex);
        }
        return result;
    }
}

