/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.completion;

import com.github.cameltooling.lsp.internal.catalog.util.KameletsCatalogManager;
import com.github.cameltooling.lsp.internal.instancemodel.CamelURIInstance;
import com.github.cameltooling.lsp.internal.instancemodel.CamelUriElementInstance;
import com.github.cameltooling.lsp.internal.parser.ParserFileHelper;
import com.github.cameltooling.lsp.internal.parser.ParserFileHelperFactory;
import com.github.cameltooling.lsp.internal.settings.SettingsManager;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.camel.catalog.CamelCatalog;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.TextDocumentItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelEndpointCompletionProcessor {
    public static final String ERROR_SEARCHING_FOR_CORRESPONDING_NODE_ELEMENTS = "Error searching for corresponding node elements";
    private static final Logger LOGGER = LoggerFactory.getLogger(CamelEndpointCompletionProcessor.class);
    private TextDocumentItem textDocumentItem;
    private CompletableFuture<CamelCatalog> camelCatalog;
    private KameletsCatalogManager kameletsCatalogManager;

    public CamelEndpointCompletionProcessor(TextDocumentItem textDocumentItem, CompletableFuture<CamelCatalog> camelCatalog, KameletsCatalogManager kameletsCatalogManager) {
        this.textDocumentItem = textDocumentItem;
        this.camelCatalog = camelCatalog;
        this.kameletsCatalogManager = kameletsCatalogManager;
    }

    public CompletableFuture<List<CompletionItem>> getCompletions(Position position, SettingsManager settingsManager) {
        if (this.textDocumentItem != null) {
            try {
                String camelComponentUri;
                ParserFileHelper parserFileHelper = new ParserFileHelperFactory().getCorrespondingParserFileHelper(this.textDocumentItem, position.getLine());
                if (parserFileHelper != null && (camelComponentUri = parserFileHelper.getCamelComponentUri(this.textDocumentItem, position)) != null) {
                    CamelURIInstance camelURIInstance = parserFileHelper.createCamelURIInstance(this.textDocumentItem, position, camelComponentUri);
                    int positionInCamelUri = parserFileHelper.getPositionInCamelURI(this.textDocumentItem, position);
                    return this.getCompletions(camelURIInstance, positionInCamelUri, settingsManager);
                }
            }
            catch (Exception e) {
                LOGGER.error(ERROR_SEARCHING_FOR_CORRESPONDING_NODE_ELEMENTS, (Throwable)e);
            }
        }
        return CompletableFuture.completedFuture(Collections.emptyList());
    }

    private CompletableFuture<List<CompletionItem>> getCompletions(CamelURIInstance camelURIInstance, int positionInCamelUri, SettingsManager settingsManager) {
        CamelUriElementInstance camelUriElementInstance = camelURIInstance.getSpecificElement(positionInCamelUri);
        return camelUriElementInstance.getCompletions(this.camelCatalog, positionInCamelUri, this.textDocumentItem, settingsManager, this.kameletsCatalogManager);
    }
}

