/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.completion;

import com.github.cameltooling.lsp.internal.catalog.model.EndpointOptionModel;
import com.github.cameltooling.lsp.internal.catalog.util.ModelHelper;
import com.github.cameltooling.lsp.internal.completion.CompletionResolverUtils;
import com.github.cameltooling.lsp.internal.completion.FilterPredicateUtils;
import com.github.cameltooling.lsp.internal.instancemodel.OptionParamValueURIInstance;
import com.github.cameltooling.lsp.internal.kubernetes.KubernetesConfigManager;
import io.fabric8.kubernetes.api.model.ConfigMapList;
import io.fabric8.kubernetes.api.model.NamespaceList;
import io.fabric8.kubernetes.api.model.SecretList;
import io.fabric8.kubernetes.client.KubernetesClient;
import io.fabric8.kubernetes.client.NamespacedKubernetesClient;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.camel.catalog.CamelCatalog;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.lsp4j.CompletionItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CamelOptionValuesCompletionsFuture
implements Function<CamelCatalog, List<CompletionItem>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CamelOptionValuesCompletionsFuture.class);
    private static final String BOOLEAN_TYPE = "boolean";
    private OptionParamValueURIInstance optionParamValueURIInstance;
    private String filterString;

    public CamelOptionValuesCompletionsFuture(OptionParamValueURIInstance optionParamValueURIInstance, String filterText) {
        this.optionParamValueURIInstance = optionParamValueURIInstance;
        this.filterString = filterText;
    }

    @Override
    public List<CompletionItem> apply(CamelCatalog camelCatalog) {
        Optional<EndpointOptionModel> endpointModel = this.retrieveEndpointOptionModel(camelCatalog);
        if (endpointModel.isPresent()) {
            EndpointOptionModel endpointOptionModel = endpointModel.get();
            List<String> enums = endpointOptionModel.getEnums();
            if (enums != null && !enums.isEmpty()) {
                return this.computeCompletionForEnums(enums);
            }
            if (BOOLEAN_TYPE.equals(endpointOptionModel.getType())) {
                CompletionItem trueItem = new CompletionItem(Boolean.TRUE.toString());
                CompletionResolverUtils.applyTextEditToCompletionItem(this.optionParamValueURIInstance, trueItem);
                CompletionItem falseItem = new CompletionItem(Boolean.FALSE.toString());
                CompletionResolverUtils.applyTextEditToCompletionItem(this.optionParamValueURIInstance, falseItem);
                Stream<CompletionItem> values = Stream.of(trueItem, falseItem);
                return values.filter(FilterPredicateUtils.matchesCompletionFilter(this.filterString)).collect(Collectors.toList());
            }
            if (this.optionParamValueURIInstance.getComponentName().startsWith("kubernetes-") && "namespace".equals(this.optionParamValueURIInstance.getOptionParamURIInstance().getKey().getKeyName())) {
                List<CompletionItem> list;
                block15: {
                    KubernetesClient client = KubernetesConfigManager.getInstance().getClient();
                    try {
                        list = ((NamespaceList)client.namespaces().list()).getItems().stream().map(namespace -> {
                            CompletionItem completionItem = new CompletionItem(namespace.getMetadata().getName());
                            CompletionResolverUtils.applyTextEditToCompletionItem(this.optionParamValueURIInstance, completionItem);
                            return completionItem;
                        }).collect(Collectors.toList());
                        if (client == null) break block15;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (client != null) {
                                try {
                                    client.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            LOGGER.error("Error while trying to provide completion for Kubernetes connected mode", (Throwable)e);
                        }
                    }
                    client.close();
                }
                return list;
            } else if ("lang".equalsIgnoreCase(endpointOptionModel.getName()) && this.optionParamValueURIInstance.getComponentName().startsWith("twitter-")) {
                ArrayList<CompletionItem> items = new ArrayList<CompletionItem>();
                for (String lang : Locale.getISOLanguages()) {
                    CompletionItem langItem = new CompletionItem(lang);
                    CompletionResolverUtils.applyTextEditToCompletionItem(this.optionParamValueURIInstance, langItem);
                    items.add(langItem);
                }
                return items;
            }
            return this.getCompletionForKubernetes();
        }
        return Collections.emptyList();
    }

    private List<CompletionItem> getCompletionForKubernetes() {
        int interestingPosition = this.optionParamValueURIInstance.getValueName().length() > this.filterString.length() ? this.filterString.length() + 1 : this.filterString.length();
        String value = this.optionParamValueURIInstance.getValueName().substring(0, interestingPosition);
        ArrayList<CompletionItem> kubernetesPlaceholders = new ArrayList<CompletionItem>();
        if (StringUtils.contains((CharSequence)value, (CharSequence)"{{") && (!StringUtils.contains((CharSequence)value, (CharSequence)"}}") || value.lastIndexOf("}}") < value.lastIndexOf("{{"))) {
            String pre = value.substring(0, value.lastIndexOf("{{"));
            String lastPart = this.optionParamValueURIInstance.getValueName().substring(interestingPosition);
            if (lastPart.indexOf("}}") >= 0 && (lastPart.indexOf("}}") < lastPart.indexOf("{{") || lastPart.indexOf("{{") < 0)) {
                lastPart = lastPart.substring(lastPart.indexOf("}}") + 2);
            }
            String post = lastPart;
            try (KubernetesClient client = KubernetesConfigManager.getInstance().getClient();){
                if (client instanceof NamespacedKubernetesClient) {
                    NamespacedKubernetesClient nsClient = (NamespacedKubernetesClient)client;
                    kubernetesPlaceholders.addAll(((SecretList)nsClient.inAnyNamespace().secrets().list()).getItems().stream().flatMap(element -> element.getData().keySet().stream().map(k -> {
                        CompletionItem item = new CompletionItem("{{secret:" + element.getMetadata().getName() + "/" + k + "}}");
                        item.setInsertText(pre + item.getLabel() + post);
                        item.setFilterText(pre + item.getLabel());
                        CompletionResolverUtils.applyTextEditToCompletionItem(this.optionParamValueURIInstance, item);
                        return item;
                    })).collect(Collectors.toList()));
                    kubernetesPlaceholders.addAll(((ConfigMapList)nsClient.inAnyNamespace().configMaps().list()).getItems().stream().flatMap(element -> element.getData().keySet().stream().map(k -> {
                        CompletionItem item = new CompletionItem("{{configmap:" + element.getMetadata().getName() + "/" + k + "}}");
                        item.setInsertText(pre + item.getLabel() + post);
                        item.setFilterText(pre + item.getLabel());
                        CompletionResolverUtils.applyTextEditToCompletionItem(this.optionParamValueURIInstance, item);
                        return item;
                    })).collect(Collectors.toList()));
                }
            }
            catch (Exception e) {
                LOGGER.error("Error while trying to provide completion for Kubernetes connected mode", (Throwable)e);
            }
        }
        return kubernetesPlaceholders;
    }

    private List<CompletionItem> computeCompletionForEnums(List<String> enums) {
        ArrayList<CompletionItem> completionItems = new ArrayList<CompletionItem>();
        for (String enumValue : enums) {
            CompletionItem item = new CompletionItem(enumValue);
            CompletionResolverUtils.applyTextEditToCompletionItem(this.optionParamValueURIInstance, item);
            completionItems.add(item);
        }
        return completionItems.stream().filter(FilterPredicateUtils.matchesCompletionFilter(this.filterString)).collect(Collectors.toList());
    }

    private Optional<EndpointOptionModel> retrieveEndpointOptionModel(CamelCatalog camelCatalog) {
        String componentName = this.optionParamValueURIInstance.getOptionParamURIInstance().getComponentName();
        String keyName = this.optionParamValueURIInstance.getOptionParamURIInstance().getKey().getKeyName();
        List<EndpointOptionModel> endpointOptions = ModelHelper.generateComponentModel(camelCatalog.componentJSonSchema(componentName), true).getEndpointOptions();
        return endpointOptions.stream().filter(endpoint -> keyName.equals(endpoint.getName())).findAny();
    }
}

