/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.completion;

import com.github.cameltooling.lsp.internal.instancemodel.CamelURIInstance;
import com.github.cameltooling.lsp.internal.instancemodel.ILineRangeDefineable;
import com.github.cameltooling.lsp.internal.instancemodel.ReferenceUtils;
import com.github.cameltooling.lsp.internal.parser.ParserXMLFileHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.camel.parser.helper.CamelXmlHelper;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.CompletionItemTag;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.w3c.dom.Node;

public class CompletionResolverUtils {
    private CompletionResolverUtils() {
    }

    public static void applyTextEditToCompletionItem(ILineRangeDefineable lineRangeDefineable, CompletionItem item) {
        if (lineRangeDefineable != null) {
            int line = lineRangeDefineable.getLine();
            Position pStart = new Position(line, lineRangeDefineable.getStartPositionInLine());
            Position pEnd = new Position(line, lineRangeDefineable.getEndPositionInLine());
            Range range = new Range(pStart, pEnd);
            if (item.getInsertText() != null) {
                item.setTextEdit(Either.forLeft((Object)new TextEdit(range, item.getInsertText())));
            } else {
                item.setTextEdit(Either.forLeft((Object)new TextEdit(range, item.getLabel())));
            }
        }
    }

    public static List<String> retrieveEndpointIDsOfScheme(String scheme, ParserXMLFileHelper xmlFileHelper, TextDocumentItem docItem) throws Exception {
        List<Node> allEndpoints = xmlFileHelper.getAllEndpoints(docItem);
        ArrayList<String> endpointIDs = new ArrayList<String>();
        for (Node endpoint : allEndpoints) {
            CamelURIInstance uriInstance;
            String uriToParse = CamelXmlHelper.getSafeAttribute((Node)endpoint, (String)"uri");
            if (uriToParse == null || !ReferenceUtils.isReferenceComponentKind(uriInstance = new CamelURIInstance(uriToParse, endpoint, docItem)) || !uriInstance.getComponentName().equalsIgnoreCase(scheme)) continue;
            String dId = ReferenceUtils.getReferenceKey(uriInstance);
            String directValue = String.format("%s:%s", scheme, dId);
            if (dId == null || dId.trim().length() <= 0 || endpointIDs.contains(directValue)) continue;
            endpointIDs.add(directValue);
        }
        return endpointIDs;
    }

    public static void applyDeprecation(CompletionItem completionItem, boolean isDeprecated) {
        completionItem.setDeprecated(Boolean.valueOf(isDeprecated));
        if (isDeprecated) {
            completionItem.setTags(Collections.singletonList(CompletionItemTag.Deprecated));
        }
    }
}

