/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.completion.traits;

import com.github.cameltooling.lsp.internal.completion.CompletionResolverUtils;
import com.github.cameltooling.lsp.internal.completion.traits.TraitProperty;
import com.github.cameltooling.lsp.internal.modelinemodel.CamelKModelineTraitDefinition;
import com.github.cameltooling.lsp.internal.modelinemodel.CamelKModelineTraitOption;
import java.util.List;
import org.eclipse.lsp4j.CompletionItem;

public class TraitDefinition {
    private String name;
    private String description;
    private boolean platform;
    private List<String> profiles;
    private List<TraitProperty> properties;

    public CompletionItem createCompletionItem(CamelKModelineTraitDefinition traitDefinition) {
        CompletionItem completionItem = new CompletionItem(this.name);
        completionItem.setDocumentation(this.description);
        if (this.hasAPropertySpecified(traitDefinition.getTraitOption())) {
            completionItem.setInsertText(this.name);
        } else {
            completionItem.setInsertText(this.name + ".");
        }
        CompletionResolverUtils.applyTextEditToCompletionItem(traitDefinition, completionItem);
        return completionItem;
    }

    public List<TraitProperty> getProperties() {
        return this.properties;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    public boolean isPlatform() {
        return this.platform;
    }

    public List<String> getProfiles() {
        return this.profiles;
    }

    private boolean hasAPropertySpecified(CamelKModelineTraitOption traitOption) {
        return traitOption.getTraitProperty() != null;
    }
}

