/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.documentsymbol;

import com.github.cameltooling.lsp.internal.documentsymbol.AbstractDocumentSymbolProcessor;
import com.github.cameltooling.lsp.internal.parser.ParserXMLFileHelper;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.apache.camel.parser.XmlRouteParser;
import org.apache.camel.parser.model.CamelEndpointDetails;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.Location;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.TextDocumentItem;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class DocumentSymbolXMLProcessor
extends AbstractDocumentSymbolProcessor {
    static final String CANNOT_DETERMINE_DOCUMENT_SYMBOLS = "Cannot determine document symbols";
    private static final String ATTRIBUTE_ID = "id";
    private static final Logger LOGGER = LoggerFactory.getLogger(DocumentSymbolXMLProcessor.class);
    private ParserXMLFileHelper parserFileHelper = new ParserXMLFileHelper();

    public DocumentSymbolXMLProcessor(TextDocumentItem textDocumentItem) {
        super(textDocumentItem);
    }

    public List<Either<SymbolInformation, DocumentSymbol>> getSymbolInformations() {
        ArrayList<Either<SymbolInformation, DocumentSymbol>> symbolInformations = new ArrayList<Either<SymbolInformation, DocumentSymbol>>();
        try {
            NodeList camelContextNodes;
            String rawpath = URI.create(this.textDocumentItem.getUri()).getRawPath();
            List camelNodeDetails = XmlRouteParser.parseXmlRouteTree((InputStream)this.createInputStream(this.textDocumentItem), (String)"", (String)rawpath);
            ArrayList<CamelEndpointDetails> endpoints = new ArrayList<CamelEndpointDetails>();
            XmlRouteParser.parseXmlRouteEndpoints((InputStream)this.createInputStream(this.textDocumentItem), (String)"", (String)rawpath, endpoints);
            symbolInformations.addAll(this.createSymbolInformations(camelNodeDetails, endpoints));
            NodeList routeNodes = this.parserFileHelper.getRouteNodes(this.textDocumentItem);
            if (routeNodes != null) {
                symbolInformations.addAll(this.convertToSymbolInformation(routeNodes));
            }
            if ((camelContextNodes = this.parserFileHelper.getCamelContextNodes(this.textDocumentItem)) != null) {
                symbolInformations.addAll(this.convertToSymbolInformation(camelContextNodes));
            }
        }
        catch (Exception e) {
            LOGGER.error(CANNOT_DETERMINE_DOCUMENT_SYMBOLS, (Throwable)e);
        }
        return symbolInformations;
    }

    private ByteArrayInputStream createInputStream(TextDocumentItem textDocumentItem) {
        return new ByteArrayInputStream(textDocumentItem.getText().getBytes());
    }

    private List<Either<SymbolInformation, DocumentSymbol>> convertToSymbolInformation(NodeList routeNodes) {
        ArrayList<Either<SymbolInformation, DocumentSymbol>> res = new ArrayList<Either<SymbolInformation, DocumentSymbol>>();
        for (int i = 0; i < routeNodes.getLength(); ++i) {
            Node routeNode = routeNodes.item(i);
            Location location = this.parserFileHelper.retrieveLocation(routeNode, this.textDocumentItem);
            String displayNameOfSymbol = this.computeDisplayNameOfSymbol(routeNode);
            res.add((Either<SymbolInformation, DocumentSymbol>)Either.forRight((Object)new DocumentSymbol(displayNameOfSymbol, SymbolKind.Field, location.getRange(), location.getRange())));
        }
        return res;
    }

    private String computeDisplayNameOfSymbol(Node node) {
        Node routeIdAttribute = node.getAttributes().getNamedItem(ATTRIBUTE_ID);
        String displayNameOfSymbol = routeIdAttribute != null ? routeIdAttribute.getNodeValue() : "<no id>";
        return displayNameOfSymbol;
    }
}

