/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.hover;

import com.github.cameltooling.lsp.internal.catalog.model.ComponentModel;
import com.github.cameltooling.lsp.internal.catalog.util.KameletsCatalogManager;
import com.github.cameltooling.lsp.internal.catalog.util.ModelHelper;
import com.github.cameltooling.lsp.internal.instancemodel.CamelUriElementInstance;
import java.util.Collections;
import java.util.function.Function;
import org.apache.camel.catalog.CamelCatalog;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.messages.Either;

public class CamelURIHoverFuture
implements Function<CamelCatalog, Hover> {
    private CamelUriElementInstance uriElement;
    private KameletsCatalogManager kameletCatalogManager;

    public CamelURIHoverFuture(CamelUriElementInstance uriElement, KameletsCatalogManager kameletCatalogManager) {
        this.uriElement = uriElement;
        this.kameletCatalogManager = kameletCatalogManager;
    }

    @Override
    public Hover apply(CamelCatalog camelCatalog) {
        String componentJSonSchema = camelCatalog.componentJSonSchema(this.uriElement.getComponentName());
        if (componentJSonSchema != null) {
            Hover hover = new Hover();
            ComponentModel componentModel = ModelHelper.generateComponentModel(componentJSonSchema, true);
            hover.setContents(Collections.singletonList(Either.forLeft((Object)this.uriElement.getDescription(componentModel, this.kameletCatalogManager))));
            Position start = new Position(this.uriElement.getLine(), this.uriElement.getStartPositionInLine());
            hover.setRange(new Range(start, new Position(this.uriElement.getLine(), this.uriElement.getEndPositionInLine())));
            return hover;
        }
        return null;
    }
}

