/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.instancemodel;

import com.github.cameltooling.lsp.internal.catalog.model.ComponentModel;
import com.github.cameltooling.lsp.internal.catalog.util.KameletsCatalogManager;
import com.github.cameltooling.lsp.internal.completion.CamelComponentSchemesCompletionsFuture;
import com.github.cameltooling.lsp.internal.instancemodel.CamelComponentURIInstance;
import com.github.cameltooling.lsp.internal.instancemodel.CamelURIInstance;
import com.github.cameltooling.lsp.internal.instancemodel.CamelUriElementInstance;
import com.github.cameltooling.lsp.internal.instancemodel.PathParamURIInstance;
import com.github.cameltooling.lsp.internal.settings.SettingsManager;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.apache.camel.catalog.CamelCatalog;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.TextDocumentItem;

public class CamelComponentAndPathUriInstance
extends CamelUriElementInstance {
    private static final String CAMEL_PATH_PRIMARY_SEPARATOR_REGEX = ":";
    private static final String CAMEL_PATH_POTENTIAL_SECONDARY_SEPARATOR_REGEX = "/";
    private CamelURIInstance parent;
    private CamelComponentURIInstance component;
    private Set<PathParamURIInstance> pathParams = new HashSet<PathParamURIInstance>();
    private PathParamURIInstance apiNamePathInstance;
    private PathParamURIInstance methodNamePathInstance;

    public CamelComponentAndPathUriInstance(CamelURIInstance parent, String schemeAndPath, int endPosition) {
        super(0, endPosition);
        this.parent = parent;
        this.init(schemeAndPath);
    }

    private void init(String schemeAndPath) {
        int posDoubleDot = schemeAndPath.indexOf(58);
        if (posDoubleDot > 0) {
            this.component = new CamelComponentURIInstance(this, schemeAndPath.substring(0, posDoubleDot), posDoubleDot);
            int posEndofPathParams = this.getPosEndOfPathParams(posDoubleDot, schemeAndPath);
            this.initPathParams(schemeAndPath, posDoubleDot, posEndofPathParams);
        } else {
            this.component = new CamelComponentURIInstance(this, schemeAndPath, schemeAndPath.length());
        }
    }

    private void initPathParams(String uriToParse, int posDoubleDot, int posEndofPathParams) {
        String pathParamsSubstring = uriToParse.substring(posDoubleDot + 1, posEndofPathParams);
        String[] splitsForDoubleDots = pathParamsSubstring.split(CAMEL_PATH_PRIMARY_SEPARATOR_REGEX);
        int currentPosition = posDoubleDot + 1;
        int pathParamIndex = 0;
        for (String splitForDoubleDot : splitsForDoubleDots) {
            String[] splitsForSlash;
            if (splitForDoubleDot.startsWith(CAMEL_PATH_POTENTIAL_SECONDARY_SEPARATOR_REGEX)) {
                PathParamURIInstance pathParamURIInstance = new PathParamURIInstance(this, splitForDoubleDot, currentPosition, currentPosition + splitForDoubleDot.length(), pathParamIndex);
                this.pathParams.add(pathParamURIInstance);
                currentPosition += splitForDoubleDot.length() + 1;
                this.initApiPathParams(pathParamIndex, pathParamURIInstance);
                ++pathParamIndex;
                continue;
            }
            for (String splitForSlash : splitsForSlash = splitForDoubleDot.split(CAMEL_PATH_POTENTIAL_SECONDARY_SEPARATOR_REGEX)) {
                PathParamURIInstance pathParamURIInstance = new PathParamURIInstance(this, splitForSlash, currentPosition, currentPosition + splitForSlash.length(), pathParamIndex);
                this.pathParams.add(pathParamURIInstance);
                currentPosition += splitForSlash.length() + 1;
                this.initApiPathParams(pathParamIndex, pathParamURIInstance);
                ++pathParamIndex;
            }
            if (!splitForDoubleDot.endsWith(CAMEL_PATH_POTENTIAL_SECONDARY_SEPARATOR_REGEX)) continue;
            PathParamURIInstance pathParamURIInstance = new PathParamURIInstance(this, "", currentPosition, currentPosition, pathParamIndex);
            this.pathParams.add(pathParamURIInstance);
            this.initApiPathParams(pathParamIndex, pathParamURIInstance);
        }
    }

    private void initApiPathParams(int pathParamIndex, PathParamURIInstance pathParamURIInstance) {
        if (pathParamIndex == 0) {
            this.apiNamePathInstance = pathParamURIInstance;
        }
        if (pathParamIndex == 1) {
            this.methodNamePathInstance = pathParamURIInstance;
        }
    }

    private int getPosEndOfPathParams(int posDoubleDot, String uriToParse) {
        int questionMarkPosition = uriToParse.indexOf(63, posDoubleDot);
        if (questionMarkPosition > 0) {
            return questionMarkPosition;
        }
        return uriToParse.length();
    }

    public CamelComponentURIInstance getComponent() {
        return this.component;
    }

    public Set<PathParamURIInstance> getPathParams() {
        return this.pathParams;
    }

    public CamelUriElementInstance getSpecificElement(int position) {
        if (this.component != null && this.component.isInRange(position)) {
            return this.component;
        }
        for (PathParamURIInstance pathParamURIInstance : this.pathParams) {
            if (!pathParamURIInstance.isInRange(position)) continue;
            return pathParamURIInstance;
        }
        return this;
    }

    @Override
    public CompletableFuture<List<CompletionItem>> getCompletions(CompletableFuture<CamelCatalog> camelCatalog, int positionInCamelUri, TextDocumentItem docItem, SettingsManager settingsManager, KameletsCatalogManager kameletsCatalogManager) {
        CamelUriElementInstance specificElement = this.getSpecificElement(positionInCamelUri);
        if (specificElement != null && specificElement != this.component && specificElement != this) {
            return specificElement.getCompletions(camelCatalog, positionInCamelUri, docItem, settingsManager, kameletsCatalogManager);
        }
        if (this.getStartPositionInUri() <= positionInCamelUri && positionInCamelUri <= this.getEndPositionInUri()) {
            return camelCatalog.thenApply((Function)new CamelComponentSchemesCompletionsFuture(this, this.getFilter(positionInCamelUri), docItem));
        }
        return CompletableFuture.completedFuture(Collections.emptyList());
    }

    protected String getFilter(int positionInUri) {
        String componentName = this.getComponent().getComponentName();
        if (componentName != null && componentName.trim().length() > 0 && this.getStartPositionInUri() != positionInUri) {
            Object filter = componentName.substring(this.getStartPositionInUri(), positionInUri < componentName.length() ? positionInUri : componentName.length());
            if (positionInUri - this.getStartPositionInUri() > componentName.length()) {
                filter = (String)filter + CAMEL_PATH_PRIMARY_SEPARATOR_REGEX;
            }
            return filter;
        }
        return null;
    }

    @Override
    public String getComponentName() {
        return this.component != null ? this.component.getComponentName() : null;
    }

    @Override
    public String getDescription(ComponentModel componentModel, KameletsCatalogManager kameletCatalogManager) {
        return null;
    }

    @Override
    public CamelURIInstance getCamelUriInstance() {
        return this.parent.getCamelUriInstance();
    }

    public PathParamURIInstance getApiNamePath() {
        return this.apiNamePathInstance;
    }

    public PathParamURIInstance getMethodNamePath() {
        return this.methodNamePathInstance;
    }
}

