/*
 * Decompiled with CFR 0.152.
 */
package com.github.cameltooling.lsp.internal.instancemodel;

import com.github.cameltooling.lsp.internal.catalog.model.ApiOptionModel;
import com.github.cameltooling.lsp.internal.catalog.model.ApiPropertyMethodOptionModel;
import com.github.cameltooling.lsp.internal.catalog.model.ApiPropertyOptionModel;
import com.github.cameltooling.lsp.internal.catalog.model.ComponentModel;
import com.github.cameltooling.lsp.internal.catalog.model.EndpointOptionModel;
import com.github.cameltooling.lsp.internal.catalog.util.KameletsCatalogManager;
import com.github.cameltooling.lsp.internal.instancemodel.CamelURIInstance;
import com.github.cameltooling.lsp.internal.instancemodel.ILineRangeDefineable;
import com.github.cameltooling.lsp.internal.instancemodel.PathParamURIInstance;
import com.github.cameltooling.lsp.internal.settings.SettingsManager;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.apache.camel.catalog.CamelCatalog;
import org.eclipse.lsp4j.CompletionItem;
import org.eclipse.lsp4j.TextDocumentItem;

public abstract class CamelUriElementInstance
implements ILineRangeDefineable {
    private int startPositionInUri;
    private int endPositionInUri;
    private TextDocumentItem document;

    protected CamelUriElementInstance(int startPositionInUri, int endPositionInUri) {
        this.startPositionInUri = startPositionInUri;
        this.endPositionInUri = endPositionInUri;
    }

    public int getStartPositionInUri() {
        return this.startPositionInUri;
    }

    public int getEndPositionInUri() {
        return this.endPositionInUri;
    }

    public boolean isInRange(int position) {
        return this.startPositionInUri <= position && position <= this.endPositionInUri;
    }

    public TextDocumentItem getDocument() {
        return this.document;
    }

    public void setDocument(TextDocumentItem document) {
        this.document = document;
    }

    @Override
    public int getStartPositionInLine() {
        return this.getCamelUriInstance().getStartPositionInDocument().getCharacter() + this.getStartPositionInUri();
    }

    @Override
    public int getEndPositionInLine() {
        return this.getCamelUriInstance().getStartPositionInDocument().getCharacter() + this.getEndPositionInUri();
    }

    @Override
    public int getLine() {
        return this.getCamelUriInstance().getAbsoluteBounds().getStart().getLine();
    }

    public abstract CompletableFuture<List<CompletionItem>> getCompletions(CompletableFuture<CamelCatalog> var1, int var2, TextDocumentItem var3, SettingsManager var4, KameletsCatalogManager var5);

    public abstract String getComponentName();

    public abstract String getDescription(ComponentModel var1, KameletsCatalogManager var2);

    public abstract CamelURIInstance getCamelUriInstance();

    public List<EndpointOptionModel> findAvailableApiProperties(ComponentModel componentModel) {
        CamelURIInstance camelUriInstance = this.getCamelUriInstance();
        PathParamURIInstance apiNamePath = camelUriInstance.getComponentAndPathUriElementInstance().getApiNamePath();
        PathParamURIInstance methodNamePath = camelUriInstance.getComponentAndPathUriElementInstance().getMethodNamePath();
        Optional<ApiPropertyMethodOptionModel> apisPropertiesModel = componentModel.getApiProperties().stream().filter(apiProperty -> this.isCorrespondingApiName(apiNamePath, (ApiPropertyOptionModel)apiProperty)).map(apiProperty -> this.findApiPropertyModel(componentModel, methodNamePath, (ApiPropertyOptionModel)apiProperty)).filter(Objects::nonNull).findAny();
        if (apisPropertiesModel.isPresent()) {
            return apisPropertiesModel.get().getProperties();
        }
        return Collections.emptyList();
    }

    private boolean isCorrespondingApiName(PathParamURIInstance apiNamePath, ApiPropertyOptionModel apiProperty) {
        return apiNamePath != null && apiProperty.getName().equals(apiNamePath.getValue());
    }

    private ApiPropertyMethodOptionModel findApiPropertyModel(ComponentModel componentModel, PathParamURIInstance methodNamePath, ApiPropertyOptionModel apiProperty) {
        Optional<ApiOptionModel> correspondingApi = componentModel.getApis().stream().filter(api -> apiProperty.getName().equals(api.getName())).findAny();
        if (correspondingApi.isPresent() && methodNamePath != null) {
            Map<String, String> aliasesMapping = correspondingApi.get().getAliasToKind();
            String methodKind = aliasesMapping.get(methodNamePath.getValue());
            if ("^creator$".equals(methodKind)) {
                return apiProperty.getCreator();
            }
            if ("^deleter$".equals(methodKind)) {
                return apiProperty.getDeleter();
            }
            if ("^fetcher$".equals(methodKind)) {
                return apiProperty.getFetcher();
            }
            if ("^reader$".equals(methodKind)) {
                return apiProperty.getReader();
            }
            if ("^updater$".equals(methodKind)) {
                return apiProperty.getUpdater();
            }
            return apiProperty.getPropertyMethod(methodNamePath.getValue());
        }
        return null;
    }
}

